<!DOCTYPE html>
<html>
	<head>

		<!-- Basic -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">	

		<title>Mónica Tapia – Comunicación y Alianzas para transformar al mundo</title>	

		<meta name="keywords" content="Onu, agenda 2030, objetivos de desarrollo sostenible, ODS, cambiar al mundo, desarrollo sustentable, Visionarios 2030, metas de desarrollo sostenible, gobierno de México, organización de las naciones unidas, " />
		<meta name="description" content="Somos la plataforma de comunicación que potencia la voz de los líderes mexicanos que están cambiando al mundo.">
		<meta name="author" content="LeadME Internet Marketing">

		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="archivos/favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="archivos/favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="archivos/favicon/favicon-16x16.png">
		<link rel="manifest" href="archivos/favicon/site.webmanifest">
		<link rel="mask-icon" href="archivos/favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">

		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome-free/css/all.min.css">
		<link rel="stylesheet" href="vendor/animate/animate.compat.css">
		<link rel="stylesheet" href="vendor/simple-line-icons/css/simple-line-icons.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.carousel.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.theme.default.min.css">
		<link rel="stylesheet" href="vendor/magnific-popup/magnific-popup.min.css">

        <!-- Theme CSS -->
		<link rel="stylesheet" href="css/theme.css">
		<link rel="stylesheet" href="css/theme-elements.css">

		<!-- Skin CSS -->
		<link id="skinCSS" rel="stylesheet" href="css/skins/skin-corporate-10.css">

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="css/custom.css">
		<link rel="stylesheet" href="css/visionarios-person.css">

		<!-- Head Libs -->
		<script src="vendor/modernizr/modernizr.min.js"></script>

        <!-- Meta Pixel Code -->
		<script>
			!function(f,b,e,v,n,t,s)
			{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
			n.callMethod.apply(n,arguments):n.queue.push(arguments)};
			if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
			n.queue=[];t=b.createElement(e);t.async=!0;
			t.src=v;s=b.getElementsByTagName(e)[0];
			s.parentNode.insertBefore(t,s)}(window, document,'script',
			'https://connect.facebook.net/en_US/fbevents.js');
			fbq('init', '1140806276704330');
			fbq('track', 'PageView');
		</script>
		<noscript><img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id=1140806276704330&ev=PageView&noscript=1"/></noscript>
		<!-- End Meta Pixel Code -->

	</head>
	<body class="visionarioChangeFooter" data-plugin-page-transition>
		<div class="body headerWhite">
            <!-- Main header -->
			<?php include('main-header.php')?>
            <!-- End Main Header -->

			<div role="main" class="main">
				<!-- Slide -->
				<section class="section section-with-shape-divider border-0 py-0 m-0" id="slideVisionarioPerson">
					<div class="shape-divider shape-divider-bottom z-index-3" style="height: 136px;">
						<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 136" preserveAspectRatio="xMinYMin">
							<path d="M 0 0.11 L 0 136 L 1920 136 L 1920 1.9 C 1650.0482 79.0955 1327.0648 134 980 134 C 615.6218 134 277.7878 84.5059 0 0.11 Z" fill="#5aba47"/>
						</svg>
					</div>
					<div class="owl-carousel owl-carousel-light owl-carousel-light-init-fadeIn owl-theme manual dots-inside dots-horizontal-center show-dots-hover show-dots-xs nav-style-1 nav-inside nav-inside-plus nav-primary nav-md nav-font-size-md show-nav-hover mb-0" data-plugin-options="{'autoplayTimeout': 9000, 'autoplay': false }" style="height: 100vh;">
						<div class="owl-stage-outer">
							<div class="owl-stage">

								<!-- Carousel Slide 1 -->
								<div class="owl-item position-relative" style="background-image: url(archivos/ficha-experto/Visionarios-2030-Ficha-Experto-VIP-Monica-Tapia-Banner.jpg); background-size: cover; background-position: center; height: 100vh;">
									<div class="container position-relative z-index-3 h-100">
										<div class="row justify-content-center align-items-center h-100">
											<div class="col-lg-9">
												<div class="d-flex flex-column align-items-center">
													<h1 class="position-relative text-color-light text-4 px-4 mb-2 appear-animation smallTitleSlide" data-appear-animation="fadeInDownShorter" data-plugin-options="{'minWindowWidth': 0}">
														<span class="position-absolute right-100pct top-50pct transform3dy-n50" style="background: var(--verde);width: 120px;height: 13px;"></span>
														<span class="">VISIONARIA </span>11.4 / 17.7
														<span class="position-absolute left-100pct top-50pct transform3dy-n50" style="background: var(--verde);width: 120px;height: 13px;"></span>
													</h1>
													<p class="text-4 text-center mb-0 titleSlide azul" ><span class="blanco">Mónica </span> Tapia</p>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>

				<!-- Frase -->
				<section id="fraseInicioPersona" class="color4">
					<div class="container">
						<div class="row">
							<div class="col-md-9 mx-md-auto appear-animation maskUp appear-animation-visible" data-appear-animation="maskUp">
								<p class="text"><span class="blanco">«Colaboro para desarrollar una </span> <span class="blanco">ciudad más sustentable y justa, </span> 
                                <span class="blanco">y así mejorar nuestra </span><span class="blanco cursive">calidad de vida».</span></p>
							</div>
						</div>
					</div>
				</section>
				<!-- End Frase -->

				<!-- Descripción Persona -->
				<section id="descriptionPersonVisionario" class="">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-7">
                                <div class="heading">
                                    <p class="title">MÓNICA TAPIA</p>
                                    <p class="subtitle">Visionaria 11.4 / 17.7</p>
                                </div>
                                <div class="description">
                                    <p class="text">Soy <span class="cursive">Ana Gaby González,</span> especialista en ciudades sustentables.</p>
                                    <p class="text">Soy Directora de <span class="cursive">Ruta Cívica</span> y colaboro con redes y proyectos ciudadanos como #CDMXsustentable @CIUDADania19s #CDMXjusta y #ObraChueca, entre otras. </p>
                                    <p class="text">Mi sueño es disminuir la desigualdad y los privilegios, para lo cual impulso la visión de ciudades más justas y sustentables. Esto me motiva a organizar y colaborar en equipo.</p>
                                    <p class="text">Mi lugar favorito son las plazas públicas y la naturaleza. En el patio tengo un compostero de lombrices que transforma la basura en tierra fértil para mis plantas.</p>
                                    <ul class="list">
                                        <p>Espacios de acción:</p>
                                        <li>Soy Directora de Ruta Cívica</li>
                                        <li>Facilito liderazgo colaborativo</li>
                                        <li>Creo plataformas de colaboración ciudadana</li>
                                        <li>Emprendo proyectos de participación activa</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <img class="img-fluid" src="archivos/ficha-experto/Monica-Tapia.jpg" alt="MÓNICA TAPIA">
                            </div>
                        </div>
                    </div>
                </section>
				<!-- End Descripcion Persona -->

                <!-- Trabajo Visionario -->
                <div id="trabajosVisionario" class="curved-border curved-border-top curved-morado">
                    <div class="container container-xl-custom">
                        <div class="row text-center text-lg-start rowProject">
                            <div class="col-lg-7 appear-animation" style="position: relative;" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">
                                <p class="smallTitle">OBJETIVOS DE DESARROLLO SONTENIBLE</p>
                                <h2 class="title naranja">ODS 11.4 Ciudades y comunidades 
                                    sostenibles</h2>
                                <p class="mb-4 text">De aquí a 2030, aumentar la urbanización inclusiva y sostenible y la capacidad para la planificación y la gestión participativas, integradas y sostenibles de los asentamientos humanos en todos los países.</p>
								<a href="#" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded">VER MÁS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
                            </div>
                            <div class="col-md-5 col-lg-5 px-2 mt-3 mt-lg-0 appear-animation boxImgRight" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="400">
                                <img src="archivos/icons/S_SDG_Icons-01-11.jpeg" class="img-fluid work" alt=""/>
                            </div>
                        </div>
                        <div class="row text-center text-lg-start rowProject reverse pt-60">
                            <div class="col-lg-7 appear-animation order-2" style="position: relative;" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">
                                <p class="smallTitle">OBJETIVOS DE DESARROLLO SONTENIBLE</p>
                                <h2 class="title morado">ODS 17.7 Alianzas para lograr los objetivos</h2>
                                <p class="mb-4 text">Fomentar y promover la constitución de alianzas eficaces en las esferas pública, público-privada y de la sociedad civil, aprovechando la experiencia y las estrategias de obtención de recursos de las alianzas.</p>
								<a href="#" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded">VER MÁS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
                            </div>
                            <div class="col-md-5 col-lg-5 px-2 mt-3 mt-lg-0 appear-animation boxImgLeft order-1" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="400">
                                <img src="archivos/icons/S_SDG_Icons-01-17.jpeg" class="img-fluid work" alt=""/>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End trabajo visionario -->

                <!-- Metas Visionario -->
                <section class="section bg-light section-with-shape-divider border-0 py-0 m-0">
                    <div class="shape-divider shape-divider-bottom z-index-3" style="height: 136px;">
						<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 136" preserveAspectRatio="xMinYMin">
							<path d="M 0 0.11 L 0 136 L 1920 136 L 1920 1.9 C 1650.0482 79.0955 1327.0648 134 980 134 C 615.6218 134 277.7878 84.5059 0 0.11 Z" fill="#144a6b"/>
						</svg>
					</div>
                    <div class="container metas">
                        <div class="row justify-content-center">
                            <div class="col-lg-8 text-center">
                                <div class="overflow-hidden mb-3">
                                    <h2 class="title appear-animation" data-appear-animation="maskUp">Metas <span class="color4">2030</span></h2>
                                </div>
                            </div>
                        </div>
                        <div class="row justify-content-center pb-5">
                            <div class="col-md-7 col-lg-4 mb-5 mb-lg-0">
                                <div class="circular-bar appear-animation" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="600">
                                    <div class="circular-bar-chart" data-percent="100" data-plugin-options="{'barColor': '#5aba47'}">
                                        <span class="mt-2 percentNumber">100%</span>
                                    </div>
                                </div>
                                <div class="col text-center appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="900">
                                    <h4 class="titleNumber color4">2020</h4>
                                    <p class="px-3 text">Invitar a los ciudadanos a participar en la planeación de la CDMX a través de proyectos colaborativos concretos.</p>
                                </div>
                            </div>

                            <div class="col-md-7 col-lg-4 mb-5 mb-lg-0">
                                <div class="circular-bar appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="400">
                                    <div class="circular-bar-chart" data-percent="50" data-plugin-options="{'barColor': '#5aba47'}">
                                        <span class="mt-2 percentNumber">50%</span>
                                    </div>
                                </div>
                                <div class="col text-center appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="900">
                                    <h4 class="titleNumber color4">2025</h4>
                                    <p class="px-3 text">Crear una alianza plural (gobierno, sociedad civil y privado) para la planeación, conservación y defensa de la CDMX.</p>
                                </div>
                            </div>

                            <div class="col-md-7 col-lg-4">
                                <div class="circular-bar appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="600">
                                    <div class="circular-bar-chart" data-percent="25" data-plugin-options="{'barColor': '#5aba47'}">
                                        <span class="mt-2 percentNumber">25%</span>
                                    </div>
                                </div>
                                <div class="col text-center appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="900">
                                    <h4 class="titleNumber color4">2030</h4>
                                    <p class="px-3 text">Replicar el modelo de Alianza en 5 ciudades metropolitanas del país a través de figuras como institutos de planeación  o consejos de desarrollo metropolitano.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                
                <!-- End Metas Visionario -->

                <!-- Contacto Visionario -->
                <div id="contactoVisionario" class="" data-spy-offset="15">
                    <div class="">
                        <div class="container">
                            <div class="row">
                                <div class="col-lg-6 text-center pb-3 pb-lg-0 mb-5 mb-lg-0 border-right">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="row pb-5 mb-5">
                                                <div class="col">
                                                    <div data-plugin-float-element data-plugin-options="{'startPos': 'top', 'speed': 0.2, 'isInsideSVG': true, 'transition': true, 'transitionDuration': 2000}">
                                                        <i class="fab fa-twitter icon color4"></i>
                                                        <h4 class="mb-0 titleLink">Twitter</h4>
                                                        <a href="https://twitter.com/monicatapiaa" target="_blank" class="mb-0 link">@monicatapiaa</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 pt-5">
                                            <div class="row pb-5 mb-5">
                                                <div class="col">
                                                    <div data-plugin-float-element data-plugin-options="{'startPos': 'bottom', 'speed': 0.1, 'isInsideSVG': true, 'transition': true, 'transitionDuration': 2000}">
                                                        <i class="fab fa-linkedin-in icon color4"></i>
                                                        <h4 class="mb-0 titleLink">Linkedin</h4>
                                                        <a href="https://www.linkedin.com/in/monicatapiaa/" target="_blank" class="mb-0 link">monicatapiaa</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 ps-lg-5 flexBox">
                                    <div class="heading">
                                        <p class="smallTitle">COMUNÍCATE</p>
                                        <p class="title">Contacto</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Contacto Visionario -->

			</div>

			<?php include('footer.php')?>
		</div>

		<!-- Vendor -->
		<script src="vendor/jquery/jquery.min.js"></script>
		<script src="vendor/jquery.appear/jquery.appear.min.js"></script>
		<script src="vendor/jquery.easing/jquery.easing.min.js"></script>
		<script src="vendor/jquery.cookie/jquery.cookie.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
		<script src="vendor/jquery.validation/jquery.validate.min.js"></script>
		<script src="vendor/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
		<script src="vendor/jquery.gmap/jquery.gmap.min.js"></script>
		<script src="vendor/lazysizes/lazysizes.min.js"></script>
		<script src="vendor/isotope/jquery.isotope.min.js"></script>
		<script src="vendor/owl.carousel/owl.carousel.min.js"></script>
		<script src="vendor/magnific-popup/jquery.magnific-popup.min.js"></script>
		<script src="vendor/vide/jquery.vide.min.js"></script>
		<script src="vendor/vivus/vivus.min.js"></script>

		<!-- Theme Base, Components and Settings -->
		<script src="js/theme.js"></script>

		<!-- Current Page Vendor and Views -->
		<script src="js/views/view.contact.js"></script>

		<!-- Theme Custom -->
		<script src="js/custom.js"></script>

		<!-- Theme Initialization Files -->
		<script src="js/theme.init.js"></script>

	</body>
</html>
