(function($){

  	'use strict';

  	jQuery.fn.exists = function(){return this.length>0;}

    jQuery("#primary-menu > li").on('mouseenter mouseleave', function (e) {
        if (jQuery('ul', this).length) {
            var elm = $('ul:first', this);
            var off = elm.offset();
            var l = off.left;
            var w = elm.width();
            var docW = $(".header-nav-wrapper").width();

            var isEntirelyVisible = (l + w <= docW);

            //console.log('left :' + l);
            //console.log('visible :' + isEntirelyVisible);

            if (!isEntirelyVisible) {
                $(this).addClass('edge');
            } else {
                $(this).removeClass('edge');
            }
        }
    });

    if( jQuery(".autoroyal-uploaded-files").exists() ) {

        jQuery('.autoroyal-uploaded-files').sortable({
            placeholder: "col-md-3 image-drag-placeholder"
        });
        jQuery('.autoroyal-uploaded-files').disableSelection();

    };

    if( jQuery(".autoroyal-side-inner-menu").exists() ) {
        jQuery("#primary-menu > li").clone().appendTo(".autoroyal-side-inner-menu");
        jQuery(".autoroyal-compare-menu > li").clone().appendTo(".autoroyal-side-inner-menu");
    }

    if( jQuery("select.chosen-select").exists() ) {
        jQuery('select.chosen-select').chosen({disable_search_threshold: 10});
    };

    if( jQuery(".woocommerce-ordering select.orderby").exists() ) {
        jQuery('.woocommerce-ordering select.orderby').chosen({disable_search_threshold: 10});
    };

    if( jQuery(".autoroyal-page-title").exists() ) {
        jQuery('.site-header:not(.white-header) .main-navigation').css('border-bottom','none');
    };

    if( jQuery(".autoroyal-horizontal-filter-wrapper .autoroyal-homepage-search-box, #autoroyal-advance-search-form.autoroyal-horizontal-car-filter").exists() ) {
        jQuery('.autoroyal-page-title .container').css('padding-bottom','90px');
    };

    var devider_1 = '<div class="devider"><svg class="bg-primary-alt" width="100%" height="96px" viewBox="0 0 100 100" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none"><path d="M0,0 C16.6666667,66 33.3333333,99 50,99 C66.6666667,99 83.3333333,66 100,0 L100,100 L0,100 L0,0 Z"></path></svg></div>';

    if( jQuery(".menu-main-menu-container li.page_item").exists() ) {
        jQuery(".menu-main-menu-container li.page_item").each(function(){
            jQuery(this).addClass("menu-item");
        });
        jQuery(".menu-main-menu-container li.page_item > a").addClass('nav-link');
    };

    if( jQuery(".menu-main-menu-container li.current_page_item").exists() ) {
        jQuery(".menu-main-menu-container li.current_page_item").each(function(){
            jQuery(this).addClass("current-menu-item");
        });
    };

    if( jQuery(".menu-main-menu-container li.page_item_has_children").exists() ) {
        jQuery(".menu-main-menu-container li.page_item_has_children").each(function(){
            jQuery(this).addClass("menu-item-has-children");
        });
    };

    if( jQuery(".menu-main-menu-container ul.children").exists() ) {
        jQuery(".menu-main-menu-container ul.children").each(function(){
            jQuery(this).addClass("sub-menu");
        });
    };

    if( jQuery("section.ar-section-devider").exists() ) {
        jQuery("section.ar-section-devider").each(function(){
            jQuery(this).append(devider_1);
            if (jQuery(this).data('vc-devider-color')) {
                jQuery(this).find('.devider svg').css('fill',jQuery(this).data('vc-devider-color'));
            }
        });
    };

    if( jQuery(".map-content-pattern").exists() ) {
        jQuery('.map-content-pattern').each(function(){
            var color = jQuery(this).data('color');
            var bg_pattern = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="60px" height="60px" viewBox="0 0 60 60" style="enable-background:new 0 0 60 60;" xml:space="preserve"><style type="text/css">.st0{fill:'+color+';}</style><circle class="st0" cx="20" cy="20" r="5"/><circle class="st0" cx="35" cy="35" r="5"/><circle class="st0" cx="5" cy="35" r="5"/><circle class="st0" cx="5" cy="5" r="5"/><circle class="st0" cx="35" cy="5" r="5"/><circle class="st0" cx="50" cy="20" r="5"/><circle class="st0" cx="20" cy="50" r="5"/><circle class="st0" cx="50" cy="50" r="5"/></svg>';      
            var encoded = window.btoa(bg_pattern);
            jQuery(this).css("background", "url(data:image/svg+xml;base64,"+encoded+")");
        });
    };

     if( jQuery(".car-makes-section-bg").exists() ) {
        jQuery( '.car-makes-section-bg' ).prepend('<div class="car-makes-bg-holder"><div class="car-makes-animated-pattern"></div></div>');
        //jQuery( '.car-makes-section-bg' ).prepend('<div class="car-makes-bg-holder"><div class="car-makes-pattern-big rellax" data-0="transform: translateY(0px);" data-600="transform: translateY(300px);"></div><div class="car-makes-pattern-small rellax" data-0="transform: translateY(0px);" data-600="transform: translateY(200px);"></div></div>');
    };


    if( jQuery(".ar-section-bg").exists() ) {
        jQuery( '.ar-section-bg' ).prepend('<div class="ar-section-pattern-holder"></div><div class="ar-section-bg-holder"></div>');

        jQuery('.ar-section-bg').each(function(){
            var section_id = jQuery(this).data('unique-id');

            if (jQuery(".ar-section-bg.data-unique-id-"+section_id).data('vc-bg-offset-y')) {
                var offset_y = jQuery(".ar-section-bg.data-unique-id-"+section_id).data('vc-bg-offset-y');
                jQuery(".ar-section-bg.data-unique-id-"+section_id+" .ar-section-bg-holder").css("margin-bottom", offset_y);
                if(jQuery(".ar-section-bg.data-unique-id-"+section_id+".ar-section-pattern-offset-top").exists() ) {
                    jQuery(".ar-section-bg.data-unique-id-"+section_id+" .ar-section-pattern-holder").css("margin-bottom", offset_y + 30);
                } else {
                    jQuery(".ar-section-bg.data-unique-id-"+section_id+" .ar-section-pattern-holder").css("margin-bottom", offset_y - 30);
                }
            }

            if (jQuery(".ar-section-bg.data-unique-id-"+section_id).data('vc-bg-offset-x')) {
                var offset_x = jQuery(".ar-section-bg.data-unique-id-"+section_id).data('vc-bg-offset-x');
                jQuery(".ar-section-bg.data-unique-id-"+section_id+".ar-section-bg-oriented-left .ar-section-bg-holder").css("margin-left", offset_x);
                jQuery(".ar-section-bg.data-unique-id-"+section_id+".ar-section-bg-oriented-right .ar-section-bg-holder").css("margin-right", offset_x);
                jQuery(".ar-section-bg.data-unique-id-"+section_id+".ar-section-bg-oriented-left .ar-section-pattern-holder").css("margin-left", offset_x - 30);
                jQuery(".ar-section-bg.data-unique-id-"+section_id+".ar-section-bg-oriented-right .ar-section-pattern-holder").css("margin-right", offset_x - 30);
            }

            if (jQuery(".ar-section-bg.data-unique-id-"+section_id).data('vc-bg-color')) {
                var bg_color = jQuery(".ar-section-bg.data-unique-id-"+section_id).data('vc-bg-color');
                jQuery(".ar-section-bg.data-unique-id-"+section_id+" .ar-section-bg-holder").css("background-color", bg_color);
            }

            if (jQuery(".ar-section-bg.data-unique-id-"+section_id).data('vc-bg-pattern-color')) {
                var bg_color = jQuery(".ar-section-bg.data-unique-id-"+section_id).data('vc-bg-pattern-color');
                var bg_pattern = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="60px" height="60px" viewBox="0 0 60 60" style="enable-background:new 0 0 60 60;" xml:space="preserve"><style type="text/css">.st0{fill:'+bg_color+';}</style><circle class="st0" cx="20" cy="20" r="5"/><circle class="st0" cx="35" cy="35" r="5"/><circle class="st0" cx="5" cy="35" r="5"/><circle class="st0" cx="5" cy="5" r="5"/><circle class="st0" cx="35" cy="5" r="5"/><circle class="st0" cx="50" cy="20" r="5"/><circle class="st0" cx="20" cy="50" r="5"/><circle class="st0" cx="50" cy="50" r="5"/></svg>';      
                var encoded = window.btoa(bg_pattern);
                jQuery(".ar-section-bg.data-unique-id-"+section_id+" .ar-section-pattern-holder").css("background", "url(data:image/svg+xml;base64,"+encoded+")");
            }
        });
    };

    if( jQuery(".open_range").exists() ) {
        jQuery("a.open_range").on("click", function(){  
            jQuery(this).parent().find(".range-container").toggleClass("open");
            jQuery(this).parent().toggleClass("active");
            return false;
        });
    };

    $(document).mouseup(function(e){
        var container = $(".range-container");

        // If the target of the click isn't the container
        if(!container.is(e.target) && container.has(e.target).length === 0){
            container.removeClass('open');
            container.parent().removeClass("active");
        }

        var container_form = $("#autoroyal-advance-search-form");
        // If the target of the click isn't the container
        if(!container_form.is(e.target) && container_form.has(e.target).length === 0){
            container_form.removeClass('open');
        }
    });

    if( jQuery(".chosen-container-single .chosen-single div").exists() ) {
        jQuery(".chosen-container-single .chosen-single div").html('<i class="material-icons">expand_more</i>');
    }

    if( $('#car-rent-details').exists() ) {
        if( $('#car-rent-details').is(':empty') ) {
            var car_id = jQuery("#rent_vehicle_id option[value='1']").data("id");
            load_car_details( car_id );
        }
    }

    jQuery("#menu-search-button a").on("click", function(){  
        jQuery("#big-search-holder").toggleClass("modal-active");
        return false;
    });

    jQuery(".close-big-search-holder").on("click", function(){   
        jQuery("#big-search-holder").toggleClass("modal-active");
        return false;
    });

    jQuery('select#rent_vehicle_id').change(function(){
        var car_id = $(this).find(':selected').data('id')
        load_car_details( car_id );
    });

    jQuery('#curentDay-filter, #curentDay, #curentHour-filter, #curentHour').on('focus', function() {
        document.body.scrollTop = $(this).offset().top;
    });

    function load_car_details( car_id ) {

        var fd = new FormData();
        fd.append('car_ID', car_id);
        fd.append('action', 'autoroyal_ajax_load_rent_car_details');

        $.ajax({
            type: 'POST',
            url: autoroyalSettings.autoroyal_ajaxurl,
            dataType: 'json',
            data: fd,
            contentType: false,
            processData: false,
            beforeSend: function(){
                //
                jQuery("#car-rent-details").html( "<i class='fa fa-spinner fa-spin fa-fw'></i>" );
            },
            success: function (data) {
                //console.log("success")
                console.log(car_id);
                //console.log(data.car_id);
                jQuery("#car-rent-details").html( data.html );

            },
            error:  function (data) {
                //console.log("error")
                //console.log(data);
            },
        });

    }

    if( $('#rent-price-table').exists() ) {
        if( $('#rent-price-table').is(':empty') ) {
            var car_id = jQuery("#rent_vehicle_id option[value='1']").data("id");
            load_car_price_sets( car_id );
        }
    }

    jQuery('select#rent_vehicle_id').change(function(){
        var car_id = $(this).find(':selected').data('id');
        jQuery("#reserv-car-id-2").val(car_id);
        load_car_price_sets( car_id );
    });

    if( !jQuery("#reserv-car-id-2").val() ) {
        var car_id = jQuery("#rent_vehicle_id option[value='1']").data("id");
        jQuery("#reserv-car-id-2").val(car_id);
    }

    function load_car_price_sets( car_id ) {

        var fd = new FormData();
        fd.append('car_ID', car_id);
        fd.append('action', 'autoroyal_ajax_load_rent_car_price');

        $.ajax({
            type: 'POST',
            url: autoroyalSettings.autoroyal_ajaxurl,
            dataType: 'json',
            data: fd,
            contentType: false,
            processData: false,
            beforeSend: function(){
                //
                jQuery("#rent-price-table").html("<li id='update-price-sets-list'><i class='fa fa-spinner fa-spin fa-fw'></i></li>");
            },
            success: function (data) {
                //console.log("success")
                //console.log(car_id);
                //console.log(data.car_id);
                jQuery("#rent-price-table").html( data.html );

                if( $("#pickup_date").val() && $("#return_date").val() ) {
                    calculate_days_rent();
                }

            },
            error:  function (data) {
                //console.log("error")
                //console.log(data);
            },
        });

    }

    jQuery('#pickup_date, #return_date').change(function(){
        if( $("#pickup_date").val() && $("#return_date").val() ) {
            calculate_days_rent();
        }
    });

    jQuery('#curentDay, #dropDay').change(function(){
        if( $("#curentDay").val() && $("#dropDay").val() ) {
            calculate_days();
        }
    });

    function getAsDate(day, time) {

        var hours = Number(time.match(/^(\d+)/)[1]);
        var minutes = Number(time.match(/:(\d+)/)[1]);
        var AMPM = time.match(/\s(.*)$/)[1];
        if(AMPM == "pm" && hours<12) hours = hours+12;
        if(AMPM == "am" && hours==12) hours = hours-12;
        var sHours = hours.toString();
        var sMinutes = minutes.toString();
        if(hours<10) sHours = "0" + sHours;
        if(minutes<10) sMinutes = "0" + sMinutes;
        time = sHours + ":" + sMinutes + ":00";
        var d = new Date(day);
        var n = d.toISOString().substring(0,10);
        var newDate = new Date(n+"T"+time);
        return newDate;

    }

    function calculate_days() {

        // Calculate Rent Price
        var pickup_date = $("#curentDay").val(),
            pickup_time = "12:00 PM",
            drop_date = $("#dropDay").val(),
            drop_time = "12:00 PM",
            c = 24*60*60*1000;

        var pickup = getAsDate(pickup_date, pickup_time),
            drop = getAsDate(drop_date, drop_time),
            diffDays = Math.round(Math.abs((drop - pickup)/(c)));

        jQuery("#daysN span").text(diffDays);
        jQuery("#reserv_car_days").val(diffDays);

        var new_price = 0;
        var total_sets = jQuery('#car-price-sets .total-sets').val();
        //console.log(total_sets);

        for (var n = 0; n <= total_sets; ++ n) {
            if( jQuery('#car-price-sets #price-set-period-'+n).val() <= diffDays ) {
                new_price = jQuery('#car-price-sets #price-set-price-'+n).val();
            }
        }

        if( new_price == 0 ) {
            new_price = jQuery('#dayP span').text("0");
        } 

        jQuery('#dayP span').text( new_price );
        jQuery('.reserv-car-price-day').val( new_price );

        var total_price = new_price * diffDays;

        jQuery("#totDayP span").text(total_price);
        jQuery("#reserv-car-price-total, #reserv-car-price-without-extras").val(total_price);

        update_extras_total_price();
    }

    function calculate_days_rent() {

        // Calculate Rent Price
        var pickup_date = $("#pickup_date").val(),
            pickup_time = "12:00 PM",
            drop_date = $("#return_date").val(),
            drop_time = "12:00 PM",
            c = 24*60*60*1000;

        var pickup = getAsDate(pickup_date, pickup_time),
            drop = getAsDate(drop_date, drop_time),
            diffDays = Math.round(Math.abs((drop - pickup)/(c)));

        jQuery("#daysN span").text(diffDays);
        jQuery("#reserv_car_days").val(diffDays);

        var new_price = 0;
        var total_sets = jQuery('#rent-price-table .total-sets').val();
        //console.log(total_sets);

        for (var n = 0; n <= total_sets; ++ n) {
            if( jQuery('#rent-price-table #price-set-period-'+n).val() <= diffDays ) {
                new_price = jQuery('#rent-price-table #price-set-price-'+n).val();
            }
        }

        if( new_price == 0 ) {
            new_price = jQuery('#dayP span').text("0");
        } 

        jQuery('#dayP span').text( new_price );
        jQuery('.reserv-car-price-day').val( new_price );

        var total_price = new_price * diffDays;

        jQuery("#totDayP span").text(total_price);
        jQuery("#reserv-car-price-total, #reserv-car-price-without-extras").val(total_price);

        update_extras_total_price();
    }

    jQuery('.extra-option-group input[type=checkbox]').change(function(){

        var option_id = $(this).data('id');

        if( jQuery(this).prop('checked') ) {
            jQuery("#extra-option-"+option_id+" select.extra-options-multiple-selections option[value='1']").prop("selected", true);
            jQuery("#extra-option-"+option_id+" select.extra-options-multiple-selections").val("1");
        } else {
            jQuery("#extra-option-"+option_id+" select.extra-options-multiple-selections option[value='0']").prop("selected", true);
            jQuery("#extra-option-"+option_id+" select.extra-options-multiple-selections").val("0");
        }

        var extra_total = true;
        calculate_extra_options_price( option_id, extra_total );

    });

    jQuery('select.extra-options-multiple-selections').change(function(){

        var option_id = $(this).data('id');

        if($(this).val() == '0'){

            jQuery("#extra-option-"+option_id+" input[type=checkbox]").prop('checked', false);

        } else {

            jQuery("#extra-option-"+option_id+" input[type=checkbox]").prop('checked', true);

        }

        var extra_total = true;
        calculate_extra_options_price( option_id, extra_total );

    });

    function calculate_extra_options_price( option_id, extra_total ) {

        var currency_symbol = jQuery("#extras-currency-symbol").val();

        var option_name = jQuery("#extra-option-"+option_id+" input[type=checkbox]").data('name');

        var total_days = 1;
        if( jQuery("#extra-option-"+option_id+" input[type=checkbox]").data('type') == "per_day" ) {
            total_days = jQuery('#reserv-car-days').val();
        }

        var total_units = 1;
        if( jQuery("#extra-option-"+option_id+" select.extra-options-multiple-selections").exists() ) {
            total_units = jQuery("#extra-option-"+option_id+" select.extra-options-multiple-selections").val();
        }
        
        var price = jQuery("#extra-option-"+option_id+" input[type=checkbox]").data('price');

        if( jQuery("#extra-option-"+option_id+" input[type=checkbox]").attr('checked') ) {

            var total_price = price * total_days * total_units;
            jQuery("#extra-option-val-"+option_id).remove();
            jQuery('<li id="extra-option-val-'+option_id+'" class="extra-option-val clearfix" data-id='+option_id+'><span class="pull-left">'+option_name+'</span><span class="pull-right"><b class="extraP">'+currency_symbol+'<span>'+total_price+'</span></b></span></li>').insertBefore("#rent_extra_options ul.result-dates li.reservation-total");

        } else {

            var total_price = 0;
            jQuery("#extra-option-val-"+option_id).remove();

        }

        if( extra_total ) {
            update_extras_total_price();
        }

    }

    function update_extras_total_price() {

        if( jQuery("#reserv-car-price-without-extras").exists() ) {
            var subtotal_price = parseInt(jQuery("#reserv-car-price-without-extras").val(), 10);
        } else if( jQuery("#totDayP").exists() ) {
            var subtotal_price = parseInt(jQuery("#totDayP span").text(), 10);
        } else {
            var subtotal_price = 1;
        }
        
        var price = subtotal_price;
        var extra_options_price = 0;
        jQuery('#rent_extra_options ul.result-dates li.extra-option-val').each(function(){

            var option_id = jQuery(this).data('id');

            var currency_symbol = jQuery("#extras-currency-symbol").val();

            var option_name = jQuery("#extra-option-"+option_id+" input[type=checkbox]").data('name');

            var total_days = 1;
            if( jQuery("#extra-option-"+option_id+" input[type=checkbox]").data('type') == "per_day" ) {
                total_days = jQuery('#reserv-car-days').val();
            }

            var total_units = 1;
            if( jQuery("#extra-option-"+option_id+" select.extra-options-multiple-selections").exists() ) {
                total_units = jQuery("#extra-option-"+option_id+" select.extra-options-multiple-selections").val();
            }
            
            var price = jQuery("#extra-option-"+option_id+" input[type=checkbox]").data('price');

            var total_price = price * total_days * total_units;
            jQuery("#extra-option-val-"+option_id).remove();
            jQuery('<li id="extra-option-val-'+option_id+'" class="extra-option-val clearfix" data-id='+option_id+'><span class="pull-left">'+option_name+'</span><span class="pull-right"><b class="extraP">'+currency_symbol+'<span>'+total_price+'</span></b></span></li>').insertBefore("#rent_extra_options ul.result-dates li.reservation-total");

            extra_options_price += total_price;

        });

        price += extra_options_price;

        jQuery(".totDayP span").text(price);
        jQuery("#reserv-car-price-total").val(price);
        jQuery("#reserv-car-price-extras").val(extra_options_price);

    }

    if( jQuery(".autoroyal-panel-group").exists() ) {

        jQuery(".autoroyal-panel-group").find('.card:first-of-type .collapse').addClass('show');
        jQuery(".autoroyal-panel-group").find('.autoroyal-panel-title button').addClass('collapsed');
        jQuery(".autoroyal-panel-group").find('.card:first-of-type .autoroyal-panel-title button').removeClass('collapsed');

    }

    var reset_btn = 0;

    function getAsDate(day, time) {

        var hours = Number(time.match(/^(\d+)/)[1]);
        var minutes = Number(time.match(/:(\d+)/)[1]);
        var AMPM = time.match(/\s(.*)$/)[1];
        if(AMPM == "pm" && hours<12) hours = hours+12;
        if(AMPM == "am" && hours==12) hours = hours-12;
        var sHours = hours.toString();
        var sMinutes = minutes.toString();
        if(hours<10) sHours = "0" + sHours;
        if(minutes<10) sMinutes = "0" + sMinutes;
        time = sHours + ":" + sMinutes + ":00";
        var d = new Date(day);
        var n = d.toISOString().substring(0,10);
        var newDate = new Date(n+"T"+time);
        return newDate;

    }

    // show more options filter to fixed bottom bar
    $(document).on('click', '.autoroyal-reserve-vehicle', function(e){

        e.preventDefault();
        //jQuery("#reservation-modal").addClass('open');
        //$('body').css('overflow', 'hidden');
            
        //
        var car_id = $(this).data('car-id');
        var img_src = $(this).data('car-thumb');

        jQuery("#reservation-modal h3.reserv-title").html( jQuery("#car-rent-id-"+car_id+" .autoroyal-vehicle-block-meta a.heading").html() );
        jQuery("#reservation-modal ul.reserv-subtitle").html( jQuery("#car-rent-id-"+car_id+" .autoroyal-vehicle-block-meta .autoroyal-rent-subtitle").html() );

        jQuery("#reserv-car-id").val( car_id );

        jQuery("#reservation-modal .car-preview .image").html('<img src="'+img_src+'" alt="car-preview-image" class="img-responsive">');

        jQuery('.chosen-select').trigger("chosen:updated");

        jQuery("#reservation-modal #curentDay").val(jQuery('#car-rent-id-'+car_id+' .pickup-date-select .daySelect').val());
        jQuery("#reservation-modal #curentHour").val(jQuery('#car-rent-id-'+car_id+' .pickup-time-select .timeSelect').val());
        jQuery("#pickT, .pickT").text( jQuery('#car-rent-id-'+car_id+' .pickup-time-select .timeSelect').val() );

        jQuery("#reservation-modal #dropDay").val(jQuery('#car-rent-id-'+car_id+' .dropoff-date-select .daySelect').val());
        jQuery("#reservation-modal #dropHour").val(jQuery('#car-rent-id-'+car_id+' .dropoff-time-select .timeSelect').val());
        jQuery("#dropT, .dropT").text(jQuery('#car-rent-id-'+car_id+' .dropoff-time-select .timeSelect').val());

        jQuery("#reservation-modal #car-price-sets").html(jQuery('#car-price-sets-'+car_id).html());

        jQuery("#reservation-modal #rent-price-table").html(jQuery('#rent-price-table-'+car_id).html());

        jQuery('#reserv-car-days').val( 0 );

        if( jQuery("#curentDay-filter").exists() ) {
            jQuery("#curentDay").val( jQuery("#curentDay-filter").val() );
            jQuery("#dropDay").val( jQuery("#dropDay-filter").val() );
            jQuery("#curentHour").val( jQuery("#curentHour-filter").val() );
            jQuery("#pickT, .pickT").text( jQuery("#curentHour-filter").val() );
            jQuery("#dropHour").val( jQuery("#dropHour-filter").val() );
            jQuery("#dropT, .dropT").text(jQuery("#dropHour-filter").val());
            jQuery("#daysN").text( jQuery('.autoroyal-rent-booking-dates-rental-period .date').text() );
        } else {

            var d = new Date();
            var month = d.getMonth()+1;
            var day = d.getDate();
            var output = (month<10 ? '0' : '') + month + '/' + (day<10 ? '0' : '') + day + '/' + d.getFullYear();
            
            jQuery("#curentDay").val( output );

            var date = new Date( jQuery('#curentDay').val() );
            var newdate = new Date(date);
            newdate.setDate(newdate.getDate() + 3);
            var dd = newdate.getDate();
            var mm = newdate.getMonth() + 1;
            var y = newdate.getFullYear();
            var someFormattedDate = (mm<10 ? '0' : '') + mm + '/' + (dd<10 ? '0' : '') + dd + '/' + y;

            jQuery("#dropDay").val( someFormattedDate );
            jQuery("#curentHour").val( "12:00 PM" );
            jQuery("#pickT, .pickT").text( "12:00 PM" );
            jQuery("#dropHour").val( "12:00 PM" );
            jQuery("#dropT, .dropT").text( "12:00 PM" );
            jQuery("#daysN").text( 0 );
        }

        jQuery("#startR, .startR").text( jQuery("#curentDay").val() );
        jQuery("#endR, .endR").text( jQuery("#dropDay").val() );

        // Calculate Rent Price
        var pickup_date = $("#curentDay").val(),
            pickup_time = "12:00 PM",
            drop_date = $("#dropDay").val(),
            drop_time = "12:00 PM",
            c = 24*60*60*1000;

        var pickup = getAsDate(pickup_date, pickup_time),
            drop = getAsDate(drop_date, drop_time),
            diffDays = Math.round(Math.abs((drop - pickup)/(c)));

        jQuery('#reserv-car-days').val( diffDays );
        jQuery('.autoroyal-rent-booking-dates-rental-period .date').text( diffDays );

        jQuery("#daysN, .daysN").text(diffDays + " days");
        jQuery("#startR, .startR").text( jQuery('#curentDay').val() );
        jQuery("#endR, .endR").text( jQuery('#dropDay').val() );

        var new_price = 0;
        var total_sets = jQuery('#reservation-modal #car-price-sets .total-sets').val();
        //console.log(total_sets);

        for (var n = 0; n <= total_sets; ++ n) {
            if( jQuery('#reservation-modal #car-price-sets #price-set-period-'+n).val() <= diffDays ) {
                new_price = jQuery('#reservation-modal #car-price-sets #price-set-price-'+n).val();
            }
        }

        if( new_price == 0 ) {
            new_price = jQuery('#dayP span').html();
        } 

        jQuery('.reserv-car-price-day').val( new_price );

        //console.log(new_price);

        // output calculate costs
        var days_num  = diffDays;
        var total_p   = new_price * diffDays;
        var reduced_p = new_price * diffDays;

        jQuery("#dayP span, .dayP span").text(new_price);

        jQuery("#totDayP span, .totDayP span").text(total_p);
        jQuery("#reserv-car-price-total, #reserv-car-price-without-extras").val(total_p);
        
        update_extras_total_price();

        jQuery('#reserv-car-price-total').val( total_p );

    });

    function autoroyal_update_rent_car_price() {

        $('#inventory-vehicles-holder #isotope-container .autoroyal-vehicle-item').each(function(){
            var car_id = $(this).data('car-id');
            autoroyal_calculate_price_each_car( car_id );
        });

    }

    function autoroyal_calculate_price_each_car( car_id ) {

        // Calculate Rent Price
        var pickup_date = $("#curentDay-filter").val(),
            pickup_time = "12:00 PM",
            drop_date = $("#dropDay-filter").val(),
            drop_time = "12:00 PM",
            c = 24*60*60*1000;

        var pickup = getAsDate(pickup_date, pickup_time),
            drop = getAsDate(drop_date, drop_time),
            diffDays = Math.round(Math.abs((drop - pickup)/(c))),
            price_day = jQuery('#car-rent-id-' + car_id + ' .autoroyal-vehicle-block-meta-price .rent-price span').text();

        if( diffDays > 1 ) {

            var new_price = 0;
            var total_sets = jQuery('#car-price-sets-' + car_id + ' .total-sets').val();
            //console.log(total_sets);

            for (var n = 0; n <= total_sets; ++ n) {
                if( jQuery('#car-price-sets-' + car_id + ' #price-set-period-'+n).val() <= diffDays ) {
                    new_price = jQuery('#car-price-sets-' + car_id + ' #price-set-price-'+n).val();
                }
            }

            var total_p = new_price * diffDays;

            jQuery('#car-rent-id-' + car_id + ' .autoroyal-vehicle-block-meta-price').addClass("period-price");
            jQuery('#car-rent-id-' + car_id + ' .autoroyal-vehicle-block-meta-price .rent-price-period span.price').text( total_p );
            jQuery('#car-rent-id-' + car_id + ' .autoroyal-vehicle-block-meta-price .rent-price-period span.period').text( diffDays );

            jQuery('#car-rent-id-' + car_id).data('price', total_p);
            jQuery('#car-rent-id-' + car_id).attr('data-price', total_p);

            jQuery('#car-rent-grid-id-' + car_id + ' .autoroyal-vehicle-block-meta-price').addClass("period-price");
            jQuery('#car-rent-grid-id-' + car_id + ' .autoroyal-vehicle-block-meta-price .rent-price-period span.price').text( total_p );
            jQuery('#car-rent-grid-id-' + car_id + ' .autoroyal-vehicle-block-meta-price .rent-price-period span.period').text( diffDays );

            jQuery('#car-rent-grid-id-' + car_id).data('price', total_p);
            jQuery('#car-rent-grid-id-' + car_id).attr('data-price', total_p);

        } else {
            jQuery('#car-rent-id-' + car_id + ' .autoroyal-vehicle-block-meta-price').removeClass("period-price");
            jQuery('#car-rent-id-' + car_id).data('price', price_day);
            jQuery('#car-rent-id-' + car_id).attr('data-price', price_day);

            jQuery('#car-rent-grid-id-' + car_id + ' .autoroyal-vehicle-block-meta-price').removeClass("period-price");
            jQuery('#car-rent-grid-id-' + car_id).data('price', price_day);
            jQuery('#car-rent-grid-id-' + car_id).attr('data-price', price_day);
        }

        //jQuery('#isotope-container').isotope( 'updateSortData', $('#isotope-container').children() );

    }

    jQuery('#rezerve-pickup-place').change(function(){
        jQuery('#rezerve-dropoff-place').val( jQuery('#rezerve-pickup-place').val() );
        jQuery('.pickLocation').text( jQuery('#rezerve-pickup-place').val() );
        jQuery('.dropLocation').text( jQuery('#rezerve-pickup-place').val() );
        $('.chosen-select').trigger("chosen:updated");
    });

    jQuery('#rezerve-dropoff-place').change(function(){
        jQuery('.dropLocation').text( jQuery('#rezerve-dropoff-place').val() );
    });

    jQuery('#rezerve-pickup-place-filter').change(function(){
        jQuery('#rezerve-pickup-place').val( jQuery('#rezerve-pickup-place-filter').val() );
        jQuery('#rezerve-dropoff-place').val( jQuery('#rezerve-pickup-place').val() );
        jQuery('#rezerve-drop-place-filter').val( jQuery('#rezerve-pickup-place-filter').val() );

        jQuery('.autoroyal-rent-booking-dates-pickup-location').text( jQuery('#rezerve-pickup-place-filter').val() );
        jQuery('.autoroyal-rent-booking-dates-return-location').text( jQuery('#rezerve-pickup-place-filter').val() );

        jQuery('.pickLocation').text( jQuery('#rezerve-pickup-place-filter').val() );
        jQuery('.dropLocation').text( jQuery('#rezerve-pickup-place-filter').val() );

        $('.chosen-select').trigger("chosen:updated");
    });

    jQuery('#rezerve-drop-place-filter').change(function(){
        jQuery('#rezerve-dropoff-place').val( jQuery('#rezerve-drop-place-filter').val() );
        jQuery('.autoroyal-rent-booking-dates-return-location').text( jQuery('#rezerve-drop-place-filter').val() );
        jQuery('.dropLocation').text( jQuery('#rezerve-drop-place-filter').val() );
    });

    // 
    $('#curentDay').focus(function() {
        jQuery('#curentDay').removeClass('error');
    });

    $('#curentHour').focus(function() {
        jQuery('#curentHour').removeClass('error');
    });

    $('#dropDay').focus(function() {
        jQuery('#dropDay').removeClass('error');
    });

    $('#dropHour').focus(function() {
        jQuery('#dropHour').removeClass('error');
    });

    function autoroyal_ajax_reserv_the_car_step_one() {

        var errors = 0;

        var pickup_date = $("#curentDay").val();
        var pickup_time = $("#curentHour").val();
        var drop_date = $("#dropDay").val();
        var drop_time = $("#dropHour").val();

        if ( pickup_date.length === 0 ) {
            errors = 1;
            jQuery('#curentDay').addClass('error');
            return;
        }

        if ( pickup_time.length === 0 ) {
            errors = 1;
            jQuery('#curentHour').addClass('error');
            return;
        }

        if ( drop_date.length === 0 ) {
            errors = 1;
            jQuery('#dropDay').addClass('error');
            return;
        }

        if ( drop_time.length === 0 ) {
            errors = 1;
            jQuery('#dropHour').addClass('error');
            return;
        }

        if( errors == 0 ) {
            return true;
        } else {
            return false;
        }

    }

    //
    $('#reserve-name').keypress(function() {
        jQuery('#reserve-name').removeClass('error');
        jQuery(this).focus();
    });

    $('#reserve-phone').keypress(function() {
        jQuery('#reserve-phone').removeClass('error');
        jQuery(this).focus();
    });

    $('#reserve-age').keypress(function() {
        jQuery('#reserve-age').removeClass('error');
        jQuery(this).focus();
    });

    $('#reserve-email').keypress(function() {
        jQuery('#reserve-email').removeClass('error');
        jQuery(this).focus();
    });

    function autoroyal_ajax_reserv_the_car_step_two() {

        var errors = 0;

        var username = $("#reserve-name").val();
        var phone = $("#reserve-phone").val();
        var age = $("#reserve-age").val();
        var email = $("#reserve-email").val();

        if ( username.length === 0 ) {
            errors = 1;
            jQuery('#reserve-name').addClass('error');
            return;
        }

        if ( phone.length === 0 ) {
            errors = 1;
            jQuery('#reserve-phone').addClass('error');
            return;
        }

        if ( age.length === 0 ) {
            errors = 1;
            jQuery('#reserve-age').addClass('error');
            return;
        }

        if ( email.length === 0 && ! validateEmail( email ) ) {
            errors = 1;
            jQuery('#reserve-email').addClass('error');
            return;
        }

        if( errors == 0 ) {
            return true;
        } else {
            return false;
        }

    }

    $('#reservation-next-step').click(function(e){
        e.preventDefault();
        var next_step = autoroyal_ajax_reserv_the_car_step_one();
        if( next_step ) {

            if( jQuery("#rent_extra_options").exists() ) {
                $('#place_car_reservation .nav-tabs a[href="#rent_extra_options"]').tab('show');
            } else {
                $('#place_car_reservation .nav-tabs a[href="#contact_info"]').tab('show');
            }

        }
    });

    $('#reservation-extras-step').click(function(e){
        e.preventDefault();
        $('#place_car_reservation .nav-tabs a[href="#contact_info"]').tab('show');
    });

    // Reserv the car
    function autoroyal_ajax_reserv_the_car() {

        $(document).on('click', '#submit-reservation', function(e){
            e.preventDefault();
            var reserv_car = {
                type: "POST",
                dataType: 'json',
                data: $(this).serialize() + '&action=autoroyal_ajax_place_reservation',
                beforeSubmit:  function(){
                    //
                    jQuery("#submit-reservation .fa").removeClass("fa-angle-right");
                    jQuery("#submit-reservation .fa").addClass("fa-spinner");
                    jQuery("#submit-reservation .fa").addClass("fa-spin");
                },
                success: function(data){
                    //console.log(data);
                    jQuery("#submit-reservation .fa").addClass("fa-angle-right");
                    jQuery("#submit-reservation .fa").removeClass("fa-spinner");
                    jQuery("#submit-reservation .fa").removeClass("fa-spin");
                    jQuery("#reservation-modal-response").fadeIn();
                },
                error: function(data){
                    //console.log(data);
                    //
                    jQuery("#submit-reservation .fa").addClass("fa-angle-right");
                    jQuery("#submit-reservation .fa").removeClass("fa-spinner");
                    jQuery("#submit-reservation .fa").removeClass("fa-spin");
                }
            };

            var errors = 0;
            var step_one = autoroyal_ajax_reserv_the_car_step_one();
            var step_two = autoroyal_ajax_reserv_the_car_step_two();

            if( !step_one ) {
                $('#place_car_reservation .nav-tabs a[href="#order_details"]').tab('show');
                errors = 1;
                return false;
            } else if( !step_two ) {
                errors = 1;
                return false;
            }

            if( errors == 0 ) {
                $('#place_car_reservation').ajaxSubmit( reserv_car );
            } else {
                return false;
            }

        });
    }
    // End

    $(window).load(function() {

        jQuery('#pageloader').fadeOut(600, function() {

            init_animations_after_preloader();

        });

        if( jQuery(".owl-image-slider").exists() ) {

            // testimonials carousel
            jQuery('.owl-image-slider').owlCarousel({
                loop: false,
                margin: 10,
                nav: true,
                dots: false,
                items: 1,
                smartSpeed: 400,
                autoplay: true,
                autoplayTimeout: 3000,
                autoHeight: true,
                navText: [
                   "<i class='material-icons'>chevron_left</i>",
                   "<i class='material-icons'>chevron_right</i>"
                ]
            });

        }

        if( jQuery(".testimonials-carousel").exists() ) {

            // testimonials carousel
            jQuery('.testimonials-carousel').owlCarousel({
                loop: true,
                margin: 10,
                dots: false,
                nav: true,
                items: 1,
                smartSpeed: 400,
                autoplay: true,
                autoplayTimeout: 7000,
                autoHeight: true,
                navText: [
                   "<i class='material-icons'>chevron_left</i>",
                   "<i class='material-icons'>chevron_right</i>"
                ]
            });

        }

        if( jQuery(".team-carousel").exists() ) {

            // testimonials carousel
            jQuery('.team-carousel').owlCarousel({
                loop: true,
                margin: 30,
                dots: true,
                responsive:{
                    0:{
                        items: 1
                    },
                    400:{
                        items: 1
                    },
                    600:{
                        items: 2
                    },
                    800:{
                        items: 2
                    },
                    1000:{
                        items: 2
                    }
                },
                smartSpeed: 700,
                autoplay: false,
                autoplayTimeout: 5000,
                autoHeight: true,
            });

        }

        if( jQuery(".vehicles-style2-carousel").exists() ) {

            // vehicles carousel
            jQuery('.vehicles-style2-carousel').owlCarousel({
                loop: false,
                margin: 0,
                nav: true,
                dots: false,
                smartSpeed: 700,
                items: 1,
                animateIn: 'fadeIn', // add this
                animateOut: 'fadeOut', // and this
                autoplay: true,
                autoplayHoverPause: true,
                autoplayTimeout: 3000,
                autoHeight: true,
            });

        }

        if( jQuery(".vehicles-carousel").exists() ) {

            // vehicles carousel
            jQuery('.vehicles-carousel').owlCarousel({
                loop: false,
                margin: 30,
                nav: true,
                dots: false,
                smartSpeed: 700,
                responsive:{
                    0:{
                        items: 1
                    },
                    400:{
                        items: 1
                    },
                    600:{
                        items: 2
                    },
                    800:{
                        items: 3
                    },
                    1025:{
                        items: 4
                    }
                }
            });

        }

        if( jQuery(".autoroyal-latest-vehicles .autoroyal-carousel-view-all").exists() ) {
            jQuery(".autoroyal-latest-vehicles .autoroyal-carousel-view-all").clone().appendTo(".vehicles-carousel");
            jQuery(".autoroyal-latest-vehicles .vehicles-carousel .autoroyal-carousel-view-all").removeClass("hidden");
        }

        if( jQuery(".locations-carousel").exists() ) {

            // vehicles carousel
            jQuery('.locations-carousel').owlCarousel({
                loop: false,
                margin: 30,
                nav: true,
                dots: false,
                smartSpeed: 700,
                responsive:{
                    0:{
                        items: 1
                    },
                    400:{
                        items: 1
                    },
                    600:{
                        items: 2
                    },
                    800:{
                        items: 2
                    },
                    1000:{
                        items: 3
                    }
                }
            });

        }

    });

    // count animation
    if( jQuery(".count").exists() ) {
        jQuery(".count").one("inview", function(event, isInView) {
            if (isInView) {
                var duration = 1000;
                if(jQuery(this).text() >= 10) {
                    var duration = 1500;
                }
                if(jQuery(this).text() >= 100) {
                    var duration = 2500;
                }
                if(jQuery(this).text() >= 500) {
                    var duration = 3500;
                }
                if(jQuery(this).text() >= 1000) {
                    var duration = 4000;
                }
                jQuery(this).prop('Counter',0).animate({
                    Counter: jQuery(this).text()
                }, {
                    duration: duration,
                    easing: 'swing',
                    step: function (now) {
                        jQuery(this).text(Math.ceil(now));
                    }
                });
            }
        });
    };

    $(document).on('click', '#autoroyal-advanced-options', function(e){
        e.preventDefault();
        if( jQuery("#autoroyal-advance-search-form").hasClass("open") ) {
            jQuery("#autoroyal-advance-search-form").removeClass("open");
        } else {
            jQuery("#autoroyal-advance-search-form").addClass("open");
        }
    });

    $(document).on('click', '.autoroyal-change-rent-booking-dates', function(e){
        e.preventDefault();
        if( jQuery(".autoroyal-rent-booking-dates").hasClass("open") ) {
            jQuery(".autoroyal-rent-booking-dates").removeClass("open");
            $('#rent-select-price-mask').css("display", "none");
        } else {
            jQuery(".autoroyal-rent-booking-dates").addClass("open");
            $('#rent-select-price-mask').css("display", "block");
        }
    });

    $(document).on('click', '#rent-select-price-mask', function(e) {
        e.preventDefault();
        if( jQuery(".autoroyal-rent-booking-dates").hasClass("open") ) {
            jQuery(".autoroyal-rent-booking-dates").removeClass("open");
            jQuery('#autoroyal-listing-sort').css("height", "auto");
            $('body').css('overflow', 'auto');
            $('body').css('overflow-x', 'hidden');
            $('#rent-select-price-mask').fadeOut(200);
        } else {
            jQuery('#autoroyal-listing-sort').css("height", jQuery('#autoroyal-listing-sort').height());
            jQuery(".autoroyal-rent-booking-dates").addClass("open");
            $('#rent-select-price-mask').fadeIn(200);
            $('body').css('overflow', 'hidden');
        }
    });

    $('.autoroyal-entry-title h3').each(function(){
        var me = $(this);
        me.html(me.html().replace(/^(\w+)/, '<span>$1</span>'));
    });

    $("a.fancybox").fancybox({
        afterLoad: function() {
            this.title = (this.index + 1) + ' of ' + this.group.length;
        },
        helpers : { 
            title : { type : 'inside' }
        }
    });
    $('.open-album').click(function(e) {
        var el, id = $(this).data('open-id');
        if(id){
            el = $('.fancybox[rel=' + id + ']:eq(0)');
            e.preventDefault();
            el.click();
        }
    });

    $("#favorite-vehicles-basket .row").on("focusin", function(){

        $("a.fancybox").fancybox({
            afterLoad: function() {
                this.title = (this.index + 1) + ' of ' + this.group.length;
            },
            helpers : { 
                title : { type : 'inside' }
            }
        });
        $('.open-album').click(function(e) {
            var el, id = $(this).data('open-id');
            if(id){
                el = $('.fancybox[rel=' + id + ']:eq(0)');
                e.preventDefault();
                el.click();
            }
        });

    });

    $(document).on('click', '.autoroyal-vehicle-block-image-quick-view', function(e){
        e.preventDefault();
        var car_ID = jQuery(this).data('car-id');
        //jQuery("#quick-view-block").addClass('open');
        jQuery("#quick-view-block").addClass('ajax_loading');
        //$('body').css('overflow', 'hidden');
        autoroyal_ajax_load_quick_view( car_ID );
        return false;
    });

    function autoroyal_ajax_load_quick_view( car_ID ) {

        var fd = new FormData();
        fd.append('car_ID', car_ID);
        fd.append('action', 'autoroyal_ajax_load_quick_view');

        $.ajax({
            type: 'POST',
            url: autoroyalSettings.autoroyal_ajaxurl,
            dataType: 'json',
            data: fd,
            contentType: false,
            processData: false,
            beforeSend: function(){
                //
                jQuery("#quick-view-block .cs-modal-inner").html("");
            },
            success: function (data) {
                //console.log(data.html);
                jQuery("#quick-view-block").removeClass('ajax_loading');
                jQuery("#quick-view-block .cs-modal-inner").html(data.html);
                jQuery('#cd-item-slider').carousel();
                autoroyal_load_quick_view_map();
                // bootstrap carousel touch swipe support
                jQuery("#cd-item-slider").swipe({
                    swipe: function(event, direction, distance, duration, fingerCount, fingerData) {
                        if (direction == 'left') jQuery(this).carousel('next');
                        if (direction == 'right') jQuery(this).carousel('prev');
                    },
                    allowPageScroll:"vertical"
                });
            },
            error:  function (data) {
                //console.log("error")
            },
        });

    };

    function autoroyal_load_quick_view_map() {

        var drgflag = true;

        if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
            drgflag = false;
        }

        if( jQuery("#cd-map").exists() ) {

            var map;
            var marker;

            function initialize() {

                var latlng = new google.maps.LatLng(jQuery("#vehicle_location_latitude").val(), jQuery("#vehicle_location_longitude").val());
                var mapOptions = {
                    zoom: 16,
                    center: latlng,
                    scrollwheel: false,
                    mapTypeControl: false,
                    draggable: drgflag,
                }

                map = new google.maps.Map(document.getElementById('cd-map'), mapOptions);

                marker = new google.maps.Marker({
                    position: latlng,
                    map: map,
                    draggable: drgflag,
                });

            }

            google.maps.event.addDomListener(window, 'load', initialize);
                     
            initialize();

        }

    }

    function addCommas(nStr) {
        nStr += '';
        var x = nStr.split('.');
        var x1 = x[0];
        var x2 = x.length > 1 ? '.' + x[1] : '';
        var rgx = /(\d+)(\d{3})/;
        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + ' ' + '$2');
        }
        return x1 + x2;
    }

    function autoroyal_ajax_update_vehicles_fn() {

        //console.log("ajax");
        jQuery("#filter_make").val( $( "#make" ).val() );
        jQuery("#filter_model").val( $( "#model" ).val() );
        jQuery("#filter_fuel_type").val( $( "#fuel_type" ).val() );
        jQuery("#filter_price").val( $( "#priceUpRange2" ).slider( "values", 1 ) );
        jQuery("#filter_year").val( $( "#registrationRange2" ).slider( "values", 1 ) );
        jQuery("#filter_mileage").val( $( "#mileageRange2" ).slider( "values", 1 ) * 1000 );
        jQuery("#filter_condition").val( $( "#vehicle_condition" ).val() );

        jQuery("#subscribe-filter").css("display", "inline-block");

        //jQuery('html, body').animate({ scrollTop: 0 }, 800);

        var populateVehicles, unPopulateVehicles;

        var targetForm = jQuery('#autoroyal-advance-search-form');
        var urlWithParams = targetForm.attr('action') + "?" + targetForm.serialize();
        window.history.pushState("", "", urlWithParams);
        //location.hash = targetForm.serialize();
        //console.log(urlWithParams);

        $.ajax({
            url: autoroyalSettings.autoroyal_ajaxurl,
            type: "POST",
            dataType: 'json',
            context: $('#autoroyal-advance-search-form'),
            data: $("#autoroyal-advance-search-form").serialize() + '&action=autoroyal_ajax_filter',
            beforeSend: function(){
                //
                jQuery('#inventory-vehicles-pagination').html("");
                //jQuery("#inventory-vehicles-holder").slideUp("fast");
                jQuery('#autoroyal-listing-sort .autoroyal-listing-sort-item-result strong').html('<i class="fa fa-spinner fa-spin fa-fw"></i>');
                clearTimeout(populateVehicles);
                clearTimeout(unPopulateVehicles);
                jQuery('#inventory-vehicles-holder .row').find('.autoroyal-animated-blk').each(function(i){
                    var row = $(this).find('.autoroyal-vehicle-block');
                    unPopulateVehicles = setTimeout(function() {
                        row.removeClass('visible');
                    }, 25*i);
                });
            },
            success: function (data) {
                //console.log(data);
                jQuery('#autoroyal-listing-sort .autoroyal-listing-sort-item-result strong').text(data.total);
                jQuery('#inventory-vehicles-pagination').html(data.pagination);
                jQuery("#inventory-vehicles-holder .row").html("");
                //jQuery("#inventory-vehicles-holder").slideDown("fast");
                jQuery("#inventory-vehicles-holder .row").html(data.html);
                clearTimeout(populateVehicles);
                clearTimeout(unPopulateVehicles);
                jQuery('#inventory-vehicles-holder .row').find('.autoroyal-animated-blk').each(function(i){
                    var row = $(this).find('.autoroyal-vehicle-block');
                    populateVehicles = setTimeout(function() {
                        row.addClass('visible');
                    }, 50*i);
                });
            },
            error:  function (data) {
                //console.log("error")
                //console.log(data);
            },
        });

    };

    $(document).on('click', '.autoroyal-filter-reset-button', function(e){
        e.preventDefault();

        reset_btn = 1;

        jQuery("#make").val("0");
        jQuery('#make option[value="0"]').prop("selected", true);
        jQuery("#model").val("0");
        jQuery('#model option[value="0"]').prop("selected", true);
        jQuery("#vehicle_condition").val("0");
        jQuery('#vehicle_condition option[value="0"]').prop("selected", true);
        jQuery("#fuel_type").val("0");
        jQuery('#fuel_type option[value="0"]').prop("selected", true);
        jQuery("#transmission").val("0");
        jQuery('#transmission option[value="0"]').prop("selected", true);
        jQuery("#body_style").val("0");
        jQuery('#body_style option[value="0"]').prop("selected", true);
        $('.chosen-select').trigger("chosen:updated");

        var options = $("#priceUpRange2").slider( 'option' );
        jQuery("#priceUpRange2").slider( 'values', [ options.min, options.max ] );
        jQuery("#priceUp1").val( options.min );
        jQuery("#priceUp2").val( options.max );

        var currency_symbol = jQuery(".filter-surrency-symbol").text();
        var currency_pos = autoroyalSettings.currency_pos;
        console.log(currency_pos);
        jQuery( "#price_up span.filter-dynamic-data-min" ).text( currency_symbol + addCommas( options.min ) );
        jQuery( "#price_up span.filter-dynamic-data-max" ).text( currency_symbol + addCommas( options.max ) );

        var options_year = $("#registrationRange2").slider( 'option' );
        jQuery("#registrationRange2").slider( 'values', [ options_year.min, options_year.max ] );
        jQuery("#cd-registration1").val( options_year.min );
        jQuery("#cd-registration2").val( options_year.max );

        jQuery( "#year_up span.filter-dynamic-data-min" ).text( options_year.min );
        jQuery( "#year_up span.filter-dynamic-data-max" ).text( options_year.max );

        var options_mileage = $("#mileageRange2").slider( 'option' );
        jQuery("#mileageRange2").slider( 'values', [ options_mileage.min, options_mileage.max ] );
        jQuery("#cd-mileage1").val( options_mileage.min );
        jQuery("#cd-mileage2").val( options_mileage.max );

        jQuery( "#mileage_up span.filter-dynamic-data-min" ).text( options_mileage.min + "K" );
        jQuery( "#mileage_up span.filter-dynamic-data-max" ).text( options_mileage.max + "K" );

        jQuery(".color-list .btn").removeClass("selected");
        jQuery("#autoroyal-filter-color-wrapper").html("");

        if( jQuery(".autoroyal-inventory-ajax").exists() ) {
            autoroyal_ajax_update_vehicles_fn();
        } else if( jQuery(".autoroyal-inventory-flash").exists() ) {
            updateFlashFilter(); 
        } else {
            autoroyal_ajax_update_vehicles_amount_fn();
        }

        reset_btn = 0;

        return false;
    });

    $(document).on('click', '.modal-mask', function(e){
        e.preventDefault();

        //console.log("ceva");

        // Close Reservation 
        jQuery("#reservation-modal-response").slideUp("fast");
        jQuery("#place_car_reservation").slideDown("fast");
        jQuery("#reservation-modal").removeClass('open');
        jQuery('#place_car_reservation .nav-tabs a[href="#order_details"]').tab('show');
        jQuery("#reservation-modal-response").fadeOut();

        // Close Check Availability
        jQuery("#check-availability-response").slideUp("fast");
        jQuery("#check-availability-form").slideDown("fast");
        jQuery("#check-availability").removeClass('open');
        jQuery("#quick-view-block").removeClass('open');
        jQuery("#quick-view-block .cs-modal-inner").html("");

        // Close Pre Qualify
        if( jQuery("#pre-qualify").exists() ) {
            var anchor = jQuery('#pre-qualify');
            var position = anchor.position().top + $("#pre-qualify .cs-modal").scrollTop() - 180;
            jQuery("#pre-qualify").animate({scrollTop: position});
        }

        jQuery("#pre-qualify-response").slideUp("fast");
        jQuery("#pre-qualify-form").slideDown("fast");
        jQuery("#pre-qualify").removeClass('open');

        // Close Financial Application
        if( jQuery("#financial-application").exists() ) {
            var anchor = jQuery('#financial-application');
            var position = anchor.position().top + $("#financial-application .cs-modal").scrollTop() - 180;
            jQuery("#financial-application").animate({scrollTop: position});
        }

        jQuery("#financial-application-response").slideUp("fast");
        jQuery("#financial-application-form").slideDown("fast");
        jQuery("#financial-application").removeClass('open');
        jQuery("#pre-qualify").scrollTop();

        // Close Test Drive
        if( jQuery("#test-drive").exists() ) {
            var anchor = jQuery('#test-drive');
            var position = anchor.position().top + $("#test-drive .cs-modal").scrollTop() - 180;
            jQuery("#test-drive").animate({scrollTop: position});
        }

        jQuery("#test-drive-response").slideUp("fast");
        jQuery("#test-drive-form").slideDown("fast");
        jQuery("#test-drive").removeClass('open');
        jQuery("#test-drive").scrollTop();

        // Close Trade In
        if( jQuery("#trade-in").exists() ) {
            var anchor = jQuery('#trade-in');
            var position = anchor.position().top + $("#trade-in .cs-modal").scrollTop() - 180;
            jQuery("#trade-in").animate({scrollTop: position});
        }

        jQuery("#trade-in-response").slideUp("fast");
        jQuery("#trade-in-form").slideDown("fast");
        jQuery("#trade-in").removeClass('open');
        jQuery("#trade-in").scrollTop();

        $('body').css('overflow', 'auto');
        $('body').css('overflow-x', 'hidden');
        return false;
    });

    // Check Availability function
    function autoroyal_ajax_check_availability() {

        $('#check-availability-form .userName').keypress(function() {
            jQuery('#check-availability-form .userName-error').css('display', 'none');
            jQuery(this).focus();
        });

        $('#check-availability-form .userMail').keypress(function() {
            jQuery('#check-availability-form .userMail-error').css('display', 'none');
            jQuery(this).focus();
        });

        $('#check-availability-form .userPhone').keypress(function() {
            jQuery('#check-availability-form .userPhone-error').css('display', 'none');
            jQuery(this).focus();
        });

        $(document).on('click', '#check-availability-form-submit', function(e){
            e.preventDefault();
            var check_avblt = {
                type: "POST",
                dataType: 'json',
                data: $(this).serialize() + '&action=autoroyal_check_availability',
                beforeSubmit:  function(){
                    //
                    jQuery(".check-availability-loading").fadeIn();
                },
                success: function(data){
                    //console.log(data);
                    jQuery(".check-availability-loading").fadeOut();
                    jQuery("#check-availability-response").slideDown("fast");
                    jQuery("#check-availability-form").slideUp("fast");
                },
                error: function(data){
                    //console.log(data);
                    //
                    jQuery(".check-availability-loading").fadeOut();
                }
            };

            var errors = 0;

            var username = $("#check-availability-form .userName").val();
            var email = $("#check-availability-form .userMail").val();
            var phone = $("#check-availability-form .userPhone").val();

            if ( username.length === 0 ) {
                errors = 1;
                jQuery('#check-availability-form .userName-error').css('display', 'inline-block');
                return;
            }

            if ( email.length === 0 && ! validateEmail( email ) ) {
                errors = 1;
                jQuery('#check-availability-form .userMail-error').css('display', 'inline-block');
                return;
            }

            if ( phone.length === 0 ) {
                errors = 1;
                jQuery('#check-availability-form .userPhone-error').css('display', 'inline-block');
                return;
            }

            if( errors == 0 ) {
                $('#check-availability-form').ajaxSubmit( check_avblt );
            } else {
                return false;
            }

        });
    }
    // End

    // Pre Qualify function
    function autoroyal_ajax_pre_qualify() {

        $('#pre-qualify-form .lead_first_name').keypress(function() {
            jQuery('#pre-qualify-form #lead_first_name-error').css('display', 'none');
            jQuery(this).focus();
        });

        $('#pre-qualify-form .lead_email').keypress(function() {
            jQuery('#pre-qualify-form #lead_email-error').css('display', 'none');
            jQuery(this).focus();
        });

        $('#pre-qualify-form .lead_mobile_phone').keypress(function() {
            jQuery('#pre-qualify-form #lead_mobile_phone-error').css('display', 'none');
            jQuery(this).focus();
        });

        $(document).on('click', '#pre-qualify-form #autoroyal_pre_qualify_me', function(e){
            //console.log("qualify");
            e.preventDefault();
            var pre_qualify_form = {
                type: "POST",
                dataType: 'json',
                data: $(this).serialize() + '&action=autoroyal_pre_qualify',
                beforeSubmit:  function(){
                    //
                    jQuery(".pre-qualify-loading").fadeIn();
                    jQuery("#autoroyal_pre_qualify_me .fa").css("display", "inline-block");
                },
                success: function(data){
                    //console.log(data);
                    jQuery(".pre-qualify-loading").fadeOut();
                    jQuery("#autoroyal_pre_qualify_me .fa").css("display", "none");
                    jQuery("#pre-qualify-response").slideDown("fast");
                    jQuery("#pre-qualify-form").slideUp("fast");
                    jQuery("#pre-qualify").scrollTop();
                },
                error: function(data){
                    //console.log(data);
                    //
                    jQuery(".pre-qualify-loading").fadeOut();
                    jQuery("#autoroyal_pre_qualify_me .fa").css("display", "none");
                    jQuery("#pre-qualify").scrollTop();
                }
            };

            var errors = 0;

            var username = $("#pre-qualify-form .lead_first_name").val();
            var email = $("#pre-qualify-form .lead_email").val();
            var phone = $("#pre-qualify-form .lead_mobile_phone").val();

            if ( username.length === 0 ) {
                errors = 1;
                jQuery('#pre-qualify-form #lead_first_name-error').css('display', 'inline-block');
                //jQuery("#pre-qualify").scrollTop();
                var anchor = jQuery('#pre-qualify #lead_first_name-error');
                var position = anchor.position().top + $("#pre-qualify .cs-modal").scrollTop() + 180;
                jQuery("#pre-qualify").animate({scrollTop: position});
                return;
            }

            if ( phone.length === 0 ) {
                errors = 1;
                jQuery('#pre-qualify-form #lead_mobile_phone-error').css('display', 'inline-block');
                var anchor = jQuery('#pre-qualify #lead_mobile_phone-error');
                var position = anchor.position().top + $("#pre-qualify .cs-modal").scrollTop() + 480;
                jQuery("#pre-qualify").animate({scrollTop: position});
                return;
            }

            if ( email.length === 0 && ! validateEmail( email ) ) {
                errors = 1;
                jQuery('#pre-qualify-form #lead_email-error').css('display', 'inline-block');
                var anchor = jQuery('#pre-qualify #lead_email-error');
                var position = anchor.position().top + $("#pre-qualify .cs-modal").scrollTop() + 600;
                jQuery("#pre-qualify").animate({scrollTop: position});
                return;
            }

            if( errors == 0 ) {
                $('#pre-qualify-form').ajaxSubmit( pre_qualify_form );
            } else {
                return false;
            }

        });
    }
    // End

    // Financial Application function
    function autoroyal_ajax_financial_application() {

        $('#financial-application-form .lead_first_name').keypress(function() {
            jQuery('#financial-application-form #lead_first_name-error').css('display', 'none');
            jQuery(this).focus();
        });

        $('#financial-application-form .lead_email').keypress(function() {
            jQuery('#financial-application-form #lead_email-error').css('display', 'none');
            jQuery(this).focus();
        });

        $('#financial-application-form .lead_mobile_phone').keypress(function() {
            jQuery('#financial-application-form #lead_mobile_phone-error').css('display', 'none');
            jQuery(this).focus();
        });

        $(document).on('click', '#financial-application-form #autoroyal_submit_application_form', function(e){
            //console.log("qualify");
            e.preventDefault();
            var pre_qualify_form = {
                type: "POST",
                dataType: 'json',
                data: $(this).serialize() + '&action=autoroyal_ajax_financial_application',
                beforeSubmit:  function(){
                    //
                    jQuery(".financial-application-loading").fadeIn();
                    jQuery("#autoroyal_submit_application_form .fa").css("display", "inline-block");
                },
                success: function(data){
                    //console.log(data);
                    jQuery(".financial-application-loading").fadeOut();
                    jQuery("#autoroyal_submit_application_form .fa").css("display", "none");
                    jQuery("#financial-application-response").slideDown("fast");
                    jQuery("#financial-application-form").slideUp("fast");
                    jQuery("#financial-application").scrollTop();
                },
                error: function(data){
                    //console.log(data);
                    //
                    jQuery(".financial-application-loading").fadeOut();
                    jQuery("#autoroyal_submit_application_form .fa").css("display", "none");
                    jQuery("#financial-application").scrollTop();
                }
            };

            var errors = 0;

            var username = $("#financial-application-form .lead_first_name").val();
            var email = $("#financial-application-form .lead_email").val();
            var phone = $("#financial-application-form .lead_mobile_phone").val();

            if ( username.length === 0 ) {
                errors = 1;
                jQuery('#financial-application-form #lead_first_name-error').css('display', 'inline-block');
                //jQuery("#pre-qualify").scrollTop();
                var anchor = jQuery('#financial-application #lead_first_name-error');
                var position = anchor.position().top + $("#financial-application .cs-modal").scrollTop() + 180;
                jQuery("#financial-application").animate({scrollTop: position});
                //console.log(position);
                return;
            }

            if ( phone.length === 0 ) {
                errors = 1;
                jQuery('#financial-application-form #lead_mobile_phone-error').css('display', 'inline-block');
                var anchor = jQuery('#financial-application #lead_mobile_phone-error');
                var position = anchor.position().top + $("#financial-application .cs-modal").scrollTop() + 480;
                jQuery("#financial-application").animate({scrollTop: position});
                return;
            }

            if ( email.length === 0 && ! validateEmail( email ) ) {
                errors = 1;
                jQuery('#financial-application-form #lead_email-error').css('display', 'inline-block');
                var anchor = jQuery('#financial-application #lead_email-error');
                var position = anchor.position().top + $("#financial-application .cs-modal").scrollTop() + 600;
                jQuery("#financial-application").animate({scrollTop: position});
                return;
            }

            if( errors == 0 ) {
                $('#financial-application-form').ajaxSubmit( pre_qualify_form );
            } else {
                return false;
            }

        });
    }
    // End

    // Test Drive function
    function autoroyal_ajax_test_drive() {

        $('#test-drive-form .lead_first_name').keypress(function() {
            jQuery('#test-drive-form #lead_first_name-error').css('display', 'none');
            jQuery(this).focus();
        });

        $('#test-drive-form .lead_email').keypress(function() {
            jQuery('#test-drive-form #lead_email-error').css('display', 'none');
            jQuery(this).focus();
        });

        $('#test-drive-form .lead_mobile_phone').keypress(function() {
            jQuery('#test-drive-form #lead_mobile_phone-error').css('display', 'none');
            jQuery(this).focus();
        });

        $(document).on('click', '#test-drive-form #autoroyal_request_test_drive_ajax', function(e){
            e.preventDefault();
            var test_drive_form = {
                type: "POST",
                dataType: 'json',
                data: $(this).serialize() + '&action=autoroyal_ajax_test_drive',
                beforeSubmit:  function(){
                    //
                    jQuery(".test-drive-loading").fadeIn();
                    jQuery("#autoroyal_request_test_drive_ajax .fa").css("display", "inline-block");
                },
                success: function(data){
                    //console.log(data);
                    jQuery(".test-drive-loading").fadeOut();
                    jQuery("#autoroyal_request_test_drive_ajax .fa").css("display", "none");
                    jQuery("#test-drive-response").slideDown("fast");
                    jQuery("#test-drive-form").slideUp("fast");
                    jQuery("#test-drive").scrollTop();
                },
                error: function(data){
                    //console.log(data);
                    //
                    jQuery(".test-drive-loading").fadeOut();
                    jQuery("#autoroyal_request_test_drive_ajax .fa").css("display", "none");
                    jQuery("#test-drive").scrollTop();
                }
            };

            var errors = 0;

            var username = $("#test-drive-form .lead_first_name").val();
            var email = $("#test-drive-form .lead_email").val();
            var phone = $("#test-drive-form .lead_mobile_phone").val();

            if ( username.length === 0 ) {
                errors = 1;
                jQuery('#test-drive-form #lead_first_name-error').css('display', 'inline-block');
                //jQuery("#pre-qualify").scrollTop();
                var anchor = jQuery('#test-drive #lead_first_name-error');
                var position = anchor.position().top + $("#test-drive .cs-modal").scrollTop() + 180;
                jQuery("#test-drive").animate({scrollTop: position});
                return;
            }

            if ( phone.length === 0 ) {
                errors = 1;
                jQuery('#test-drive-form #lead_mobile_phone-error').css('display', 'inline-block');
                var anchor = jQuery('#test-drive #lead_mobile_phone-error');
                var position = anchor.position().top + $("#test-drive .cs-modal").scrollTop() + 480;
                jQuery("#test-drive").animate({scrollTop: position});
                return;
            }

            if ( email.length === 0 && ! validateEmail( email ) ) {
                errors = 1;
                jQuery('#test-drive-form #lead_email-error').css('display', 'inline-block');
                var anchor = jQuery('#test-drive #lead_email-error');
                var position = anchor.position().top + $("#test-drive .cs-modal").scrollTop() + 600;
                jQuery("#test-drive").animate({scrollTop: position});
                return;
            }

            if( errors == 0 ) {
                $('#test-drive-form').ajaxSubmit( test_drive_form );
            } else {
                return false;
            }

        });
    }
    // End

    // Trade In function
    function autoroyal_ajax_trade_in() {

        $('#trade-in-form .lead_first_name').keypress(function() {
            jQuery('#trade-in-form #lead_first_name-error').css('display', 'none');
            jQuery(this).focus();
        });

        $('#trade-in-form .lead_email').keypress(function() {
            jQuery('#trade-in-form #lead_email-error').css('display', 'none');
            jQuery(this).focus();
        });

        $('#trade-in-form .lead_mobile_phone').keypress(function() {
            jQuery('#trade-in-form #lead_mobile_phone-error').css('display', 'none');
            jQuery(this).focus();
        });

        $('#trade-in-form .lead_tradein_vehicle_vin').keypress(function() {
            jQuery('#trade-in-form #lead_tradein_vehicle_vin-error').css('display', 'none');
            jQuery(this).focus();
        });

        $(document).on('click', '#trade-in-form #autoroyal_submit_tradein_ajax', function(e){
            e.preventDefault();
            var trade_in_form = {
                type: "POST",
                dataType: 'json',
                data: $(this).serialize() + '&action=autoroyal_ajax_trade_in',
                beforeSubmit:  function(){
                    //
                    jQuery(".trade-in-loading").fadeIn();
                    jQuery("#autoroyal_submit_tradein_ajax .fa").css("display", "inline-block");
                },
                success: function(data){
                    //console.log(data);
                    jQuery(".trade-in-loading").fadeOut();
                    jQuery("#autoroyal_submit_tradein_ajax .fa").css("display", "none");
                    jQuery("#trade-in-response").slideDown("fast");
                    jQuery("#trade-in-form").slideUp("fast");
                    jQuery("#trade-in").scrollTop();
                },
                error: function(data){
                    //console.log(data);
                    //
                    jQuery(".trade-in-loading").fadeOut();
                    jQuery("#autoroyal_submit_tradein_ajax .fa").css("display", "none");
                    jQuery("#trade-in").scrollTop();
                }
            };

            var errors = 0;

            var vin = $("#trade-in-form .lead_tradein_vehicle_vin").val();
            var username = $("#trade-in-form .lead_first_name").val();
            var email = $("#trade-in-form .lead_email").val();
            var phone = $("#trade-in-form .lead_mobile_phone").val();

            if ( vin.length === 0 ) {
                errors = 1;
                jQuery('#trade-in-form #lead_tradein_vehicle_vin-error').css('display', 'inline-block');
                //jQuery("#pre-qualify").scrollTop();
                var anchor = jQuery('#trade-in #lead_tradein_vehicle_vin-error');
                var position = anchor.position().top + $("#trade-in .cs-modal").scrollTop() + 180;
                jQuery("#trade-in").animate({scrollTop: position});
                return;
            }

            if ( username.length === 0 ) {
                errors = 1;
                jQuery('#trade-in-form #lead_first_name-error').css('display', 'inline-block');
                //jQuery("#pre-qualify").scrollTop();
                var anchor = jQuery('#trade-in #lead_first_name-error');
                var position = anchor.position().top + $("#trade-in .cs-modal").scrollTop() + 180;
                jQuery("#trade-in").animate({scrollTop: position});
                return;
            }

            if ( phone.length === 0 ) {
                errors = 1;
                jQuery('#trade-in-form #lead_mobile_phone-error').css('display', 'inline-block');
                var anchor = jQuery('#trade-in #lead_mobile_phone-error');
                var position = anchor.position().top + $("#trade-in .cs-modal").scrollTop() + 480;
                jQuery("#trade-in").animate({scrollTop: position});
                return;
            }

            if ( email.length === 0 && ! validateEmail( email ) ) {
                errors = 1;
                jQuery('#trade-in-form #lead_email-error').css('display', 'inline-block');
                var anchor = jQuery('#trade-in #lead_email-error');
                var position = anchor.position().top + $("#trade-in .cs-modal").scrollTop() + 600;
                jQuery("#trade-in").animate({scrollTop: position});
                return;
            }

            if( errors == 0 ) {
                $('#trade-in-form').ajaxSubmit( trade_in_form );
            } else {
                return false;
            }

        });
    }
    // End

    function validateEmail(email) { 
        // http://stackoverflow.com/a/46181/11236         
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }

    /* ------------------------------------------------------------------------ */
    /*  COMPARE PANEL
    /* ------------------------------------------------------------------------ */
    $(document).on('click', '.favorite-action-button, .favorite-panel-header i.close, .favorite-mask', function(e) {
        console.log('ceva');
        e.preventDefault();
        if( $('.favorite-panel').hasClass('panel-open') ){
            $('.favorite-mask').fadeOut(200);
            $('.favorite-panel').removeClass('panel-open');
            $('body').css('overflow', 'auto');
            $('body').css('overflow-x', 'hidden');
        } else {
            $('.favorite-panel').addClass('panel-open');
            $('.favorite-mask').fadeIn(200);
            $('body').css('overflow', 'hidden');
        }
    });

    jQuery('#make').change(function(){
        jQuery('#model option[value="0"]').prop("selected", true);
        jQuery('#model').val("0");
    });

    function autoroyal_flash_update_vehicles_fn() {

        /*
        $("#inventory-vehicles-holder > .row > .col-md-4").show();

        var filters = "";
        var make = $("#make").val();
        var model = $("#model").val();

        if(make !== "0"){
            filters += "." + make + ", ";
        }

        if(model !== "0"){
            filters += "." + model + ", ";
        }

        if( filters == "") {
            $("#inventory-vehicles-holder > .row > .col-md-4").show();
        } else {
            $("#inventory-vehicles-holder > .row > .col-md-4:not("+filters.slice(0,-2)+")").hide();
        }

        jQuery(".autoroyal-listing-sort-item-result strong").text( $('#inventory-vehicles-holder > .row > .col-md-4:visible').size() );

        return false;
        */

    };

    $(window).load(function() {

        // Update filter
        jQuery('#autoroyal-advance-search-form #body_style, #autoroyal-advance-search-form #transmission, #autoroyal-advance-search-form #fuel_type, #autoroyal-advance-search-form #vehicle_condition, #autoroyal-advance-search-form #model, #autoroyal-advance-search-form #make').change(function(){

            if( reset_btn == 0 ) {

                if( jQuery(".autoroyal-inventory-ajax").exists() ) {
                    autoroyal_ajax_update_vehicles_fn();
                } else if( jQuery(".autoroyal-inventory-flash").exists() ) {
                    updateFlashFilter(); 
                } else {
                    autoroyal_ajax_update_vehicles_amount_fn();
                }

            }

        });

        $( "#priceUpRange2, #registrationRange2, #mileageRange2" ).on( "slidechange", function( event, ui ) {

            if( reset_btn == 0 ) {

                if( jQuery(".autoroyal-inventory-ajax").exists() ) {
                    autoroyal_ajax_update_vehicles_fn();
                } else if( jQuery(".autoroyal-inventory-flash").exists() ) {
                    updateFlashFilter(); 
                } else {
                    autoroyal_ajax_update_vehicles_amount_fn();
                }

            }

        });

        $(document).on('click', '.autoroyal-inventory-ajax a.page-numbers', function(e) {
            e.preventDefault();
            var hrefprim = jQuery(this).attr('href');
            var href = hrefprim.replace("#", "");
            jQuery("#filter_page").val( href );
            autoroyal_ajax_update_vehicles_fn();
        });

        // select color
        jQuery(".color-list.single .btn").on("click", function(){
            if( jQuery(".autoroyal-inventory-ajax").exists() ) {
                autoroyal_ajax_update_vehicles_fn();
            } else if( jQuery(".autoroyal-inventory-flash").exists() ) {
                updateFlashFilter(); 
            } else {
                autoroyal_ajax_update_vehicles_amount_fn();
            }
            jQuery(this).closest('ul').find('.selected').removeClass('selected');
            jQuery(this).addClass('selected');
        });
        jQuery(".color-list.multiple .btn").on("click", function(){
            jQuery(this).toggleClass('selected');
            var value = jQuery(this).data('value');
            var id = value;
            var text = jQuery(this).data('original-title');

            if(jQuery(this).hasClass('selected')) {
                jQuery("#autoroyal-filter-color-wrapper").append('<input id="color-id-'+value+'" type="hidden" name="vehicle_exterior_color[]" value="'+value+'" />');
            } else {
                jQuery("#color-id-"+value).remove();
            }

            if( jQuery(".autoroyal-inventory-ajax").exists() ) {
                autoroyal_ajax_update_vehicles_fn();
            } else if( jQuery(".autoroyal-inventory-flash").exists() ) {
                updateFlashFilter(); 
            } else {
                autoroyal_ajax_update_vehicles_amount_fn();
            }
        });

        function autoroyal_ajax_update_vehicles_amount_fn() {

            $.ajax({
                url: autoroyalSettings.autoroyal_ajaxurl,
                type: "POST",
                dataType: 'json',
                context: $('#autoroyal-advance-search-form'),
                data: $("#autoroyal-advance-search-form").serialize() + '&action=update_vehicles_amount',
                beforeSend: function(){
                    //
                    jQuery('#autoroyal-advance-search-form .autoroyal-filter-button').html('<i class="fa fa-spinner fa-spin"></i>');
                },
                success: function (data) {
                    //console.log("success")
                    //console.log(data.total);
                    if( data.total == 1 ) {
                        jQuery('#autoroyal-advance-search-form .autoroyal-filter-button').text(data.total + " Offer");
                    } else {
                        jQuery('#autoroyal-advance-search-form .autoroyal-filter-button').text(data.total + " Offers");
                    }
                },
                error:  function (data) {
                    //console.log("error")
                    //console.log(data.total);
                },
            });

        };

        function autoroyal_ajax_update_vehicles_fn() {

            //console.log("ajax");
            jQuery("#filter_make").val( $( "#make" ).val() );
            jQuery("#filter_model").val( $( "#model" ).val() );
            jQuery("#filter_fuel_type").val( $( "#fuel_type" ).val() );
            jQuery("#filter_price").val( $( "#priceUpRange2" ).slider( "values", 1 ) );
            jQuery("#filter_year").val( $( "#registrationRange2" ).slider( "values", 1 ) );
            jQuery("#filter_mileage").val( $( "#mileageRange2" ).slider( "values", 1 ) * 1000 );
            jQuery("#filter_condition").val( $( "#vehicle_condition" ).val() );

            jQuery("#subscribe-filter").css("display", "inline-block");

            //jQuery('html, body').animate({ scrollTop: 0 }, 800);

            var populateVehicles, unPopulateVehicles;

            var targetForm = jQuery('#autoroyal-advance-search-form');
            var urlWithParams = targetForm.attr('action') + "?" + targetForm.serialize();
            window.history.pushState("", "", urlWithParams);
            //location.hash = targetForm.serialize();
            //console.log(urlWithParams);

            $.ajax({
                url: autoroyalSettings.autoroyal_ajaxurl,
                type: "POST",
                dataType: 'json',
                context: $('#autoroyal-advance-search-form'),
                data: $("#autoroyal-advance-search-form").serialize() + '&action=autoroyal_ajax_filter',
                beforeSend: function(){
                    //
                    jQuery('#inventory-vehicles-pagination').html("");
                    //jQuery("#inventory-vehicles-holder").slideUp("fast");
                    jQuery('#autoroyal-listing-sort .autoroyal-listing-sort-item-result strong').html('<i class="fa fa-spinner fa-spin fa-fw"></i>');
                    clearTimeout(populateVehicles);
                    clearTimeout(unPopulateVehicles);
                    jQuery('#inventory-vehicles-holder .row').find('.autoroyal-animated-blk').each(function(i){
                        var row = $(this).find('.autoroyal-vehicle-block');
                        unPopulateVehicles = setTimeout(function() {
                            row.removeClass('visible');
                        }, 25*i);
                    });
                },
                success: function (data) {
                    //console.log(data);
                    jQuery('#autoroyal-listing-sort .autoroyal-listing-sort-item-result strong').text(data.total);
                    jQuery('#inventory-vehicles-pagination').html(data.pagination);
                    jQuery("#inventory-vehicles-holder .row").html("");
                    //jQuery("#inventory-vehicles-holder").slideDown("fast");
                    jQuery("#inventory-vehicles-holder .row").html(data.html);
                    clearTimeout(populateVehicles);
                    clearTimeout(unPopulateVehicles);
                    jQuery('#inventory-vehicles-holder .row').find('.autoroyal-animated-blk').each(function(i){
                        var row = $(this).find('.autoroyal-vehicle-block');
                        populateVehicles = setTimeout(function() {
                            row.addClass('visible');
                        }, 50*i);
                    });
                },
                error:  function (data) {
                    //console.log("error")
                    //console.log(data);
                },
            });

        };

        $(document).on('click', '.form-check-label', function(e){
            e.preventDefault();
            if( jQuery(this).parent().hasClass('checked') ){
                jQuery(this).parent().removeClass("checked");
            } else {
                jQuery(this).parent().addClass("checked");
            }
            if( jQuery(".autoroyal-inventory-flash").exists() ) {
                updateFlashFilter(); 
            }
            return false;
        });

        $(document).on('click', '.form-check-label.radio', function(e){
            e.preventDefault();
            jQuery(this).parent().parent().find('.autoroyal-rent-filter-checkbox-unit').removeClass("checked");
            jQuery(this).parent().addClass("checked");
            if( jQuery(".autoroyal-inventory-flash").exists() ) {
                updateFlashFilter(); 
            }
            return false;
        });

        $(document).on('click', '.autoroyal-listing-view-type a.grid', function(e){
            e.preventDefault();
            jQuery(".autoroyal-listing-view-type a.list").removeClass('active');
            jQuery(".autoroyal-listing-view-type a.grid").addClass('active');
            jQuery("#inventory-vehicles-holder").removeClass('autoroyal-invetory-list-view');
            jQuery("#inventory-vehicles-holder").addClass('autoroyal-invetory-grid-view');
            jQuery("#view_type").val("grid");
            $.cookie("autoroyal_view_type", 'grid');
            if( jQuery(".autoroyal-inventory-flash").exists() ) {
                updateFlashFilter(); 
            }
            return false;
        });

        $(document).on('click', '.autoroyal-listing-view-type a.list', function(e){
            e.preventDefault();
            jQuery(".autoroyal-listing-view-type a.grid").removeClass('active');
            jQuery(".autoroyal-listing-view-type a.list").addClass('active');
            jQuery("#inventory-vehicles-holder").removeClass('autoroyal-invetory-grid-view');
            jQuery("#inventory-vehicles-holder").addClass('autoroyal-invetory-list-view');
            jQuery("#view_type").val("list");
            $.cookie("autoroyal_view_type", 'list');
            if( jQuery(".autoroyal-inventory-flash").exists() ) {
                updateFlashFilter(); 
            }
            return false;
        });

        if( jQuery(".autoroyal-blog-isotope-container").exists() ) {

            var $grid = $('#isotope-container').isotope({
                // main isotope options
                itemSelector: '.autoroyal-blog-item',
                // set layoutMode
                layoutMode: 'masonry',
                // options for masonry layout mode
                masonry: {
                    columnWidth: '.autoroyal-blog-item'
                }
            })
        }

        if( jQuery(".autoroyal-inventory-flash").exists() ) {

            // isotope filter
            var $container = $('#isotope-container'),
                filters = {};
            var isotopFilter, ftIsotope, prop, selector;
            var isoFilters = [];

            isotopFilter = $container.isotope({
                itemSelector : '.autoroyal-animated-blk',
                layoutMode: 'fitRows',
                resizable: false,
                masonry: {
                    columnWidth: '.autoroyal-animated-blk'
                },
                getSortData: {
                    price: '[data-price] parseInt',
                    mileage: '[data-mileage] parseInt',
                    year: '[data-year] parseInt',
                    make: '[data-make]',
                    model: '[data-model]',
                },
            });

            // Price
            $( "#priceUpRange2" ).on( "slidechange", function( event, ui ) {
            
                var priceMin = $( "#priceUpRange2" ).slider( "values", 0 );
                var priceMax = $( "#priceUpRange2" ).slider( "values", 1 );

                var itemPrice = $(this).data('price');
                filters[ 'price' ] = parseInt(itemPrice, 10) >= priceMin && parseInt(itemPrice, 10) <= priceMax;

                updateFlashFilter();

            });

            // Year
            $( "#registrationRange2" ).on( "slidechange", function( event, ui ) {
            
                var yearMin = $( "#registrationRange2" ).slider( "values", 0 );
                var yearMax = $( "#registrationRange2" ).slider( "values", 1 );

                var itemYear = $(this).data('year');
                filters[ 'year' ] = parseInt(itemYear, 10) >= yearMin && parseInt(itemYear, 10) <= yearMax;

                updateFlashFilter();

            });

            // filter buttons
            $('.filter a').click(function(){
                var $this = $(this);

                // store filter value in object
                // i.e. filters.color = 'red'
                var group = $optionSet.attr('data-filter-group');
                filters[ group ] = $this.attr('data-filter-value');
                // convert object into array
                var isoFilters = [];
                for ( var prop in filters ) {
                    isoFilters.push( filters[ prop ] )
                }
                var selector = isoFilters.join('');
                $container.isotope({ filter: selector });

                return false;

            });

        }

        // Flash Filter All
        function updateFlashFilter() {

            jQuery("#subscribe-filter").css("display", "inline-block");

            if( jQuery("#priceUpRange2").exists() ) {
                var priceMin = $( "#priceUpRange2" ).slider( "values", 0 );
                var priceMax = $( "#priceUpRange2" ).slider( "values", 1 );
            }

            if( jQuery(".autoroyal-rent-filter-doors").exists() ) {
                // Extract All Colors in an array
                var doors_inputs = $('.autoroyal-rent-filter-doors .autoroyal-rent-filter-checkbox-unit.checked input');
                var doors_values = [];

                if( !$.trim( $('.autoroyal-rent-filter-doors').html() ).length ) {
                    // 
                } else {
                    // not sure if you wanted this, but I thought I'd add it.
                    // get an associative array of just the values.
                    doors_inputs.each(function() {
                        doors_values.push( parseInt($(this).val(), 10) );
                    });

                }
            }

            if( jQuery(".autoroyal-rent-filter-seats").exists() ) {
                // Extract All Colors in an array
                var seats_inputs = $('.autoroyal-rent-filter-seats .autoroyal-rent-filter-checkbox-unit.checked input');
                var seats_values = [];

                if( !$.trim( $('.autoroyal-rent-filter-seats').html() ).length ) {
                    // 
                } else {
                    // not sure if you wanted this, but I thought I'd add it.
                    // get an associative array of just the values.
                    seats_inputs.each(function() {
                        seats_values.push( parseInt($(this).val(), 10) );
                    });

                }
            }

            if( jQuery(".autoroyal-rent-filter-luggages").exists() ) {
                // Extract All Colors in an array
                var luggages_inputs = $('.autoroyal-rent-filter-luggages .autoroyal-rent-filter-checkbox-unit.checked input');
                var luggages_values = [];

                if( !$.trim( $('.autoroyal-rent-filter-luggages').html() ).length ) {
                    // 
                } else {
                    // not sure if you wanted this, but I thought I'd add it.
                    // get an associative array of just the values.
                    luggages_inputs.each(function() {
                        luggages_values.push( parseInt($(this).val(), 10) );
                    });

                }
            }

            if( jQuery(".autoroyal-rent-filter-age").exists() ) {
                // Extract All Colors in an array
                var age_inputs = $('.autoroyal-rent-filter-age .autoroyal-rent-filter-checkbox-unit.checked input');
                var age_values = '';

                if( !$.trim( $('.autoroyal-rent-filter-age').html() ).length ) {
                    // 
                } else {
                    // not sure if you wanted this, but I thought I'd add it.
                    // get an associative array of just the values.
                    age_inputs.each(function() {
                        age_values = $(this).val();
                    });

                }
            }

            var yearMin = $( "#registrationRange2" ).slider( "values", 0 );
            var yearMax = $( "#registrationRange2" ).slider( "values", 1 );

            var mileageMin = $( "#mileageRange2" ).slider( "values", 0 ) * 1000;
            var mileageMax = $( "#mileageRange2" ).slider( "values", 1 ) * 1000;

            var makeFilter, modelFilter, conditionFilter, priceMinFilter, priceMaxFilter, yearMinFilter, yearMaxFilter, mileageMinFilter, mileageMaxFilter, fuelFilter, transmissionFilter, bodystyleFilter, colorFilter, doorsFilter, seatsFilter, luggagesFilter, ageFilter;

            // Extract All Colors in an array
            var $color_inputs = $('#autoroyal-filter-color-wrapper input');
            var color_values = [];
            var current_color = 0;

            if( !$.trim( $('#autoroyal-filter-color-wrapper').html() ).length ) {
                // 
            } else {
                // not sure if you wanted this, but I thought I'd add it.
                // get an associative array of just the values.
                $color_inputs.each(function() {
                    current_color++;
                    //color_values[current_color] = $(this).val();
                    //color_values += $(this).val() + ", ";
                    color_values.push( parseInt($(this).val(), 10) );
                });
            }

            isotopFilter = $container.isotope({
                filter: function () {

                    var itemYear = $(this).data('year');
                    var itemPrice = $(this).data('price');
                    var itemMileage = $(this).data('mileage');
                    var itemMake = $(this).data('make');
                    var itemModel = $(this).data('model');
                    var itemCondition = $(this).data('condition');
                    var itemFuel = $(this).data('fuel');
                    var itemTransmission = $(this).data('transmission');
                    var itemBodystyle = $(this).data('bodystyle');
                    var itemColor = $(this).data('color');
                    var itemDoors = $(this).data('doors');
                    var itemSeats = $(this).data('seats');
                    var itemLuggages = $(this).data('luggages');
                    var itemAge = $(this).data('age');

                    jQuery("#filter_make").val( $( "#make" ).val() );
                    jQuery("#filter_model").val( $( "#model" ).val() );
                    jQuery("#filter_fuel_type").val( $( "#fuel_type" ).val() );
                    jQuery("#filter_price").val( priceMax );
                    jQuery("#filter_year").val( yearMax );
                    jQuery("#filter_mileage").val( mileageMax );
                    jQuery("#filter_condition").val( $( "#vehicle_condition" ).val() );

                    jQuery('#inventory-vehicles-holder .row').find('.autoroyal-animated-blk').each(function(i){
                        var row = $(this).find('.autoroyal-vehicle-block').addClass('visible');
                    });

                    // Price Min Filter
                    if( jQuery("#priceUpRange2").exists() && priceMin != "0" ) {
                        if( parseInt(itemPrice, 10) >= priceMin ) {
                            priceMinFilter = true;
                        } else {
                            priceMinFilter = false;
                        }
                    } else {
                        priceMinFilter = true;
                    }

                    // Price Max Filter
                    if( jQuery("#priceUpRange2").exists() && priceMax != "0" ) {
                        if( parseInt(itemPrice, 10) <= priceMax  ) {
                            priceMaxFilter = true;
                        } else {
                            priceMaxFilter = false;
                        }
                    } else {
                        priceMaxFilter = true;
                    }

                    // Year Min Filter
                    if( yearMin != "0" ) {
                        if( parseInt(itemYear, 10) >= yearMin ) {
                            yearMinFilter = true;
                        } else {
                            yearMinFilter = false;
                        }
                    } else {
                        yearMinFilter = true;
                    }

                    // Year Max Filter
                    if( yearMax != "0" ) {
                        if( parseInt(itemYear, 10) <= yearMax ) {
                            yearMaxFilter = true;
                        } else {
                            yearMaxFilter = false;
                        }
                    } else {
                        yearMaxFilter = true;
                    }

                    // Mileage Min Filter
                    if( jQuery("#mileageRange2").exists() && mileageMin != "0" ) {
                        if( parseInt(itemMileage, 10) >= mileageMin ) {
                            mileageMinFilter = true;
                        } else {
                            mileageMinFilter = false;
                        }
                    } else {
                        mileageMinFilter = true;
                    }

                    // Mileage Max Filter
                    if( jQuery("#mileageRange2").exists() && mileageMax != "0" ) {
                        if( parseInt(itemMileage, 10) <= mileageMax ) {
                            mileageMaxFilter = true;
                        } else {
                            mileageMaxFilter = false;
                        }
                    } else {
                        mileageMaxFilter = true;
                    }

                    // Make Filter
                    if( jQuery("#make").exists() && $( "#make" ).val() != "0" ) {
                        if( itemMake == $( "#make" ).val() ) {
                            makeFilter = true;
                        } else {
                            makeFilter = false;
                        }
                    } else {
                        makeFilter = true;
                    }

                    // Model Filter
                    if( jQuery("#model").exists() && $( "#model" ).val() != "0" ) {
                        if( itemModel == $( "#model" ).val() ) {
                            modelFilter = true;
                        } else {
                            modelFilter = false;
                        }
                    } else {
                        modelFilter = true;
                    }

                    // Condition Filter
                    if( jQuery("#vehicle_condition").exists() && $( "#vehicle_condition" ).val() != "0" ) {
                        if( itemCondition == $( "#vehicle_condition" ).val() ) {
                            conditionFilter = true;
                        } else {
                            conditionFilter = false;
                        }
                    } else {
                        conditionFilter = true;
                    }

                    // Fuel Type Filter
                    if( jQuery("#fuel_type").exists() && $( "#fuel_type" ).val() != "0" ) {
                        if( itemFuel == $( "#fuel_type" ).val() ) {
                            fuelFilter = true;
                        } else {
                            fuelFilter = false;
                        }
                    } else {
                        fuelFilter = true;
                    }

                    // Transmission Filter
                    if( jQuery("#transmission").exists() && $( "#transmission" ).val() != "0" ) {
                        if( itemTransmission == $( "#transmission" ).val() ) {
                            transmissionFilter = true;
                        } else {
                            transmissionFilter = false;
                        }
                    } else {
                        transmissionFilter = true;
                    }

                    // Body Style Filter
                    if( jQuery("#body_style").exists() && $( "#body_style" ).val() != "0" ) {
                        if( itemBodystyle == $( "#body_style" ).val() ) {
                            bodystyleFilter = true;
                        } else {
                            bodystyleFilter = false;
                        }
                    } else {
                        bodystyleFilter = true;
                    }

                    // Color Filter
                    if( !$.trim( $('#autoroyal-filter-color-wrapper').html() ).length ) {
                        // 
                        colorFilter = true;
                    } else {
                        // not sure if you wanted this, but I thought I'd add it.
                        // get an associative array of just the values.
                        if( jQuery.inArray(itemColor, color_values) !== -1 ) {
                            colorFilter = true;
                        } else {
                            colorFilter = false;
                        }
                    }

                    if( jQuery(".autoroyal-rent-filter-doors").exists() ) {
                        // Extract All Colors in an array

                        if( doors_values.length === 0 ) {
                            doorsFilter = true;
                            // 
                        } else {

                            if( jQuery.inArray(itemDoors, doors_values) !== -1 ) {
                                doorsFilter = true;
                            } else {
                                doorsFilter = false;
                            }

                        }
                    } else {
                        doorsFilter = true;
                    }

                    if( jQuery(".autoroyal-rent-filter-seats").exists() ) {
                        // Extract All Colors in an array

                        if( seats_values.length === 0 ) {
                            seatsFilter = true;
                            // 
                        } else {

                            if( jQuery.inArray(itemSeats, seats_values) !== -1 ) {
                                seatsFilter = true;
                            } else {
                                seatsFilter = false;
                            }

                        }
                    } else {
                        seatsFilter = true;
                    }

                    if( jQuery(".autoroyal-rent-filter-luggages").exists() ) {
                        // Extract All Colors in an array

                        if( luggages_values.length === 0 ) {
                            luggagesFilter = true;
                            // 
                        } else {

                            if( jQuery.inArray(itemLuggages, luggages_values) !== -1 ) {
                                luggagesFilter = true;
                            } else {
                                luggagesFilter = false;
                            }

                        }
                    } else {
                        luggagesFilter = true;
                    }

                    if( jQuery(".autoroyal-rent-filter-age").exists() ) {
                        // Extract All Colors in an array

                        if( age_values.length === 0 ) {
                            ageFilter = true;
                            // 
                        } else {

                            if( itemAge <= age_values ) {
                                ageFilter = true;
                            } else {
                                ageFilter = false;
                            }

                        }
                    } else {
                        ageFilter = true;
                    }

                    var finalFilterOptions = priceMinFilter && priceMaxFilter && yearMinFilter && yearMaxFilter && mileageMinFilter && mileageMaxFilter && makeFilter && modelFilter && conditionFilter && fuelFilter && transmissionFilter && bodystyleFilter && colorFilter && doorsFilter && seatsFilter && luggagesFilter && ageFilter;

                    return finalFilterOptions;

                }
            });

            updateFilterCount();

        }

        function sortFlashFilter() {

            jQuery('#inventory-vehicles-holder .row').find('.autoroyal-animated-blk').each(function(i){
                if( !$(this).find('.autoroyal-vehicle-block').hasClass('visible') ) {
                    $(this).find('.autoroyal-vehicle-block').addClass('visible');
                }
            });

            var sortBy = jQuery("#orderby").val();
            var $container = $('#isotope-container');

            var $items = $container.find('.autoroyal-animated-blk');

            if( sortBy == "price_asc") {

                $container.isotope({ sortBy: "price", sortAscending: true });

            } else if( sortBy == "price_desc") {

                $container.isotope({ sortBy: "price", sortAscending: false });

            } else if( sortBy == "mileage_asc") {

                $container.isotope({ sortBy: "mileage", sortAscending: true });

            } else if( sortBy == "mileage_desc") {

                $container.isotope({ sortBy: "mileage", sortAscending: false });

            } else if( sortBy == "year_asc") {

                $container.isotope({ sortBy: "year", sortAscending: true });

            } else if( sortBy == "year_desc") {

                $container.isotope({ sortBy: "year", sortAscending: false });

            } else if( sortBy == "make_asc") {

                $container.isotope({ sortBy: "make", sortAscending: false });

            } else if( sortBy == "make_desc") {

                $container.isotope({ sortBy: "make", sortAscending: true });

            } else if( sortBy == "model_asc") {

                $container.isotope({ sortBy: "model", sortAscending: false });

            } else if( sortBy == "model_desc") {

                $container.isotope({ sortBy: "model", sortAscending: true });

            } else {

                $container.isotope({ sortBy: "original-order", sortAscending: true });

            }

        }

        function updateFilterCount() {
            if(typeof isotopFilter != 'undefined') {
                var ftIsoData = isotopFilter.data('isotope');
                if(typeof ftIsoData != 'undefined') {
                    if(typeof ftIsoData.filteredItems != 'undefined') {
                        jQuery(".autoroyal-listing-sort-item-result strong").text( ftIsoData.filteredItems.length / 2 );
                    }
                }
            }
        }

        jQuery('#posts_per_page').change(function(){
            var value = jQuery( this ).val();
            jQuery("#posts_per_page_filter").val(value);
            if( jQuery(".autoroyal-inventory-ajax").exists() ) {
                autoroyal_ajax_update_vehicles_fn();
            } else if( jQuery(".autoroyal-inventory-flash").exists() ) {
                updateFlashFilter();
            } else {
                jQuery( 'form#autoroyal-advance-search-form' ).submit();
            }
        });

        jQuery('#orderby').change(function(){
            var value = jQuery( this ).val();
            jQuery("#orderby_filter").val(value);
            if( jQuery(".autoroyal-inventory-ajax").exists() ) {
                autoroyal_ajax_update_vehicles_fn();
            } else if( jQuery(".autoroyal-inventory-flash").exists() ) {
                sortFlashFilter();
            } else {
                jQuery( 'form#autoroyal-advance-search-form' ).submit();
            }
        });

    });

    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });

    // Add to compare
    var autoroyal_timeout;
    $(document).on('click', '.autoroyal-vehicle-block-meta .add-to-compare, .compare-col-autoroyal .add-to-compare', function(e) {

        e.preventDefault();

        var autoroyal_add_to_compare_text = "Add to compare.";
        var autoroyal_remove_from_compare_text = "Remove from compare.";
        var autoroyal_added_to_compare_text = "added to compare.";
        var autoroyal_already_added_to_compare_text = "You have already added 3 vehicles.";
        var autoroyal_removed_from_compare_text = "removed from compare";

        var autoroyal_cookies = $.cookie();
        var autoroyal_car_compare = [];
        var autoroyal_car_add_to = $(this).data('id');
        var autoroyal_car_title = $(this).data('title');

        for (var key in autoroyal_cookies) {
            if (autoroyal_cookies.hasOwnProperty(key)) {
                if (key.indexOf('autoroyal_compare_ids') > -1) {
                    autoroyal_car_compare.push(autoroyal_cookies[key]);
                }
            }
        }

        //console.log(autoroyal_cookies);
        //console.log(autoroyal_car_compare);

        var autoroyal_compare_cars_counter = autoroyal_car_compare.length;
        $.cookie.raw = true;

        if($.inArray(autoroyal_car_add_to.toString(), autoroyal_car_compare) === -1){
            if(autoroyal_car_compare.length < 3) {
                $.cookie('autoroyal_compare_ids[' + autoroyal_car_add_to + ']', autoroyal_car_add_to, { expires: 7, path: '/' });
                autoroyal_compare_cars_counter++;

                //Added popup
                clearTimeout(autoroyal_timeout);
                $('.single-add-to-compare .autoroyal-title').text(autoroyal_car_title + ' - ' + autoroyal_added_to_compare_text);
                $('.single-add-to-compare').addClass('single-add-to-compare-visible');
                autoroyal_timeout = setTimeout(function(){
                    $('.single-add-to-compare').removeClass('single-add-to-compare-visible');
                }, 2000);
                //Added popup

                $(this).attr('data-original-title', autoroyal_remove_from_compare_text);  
                $(this).addClass("added");

                $("#autoroyal-inventory").find('.add-to-compare[data-id=' + autoroyal_car_add_to + ']').attr('data-original-title', autoroyal_remove_from_compare_text);  
                $("#autoroyal-inventory").find('.add-to-compare[data-id=' + autoroyal_car_add_to + ']').addClass("added");

                $("#favorite-vehicles-basket").find('.add-to-compare[data-id=' + autoroyal_car_add_to + ']').attr('data-original-title', autoroyal_remove_from_compare_text);  
                $("#favorite-vehicles-basket").find('.add-to-compare[data-id=' + autoroyal_car_add_to + ']').addClass("added");

            } else {
                //Already added 3 popup
                clearTimeout(autoroyal_timeout);
                $('.single-add-to-compare .autoroyal-title').text(autoroyal_already_added_to_compare_text);
                $('.single-add-to-compare').addClass('single-add-to-compare-visible');
                autoroyal_timeout = setTimeout(function(){
                    $('.single-add-to-compare').removeClass('single-add-to-compare-visible');
                    $('.single-add-to-compare').removeClass('overadded');
                    $('.compare-remove-all').remove();
                }, 2000);
                //Already added 3 popup
                $('.single-add-to-compare').addClass('overadded');
                $('.compare-remove-all').remove();
            }
        } else {
            $.removeCookie('autoroyal_compare_ids[' + autoroyal_car_add_to + ']', { path: '/' });
            autoroyal_compare_cars_counter--;
            //Deleted from compare text
            clearTimeout(autoroyal_timeout);
            $('.single-add-to-compare .autoroyal-title').text(autoroyal_car_title + ' - ' + autoroyal_removed_from_compare_text);
            $('.single-add-to-compare').addClass('single-add-to-compare-visible');
            autoroyal_timeout = setTimeout(function(){
                $('.single-add-to-compare').removeClass('single-add-to-compare-visible');
            }, 2000);
            //Deleted from compare text

            if( jQuery(".compare-page").exists() ) {
                jQuery(".compare-col-autoroyal-"+autoroyal_car_add_to).remove();
                jQuery(".autoroyal-listing-compare-row").append('<div class="col-md-3 col-sm-3 compare-col-autoroyal-empty"><a class="compare-vehicle-image empty-slot" href="#"><div class="vehicle-grid-image"><i class="fa fa-ban" aria-hidden="true"></i></div></a><div class="h5">Add listing to compare</div></div>');
                jQuery(".autoroyal-compare-row").append('<div class="col-md-3 col-sm-3"><div class="compare-options"><table><tbody><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr></tbody></table></div></div>');
            }
            $('.single-add-to-compare').removeClass('overadded');
            $('.compare-remove-all').remove();
            $('.tooltip').remove();

            $(this).attr('data-original-title', autoroyal_add_to_compare_text);  
            $(this).removeClass("added");

            $("#autoroyal-inventory").find('.add-to-compare[data-id=' + autoroyal_car_add_to + ']').attr('data-original-title', autoroyal_add_to_compare_text);  
            $("#autoroyal-inventory").find('.add-to-compare[data-id=' + autoroyal_car_add_to + ']').removeClass("added");

            $("#favorite-vehicles-basket").find('.add-to-compare[data-id=' + autoroyal_car_add_to + ']').attr('data-original-title', autoroyal_add_to_compare_text);  
            $("#favorite-vehicles-basket").find('.add-to-compare[data-id=' + autoroyal_car_add_to + ']').removeClass("added");
        }

        $('.autoroyal-current-cars-in-compare').text(autoroyal_compare_cars_counter);
        //console.log(autoroyal_compare_cars_counter);

    });

    $(document).on('click', '.compare-remove-all', function(){
        var autoroyal_cookies = $.cookie();

        for (var key in autoroyal_cookies) {
            if (autoroyal_cookies.hasOwnProperty(key)) {
                if (key.indexOf('autoroyal_compare_ids') > -1) {
                    $.removeCookie(key, { path: '/' });
                }
            }
        }

        location.reload();
    });
    // End Add to compare

    function init_animations_after_preloader () {

        animate_autoroyal_inventory();

    }

  	$(document).on('click', '.open-login-popup, .menu-login-register-button a.login-button, #autoroyal-login-submit', function(e){
        e.preventDefault();
        jQuery("#login").slideDown("fast");
        jQuery("#register").slideUp("fast");
        jQuery("#overlay").addClass('open');
        return false;
    });

    $(document).on('click', '#autoroyal_signup_submit', function(e){
        e.preventDefault();
        jQuery("#login").slideUp("fast");
        jQuery("#register").slideDown("fast");
        jQuery("#overlay").addClass('open');
        return false;
    });

    jQuery(".close").click(function(e) {
        e.preventDefault();
        jQuery("#overlay").removeClass('open');
    });

    jQuery(".autoroyal-registration").click(function(e) {
        e.preventDefault();
        jQuery("#login").slideUp("slow", function() {
            jQuery("#register").slideDown("slow");
        });
    });

    jQuery(".autoroyal-back-login").click(function(e) {
        e.preventDefault();
        jQuery("#lost-password").slideUp("slow", function() {
            jQuery("#login").slideDown("slow");
        });
    });

    jQuery(".autoroyal-lost-password").click(function(e) {
        e.preventDefault();
        jQuery("#login").slideUp("slow", function() {
            jQuery("#lost-password").slideDown("slow");
        });
    });

    jQuery(".autoroyal-login").click(function(e) {
        e.preventDefault();
        jQuery("#register").slideUp("slow", function() {
            jQuery("#login").slideDown("slow");
        });
    });
    // End

    // Login function
    function autoroyal_ajax_login() {

        $('#autoroyal_login_form #autoroyal_user_login').keypress(function() {
            jQuery("#autoroyal_account_login_errors .error-username").remove();
            jQuery('#autoroyal_account_login_errors:empty').css('display', 'none');
            jQuery(this).focus();
        });

        $('#autoroyal_login_form #autoroyal_user_pass').keypress(function() {
            jQuery("#autoroyal_account_login_errors .error-password").remove();
            jQuery('#autoroyal_account_login_errors:empty').css('display', 'none');
            jQuery(this).focus();
        });

        $(document).on('click', '#autoroyal_login_submit', function(e){
            e.preventDefault();
            var login_user = {
                type: "POST",
                dataType: 'json',
                data: $(this).serialize() + '&action=autoroyal_ajax_login',
                beforeSubmit:  function(){
                    jQuery('#login-progress').css('display', 'inline-block');
                    jQuery('#autoroyal_account_login_errors').css('display', 'none');
                    jQuery('#autoroyal_account_login_errors').empty();
                },
                success: function(data){
                    //console.log(data);
                    if( data.status == 'success' ) {
                        if( jQuery("#car_owner .car_owner").exists()) {
                            jQuery("#car_owner .car_owner").html( data.html );
                            jQuery("#overlay").removeClass('open');
                        } else {
                            if( data.redirect.length === 0  ) {
                                window.location.reload(true);
                            } else {
                                window.location.replace( data.redirect );
                            }
                        }
                        jQuery('#login-progress').css('display', 'none');
                    } else {
                        if( data.error_user != '' ) {
                            jQuery("#autoroyal_account_login_errors").append( data.error_user );
                            jQuery('#autoroyal_account_login_errors').css('display', 'inline-block');
                        }
                        if( data.error_password != '' ) {
                            jQuery("#autoroyal_account_login_errors").append( data.error_password );
                            jQuery('#autoroyal_account_login_errors').css('display', 'inline-block');
                        }
                        jQuery('#login-progress').css('display', 'none');
                    }
                },
                error: function(data){
                    if( data.error_default != '' ) {
                        jQuery("#autoroyal_account_login_errors").html( data.error_default );
                        jQuery('#autoroyal_account_login_errors').css('display', 'inline-block');
                        jQuery('#login-progress').css('display', 'none');
                    }
                    jQuery('#login-progress').css('display', 'none');
                }
            };

            var errors = 0;

            var username = $("#autoroyal_login_form .autoroyal_user_login").val();
            var password = $("#autoroyal_login_form #autoroyal_user_pass").val();

            if ( username.length === 0 ) {
                errors = 1;
                jQuery("#autoroyal_account_login_errors .error-username").remove();
                jQuery("#autoroyal_account_login_errors").append( '<div class="error-username"><span class="error-title">Error:</span> Username required.</div>' );
                jQuery('#autoroyal_account_login_errors').css('display', 'inline-block');
                return;
            }

            if ( password.length === 0 ) {
                errors = 1;
                jQuery("#autoroyal_account_login_errors .error-password").remove();
                jQuery("#autoroyal_account_login_errors").append( '<div class="error-password"><span class="error-title">Error:</span> Password required.</div>' );
                jQuery('#autoroyal_account_login_errors').css('display', 'inline-block');
                return;
            }

            if( errors == 0 ) {
                $('#autoroyal_login_form').ajaxSubmit( login_user );
            } else {
                return false;
            }

        });
    }
    // End

    // Register function
    function autoroyal_ajax_register() {

        $('#autoroyal_registration_form .autoroyal_user_login').keypress(function() {
            jQuery("#autoroyal_account_register_errors .error-username").remove();
            jQuery('#autoroyal_account_register_errors:empty').css('display', 'none');
            jQuery(this).focus();
        });

        $('#autoroyal_registration_form #autoroyal_user_email').keypress(function() {
            jQuery("#autoroyal_account_register_errors .error-email").remove();
            jQuery('#autoroyal_account_register_errors:empty').css('display', 'none');
            jQuery(this).focus();
        });

        $('#autoroyal_registration_form #password').keypress(function() {
            jQuery("#autoroyal_account_register_errors .error-password").remove();
            jQuery('#autoroyal_account_register_errors:empty').css('display', 'none');
            jQuery(this).focus();
        });

        $('#autoroyal_registration_form #password_again').keypress(function() {
            jQuery("#autoroyal_account_register_errors .error-repeat-password").remove();
            jQuery('#autoroyal_account_register_errors:empty').css('display', 'none');
            jQuery(this).focus();
        });

        $(document).on('click', '#autoroyal_register_submit', function(e){
            e.preventDefault();
            var register_user = {
                type: "POST",
                dataType: 'json',
                data: $(this).serialize() + '&action=autoroyal_register',
                beforeSubmit:  function(){
                    jQuery('#register-progress').css('display', 'inline-block');
                    jQuery('#autoroyal_account_register_errors').css('display', 'none');
                    jQuery('#autoroyal_account_register_errors').empty();
                },
                success: function(data){
                    if( data.status == 'success' ) {
                        if( jQuery("#car_owner .car_owner").exists()) {
                            jQuery("#car_owner .car_owner").html( data.html );
                            jQuery("#overlay").removeClass('open');
                        } else {
                            if( data.redirect.length === 0  ) {
                                window.location.reload(true);
                            } else {
                                window.location.replace( data.redirect );
                            }
                        }
                        jQuery('#login-progress').css('display', 'none');
                    } else {
                        if( data.error_user != '' ) {
                            jQuery("#autoroyal_account_register_errors").append( data.error_user );
                            jQuery('#autoroyal_account_register_errors').css('display', 'inline-block');
                        }
                        if( data.error_email != '' ) {
                            jQuery("#autoroyal_account_register_errors").append( data.error_email );
                            jQuery('#autoroyal_account_register_errors').css('display', 'inline-block');
                        }
                        jQuery('#register-progress').css('display', 'none');
                    }
                },
                error: function(data){
                    if( data.error_default != '' ) {
                        jQuery("#autoroyal_account_register_errors").html( data.error_default );
                        jQuery('#autoroyal_account_register_errors').css('display', 'inline-block');
                        jQuery('#register-progress').css('display', 'none');
                    }
                    jQuery('#register-progress').css('display', 'none');
                }
            };

            var errors = 0;

            var username = $("#autoroyal_registration_form .autoroyal_user_login").val();
            var password = $("#autoroyal_registration_form #password").val();
            var confirmPassword = $("#autoroyal_registration_form #password_again").val();

            if ( username.length === 0 ) {
                errors = 1;
                jQuery("#autoroyal_account_register_errors .error-username").remove();
                jQuery("#autoroyal_account_register_errors").append( '<div class="error-username"><span class="error-title">Error:</span> Username required.</div>' );
                jQuery('#autoroyal_account_register_errors').css('display', 'inline-block');
                return;
            }

            if ( ( $('#autoroyal_registration_form #autoroyal_user_email').length ) && ! validateEmail( $('#autoroyal_registration_form #autoroyal_user_email').val() ) ) { // Validate email
                errors = 1;
                jQuery("#autoroyal_account_register_errors .error-email").remove();
                jQuery("#autoroyal_account_register_errors").append( '<div class="error-email"><span class="error-title">Error:</span> Email required.</div>' );
                jQuery('#autoroyal_account_register_errors').css('display', 'inline-block');
                return;
            }

            if ( password.length === 0 ) { // Validate repeat password
                errors = 1;
                jQuery("#autoroyal_account_register_errors .error-password").remove();
                jQuery("#autoroyal_account_register_errors").append( '<div class="error-password"><span class="error-title">Error:</span> Password required.</div>' );
                jQuery('#autoroyal_account_register_errors').css('display', 'inline-block');
                return;
            }

            if ( password != confirmPassword ) { // Validate repeat password
                errors = 1;
                jQuery("#autoroyal_account_register_errors .error-repeat-password").remove();
                jQuery("#autoroyal_account_register_errors").append( "<div class='error-repeat-password'><span class='error-title'>Error:</span> Password doesn't match.</div>" );
                jQuery('#autoroyal_account_register_errors').css('display', 'inline-block');
                return;
            }

            if( errors == 0 ) {
                $('#autoroyal_registration_form').ajaxSubmit( register_user );
            } else {
                return false;
            }

        });
    }
    // End

    // Reset Password function
    function autoroyal_ajax_reset() {

        $('#lostpasswordform #user_login').keypress(function() {
            jQuery("#autoroyal_account_reset_errors .error-email").remove();
            jQuery('#autoroyal_account_reset_errors:empty').css('display', 'none');
            jQuery(this).focus();
        });

        $(document).on('click', '#autoroyal_reset_submit', function(e){
            e.preventDefault();
            var login_reset = {
                type: "POST",
                dataType: 'json',
                data: $(this).serialize() + '&action=autoroyal_reset_password',
                beforeSubmit:  function(){
                    jQuery('#reset-progress').css('display', 'inline-block');
                    jQuery('#autoroyal_account_reset_errors').css('display', 'none');
                    jQuery('#autoroyal_account_reset_errors').empty();
                },
                success: function(data){
                    if( data.status == 'success' ) {
                        jQuery("#autoroyal_account_reset_errors").append( data.success );
                        jQuery('#autoroyal_account_reset_errors').css('display', 'inline-block');
                        jQuery('#reset-progress').css('display', 'none');
                    } else {
                        if( data.error_user != '' ) {
                            jQuery("#autoroyal_account_reset_errors").append( data.error_user );
                            jQuery('#autoroyal_account_reset_errors').css('display', 'inline-block');
                        }
                        jQuery('#reset-progress').css('display', 'none');
                    }
                },
                error: function(data){
                    if( data.error_default != '' ) {
                        jQuery("#autoroyal_account_reset_errors").html( data.error_default );
                        jQuery('#autoroyal_account_reset_errors').css('display', 'inline-block');
                        jQuery('#reset-progress').css('display', 'none');
                    }
                    jQuery('#reset-progress').css('display', 'none');
                }
            };

            var errors = 0;

            if ( ( $('#lostpasswordform #user_login').length ) && ! validateEmail( $('#lostpasswordform #user_login').val() ) ) { // Validate email
                errors = 1;
                jQuery("#autoroyal_account_reset_errors .error-email").remove();
                jQuery("#autoroyal_account_reset_errors").append( '<div class="error-email"><span class="error-title">Error:</span> Email required.</div>' );
                jQuery('#autoroyal_account_reset_errors').css('display', 'inline-block');
                return;
            }

            if( errors == 0 ) {
                $('#lostpasswordform').ajaxSubmit( login_reset );
            } else {
                return false;
            }

        });
    }
    // End

  	// show sidebar menu
	jQuery('#mobile-menu').on('click', function(e){
		e.preventDefault();
		$( 'body' ).toggleClass( "autoroyal-side-opened" );
	});

	// hide sidebar menu
	jQuery('.autoroyal-side-close').on('click', function(e){
		e.preventDefault();
		$( 'body' ).toggleClass( "autoroyal-side-opened" );
	});

	// hide sidebar menu
	jQuery('.close-side-menu-icon').on('click', function(e){
		e.preventDefault();
		$( 'body' ).toggleClass( "autoroyal-side-opened" );
	});

	$(".autoroyal-side-inner .menu-item-has-children").each(function() {
		$(this).children("a").append('<i class="fa fa-angle-down open-sub-menu" aria-hidden="true"></i>');
	});

	// open sidebar sub menu 
	jQuery(".autoroyal-side-inner .menu-item-has-children > a > i.fa").on('click', function(e){
		e.preventDefault();
		$(this).closest("li").children(".sub-menu").slideUp("fast");
		$(this).css({'transform' : 'rotate(0deg)'});
		$(this).removeClass("rotate");
            
        if ($(this).closest("li").children(".sub-menu").is(":hidden") == true ) {
            $(this).closest("li").children(".sub-menu").slideDown("normal");
            $(this).css({'transform' : 'rotate(180deg)'});
            $(this).addClass("rotate");
        }
		//$(this).closest("li").toggleClass("opened-subm-menu");
	});

	function Temp(el, options) {
		this.el = $(el);
		this.init(options);
	}

	Temp.DEFAULTS = {
		sticky: true
	}

	Temp.prototype = {
		init: function (options) {
			var base = this;
				base.window = $(window);
				base.options = $.extend({}, Temp.DEFAULTS, options);
				base.stickyWrap = $('.sticky-header');
				base.goTop = $('<a id="go-to-top" href="#" class="cd-top cd-fade-out go-to-top">Top</a>').appendTo(base.el);

			// Sticky
			if (base.options.sticky) {
				base.sticky.stickySet.call(base, base.window);
				base.stickyWrap.before($(".sticky-header").clone().addClass("clone-fixed"));
				
				$( window ).on('load resize', function() {

				  	//$(".sticky-header.clone-fixed").css('top', '-' + ($('#header').outerHeight()+100) + 'px');
				     
				});
				
			}
			
			// Scroll Event
			base.window.on('scroll', function (e) {
				if (base.options.sticky) {
					base.sticky.stickyInit.call(base, e.currentTarget);
				}
				base.gotoTop.scrollHandler.call(base, e.currentTarget);
			});

			// Click Handler Button GotoTop
			base.gotoTop.clickHandler(base);
		},

		sticky: {

			stickySet: function () {
				var stickyWrap = this.stickyWrap, offset;
				if (stickyWrap.length) {
					offset = stickyWrap.outerHeight();
					$.data(stickyWrap, 'data', {
						offset: offset,
						height: stickyWrap.outerHeight(true)
					});
					 
				}
			},
			stickyInit: function (win) {
				var base = this, data;
				if (base.stickyWrap.length) {
					data = $.data(base.stickyWrap, 'data');
					base.sticky.stickyAction(data, win, base);
				}
			},
			stickyAction: function (data, win, base) {
				var scrollTop = $(win).scrollTop();
				if (scrollTop > data.offset)  {
					if (!base.stickyWrap.hasClass('sticky')) {
						base.stickyWrap.addClass('sticky');
						$('.sticky-header.clone-fixed').addClass('slideDown');
					}
				} else {
					if (base.stickyWrap.hasClass('sticky')) {
						base.stickyWrap.removeClass('sticky');
						$('.sticky-header.clone-fixed').removeClass('slideDown');
					}
				}
			}
		},
		gotoTop: {
			scrollHandler: function (win) {
				$(win).scrollTop() > 200 ?
					this.goTop.addClass('go-top-visible'):
					this.goTop.removeClass('go-top-visible');
					$('.fb-link').addClass('fb-visible');
			},
			clickHandler: function (self) {
				self.goTop.on('click', function (e) {
					e.preventDefault();
					$('html, body').animate({ scrollTop: 0 }, 800);
				});
			}
		}
	}

	/* Temp Plugin
	 * ================================== */

	$.fn.Temp = function (option) {
		return this.each(function () {
			var $this = $(this), data = $this.data('Temp'),
				options = typeof option == 'object' && option;
			if (!data) {
				$this.data('Temp', new Temp(this, options));
			}
		});
	}

	/* ---------------------------------------------------- */
    /*	Sticky menu											*/
    /* ---------------------------------------------------- */

	if ( $('#site-navigation').hasClass('sticky-header') ) {
		
		$('body').Temp({
			sticky: true
		});
	
	}

	autoroyal_ajax_login();
    autoroyal_ajax_register();
    autoroyal_ajax_reset();
    autoroyal_ajax_check_availability();
    autoroyal_ajax_reserv_the_car();
    autoroyal_ajax_pre_qualify();
    autoroyal_ajax_financial_application();
    autoroyal_ajax_test_drive();
    autoroyal_ajax_trade_in();

    function animate_autoroyal_inventory() {

        if( jQuery("#inventory-vehicles-holder").exists() ) {
            jQuery('#inventory-vehicles-holder .row').find('.autoroyal-animated-blk').each(function(i){
                var row = $(this).find('.autoroyal-vehicle-block');
                setTimeout(function() {
                    row.addClass('visible');
                }, 100*i);
            });
        };

        if( jQuery(".autoroyal-blog-isotope-container").exists() ) {
            jQuery('.autoroyal-blog-isotope-container').find('.autoroyal-animated-blk').each(function(i){
                var row = $(this).find('.autoroyal-vehicle-block');
                setTimeout(function() {
                    row.addClass('visible');
                }, 100*i);
            });
        };

    }

    $(document).ready(function () {

        AOS.init({
           once: true
        });

        if( jQuery("#rezerve-pickup-place-filter").exists() || jQuery('#rezerve-pickup-place-filter').val() ) {
            jQuery("#rezerve-pickup-place").val(jQuery('#rezerve-pickup-place-filter').val());
            jQuery('.chosen-select').trigger("chosen:updated");
        }

        if( jQuery("#rezerve-drop-place-filter").exists() || jQuery('#rezerve-drop-place-filter').val() ) {
            jQuery("#rezerve-dropoff-place").val(jQuery('#rezerve-drop-place-filter').val());
            jQuery('.chosen-select').trigger("chosen:updated");
        }

        if( jQuery("#curentHour").exists() || jQuery("#curentHour-filter").exists() ) {

            jQuery('#curentHour, #curentHour-filter').datetimepicker({
                datepicker: false,
                ampm: true,
                format: 'g:i A',
                hours24: true, //time format 24h/12h
                scrollInput: false,
                onSelectTime:function(current_time,$input){
                    //console.log("ceva");
                    jQuery("#pickT, .pickT").text( jQuery('#curentHour').val() );
                    jQuery('#dropHour').val ( jQuery('#curentHour').val() );
                    jQuery('#dropHour-filter').val ( jQuery('#curentHour-filter').val() );
                    jQuery(".autoroyal-rent-booking-dates-pickup-date .time").text( jQuery('#curentHour-filter').val() );
                    jQuery(".autoroyal-rent-booking-dates-return-date .time").text( jQuery('#curentHour-filter').val() );
                }
            });

        }

        if( jQuery("#dropHour").exists() || jQuery("#dropHour-filter").exists() ) {

            jQuery('#dropHour, #dropHour-filter').datetimepicker({
                datepicker: false,
                ampm: true,
                format: 'g:i A',
                hours24: true, //time format 24h/12h
                scrollInput: false,
                onSelectTime:function(current_time,$input){
                    jQuery("#dropT, .dropT").text( jQuery('#dropHour').val() );
                    jQuery(".autoroyal-rent-booking-dates-return-date .time").text( jQuery('#dropHour-filter').val() );
                }
            });

        }

        var fmt = 'm/d/Y';

        if( jQuery("#curentDay").exists() ) {

            // set days rent range
            jQuery('#curentDay').datetimepicker({
                defaultDate: new Date(),
                format: fmt,
                formatDate: fmt,
                timepicker: false,
                onShow:function( ct ){
                    this.setOptions({
                        minDate: 0,
                   })
                },
                onSelectDate:function(ct,$i){

                    var date = new Date( jQuery('#curentDay').val() );
                    var newdate = new Date(date);
                    newdate.setDate(newdate.getDate() + 3);
                    var dd = newdate.getDate();
                    var mm = newdate.getMonth() + 1;
                    var y = newdate.getFullYear();
                    var someFormattedDate = (mm<10 ? '0' : '') + mm + '/' + (dd<10 ? '0' : '') + dd + '/' + y;

                    var start = new Date( jQuery('#curentDay').val() );
                    var end   = new Date( jQuery('#dropDay').val() );
                    if( !jQuery('#dropDay').val() || start.getTime() >= end.getTime() ) {
                        jQuery('#dropDay').val( someFormattedDate );
                    }

                    days();
                    //diffDaysFilter();
                }
            });

        }

        if( jQuery("#curentDay-filter").exists() ) {

            jQuery('#curentDay-filter').datetimepicker({
                defaultDate: new Date(),
                format: fmt,
                formatDate: fmt,
                timepicker: false,
                onShow:function( ct ){
                    this.setOptions({
                        minDate: 0,
                   })
                },
                onSelectDate:function(ct,$i){

                    console.log("ceva 1");

                    jQuery('.autoroyal-rent-booking-dates-pickup-date .date').text( jQuery('#curentDay-filter').val() );

                    var date = new Date( jQuery('#curentDay-filter').val() );
                    var newdate = new Date(date);
                    newdate.setDate(newdate.getDate() + 3);
                    var dd = newdate.getDate();
                    var mm = newdate.getMonth() + 1;
                    var y = newdate.getFullYear();
                    var someFormattedDate = (mm<10 ? '0' : '') + mm + '/' + (dd<10 ? '0' : '') + dd + '/' + y;

                    var start = new Date( jQuery('#curentDay-filter').val() );
                    var end   = new Date( jQuery('#dropDay-filter').val() );
                    if( !jQuery('#dropDay-filter').val() || start.getTime() >= end.getTime() ) {
                        jQuery('#dropDay-filter').val( someFormattedDate );
                        jQuery('.autoroyal-rent-booking-dates-return-date .date').text( someFormattedDate );
                        jQuery('#dropDay').val( someFormattedDate );
                    }

                    jQuery('#curentDay').datetimepicker({
                        setDate: jQuery('#curentDay-filter').val(),
                    });
                    jQuery('#curentDay').val( jQuery('#curentDay-filter').val() );
                    //console.log( jQuery('#curentDay').val() );

                    days();
                    //diffDaysFilter();
                    autoroyal_update_rent_car_price();
                }
            });

        }

        if( jQuery("#dropDay").exists() ) {

            jQuery('#dropDay').datetimepicker({
                format: fmt,
                formatDate: fmt,
                timepicker: false,
                startDate:'+1970/01/02',
                onShow:function( ct ){
                    this.setOptions({
                        minDate: jQuery('#curentDay').val()?jQuery('#curentDay').val():false,
                    })
                },
                onSelectDate:function(ct,$i){
                    days();
                    //diffDaysFilter();
                }
            });

        }

        if( jQuery("#dropDay-filter").exists() ) {

            jQuery('#dropDay-filter').datetimepicker({
                format: fmt,
                formatDate: fmt,
                timepicker: false,
                startDate:'+1970/01/02',
                onShow:function( ct ){
                    this.setOptions({
                        minDate: jQuery('#curentDay-filter').val()?jQuery('#curentDay-filter').val():false,
                    })
                },
                onSelectDate:function(ct,$i){
                    jQuery('#dropDay').val( jQuery('#dropDay-filter').val() );
                    jQuery('.autoroyal-rent-booking-dates-return-date .date').text( jQuery('#dropDay-filter').val() );
                    days();
                    //diffDaysFilter();
                    autoroyal_update_rent_car_price();
                }
            });

        }
        
        function getAsDate(day, time) {

            var hours = Number(time.match(/^(\d+)/)[1]);
            var minutes = Number(time.match(/:(\d+)/)[1]);
            var AMPM = time.match(/\s(.*)$/)[1];
            if(AMPM == "pm" && hours<12) hours = hours+12;
            if(AMPM == "am" && hours==12) hours = hours-12;
            var sHours = hours.toString();
            var sMinutes = minutes.toString();
            if(hours<10) sHours = "0" + sHours;
            if(minutes<10) sMinutes = "0" + sMinutes;
            time = sHours + ":" + sMinutes + ":00";
            var d = new Date(day);
            var n = d.toISOString().substring(0,10);
            var newDate = new Date(n+"T"+time);
            return newDate;

        }

        function days() {

            var pickup_date = $("#curentDay").val(),
                pickup_time = "12:00 PM",
                drop_date = $("#dropDay").val(),
                drop_time = "12:00 PM",
                c = 24*60*60*1000;

            var pickup = getAsDate(pickup_date, pickup_time),
                drop = getAsDate(drop_date, drop_time),
                diffDays = Math.round(Math.abs((drop - pickup)/(c)));

            //console.log(diffDays);

            jQuery('#reserv-car-days').val( diffDays );
            jQuery('.autoroyal-rent-booking-dates-rental-period .date').text( diffDays );

            jQuery("#daysN, .daysN").text(diffDays + " days");
            jQuery("#startR, .startR").text( jQuery('#curentDay').val() );
            jQuery("#endR, .endR").text( jQuery('#dropDay').val() );

            var new_price = 0;
            var total_sets = jQuery('#reservation-modal #car-price-sets .total-sets').val();
            //console.log(total_sets);

            for (var n = 0; n <= total_sets; ++ n) {
                if( jQuery('#reservation-modal #car-price-sets #price-set-period-'+n).val() <= diffDays ) {
                    new_price = jQuery('#reservation-modal #car-price-sets #price-set-price-'+n).val();
                }
            }

            if( new_price == 0 ) {
                new_price = jQuery('#dayP span').html();
            } 

            jQuery('.reserv-car-price-day').val( new_price );

            //console.log(new_price);

            // output calculate costs
            var days_num  = diffDays;
            var total_p   = new_price * diffDays;
            var reduced_p = new_price * diffDays;

            jQuery("#dayP span, .dayP span").text(new_price);

            jQuery("#totDayP span, .totDayP span").text(total_p);
            jQuery("#reserv-car-price-total, #reserv-car-price-without-extras").val(total_p);
            update_extras_total_price();

            jQuery('#reserv-car-price-total').val( total_p );

        }

        function diffDaysFilter() {

            var pickup_date = $("#curentDay-filter").val(),
                pickup_time = "12:00 PM",
                drop_date = $("#dropDay-filter").val(),
                drop_time = "12:00 PM",
                c = 24*60*60*1000;

            var pickup = getAsDate(pickup_date, pickup_time),
                drop = getAsDate(drop_date, drop_time),
                diffDays = Math.round(Math.abs((drop - pickup)/(c)));

            jQuery('.autoroyal-rent-booking-dates-rental-period .date').text( diffDays );

        }

        if( jQuery(".autoroyal-rent-booking-dates").exists() || jQuery(".autoroyal-homepage-search-box-rent").exists() || jQuery("#reservation-modal").exists() ) {

            // set curent Date
            var d = new Date();
            var month = d.getMonth()+1;
            var day = d.getDate();
            var output = (month<10 ? '0' : '') + month + '/' + (day<10 ? '0' : '') + day + '/' + d.getFullYear();

            if( jQuery("#rent_pickup_date").exists() ) {
                output = jQuery("#rent_pickup_date").val();
            }

            //console.log(output);

            jQuery("#curentDay").val( output );
            jQuery("#curentDay-filter").val( output );

            var newdate = new Date();
            newdate.setDate(newdate.getDate() + 3);
            var month = newdate.getMonth()+1;
            var day = newdate.getDate();
            var output_new = (month<10 ? '0' : '') + month + '/' + (day<10 ? '0' : '') + day + '/' + newdate.getFullYear();

            if( jQuery("#rent_drop_date").exists() ) {
                output_new = jQuery("#rent_drop_date").val();
            }

            //console.log(output_new);

            jQuery("#dropDay").val( output_new );
            jQuery("#dropDay-filter").val( output_new );

            if( jQuery("#rent_pickup_time").exists() ) {
                jQuery("#curentHour-filter").val( jQuery("#rent_pickup_time").val() );
                jQuery("#pickT, .pickT").text( jQuery('#rent_pickup_time').val() );
                jQuery('.autoroyal-rent-booking-dates-pickup-date .time').text( jQuery("#rent_pickup_time").val() );
            } else {
                jQuery("#curentHour-filter").val( "12:00 PM" );
                jQuery("#pickT, .pickT").text( "12:00 PM" );
                jQuery('.autoroyal-rent-booking-dates-pickup-date .time').text( "12:00 PM" );
            }

            if( jQuery("#rent_drop_time").exists() ) {
                jQuery("#dropHour-filter").val( jQuery("#rent_drop_time").val() );
                jQuery("#dropT, .dropT").text( jQuery("#rent_drop_time").val() );
                jQuery('.autoroyal-rent-booking-dates-return-date .time').text( jQuery("#rent_drop_time").val() );
            } else {
                jQuery("#dropHour-filter").val( "12:00 PM" );
                jQuery("#dropT, .dropT").text( "12:00 PM" );
                jQuery('.autoroyal-rent-booking-dates-return-date .time').text( "12:00 PM" );
            }

            jQuery('.autoroyal-rent-booking-dates-pickup-date .date').text( jQuery('#curentDay-filter').val() );
            jQuery('.autoroyal-rent-booking-dates-return-date .date').text( jQuery('#dropDay-filter').val() );
            
            days();

            autoroyal_update_rent_car_price();

        }

        // animate progress circles
        if( jQuery(".autoroyal-progress-circle").exists() ) {
            jQuery(".autoroyal-progress-circle").on("inview", function(event, isInView) {
                if (isInView) {
                    jQuery(this).addClass("animated");
                }
            });
        };

        // animate progress bars
        if( jQuery(".autoroyal-progress-bar-progress").exists() ) {
            jQuery(".autoroyal-progress-bar-progress").on("inview", function(event, isInView) {
                if (isInView) {
                    $(this).animate({
                        width: $(this).data("percent")
                    }, 700 );
                }
            });
        };

        if( jQuery("#cd-item-slider").exists() || jQuery("#cd-main-carousel").exists() || jQuery("#rent-me").exists() ) {

            // bootstrap carousel touch swipe support
            jQuery("#cd-item-slider, #cd-main-carousel, #rent-me").swipe({
                swipe: function(event, direction, distance, duration, fingerCount, fingerData) {
                    if (direction == 'left') jQuery(this).carousel('next');
                    if (direction == 'right') jQuery(this).carousel('prev');
                },
                allowPageScroll:"vertical"
            });

        }

    });

})(jQuery)