<?php

/////////////////// Section ///////////////////
$wp_customize->add_section( 'autoroyal_colors_options',
array(
    'title' => esc_html__( 'Colors', 'autoroyal' ), //Visible title of section
    'priority' => 45, //Determines what order this appears in
    'capability' => 'edit_theme_options', //Capability needed to tweak
    'description' => esc_html__('Allows you to customize Colors for autoRoyal Theme.', 'autoroyal'), //Descriptive tooltip
    'panel'  => 'autoroyal_styling_options',
    )
);
////////////////////////////////////////////////


// <editor-fold defaultstate="collapsed" desc=" main_color ">\
$wp_customize->add_setting( 'main_color',
array(
    'default' => $autoroyal_defaults['main_color'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'main_color', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Main Color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_colors_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'main_color', //Which setting to load and manipulate (serialized is okay)
        'description' => esc_html__('Pick main color (default: #0C3EB8).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" hover_color ">\
$wp_customize->add_setting( 'main_hover_color',
array(
    'default' => $autoroyal_defaults['main_hover_color'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'main_hover_color', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Main Hover Color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_colors_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'main_hover_color', //Which setting to load and manipulate (serialized is okay)
        'description' => esc_html__('Pick main hover color (default: #c7b147).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" second_color ">\
$wp_customize->add_setting( 'second_color',
array(
    'default' => $autoroyal_defaults['second_color'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'second_color', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Second Color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_colors_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'second_color', //Which setting to load and manipulate (serialized is okay)
        'description' => esc_html__('Pick second color (default: #dc3545).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" second_hover_color ">\
$wp_customize->add_setting( 'second_hover_color',
array(
    'default' => $autoroyal_defaults['second_hover_color'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'second_hover_color', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Second Hover Color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_colors_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'second_hover_color', //Which setting to load and manipulate (serialized is okay)
        'description' => esc_html__('Pick second hover color (default: #aa0020).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" button_bg_color ">\
$wp_customize->add_setting( 'button_bg_color',
array(
    'default' => $autoroyal_defaults['button_bg_color'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'button_bg_color', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Button Background Color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_colors_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'button_bg_color', //Which setting to load and manipulate (serialized is okay)
        'description' => esc_html__('Pick button background color (default: #2c425d).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" hover_color ">\
$wp_customize->add_setting( 'button_text_color',
array(
    'default' => $autoroyal_defaults['button_text_color'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'button_text_color', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Button Text Color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_colors_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'button_text_color', //Which setting to load and manipulate (serialized is okay)
        'description' => esc_html__('Pick button text color (default: #f0f7ff).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" button_hover_bg_color ">\
$wp_customize->add_setting( 'button_hover_bg_color',
array(
    'default' => $autoroyal_defaults['button_hover_bg_color'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'button_hover_bg_color', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Button Hover Background Color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_colors_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'button_hover_bg_color', //Which setting to load and manipulate (serialized is okay)
        'description' => esc_html__('Pick button hover background color (default: #f0f7ff).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" hover_color ">\
$wp_customize->add_setting( 'button_hover_text_color',
array(
    'default' => $autoroyal_defaults['button_hover_text_color'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'button_hover_text_color', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Button Hover Text Color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_colors_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'button_hover_text_color', //Which setting to load and manipulate (serialized is okay)
        'description' => esc_html__('Pick button hover text color (default: #2c425d).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" hover_color ">\
$wp_customize->add_setting( 'select_text',
array(
    'default' => $autoroyal_defaults['select_text'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'select_text', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Dropdown select text highlited color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_colors_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'select_text', //Which setting to load and manipulate (serialized is okay)
        'description' => esc_html__('Pick dropdown select text highlited color (default: #0C3EB8).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" hover_color ">\
$wp_customize->add_setting( 'select_bg',
array(
    'default' => $autoroyal_defaults['select_bg'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'sanitize_hex_color',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control( new WP_Customize_Color_Control(
    $wp_customize,
    'select_bg', //Set a unique ID for the control
    array(
        'label' => esc_html__( 'Dropdown select background highlited color', 'autoroyal' ), //Admin-visible name of the control
        'section' => 'autoroyal_colors_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
        'settings' => 'select_bg', //Which setting to load and manipulate (serialized is okay)
        'description' => esc_html__('Pick dropdown select background highlited color (default: #e6ecf7).', 'autoroyal'), //Descriptive tooltip
        )
    )
);
// </editor-fold>