/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {
	
	"use strict";

	// Enable Top Info Bar
    wp.customize( 'show_hide_top_bar', function( value ) {
        value.bind( function( newval ) {
            if (newval === true) {
                $("#customize-control-show_fav_in_top_bar").show();
                $("#customize-control-header_address").show();
                $("#customize-control-header_phone_number").show();
                $("#customize-control-header_working_hours").show();
            } else {
                $("#customize-control-show_fav_in_top_bar").hide();
                $("#customize-control-header_address").hide();
                $("#customize-control-header_phone_number").hide();
                $("#customize-control-header_working_hours").hide();
            }
        });
    });

	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				} );
			} else {
				$( '.site-title, .site-description' ).css( {
					'clip': 'auto',
					'position': 'relative'
				} );
				$( '.site-title a, .site-description' ).css( {
					'color': to
				} );
			}
		} );
	} );
} )( jQuery );
