<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package fantasy_themes
 */

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function autoroyal_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'autoroyal_pingback_header' );



/**
* Add classes to navigation buttons
*/
add_filter( 'next_posts_link_attributes', 'autoroyal_posts_link_attributes' );
add_filter( 'previous_posts_link_attributes', 'autoroyal_posts_link_attributes' );
add_filter( 'next_comments_link_attributes', 'autoroyal_comments_link_attributes' );
add_filter( 'previous_comments_link_attributes', 'autoroyal_comments_link_attributes' );

function autoroyal_posts_link_attributes() {
    return 'class="btn btn-outline-primary mb-4"';
}

function autoroyal_comments_link_attributes() {
    return 'class="btn btn-outline-primary mb-4"';
}



/**
* Return shorter excerpt
*/
function autoroyal_get_short_excerpt( $length = 40, $post_obj = null ) {
	global $post;
	if ( is_null( $post_obj ) ) {
		$post_obj = $post;
	}
	$length = absint( $length );
	if ( $length < 1 ) {
		$length = 40;
	}
	$source_content = $post_obj->post_content;
	if ( ! empty( $post_obj->post_excerpt ) ) {
		$source_content = $post_obj->post_excerpt;
	}
	$source_content = preg_replace( '`\[[^\]]*\]`', '', $source_content );
	$trimmed_content = wp_trim_words( $source_content, $length, '...' );
	return $trimmed_content;
}


/**
* Add admin styles
*/
function autoroyal_admin_style( $hook ) {
	if ( 'appearance_page_fantasy-themes-theme-help' != $hook ) {
		return;
	}
	wp_enqueue_style( 'autoroyal-admin', get_template_directory_uri() . '/assets/css/theme-admin.css' );
}
add_action( 'admin_enqueue_scripts' , 'autoroyal_admin_style' );
