<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package fantasy_themes
 */

get_header(); ?>

<?php
	$default_sidebar_position = get_theme_mod( 'default_sidebar_position', 'right' );
?>

	<div class="container">
		<div class="row justify-content-center">

			<?php if ( $default_sidebar_position === 'no' ) : ?>
				<div class="col-md-12 fantasy-themes-content-width">
			<?php else : ?>
				<div class="col-md-8 fantasy-themes-content-width">
			<?php endif; ?>

				<div id="primary" class="content-area">
					<main id="main" class="site-main">

					<?php
					while ( have_posts() ) : the_post();

						?>

						<article id="post-<?php the_ID(); ?>" <?php post_class( 'card mt-3r' ); ?>>

							<div class="card-body">

								<?php if ( is_sticky() ) : ?>
									<span class="fa fa-bookmark fantasy-themes-sticky" title="<?php echo esc_attr__( 'Sticky Post', 'autoroyal' ); ?>"></span>
								<?php endif; ?>

								<header class="entry-header">

									<span class="cat-links">
										<span class="ar-badge"><?php the_category( '</span> <span class="ar-badge">' ); ?></span>
									</span>
									<?php the_title( '<h2 class="entry-title card-title h3"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>

								</header><!-- .entry-header -->

								<?php autoroyal_post_thumbnail(); ?>

								<div class="entry-meta text-muted border-bottom">

									<?php autoroyal_posted_on(); ?>

									<span class="post-meta-comm float-right">
										<a href="<?php comments_link(); ?>"><i class="fas fa-comment"></i> <?php $my_comments = get_comments_number( $post->ID ); echo esc_attr( $my_comments ); ?></a>
									</span>

								</div><!-- .entry-meta -->

								<div class="entry-content">
									<?php
										the_content( sprintf(
											wp_kses(
												/* translators: %s: Name of current post. Only visible to screen readers */
												__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'autoroyal' ),
												array(
													'span' => array(
														'class' => array(),
													),
												)
											),
											get_the_title()
										) );

										wp_link_pages( array(
											'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'autoroyal' ),
											'after'  => '</div>',
										) );
									?>
								</div><!-- .entry-content -->

							</div>
							<!-- /.card-body -->

						</article><!-- #post-<?php the_ID(); ?> -->

					<?php
						$prev_post = get_previous_post();
						$next_post = get_next_post();
					?>
					
					<div class="post-navigation">
						
						<div class="post-navigation-inner">
					
							<?php
							if (!empty( $prev_post )): ?>
							
								<div class="post-nav-prev">
									<p><?php esc_html_e('Previous', 'autoroyal'); ?></p>
									<h4>
										<a href="<?php echo get_permalink( $prev_post->ID ); ?>" title="<?php esc_attr_e('Previous post', 'autoroyal'); echo ': ' . esc_attr( get_the_title($prev_post) ); ?>">
											<?php echo get_the_title($prev_post); ?>
										</a>
									</h4>
								</div>
							<?php endif; ?>
							
							<?php
							if (!empty( $next_post )): ?>
								
								<div class="post-nav-next">					
									<p><?php esc_html_e('Next', 'autoroyal'); ?></p>
									<h4>
										<a title="<?php esc_attr_e('Next post', 'autoroyal'); echo ': ' . esc_attr( get_the_title($next_post) ); ?>" href="<?php echo get_permalink( $next_post->ID ); ?>">
											<?php echo get_the_title($next_post); ?>
										</a>
									</h4>
								</div>
						
							<?php endif; ?>
							
							<div class="clear"></div>
						
						</div> <!-- /post-navigation-inner -->
					
					</div> <!-- /post-navigation -->
					<?php

						//the_post_navigation(array(
				        //    'prev_text' => esc_html__( 'Previous Post', 'autoroyal' ),
				        //    'next_text' => esc_html__( 'Next Post', 'autoroyal' ),
				        //) );

						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;

					endwhile; // End of the loop.
					?>

					</main><!-- #main -->
				</div><!-- #primary -->
			</div>
			<!-- /.col-md-8 -->
			
			<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
				<?php if ( $default_sidebar_position != 'no' ) : ?>
					<?php if ( $default_sidebar_position === 'right' ) : ?>
						<div class="col-md-4 fantasy-themes-sidebar-width">
					<?php elseif ( $default_sidebar_position === 'left' ) : ?>
						<div class="col-md-4 order-md-first fantasy-themes-sidebar-width">
					<?php endif; ?>
							<?php get_sidebar(); ?>
						</div>
						<!-- /.col-md-4 -->
				<?php endif; ?>
			<?php endif; ?>
		</div>
		<!-- /.row -->
	</div>
	<!-- /.container -->

<?php
get_footer();
