<?php

	$id = get_the_ID();

    $td_user        = wp_get_current_user();
    $td_user_id     = $td_user->ID;

    $website_type = get_option("autoroyal_webiste_type");

    // Account Funds
    $account_funds = get_option("autoroyal_enable_account_funds");

    // Dashboard
    $dashboard_page = get_option("autoroyal_dashboard_page_id");

    // My Listings
    $my_listings_page = get_option("autoroyal_inventory_page_id");

    // Submit Listing
    $submit_listing_page = get_option("autoroyal_submit_car_form_page_id");

    // Leads Page
    $leads_page = get_option("autoroyal_leads_page_id");

    // Deals Page
    $deals_page = get_option("autoroyal_deals_page_id");

    // Reservations Page
    $reservations_page = get_option("autoroyal_reservations_page_id");

    // Sales & Reports Page
    $reports_page = get_option("autoroyal_reports_page_id");

    // Account Funds
    $account_funds_page = get_option("autoroyal_account_funds_page_id");

    // Account Settings
    $account_settings = get_option("autoroyal_account_settings_page_id");

    // Notifications
    $notifications_page = get_option("autoroyal_notifications_page_id");

    // Notifications Subscribers
    $notifications_subscribers = get_option("autoroyal_notifications_subscribers_page_id");

    // My Active Advertised Listings
    $my_advertised_listings_page = get_option("autoroyal_active_adv_page_id");

    // Upcoming Payments
    $upcoming_payments_page = get_option("autoroyal_upcoming_payments_page_id");

?>

<?php if( !empty($dashboard_page) AND $website_type != 'rentals' ){ ?>
<li class="menu-item <?php if($id == $dashboard_page) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $dashboard_page ); ?>"><i class="material-icons">dashboard</i> <?php esc_html_e( 'Dashboard', 'autoroyal' ) ?></a></li>
<?php } ?>

<?php if($website_type == "marketplace") { ?>
<li class="menu-item"><a class="" href="<?php echo get_author_posts_url($td_user_id); ?>"><i class="material-icons">face</i> <?php esc_html_e( 'Public Profile', 'autoroyal' ) ?></a></li>
<?php } ?>

<?php if( !empty($my_listings_page) ){ $my_listings = "0"; $my_listings = autoroyal_get_total_cars_all_by_user( $td_user_id ); ?>
<li class="menu-item <?php if($id == $my_listings_page) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $my_listings_page ); ?>"><i class="material-icons">directions_car</i> <?php esc_html_e( 'My Listings', 'autoroyal' ) ?> (<?php echo esc_attr($my_listings); ?>)</a></li>
<?php } ?>

<?php if( !empty($reservations_page) AND $website_type == 'rentals' ){ ?>
<li class="menu-item <?php if($id == $reservations_page) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $reservations_page ); ?>"><i class="material-icons">local_taxi</i> <?php esc_html_e( 'Reservation', 'autoroyal' ) ?> (<?php echo autoroyal_get_total_new_reservations(); ?>)</a></li>
<?php } ?>

<?php if( !empty($account_funds_page) AND !empty($account_funds) ){ 

    if( class_exists('autoroyal_WC_Account_Funds') ) {
        $funds = autoroyal_WC_Account_Funds::get_account_funds();
    } else {
        $funds = '';
    }

    ?>
<li class="menu-item <?php if($id == $account_funds_page) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $account_funds_page ); ?>"><i class="material-icons">monetization_on</i> <?php esc_html_e( 'Account Funds', 'autoroyal' ) ?> <?php if(!empty($funds)) { echo "("; echo wp_kses($funds, true); echo ")"; } ?></a></li>
<?php } ?>

<?php if( !empty($submit_listing_page) ){ ?>
<li class="menu-item <?php if($id == $submit_listing_page) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $submit_listing_page ); ?>"><i class="material-icons">add_box</i> <?php esc_html_e( 'Submit Vehicle', 'autoroyal' ) ?></a></li>
<?php } ?>

<?php if( !empty($leads_page) ){ ?>
<li class="menu-item <?php if($id == $leads_page) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $leads_page ); ?>"><i class="material-icons">group</i> <?php esc_html_e( 'Leads', 'autoroyal' ) ?> (<?php echo autoroyal_get_total_leads(); ?>)</a></li>
<?php } ?>

<?php if( !empty($deals_page) ){ ?>
<li class="menu-item <?php if($id == $deals_page) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $deals_page ); ?>"><i class="material-icons">done_all</i> <?php esc_html_e( 'Deals', 'autoroyal' ) ?> (<?php echo autoroyal_get_total_deals(); ?>)</a></li>
<?php } ?>

<?php if( !empty($reports_page) ){ ?>
<li class="menu-item <?php if($id == $reports_page) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $reports_page ); ?>"><i class="material-icons">pie_chart</i> <?php esc_html_e( 'Sales & Reports', 'autoroyal' ) ?></a></li>
<?php } ?>

<?php if( !empty($upcoming_payments_page) ){ ?>
<li class="menu-item <?php if($id == $upcoming_payments_page) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $upcoming_payments_page ); ?>"><i class="material-icons">monetization_on</i> <?php esc_html_e( 'Upcoming Payments', 'autoroyal' ) ?></a></li>
<?php } ?>

<?php if( !empty($pending_review_page) AND current_user_can('administrator') ){ $new_pendings = "0"; $new_pendings = autoroyal_get_total_pending_properties(); ?>
<li class="menu-item <?php if($id == $pending_review_page) { echo "active"; } ?> <?php if($new_pendings > 0) { echo "alerted"; } ?>"><a class="" href="<?php echo get_permalink( $pending_review_page ); ?>"><i class="material-icons">gavel</i> <?php esc_html_e( 'Pending Review', 'autoroyal' ) ?> <span class="autoroyal-alert">(<?php echo esc_attr($new_pendings); ?>)</a></li>
<?php } ?>

<?php if(!empty($notifications_page)){ $new_notifications = "0"; ?>
<li class="menu-item <?php if($id == $notifications_page) { echo "active"; } ?> <?php if($new_notifications > 0) { echo "alerted"; } ?>"><a class="" href="<?php echo get_permalink( $notifications_page ); ?>"><i class="material-icons">notifications_active</i> <?php esc_html_e( 'Notifications', 'autoroyal' ) ?>  (<?php echo esc_attr($new_notifications); ?>)</a></li>
<?php } ?>

<?php if( !empty($notifications_subscribers) AND current_user_can('administrator') ){ ?>
<li class="menu-item <?php if($id == $notifications_subscribers) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $notifications_subscribers ); ?>"><i class="material-icons">add_alert</i> <?php esc_html_e( 'Notifications Subscribers', 'autoroyal' ) ?></a></li>
<?php } ?>

<?php if(!empty($my_advertised_listings_page)){ ?>
<li class="menu-item <?php if($id == $my_advertised_listings_page) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $my_advertised_listings_page ); ?>"><i class="material-icons">stars</i> <?php esc_html_e( 'Active Advertised Listings', 'autoroyal' ) ?></a></li>
<?php } ?>

<?php if(!empty($account_settings)){ ?>
<li class="menu-item <?php if($id == $account_settings) { echo "active"; } ?>"><a class="" href="<?php echo get_permalink( $account_settings ); ?>"><i class="material-icons">settings_applications</i> <?php esc_html_e( 'Account Settings', 'autoroyal' ) ?></a></li>
<?php } ?>

<li class="menu-item"><a class="" href="<?php echo wp_logout_url( home_url() ); ?>"><i class="material-icons">exit_to_app</i> <?php esc_html_e( 'Logout', 'autoroyal' ) ?></a></li>