<?php 

/*******
*
* Template Name: Blank Page (No Header, No Footer) 
*
*******/

?>

<!DOCTYPE html>

<html class="no-js" <?php language_attributes(); ?>>

	<head>
		
		<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" >

		<?php

			$MODS = get_theme_mods();
		    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

		    if ( ! function_exists( 'wp_site_icon' ) ) {

			    $theme_favicon = "";
				if(strlen($MODS['theme_favicon'])>0) {
				    $theme_favicon = $MODS['theme_favicon'];
				}

				if(!empty($theme_favicon)) {

		?>

		<link rel="shortcut icon" href="<?php echo esc_url($theme_favicon); ?>" />

		<?php } } ?>
		 
		<?php wp_head(); ?>
	
	</head>

	<body <?php body_class(); ?>>

		<div id="pageloader">

	    	<div class="preloader-wrapper big active">

		      	<div class="spinner-layer color_1">
			        <div class="circle-clipper left">
			          	<div class="circle"></div>
			        </div><div class="gap-patch">
			          	<div class="circle"></div>
			        </div><div class="circle-clipper right">
			          	<div class="circle"></div>
			        </div>
		      	</div>

		      	<div class="spinner-layer color_2">
			        <div class="circle-clipper left">
			          	<div class="circle"></div>
			        </div><div class="gap-patch">
			          	<div class="circle"></div>
			        </div><div class="circle-clipper right">
			          	<div class="circle"></div>
			        </div>
		      	</div>
		      	
		  	</div>

		</div>

		<div id="page" class="site">

			<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'autoroyal' ); ?></a>

			<div id="content" class="site-content">

				<div class="autoroyal-front-dashboard">

			        <div id="primary" class="content-area">

			            <main id="main" class="site-main">

			                <div class="container">

			                    <?php if ( $post && preg_match( '/vc_row/', $post->post_content ) ) { ?>

			                        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

			                            <?php if ( get_the_content() ) : ?>
			                
			                                <?php the_content(); ?>

			                            <?php endif; ?>

			                        <?php endwhile; endif; ?>

			                    <?php } else { ?>

			                    <div class="row">

			                        <div class="autoroyal-full-width-page col-md-12">

			                            <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

			                                <?php if ( get_the_content() ) : ?>

			                                    <?php the_content(); ?>

			                                <?php endif; ?>

			                            <?php endwhile; endif; ?>

			                        </div>

			                    </div>

			                    <?php } ?>

			                </div>

			            </main><!-- #main -->

			        </div><!-- #primary -->

			    </div>

			</div>

		</div>

	</body>
	
	<?php wp_footer(); ?>
	</body>
</html>