<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://wpautoroyalplugin.com
 * @since      1.0.2
 *
 * @package    autoroyal
 * @subpackage autoroyal/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the autoroyal, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    autoroyal
 * @subpackage autoroyal/admin
 * @author     Your Name <email@example.com>
 */
class autoroyal_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.2
	 * @access   private
	 * @var      string    $autoroyal    The ID of this plugin.
	 */
	private $autoroyal;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.2
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.2
	 * @param      string    $autoroyal       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $autoroyal, $version ) {

		$this->autoroyal = $autoroyal;
		$this->version = $version;

		include_once( 'class-autoroyal-settings.php' );

		$this->settings_page = new autoroyal_Settings();

		add_action( 'init', array( $this, 'includes' ) );
		add_action( 'admin_menu', array( $this, 'admin_menu' ), 12 );
		//add_action( 'admin_init', array( $this, 'admin_redirects' ) );
		add_action( 'init', array( $this, 'autoroyal_add_new_image_sizes' ) );

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.2
	 */
	public function autoroyal_add_new_image_sizes() {

		add_image_size( 'dealer_block_image', 290, 320, true );

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.2
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in autoroyal_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The autoroyal_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_register_style( 'jquery-ui',          autoroyal_PLUGIN_URL . '/assets/css/jquery-ui.css', false, "1.0.2", "all");
		wp_enqueue_style( 'select2',             autoroyal_PLUGIN_URL . '/assets/css/select2.min.css', array(), '4.0.3', 'all' );
		wp_register_style( 'bootstrap-select',   autoroyal_PLUGIN_URL . '/assets/css/bootstrap-select.min.css', array(), '4.0.3', 'all' );
		wp_enqueue_style( 'fontawesome',         autoroyal_PLUGIN_URL . '/assets/css/font-awesome.min.css', array(), '4.5.0', 'all' );
		wp_enqueue_style( 'autoroyal_admin_css',   autoroyal_PLUGIN_URL . '/assets/css/autoroyal-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.2
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in autoroyal_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The autoroyal_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		// Enqueue the color picker
		wp_enqueue_script( 'wp-color-picker' );
		wp_enqueue_style( 'wp-color-picker' );

		// Enqueue the autocomplete jquery and css
		wp_enqueue_style( 'jquery-ui' );
		wp_enqueue_script( 'jquery-ui-autocomplete' );

		// Enqueue scripts
		wp_enqueue_script( 'time-picker' );
		wp_enqueue_script( 'bootstrap-select' );
		
		wp_enqueue_script( 'carquery-api-js',      autoroyal_PLUGIN_URL . '/assets/js/carquery.0.3.4.js', array('jquery'), '0.3.4', true );
		//wp_enqueue_script( 'jquery-ui',            autoroyal_PLUGIN_URL . '/assets/js/jquery-ui.min.js', array( 'jquery' ), '1.0.0', false );
		wp_enqueue_script( 'time-picker',          autoroyal_PLUGIN_URL . '/assets/js/jquery.timePicker.min.js', array('jquery'), '2013-07-18', true );
		wp_enqueue_script( 'select2',              autoroyal_PLUGIN_URL . '/assets/js/select2.min.js', array('jquery'), '4.0.3', true );
		wp_enqueue_script( 'popper',               autoroyal_PLUGIN_URL . '/assets/js/popper.min.js', array( 'jquery' ), '1.14.3', false );
		wp_enqueue_script( 'bootstrap',            autoroyal_PLUGIN_URL . '/assets/js/bootstrap.min.js', array( 'jquery' ), '3.3.7', false );
		wp_enqueue_script( 'bootstrap-datepicker', autoroyal_PLUGIN_URL . '/assets/js/bootstrap-datepicker.min.js', array( 'jquery' ), '3.3.7', false );
		wp_register_script( 'bootstrap-select',    autoroyal_PLUGIN_URL . '/assets/js/bootstrap-select.min.js', array('jquery'), '4.0.3', true );
		wp_register_script( 'loan-rate',           autoroyal_PLUGIN_URL . '/assets/js/loan_rate.js', array('jquery'), '1.0.2', true );
		wp_enqueue_script( 'google-maps',          'https://maps.googleapis.com/maps/api/js?key='.get_google_map_api_key(), array( 'jquery' ) );
		wp_enqueue_script( 'autoroyal_admin_js',   autoroyal_PLUGIN_URL . '/assets/js/autoroyal-admin.js', array( 'jquery' ), $this->version, false );

		// Enqueue styles
		wp_enqueue_style( 'jquery-ui' );
		wp_enqueue_style( 'bootstrap-select' );

		$expense_currency = "";
		$autoroyal_currency = get_option( 'autoroyal_currency' ); 
		if(!empty($autoroyal_currency)) { 
			$expense_currency = esc_html__('in', 'autoroyal' ) . " " . $autoroyal_currency; 
		}
		$currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency );
		$settings = array(
			'url_theme' => get_template_directory_uri(),
			'autoroyal_ajaxurl' => esc_url( admin_url('admin-ajax.php', 'relative') ),
			'remove_image' => esc_html__("Remove Image", "autoroyal"),
			'upload_image' => esc_html__("Upload Image", "autoroyal"),
			'currency_symbol' => $currency_symbol,
			'expense_label' => esc_html__("Price", "autoroyal"),
			'expense_currency' => $expense_currency,
			'expense_desc' => esc_html__("Description", "autoroyal"),
			'expense_desc_placeholder' => esc_html__("Write down vehicle’s expense description here...", "autoroyal"),
			'expense_delete' => esc_html__("Delete", "autoroyal"),
			'measurement_type' => get_option( 'autoroyal_measurement_type' ),
			'select_a_make' => esc_html__("Select a Make", "autoroyal"),
		);
		wp_localize_script( 'autoroyal_admin_js', 'autoroyalSettings', apply_filters( 'autoroyal_admin_js', $settings ) );
		

	}

	/**
	 * Include any classes we need within admin.
	 */
	public function includes() {
		// Setup/welcome
		if ( ! empty( $_GET['page'] ) ) {
			switch ( $_GET['page'] ) {
				case 'autoroyal-setup' :
					//include_once( dirname( __FILE__ ) . '/class-autoroyal-setup-wizard.php' );
				break;
			}
		}
	}

	/**
	 * admin_menu function.
	 *
	 * @access public
	 * @return void
	 */
	public function admin_menu() {
		add_submenu_page( 'edit.php?post_type=vehicle', __( 'autoRoyal settings', 'autoroyal' ), __( 'autoRoyal settings', 'autoroyal' ), 'manage_options', 'car-settings', array( $this->settings_page, 'output' ) );
	}

	/**
	 * Handle redirects to setup/welcome page after install and updates.
	 *
	 * For setup wizard, transient must be present, the user must have access rights, and we must ignore the network/bulk plugin updaters.
	 */
	public function admin_redirects() {

		// Setup wizard redirect
		if ( ( ! empty( $_GET['page'] ) && in_array( $_GET['page'], array( 'autoroyal-setup' ) ) ) || is_network_admin() ) {
			return;
		}

		// If the user needs to install, send them to the setup wizard
		$autoroyal_run_wizard = get_option( 'autoroyal_run_wizard', null );
		if ( !empty($autoroyal_run_wizard) AND $autoroyal_run_wizard == "yes" ) {

			wp_safe_redirect( admin_url( 'index.php?page=autoroyal-setup' ) );
			delete_option( 'autoroyal_run_wizard' );
			exit;
			
		}
		
	}

}
