<?php
/* Create Custom Post Type : Team */
if( !function_exists( 'create_team_post_type' ) ){
    function create_team_post_type(){
        $labels = array(
            'name' => esc_html__( 'Team','autoroyal'),
            'singular_name' => esc_html__( 'Team Member','autoroyal' ),
            'add_new' => esc_html__('Add New','autoroyal'),
            'add_new_item' => esc_html__('Add New Team Member','autoroyal'),
            'edit_item' => esc_html__('Edit Team Member','autoroyal'),
            'new_item' => esc_html__('New Team Member','autoroyal'),
            'view_item' => esc_html__('View Team Member','autoroyal'),
            'search_items' => esc_html__('Search Team Member','autoroyal'),
            'not_found' =>  esc_html__('No Team Member found','autoroyal'),
            'not_found_in_trash' => esc_html__('No Team Member found in Trash','autoroyal'),
            'parent_item_colon' => ''
        );

        $args = array(
            'labels' => $labels,
            'public' => true,
            'exclude_from_search' => true,
            'publicly_queryable' => true,
            'show_ui' => true,
            'query_var' => true,
            'capability_type' => 'post',
            'hierarchical' => false,
            'menu_icon' => 'dashicons-businessman',
            'menu_position' => 5,
            'supports' => array('title','editor','thumbnail','revisions'),
            'rewrite' => array( 'slug' => esc_html__('team', 'autoroyal') )
        );

        register_post_type('team',$args);
    }
}
add_action( 'init', 'create_team_post_type' );

?>