<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://wpautoroyalplugin.com
 * @since      1.0.2
 *
 * @package    autoroyal
 * @subpackage autoroyal/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the autoroyal, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    autoroyal
 * @subpackage autoroyal/public
 * @author     FantasyThemes <hi@FantasyThemes.com>
 */
class autoroyal_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.2
	 * @access   private
	 * @var      string    $autoroyal    The ID of this plugin.
	 */
	private $autoroyal;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.2
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.2
	 * @param      string    $autoroyal       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $autoroyal, $version ) {

		$this->autoroyal = $autoroyal;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.2
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in autoroyal_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The autoroyal_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_register_style( 'jquery-ui',            autoroyal_PLUGIN_URL . '/assets/css/jquery-ui.css', false, "1.0.2", "all");
		wp_register_style( 'bootstrap-select',     autoroyal_PLUGIN_URL . '/assets/css/bootstrap-select.min.css', array(), '4.0.3', 'all' );
		wp_register_style( 'bootstrap-datepicker', autoroyal_PLUGIN_URL . '/assets/css/bootstrap-datepicker.min.css', array(), '4.0.3', 'all' );

		//wp_enqueue_style( 'font-awesome.min',    autoroyal_PLUGIN_URL . '/assets/css/font-awesome.min.css', array(), '4.5.0', 'all' );
		wp_enqueue_style( 'bootstrap',             autoroyal_PLUGIN_URL . '/assets/css/bootstrap.min.css', array(), '4.1.1', 'all' );
		wp_enqueue_style( 'plugins',               autoroyal_PLUGIN_URL . '/assets/css/plugins.css', array(), '1.0.0', 'all' );
		wp_enqueue_style( 'animate',               autoroyal_PLUGIN_URL . '/assets/css/animate.css', array(), '3.5.2', 'all' );
		wp_enqueue_style( 'owl-carousel.min',      autoroyal_PLUGIN_URL . '/assets/css/owl-carousel.min.css', array(), '2.2.1', 'all' );
		wp_enqueue_style( 'select2.min',           autoroyal_PLUGIN_URL . '/assets/css/select2.min.css', array(), '2.2.1', 'all' );
		wp_enqueue_style( 'autoroyal_public_css',  autoroyal_PLUGIN_URL . '/assets/css/autoroyal-public.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'responsive',            autoroyal_PLUGIN_URL . '/assets/css/responsive.css', array(), '1.0.2', 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.2
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in autoroyal_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The autoroyal_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		
		wp_enqueue_script( 'carquery-api-js',     autoroyal_PLUGIN_URL . '/assets/js/carquery.0.3.4.js', array('jquery'), '0.3.4', true );
		wp_enqueue_script( 'google-maps',         'https://maps.googleapis.com/maps/api/js?key='.get_google_map_api_key(). '&libraries=places&v=3', array( 'jquery' ) );

		wp_register_script( 'loan-rate',          autoroyal_PLUGIN_URL . '/assets/js/loan_rate.js', array('jquery'), '1.0.2', true );
		wp_register_script( 'time-picker',        autoroyal_PLUGIN_URL . '/assets/js/jquery.timePicker.min.js', array('jquery'), '2013-07-18', true );
		wp_register_script( 'charts',             autoroyal_PLUGIN_URL . '/assets/js/charts.js', array('jquery'), '2013-07-18', true );

		wp_enqueue_script( 'plugins',             autoroyal_PLUGIN_URL . '/assets/js/plugins.js', array( 'jquery' ), '1.0.0', false );
		wp_enqueue_script( 'jquery-ui',           autoroyal_PLUGIN_URL . '/assets/js/jquery-ui.min.js', array( 'jquery' ), '1.0.0', false );
		wp_enqueue_script( 'popper',              autoroyal_PLUGIN_URL . '/assets/js/popper.min.js', array( 'jquery' ), '1.14.3', false );
		wp_enqueue_script( 'bootstrap',           autoroyal_PLUGIN_URL . '/assets/js/bootstrap.min.js', array( 'jquery' ), '3.3.7', false );
		wp_enqueue_script( 'bootstrap-datepicker',autoroyal_PLUGIN_URL . '/assets/js/bootstrap-datepicker.min.js', array( 'jquery' ), '3.3.7', false );
		wp_enqueue_script( 'owl-carousel.min',    autoroyal_PLUGIN_URL . '/assets/js/owl-carousel.min.js', array( 'jquery' ), '2.2.1', false );
		wp_enqueue_script( 'jquery.touchSwipe',   autoroyal_PLUGIN_URL . '/assets/js/jquery.touchSwipe.min.js', array( 'jquery' ), '1.6.18', false );
		wp_enqueue_script( 'clipboard',           autoroyal_PLUGIN_URL . '/assets/js/clipboard.js', array( 'jquery' ), '1.6.1', false );
		//wp_enqueue_script( 'modernizr.min',     autoroyal_PLUGIN_URL . '/assets/js/modernizr.min.js', array( 'jquery' ), '2.6.2', false );
		wp_enqueue_script( 'select2.min',         autoroyal_PLUGIN_URL . '/assets/js/select2.min.js', array( 'jquery' ), '4.0.3', false );
		wp_enqueue_script( 'form',                autoroyal_PLUGIN_URL . '/assets/js/jquery.form.js', array( 'jquery' ), '1.0.2', false );
		wp_register_script( 'bootstrap-select',   autoroyal_PLUGIN_URL . '/assets/js/bootstrap-select.min.js', array('jquery'), '4.0.3', true );
		wp_enqueue_script( 'autoroyal_public_js', autoroyal_PLUGIN_URL . '/assets/js/autoroyal-public.js', array( 'jquery' ), $this->version, false );
		
		// Enqueue styles
		wp_enqueue_style( 'jquery-ui' );
		wp_enqueue_style( 'bootstrap-select' );

		// Enqueue scripts
		wp_enqueue_script( 'time-picker' );
		wp_enqueue_script( 'bootstrap-select' );

		$expense_currency = "";
		$autoroyal_currency = get_option( 'autoroyal_currency' ); 
		if(!empty($autoroyal_currency)) { 
			$expense_currency = esc_html__('in', 'autoroyal' ) . " " . $autoroyal_currency; 
		}
		$measurement_type = get_option("autoroyal_measurement_type"); 
		if($measurement_type == "metric") { 
			$measurement_text = "km"; 
		} else { 
			$measurement_text = "mi"; 
		};
		$currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency );
		$settings = array(
			'any_make_label' => esc_html__("Any", "autoroyal"),
			'any_model_label' => esc_html__("Select a make", "autoroyal"),
			'currency_symbol' => $currency_symbol,
			'measurement_text' => $measurement_text,
			'url_theme' => get_template_directory_uri(),
			'autoroyal_ajaxurl' => esc_url( admin_url('admin-ajax.php', 'relative') ),
			'remove_image' => esc_html__("Remove Image", "autoroyal"),
			'upload_image' => esc_html__("Upload Image", "autoroyal"),
			'expense_label' => esc_html__("Price", "autoroyal"),
			'expense_currency' => $expense_currency,
			'expense_desc' => esc_html__("Description", "autoroyal"),
			'expense_desc_placeholder' => esc_html__("Write down vehicle’s expense description here...", "autoroyal"),
			'expense_delete' => esc_html__("Delete", "autoroyal"),
			'measurement_type' => get_option( 'autoroyal_measurement_type' ),
			'remove_testimonial' => esc_html__("Remove Testimonial", "autoroyal"),
			'img_author' => esc_html__("Author Image", "autoroyal"),
			'company_url' => esc_html__("Company URL", "autoroyal"),
			'company' => esc_html__("Company", "autoroyal"),
			'position' => esc_html__("Position", "autoroyal"),
			'testimonial_author' => esc_html__("Testimonial Author", "autoroyal"),
			'testimonial' => esc_html__("Testimonial", "autoroyal"),
			'select_a_make' => esc_html__("Select a Make", "autoroyal"),
		);
		wp_localize_script( 'autoroyal_public_js', 'autoroyalSettings', apply_filters( 'autoroyal_public_js', $settings ) );

	}

}
