<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_blog_posts_func( $atts ) {

	extract( shortcode_atts( array(
        "columns" => "three",
    	"css" => "",
   	), $atts ) );

	ob_start();

    $class_to_filter = '';
    $class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
    $css_class = $class_to_filter;

   	?>

   	<div class="autoroyal-invetory-grid-view">
            
        <?php 

            $columns_number = 3;
            if($columns == "two") {
                $columns_number = 2;
            }

            $wp_query_project = null;
            $wp_query_project = new WP_Query();
            $wp_query_project->query('post_type=post&posts_per_page='.$columns_number);

        ?>
        <?php if ( $wp_query_project->have_posts() ) : ?>
                    
            <div id="isotope-container" class="row">
                
                <?php while ($wp_query_project->have_posts()) : $wp_query_project->the_post(); ?>

                    <!-- post -->
                    <div id="post-<?php the_ID(); ?>" <?php if($columns == "two") { post_class('col-lg-6 autoroyal-animated-blk autoroyal-vehicle-grid-block'); } else { post_class('col-lg-4 autoroyal-animated-blk autoroyal-vehicle-grid-block'); } ?>>

                        <div class="autoroyal-vehicle-block autoroyal-block-style-2 autoroyal-blog-post">

                            <?php 

                                if(has_post_thumbnail()) {

                                    $image_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), false, '' ); 
                                    $td_title_bg_img = esc_url($image_src[0]);
                                    $foto_large = autoroyal_get_resized_image( $td_title_bg_img, 'autoroyal-blog-post-image' );

                                ?>

                                <div class="autoroyal-vehicle-block-image-wrapper">

                                    <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($foto_large); ?>" alt="<?php the_title(); ?>"></a>

                                </div>

                                <?php

                                } 

                            ?>

                            <div class="autoroyal-vehicle-block-meta">

                                <div class="entry-title"><?php the_category(' '); ?></div>

                                <a class="heading" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>

                                <div class="autoroyal-rent-subtitle">

                                    <span><?php esc_html_e( 'by', 'autoroyal' ); ?> <strong><?php the_author(); ?></strong></span> <span><?php esc_html_e( 'on', 'autoroyal' ); ?> <strong><a href="<?php the_permalink(); ?>"><?php the_time(get_option('date_format')); ?></a></strong></span>                                
                                        
                                </div>

                            </div>

                        </div>

                    </div>
                    <!-- /post -->
                                                    
                <?php endwhile; ?>
                            
            </div> <!-- /posts -->
    
        <?php endif; wp_reset_postdata(); ?>

    </div> <!-- /content -->

    <?php

    return ob_get_clean();

}
add_shortcode( 'autoroyal_blog_posts', 'autoroyal_blog_posts_func' );

vc_map( array(
  	'name' => esc_html__( 'Blog Posts', 'autoroyal' ),
	'base' => 'autoroyal_blog_posts',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoroyal blog posts', 'autoroyal' ),
	'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Columns', 'autoroyal' ),
            'description' => esc_html__( 'Select columns amount.', 'autoroyal' ),
            'param_name' => 'columns',
            'value' => array(
                esc_html__( 'Three', 'autoroyal' ) => 'three',
                esc_html__( 'Two', 'autoroyal' ) => 'two',
            ),
            'std' => 'three',
            'group' => esc_html__( 'General', 'autoroyal' ),
        ),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

?>