<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function search_by_price_container_func( $atts, $content = null ) {

    extract( shortcode_atts( array(
        "css" => "",
    ), $atts ) );

    ob_start();

    $class_to_filter = '';
    $class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
    $css_class = $class_to_filter;
   
    ?>

    <div class="autoroyal-search-by-make <?php echo esc_attr($css_class); ?>">

        <div class="row">

            <?php

                // execute the '[tab]' shortcode first to get the title and content - acts on global $single_tab_array
                echo do_shortcode($content);
           
            ?>
            
        </div>

    </div>

    <?php

    return ob_get_clean();

}
add_shortcode('search_by_price_container', 'search_by_price_container_func');

vc_map( array(
    'name' => esc_html__( 'Search by Price Container', 'autoroyal' ),
    'base' => 'search_by_price_container',
    'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
    'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
    'description' => esc_html__( 'Custom autoroyal search by price container', 'autoroyal' ),
    'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
    "as_parent" => array('only' => 'search_by_price_item'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
    "content_element" => true,
    "show_settings_on_create" => false,
    'params' => array(
        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'CSS box', 'autoroyal' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design Options', 'autoroyal' ),
        ),
    ),
    "js_view" => 'VcColumnView'
));

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_search_by_price_container extends WPBakeryShortCodesContainer {
    }
}