<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_latest_vehicles_rent_func( $atts ) {

	extract( shortcode_atts( array(
        "amount" => "6",
        "style" => "default",
    	"css" => "",
   	), $atts ) );

	ob_start();

	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

    $uniqid = uniqid();

	?>

    <div class="autoroyal-latest-vehicles autoroyal-vehicles-for-rent <?php echo esc_attr($css_class); ?>">

        <div class="row">

    	<?php 

            $search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
                'post_type'           => 'vehicle',
                'post_status'         => 'publish',
                'posts_per_page'      => $amount,
                'orderby'             => 'date', 
                'order'               => 'DESC',
                'ignore_sticky_posts' => 1,
                'meta_key'            => 'vehicle_for_rent',
                'meta_query' => array(
                    'relation' => 'AND',
                    array(
                        'key'     => '_sold',
                        'value'   => 0
                    )
                )
            ));

            $search_args = apply_filters( 'autoroyal_search_filter_parameters', $search_args );
            $cars_query  = new WP_Query;
            $cars        = $cars_query->query( $search_args );

            if ( $cars ) :
            
                foreach ( $cars as $car ) :

                    $car_ID = $car->ID; 

                    $vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
                    $vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
                    $vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
                    $vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
                    $vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
                    $vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
                    $vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

                    $vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
                    if(!empty($vehicle_exterior_color)) {
                        $color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
                        $color_id   = $vehicle_exterior_color[0]->term_id;
                        $color_name = $vehicle_exterior_color[0]->name;
                    } else {
                        $color_name = "";
                        $color_id   = "";
                    }

                    $vehicle_mileage = esc_attr(get_post_meta($car_ID, 'vehicle_mileage',true));

                    $vehicle_cost = esc_attr(get_post_meta($car_ID, 'vehicle_cost',true));
                    $vehicle_retail_price = esc_attr(get_post_meta($car_ID, 'vehicle_retail_price',true));
                    $vehicle_discounted_price = esc_attr(get_post_meta($car_ID, 'vehicle_discounted_price',true));
                    $price = esc_attr(get_post_meta($car_ID, 'vehicle_price',true));

                    $vehicle_image_gallery = get_post_meta($car_ID, 'vehicle_image_gallery',true);
                    $vehicle_image_extended_gallery = get_post_meta($car_ID, 'vehicle_image_extended_gallery',true);
                    $vehicle_image_url = "";

                    if(!empty($vehicle_image_gallery[0]['url'])) {

                        $vehicle_image_url = $vehicle_image_gallery[0]['url'];

                    } elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

                        $vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

                    }

                    $vehicle_cover_image = get_post_meta($car_ID, 'vehicle_cover_image',true);
                    if(!empty($vehicle_cover_image)) {
                        $vehicle_image_url = $vehicle_cover_image;
                    }

                    $vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));
                    $vehicle_power_hp = esc_attr(get_post_meta($car_ID, 'vehicle_power_hp',true));

                    $vehicle_drive = get_the_terms($car_ID, 'vehicle_drive' );
                    $terms_vehicle_drive = $vehicle_drive[0]->name;

                    // Cars meta
                    $vehicle_consumption_urban = esc_attr(get_post_meta($car_ID, 'vehicle_consumption_urban',true));
                    $vehicle_consumption_highway = esc_attr(get_post_meta($car_ID, 'vehicle_consumption_highway',true));

                    $terms_vehicle_fuel_type = "";
                    $terms_vehicle_fuel_type_id = "";
                    $vehicle_fuel_type = get_the_terms($car_ID, 'vehicle_fuel_type' );
                    if ($vehicle_fuel_type && ! is_wp_error($vehicle_fuel_type)) :
                        $terms_vehicle_fuel_type = $vehicle_fuel_type[0]->name;
                        $terms_vehicle_fuel_type_id = $vehicle_fuel_type[0]->term_id;
                    endif;

                    $terms_vehicle_transmission = "";
                    $terms_vehicle_transmission_id = "";
                    $vehicle_transmission = get_the_terms($car_ID, 'vehicle_transmission' );
                    if ($vehicle_transmission && ! is_wp_error($vehicle_transmission)) :
                        $terms_vehicle_transmission = $vehicle_transmission[0]->name;
                        $terms_vehicle_transmission_id = $vehicle_transmission[0]->term_id;
                    endif;

                    $vehicle_name = $vehicle_year . " " . $vehicle_make . " " . $vehicle_model;

                    $vehicle_condition = esc_attr(get_post_meta($car_ID, 'vehicle_condition',true));

                    //
                    $terms_vehicle_body_style = "";
                    $terms_vehicle_body_style_name = "";
                    $vehicle_body_style = get_the_terms($car_ID, 'vehicle_body_style' );
                    if ($vehicle_body_style && ! is_wp_error($vehicle_body_style)) :
                        $terms_vehicle_body_style = $vehicle_body_style[0]->term_id;
                        $terms_vehicle_body_style_name = $vehicle_body_style[0]->name;
                    endif;

                    $total_photos = autoroyal_count_photos( $car_ID );

                    //
                    $vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
                    if(!empty($vehicle_exterior_color)) {
                        $color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
                        $color_id   = $vehicle_exterior_color[0]->term_id;
                        $color_name = $vehicle_exterior_color[0]->name;
                        $color_type = get_term_meta( $vehicle_exterior_color[0]->term_id, 'color_type', true );
                    } else {
                        $color_type = "";
                    }

                    $vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));

                    $vehicle_carfax_link = esc_attr(get_post_meta($car_ID, 'vehicle_carfax_link',true));
                    $vehicle_autocheck_link = esc_attr(get_post_meta($car_ID, 'vehicle_autocheck_link',true));
                    $vehicle_pre_owned = esc_attr(get_post_meta($car_ID, 'vehicle_pre_owned',true));

                    // Rent
                    $minimum_age = get_post_meta($car_ID, 'minimum_age',true);
                    $vehicle_rent_price_min = get_post_meta($car_ID, 'vehicle_rent_price_min',true);
                    $vehicle_rent_price_max = get_post_meta($car_ID, 'vehicle_rent_price_max',true);

                    $vehicle_seats = get_post_meta($car_ID, 'vehicle_seats',true);
                    $vehicle_luggage = get_post_meta($car_ID, 'vehicle_luggage',true);
                    $vehicle_doors = get_post_meta($car_ID, 'vehicle_doors',true);
                    $vehicle_navigation = get_post_meta($car_ID, 'vehicle_navigation',true);
                    $vehicle_ac = get_post_meta($car_ID, 'vehicle_ac',true);
                    $rent_deposit = get_post_meta($car_ID, 'rent_deposit',true);
                    $mileage_limit = get_post_meta($car_ID, 'mileage_limit',true);

                    $autoroyal_currency = get_option( 'autoroyal_currency' );

                ?>

                <?php if( $style == "default" ) { ?>

                <!-- cars offer block image -->
                <div id="car-rent-id-<?php echo esc_attr($car_ID); ?>" class="col-sm-6 col-lg-4 autoroyal-animated-blk autoroyal-vehicle-grid-block autoroyal-vehicle-rent">

                    <div class="autoroyal-vehicle-block autoroyal-block-style-1">
                                    
                        <div class="autoroyal-vehicle-block-image-wrapper">
                            
                            <?php if(!empty($vehicle_image_url)) { ?>
                            <a data-open-id="car-gallery-grid-<?php echo esc_attr($uniqid); ?>-<?php echo esc_attr($car_ID); ?>" class="autoroyal-vehicle-block-image-gallery open-album" href="#"><i class="fa fa-file-image-o" aria-hidden="true"></i><?php if($total_photos['total'] > "0") {?><span><?php echo esc_attr($total_photos['total']); ?></span><?php } ?></a>
                            
                            <?php foreach ( $total_photos['image'] as $image ) { ?>
                            <a rel="car-gallery-grid-<?php echo esc_attr($uniqid); ?>-<?php echo esc_attr($car_ID); ?>"  class="fancybox" href="<?php echo esc_url($image); ?>"></a>
                            <?php } ?>

                            <?php } ?>

                            <?php if(!empty($vehicle_image_url)) { $foto_large = autoroyal_get_resized_image( $vehicle_image_url, 'autoroyal-large-thumbnail-image' ); ?>
                            <a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-thumbnail" style="background-image: url(<?php echo esc_url($foto_large); ?>);"></a>
                            <?php } else { ?>
                            <a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-no-thumbnail">
                                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 538.043 538.043" style="enable-background:new 0 0 538.043 538.043;" xml:space="preserve"><path d="M526.745,312.866h-15.005c-3.706-18.736-10.307-44.359-20.792-57.941c-49.022-63.573-110.574-97.697-187.945-97.697
    c-50.134,0-82.787,4.902-99.789,14.981c-2.295,1.363-9.063,5.369-27.344,42.135c-26.687,0.419-97.278,5.261-131.127,43.414
    c-16.99,19.143-23.746,39.719-26.352,55.096h-7.078C5.058,312.854,0,317.924,0,324.177c0,6.241,5.058,11.323,11.311,11.323h5.655
    c0.048,0.61,0.096,1.076,0.108,1.219c0.598,5.739,5.464,10.115,11.239,10.115h14.252c8.752,19.968,28.66,33.981,51.831,33.981
    s43.079-14.013,51.855-33.981h215.982c8.74,19.968,28.66,33.981,51.832,33.981c23.172,0,43.091-14.013,51.832-33.981h38.165
    c0.084,0,0.155,0,0.215,0c6.253,0,11.335-5.07,11.335-11.323h11.131c6.241,0,11.299-5.081,11.299-11.323
    C538.044,317.924,532.986,312.866,526.745,312.866z M94.397,358.169c-18.724,0-33.968-15.232-33.968-33.981
    c0-18.748,15.232-33.992,33.968-33.992c18.748,0,34.004,15.245,34.004,33.992C128.402,342.937,113.145,358.169,94.397,358.169z
     M295.183,226.433c0,3.133-2.523,5.667-5.667,5.667h-87.964c-1.937,0-3.742-1.016-4.783-2.666
    c-1.052-1.662-1.148-3.731-0.287-5.476c4.149-8.537,11.67-23.327,15.269-26.4c11.981-7.616,36.001-11.227,72.002-11.227
    c1.961,0,3.922,0.024,5.906,0.06c3.061,0.072,5.512,2.595,5.512,5.667L295.183,226.433L295.183,226.433z M306.53,226.433V193.66
    c0-1.614,0.705-3.157,1.901-4.233c1.208-1.076,2.81-1.614,4.424-1.399c39.863,4.687,70.519,17.875,82.058,35.272
    c1.16,1.746,1.244,3.97,0.263,5.811c-0.968,1.841-2.905,2.989-4.998,2.989h-78.004C309.077,232.1,306.53,229.565,306.53,226.433z
     M414.067,358.169c-18.724,0-33.98-15.232-33.98-33.981c0-18.748,15.244-33.992,33.98-33.992c18.736,0,33.98,15.245,33.98,33.992
    C448.047,342.937,432.791,358.169,414.067,358.169z"/></svg>

                            </a>
                            <?php } ?>
                        </div>

                        <div class="autoroyal-vehicle-block-meta">

                            <a class="heading" href="<?php echo get_permalink( $car_ID ); ?>"><span class="productYear"><?php echo esc_attr($vehicle_year); ?></span> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?></a>

                            <div class="autoroyal-rent-subtitle">

                                <?php if(!empty($vehicle_seats)) { ?>
                                    <span>
                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 350 350" style="enable-background:new 0 0 350 350;" xml:space="preserve"><path d="M175,171.173c38.914,0,70.463-38.318,70.463-85.586C245.463,38.318,235.105,0,175,0s-70.465,38.318-70.465,85.587
        C104.535,132.855,136.084,171.173,175,171.173z"/><path d="M41.909,301.853C41.897,298.971,41.885,301.041,41.909,301.853L41.909,301.853z"/><path d="M308.085,304.104C308.123,303.315,308.098,298.63,308.085,304.104L308.085,304.104z"/><path d="M307.935,298.397c-1.305-82.342-12.059-105.805-94.352-120.657c0,0-11.584,14.761-38.584,14.761
        s-38.586-14.761-38.586-14.761c-81.395,14.69-92.803,37.805-94.303,117.982c-0.123,6.547-0.18,6.891-0.202,6.131
        c0.005,1.424,0.011,4.058,0.011,8.651c0,0,19.592,39.496,133.08,39.496c113.486,0,133.08-39.496,133.08-39.496
        c0-2.951,0.002-5.003,0.005-6.399C308.062,304.575,308.018,303.664,307.935,298.397z"/></svg><?php echo esc_attr($vehicle_seats); ?>
                                    </span>
                                <?php } ?>

                                <?php if(!empty($vehicle_luggage)) { ?>
                                    <span>
                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="511.626px" height="511.627px" viewBox="0 0 511.626 511.627" style="enable-background:new 0 0 511.626 511.627;" xml:space="preserve"><path d="M18.842,128.48C6.28,141.043,0,156.08,0,173.588v237.537c0,17.515,6.28,32.552,18.842,45.111
            c12.563,12.565,27.6,18.842,45.111,18.842h18.271V109.634H63.953C46.438,109.634,31.402,115.917,18.842,128.48z"/><path d="M365.446,63.955c0-7.614-2.663-14.084-7.994-19.414c-5.325-5.33-11.8-7.993-19.411-7.993H173.589
            c-7.612,0-14.083,2.663-19.414,7.993c-5.33,5.327-7.994,11.799-7.994,19.414v45.679h-36.545v365.444h292.359V109.634h-36.549
            V63.955z M328.904,109.634H182.725V73.091h146.179V109.634z"/><path d="M492.785,128.48c-12.563-12.562-27.601-18.846-45.111-18.846h-18.274v365.444h18.274c17.511,0,32.548-6.276,45.111-18.842
            c12.559-12.56,18.842-27.597,18.842-45.111V173.588C511.626,156.08,505.343,141.043,492.785,128.48z"/></svg><?php echo esc_attr($vehicle_luggage); ?>
                                    </span>
                                <?php } ?>

                                <?php if(!empty($vehicle_doors)) { ?>
                                    <span>
                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M446.479,261.188l-55.826-93.043c2.393-1.956,4.013-4.81,4.013-8.145V74.667C394.667,68.771,389.896,64,384,64h-1.505
            c-3.048-13.035-10.828-24.598-22.245-32.208L325.99,8.958C317.198,3.104,306.969,0,296.417,0h-80.833
            C205.031,0,194.802,3.104,186,8.958l-34.25,22.833C140.333,39.402,132.555,50.965,129.507,64H128
            c-5.896,0-10.667,4.771-10.667,10.667V160c0,3.335,1.62,6.189,4.013,8.145l-55.826,93.043c-3.031,5.042-1.396,11.604,3.656,14.625
            c5.052,3.063,11.615,1.396,14.635-3.667L128,198.5v132.167v10.667c-5.896,0-10.667,4.771-10.667,10.667v85.333
            c0,5.896,4.771,10.667,10.667,10.667h1.078c5.232,36.089,36.074,64,73.589,64h106.667c37.514,0,68.357-27.911,73.589-64H384
            c5.896,0,10.667-4.771,10.667-10.667V352c0-5.896-4.771-10.667-10.667-10.667v-10.667V198.5l44.188,73.646
            c3.021,5.063,9.583,6.729,14.635,3.667C447.875,272.792,449.51,266.229,446.479,261.188z M180.448,116.792
            c3.917-6.333,10.698-10.125,18.146-10.125h114.812c7.448,0,14.229,3.792,18.146,10.125c3.917,6.333,4.271,14.083,0.938,20.75
            l-21.333,42.667C307.521,187.479,300.208,192,292.073,192h-72.146c-8.135,0-15.448-4.521-19.083-11.792l-21.333-42.667
            C176.177,130.875,176.531,123.125,180.448,116.792z M149.333,313.41V185.75l21.333,21.333v95.667L149.333,313.41z
             M338.208,402.208c-1,1-25.115,24.458-82.208,24.458s-81.208-23.458-82.208-24.458c-3.25-3.25-4.052-8.208-2-12.313l21.333-42.667
            c2.635-5.229,9.063-7.354,14.281-4.792C207.594,342.542,227.187,352,256,352c29.146,0,48.375-9.438,48.562-9.542
            c2.542-1.271,5.438-1.438,8.146-0.583c2.677,0.896,4.896,2.833,6.167,5.354l21.333,42.667
            C342.26,394,341.458,398.958,338.208,402.208z M362.667,313.41l-21.333-10.66v-95.667l21.333-21.333V313.41z"/></svg><?php echo esc_attr($vehicle_doors); ?> <?php echo esc_html_e('Doors', 'autoroyal'); ?>
                                    </span>
                                <?php } ?>
                                
                                <?php if(!empty($terms_vehicle_transmission)) { ?>
                                    <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M30,94H70A24,24,0,0,0,94,70V30A24,24,0,0,0,70,6H30A24,24,0,0,0,6,30V70A24,24,0,0,0,30,94ZM14,30A16,16,0,0,1,30,14H70A16,16,0,0,1,86,30V70A16,16,0,0,1,70,86H30A16,16,0,0,1,14,70Z"></path><path d="M30,74a4,4,0,0,0,4-4V54H46V70a4,4,0,0,0,8,0V54h8A12,12,0,0,0,74,42V30a4,4,0,0,0-8,0V42a4,4,0,0,1-4,4H54V30a4,4,0,0,0-8,0V46H34V30a4,4,0,0,0-8,0V70A4,4,0,0,0,30,74Z"></path><circle cx="70" cy="70" r="4"></circle></svg><?php echo esc_attr($terms_vehicle_transmission); ?>
                                    </span>
                                <?php } ?>

                                <?php if(!empty($vehicle_navigation)) { ?>
                                    <span>
                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="438.533px" height="438.533px" viewBox="0 0 438.533 438.533" style="enable-background:new 0 0 438.533 438.533;" xml:space="preserve"><path d="M409.133,109.203c-19.608-33.592-46.205-60.189-79.798-79.796C295.736,9.801,259.058,0,219.273,0
            c-39.781,0-76.47,9.801-110.063,29.407c-33.595,19.604-60.192,46.201-79.8,79.796C9.801,142.8,0,179.489,0,219.267
            c0,39.78,9.804,76.463,29.407,110.062c19.607,33.592,46.204,60.189,79.799,79.798c33.597,19.605,70.283,29.407,110.063,29.407
            s76.47-9.802,110.065-29.407c33.593-19.602,60.189-46.206,79.795-79.798c19.603-33.596,29.403-70.284,29.403-110.062
            C438.533,179.485,428.732,142.795,409.133,109.203z M353.742,297.208c-13.894,23.791-32.736,42.64-56.527,56.534
            c-23.791,13.894-49.771,20.834-77.945,20.834c-28.167,0-54.149-6.94-77.943-20.834c-23.791-13.895-42.633-32.743-56.527-56.534
            c-13.897-23.791-20.843-49.772-20.843-77.941c0-28.171,6.949-54.152,20.843-77.943c13.891-23.791,32.738-42.637,56.527-56.53
            c23.791-13.895,49.772-20.84,77.943-20.84c28.173,0,54.154,6.945,77.945,20.84c23.791,13.894,42.634,32.739,56.527,56.53
            c13.895,23.791,20.838,49.772,20.838,77.943C374.58,247.436,367.637,273.417,353.742,297.208z"/><path d="M146.181,333.182l146.178-73.087V105.35l-146.178,73.089V333.182z M182.727,200.992l73.094,36.547l-73.094,36.545V200.992
            z"/></svg><?php echo esc_html_e('Navigation', 'autoroyal'); ?>
                                    </span>
                                <?php } ?>

                                <?php if(!empty($vehicle_ac)) { ?>
                                    <span>
                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="700.236px" height="700.236px" viewBox="0 0 700.236 700.236" style="enable-background:new 0 0 700.236 700.236;" xml:space="preserve"><path d="M645.527,495.815l-75.609-43.689l63.832-38.015c10.262-4.944,13.438-18.724,7.602-28.855
        c-5.941-10.375-18.764-12.563-28.498-6.89l-85.107,49.849L392.488,349.51l135.258-77.894l85.107,49.768
        c2.658,1.945,6.078,3.08,9.881,3.08c7.213,0,13.674-3.404,18.617-9.889c5.699-10.294,2.66-23.911-7.602-28.855l-63.832-38.015
        l75.609-43.688c9.855-5.674,13.244-18.4,7.602-28.856c-5.389-10.051-18.723-13.536-28.879-7.619l-75.99,44.094l-1.135-76.03
        c-0.178-11.753-9.119-21.237-20.896-21.237c-11.775,0-20.984,10.213-20.895,21.237l0.754,100.346l-134.496,77.894V155.788
        l84.727-48.309c9.891-5.593,14.201-18.643,8.357-28.855c-5.934-10.375-18.115-13.456-28.498-7.619l-64.586,36.475V21.236
        c0-11.753-9.5-21.236-21.277-21.236c-11.777,0-20.896,9.483-20.896,21.236v87.053l-66.871-37.285
        c-10.416-5.755-22.274-2.513-28.118,7.619c-5.933,10.375-2.245,23.101,7.976,28.855l87.013,49.039v156.518l-137.542-79.353
        l0.762-98.077c1.143-11.023-8.738-21.237-20.515-21.237h-0.762c-11.016,0-20.774,9.484-20.896,21.237l-0.762,73.76l-74.084-42.554
        c-10.343-5.998-23.109-2.432-28.499,7.538c-5.642,10.537-2.724,22.939,7.603,28.937l74.846,43.283l-65.354,39.15
        C53.96,290.664,50.758,304.443,57,314.575c4.02,6.566,9.873,9.889,17.856,9.889c4.174,0,7.651-1.054,11.015-3.08l85.489-50.498
        l137.162,78.624l-137.162,79.434l-85.489-50.578c-10.262-5.998-23.49-3.161-28.872,6.89c-5.642,10.456-2.578,23.02,7.214,28.855
        l65.355,38.744l-74.847,43.689c-10.302,5.998-13.642,18.643-7.603,28.937C51.342,532.614,57,536.1,64.976,536.1
        c1.897,0,5.698-1.135,10.643-3.08l74.084-42.554l0.762,73.76c0.122,11.753,9.88,20.831,20.896,20.831h0.762
        c11.777,0,20.604-9.808,20.515-21.642l-0.762-97.996l137.542-78.623v155.707l-87.013,49.038
        c-10.383,5.836-14.015,18.562-7.976,28.856c4.223,7.214,9.881,10.699,17.856,10.699c3.802,0,7.303-0.648,10.262-2.351
        l66.871-37.935v88.513c0,11.753,9.119,20.912,20.896,20.912c11.777,0,21.277-9.159,21.277-20.912v-87.054l64.586,36.476
        c2.957,1.702,6.459,2.351,9.881,2.351c8.355,0,14.516-3.404,18.617-10.699c5.771-10.213,2.043-23.021-8.357-28.856l-84.727-47.498
        V385.985l134.496,77.894l-0.754,99.536c-0.098,11.834,9.119,21.642,20.896,21.642s20.717-9.078,20.895-20.831l1.135-76.435
        l75.99,44.499c2.934,1.702,6.84,2.27,11.023,2.27c7.977,0,13.828-3.323,17.855-9.889
        C659.363,514.539,655.382,501.489,645.527,495.815z"/></svg><?php echo esc_html_e('Air Conditioning', 'autoroyal'); ?>
                                    </span>
                                <?php } ?>

                            </div>

                            <h4 class="autoroyal-vehicle-block-meta-price">
                                <span class="rent-price"><?php esc_html_e('From', 'autoroyal'); ?> <b><span><?php echo autoroyal_clean_price($vehicle_rent_price_min); ?></span></b> <?php esc_html_e('per day', 'autoroyal'); ?></span>
                            </h4>

                            <a href="#" class="autoroyal-reserve-vehicle autoroyal-button button-icon-right autoroyal-button-align-center" data-toggle="modal" data-target="#reservation-modal" data-car-id="<?php echo esc_attr($car_ID); ?>" data-car-thumb="<?php echo esc_url($foto_large); ?>"><?php esc_html_e('Reserve Now', 'autoroyal'); ?> <i class="fa fa-angle-right"></i></a>

                            <select id="car-pickup-list-<?php echo esc_attr($car_ID); ?>" class="hidden">
                                <?php

                                    $vehicle_rent_pickup = wp_get_post_terms( $car_ID, 'vehicle_rent_pickup', array( 'orderby' => 'name', 'order' => 'ASC') ); 

                                    if( $vehicle_rent_pickup && ! is_wp_error($vehicle_rent_pickup) ) { 

                                        foreach ($vehicle_rent_pickup as $vehicle_rent_pickup_item) {

                                            $nume_cat = $vehicle_rent_pickup_item->name;

                                ?>
                                <option value="<?php echo esc_attr($nume_cat); ?>"><?php echo esc_attr($nume_cat); ?></option>
                                <?php } } ?>
                            </select>

                            <div id="car-price-sets-<?php echo esc_attr($car_ID); ?>">

                                <?php

                                    $vehicle_rent_price_set = get_post_meta($car_ID, 'vehicle_rent_price_set',true);
                    
                                    $i = 0;

                                    if(!empty($vehicle_rent_price_set)) {

                                        foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
                                            
                                            if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

                                                $i++;

                                                ?>

                                                <input type="hidden" id="price-set-period-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['period']); ?>">
                                                <input type="hidden" id="price-set-price-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['price']); ?>">

                                                <?php

                                            }

                                        }

                                    }

                                ?>

                                <input type="hidden" class="total-sets" value="<?php echo esc_attr($i); ?>">

                            </div>

                            <ul id="rent-price-table-<?php echo esc_attr($car_ID); ?>" class="hidden">

                                <?php
                    
                                    $i = 0;

                                    if(!empty($vehicle_rent_price_set)) {

                                        foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
                                            
                                            if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

                                                $i++;

                                                ?>

                                                <li class="clearfix">
                                                    <span class="pull-left"><?php if($vehicle_rent_price_set_item['period'] == 1) { echo "24"; echo " "; echo esc_html_e('hours', 'autoroyal'); } else { echo esc_attr($vehicle_rent_price_set_item['period']); echo "+ "; echo esc_html_e('days', 'autoroyal'); } ?></span>
                                                    <span class="pull-right">
                                                        <b><?php echo autoroyal_clean_price($vehicle_rent_price_set_item['price']); ?></b>
                                                    </span>
                                                </li>

                                                <?php

                                            }

                                        }

                                    }

                                ?>

                            </ul>

                        </div>

                    </div>

                </div>

                <?php } else { ?>

                <div class="col-sm-6 col-md-4 col-lg-3">
                    <div class="thumbnail bg-white small-rent">
                        <a href="car-rent-item.html" class="rent-lnk"></a>
                        <img src="<?php if(!empty($vehicle_image_url)) { echo esc_url($vehicle_image_url); } ?>" alt="<?php echo esc_attr($vehicle_name_final); ?>">
                        <h4><?php echo esc_attr($vehicle_name_final); ?> <span><?php echo esc_attr($vehicle_year); ?></span></h4>
                        <span class="car-spec"><?php esc_html_e('Starting at', 'autoroyal'); ?> <b><?php $currency = autoroyal_get_currency(); $currency_symbol = autoroyal_get_currency_symbol( $currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } ?><?php echo esc_attr($vehicle_rent_price_max); ?></b>/<small><?php esc_html_e('day', 'autoroyal'); ?></small> </span>
                        <a href="<?php echo get_permalink( $car_ID ); ?>" class="btn btn-default"><?php esc_html_e('Details', 'autoroyal'); ?> <i class="fa fa-angle-right"></i></a>
                    </div>
                </div>

                <?php } ?>

            <?php endforeach; ?>

        <?php endif; ?>

        </div>

    </div>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_latest_vehicles_rent', 'autoroyal_latest_vehicles_rent_func' );

vc_map( array(
  	'name' => esc_html__( 'Latest Vehicles for Rent', 'autoroyal' ),
	'base' => 'autoroyal_latest_vehicles_rent',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Latest vehicles for rent', 'autoroyal' ),
	'params' => array(
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Amount number of vehicles', 'autoroyal' ),
            'param_name' => 'amount',
            'value' => "6",
        ),
        array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

