<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function tabs_func( $atts, $content = null ) {

    extract( shortcode_atts( array(
        "tabs_nav_style" => "show",
        "css" => "",
    ), $atts ) );

    global $single_tab_array;
    $single_tab_array = array(); // clear the array
   
    $tabs_nav = '';
    $tabs_content = '';
    $tabs_output = '';

    $class_to_filter = '';
    $class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
    $css_class = $class_to_filter;
 
    $tabs_nav .= '<div class="nav nav-classic nav-rounded nav-shadow nav-bordered nav-justified mx-lg-auto w-lg-85">';
   
    // execute the '[tab]' shortcode first to get the title and content - acts on global $single_tab_array
    do_shortcode($content);

    $random_id = '';
   
    //declare our vars to be super clean here
    foreach ($single_tab_array as $tab => $tab_attr_array) {

        $random_id = rand(1000,2000); // potential duplicate issue.. need to fix
     
        $default_nav = ( $tab == 0 ) ? 'active' : '';
        $default_tab = ( $tab == 0 ) ? 'show active' : '';

        $title = $tab_attr_array['title'];
        $add_icon = $tab_attr_array['add_icon'];
        $icon_type = $tab_attr_array['icon_type'];
        $icon_material = $tab_attr_array['icon_material'];
        $icon_fontawesome = $tab_attr_array['icon_fontawesome'];
        $icon_openiconic = $tab_attr_array['icon_openiconic'];
        $icon_typicons = $tab_attr_array['icon_typicons'];
        $icon_entypo = $tab_attr_array['icon_entypo'];
        $icon_linecons = $tab_attr_array['icon_linecons'];
        $icon_monosocial = $tab_attr_array['icon_monosocial'];
        $icon_bg_type = $tab_attr_array['icon_bg_type'];
        $tab_id = $tab_attr_array['tab_id'];

        if ( 'true' === $add_icon ) {
            vc_icon_element_fonts_enqueue( $icon_type );

            if ( isset( ${'icon_' . $icon_type} ) ) {
                $icon_class = ${'icon_' . $icon_type};
            } else {
                $icon_class = 'fa fa-adjust';
            }
            if( $icon_type == "material" ) {
                $icon_class = 'material-icons';
            }
        }

        $icon_wrapper = "";
        $unique_id = uniqid();
        $icon_bg_class = "autoroyal_icon_bg_class_" . $unique_id;

        if ( 'true' === $add_icon ) { 
            if( $icon_type == "material" ) { 
                $icon_wrapper = "<i class='" . wp_kses($icon_material, true) . "'></i>"; 
            } else { 
                $icon_wrapper = "<i class='" . wp_kses($icon_class, true) . "'></i>"; 
            } 
        }
      
        $tabs_nav .= '<a class="nav-item nav-link icon-bg-' . $icon_bg_type . ' ' . $default_nav . '" id="' . ( empty( $tab_id ) ? sanitize_title( $title ) : esc_attr( $tab_id ) ) . '-tab" data-toggle="tab" href="#pricing-' . ( empty( $tab_id ) ? sanitize_title( $title ) : esc_attr( $tab_id ) ) . '">' . $icon_wrapper . ' ' . esc_attr($title) . '</a>';
        $tabs_content .= '<div class="tab-pane pt-5 ' . $default_tab . '" id="pricing-' . esc_attr( $tab_id ) . '" role="tabpanel" aria-labelledby="' . esc_attr( $tab_id ) . '">'.$tab_attr_array['content'].'</div>';

      
    }

    $tabs_nav .= '</div><!-- .tab-me-tabs -->';
    
    if ($tabs_nav_style == "hide") {
        $tabs_output = '<div class="tab-content tab-style-1" id="myTabContent-' . $random_id . '">' . $tabs_content . '</div>';
    } else {
        $tabs_output = $tabs_nav . '<div class="tab-content tab-style-1" id="myTabContent-' . $random_id . '">' . $tabs_content . '</div>';
    }

    return $tabs_output;
}
add_shortcode('tabs', 'tabs_func');

vc_map( array(
    'name' => esc_html__( 'Tabs', 'autoroyal' ),
    'base' => 'tabs',
    'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
    'description' => esc_html__( 'Custom autoRoyal tab', 'autoroyal' ),
    'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
    "as_parent" => array('only' => 'tab'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
    "content_element" => true,
    //"show_settings_on_create" => false,
    "is_container" => true,
    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Show/Hide default tabs navigation', 'autoroyal' ),
            'value' => array(
                esc_html__( 'Show', 'autoroyal' ) => 'show',
                esc_html__( 'Hide', 'autoroyal' ) => 'hide',
            ),
            'param_name' => 'tabs_nav_style',
            'description' => esc_html__( 'Add navigation in a new place with custom tab navigation shortcode.', 'autoroyal' ),
            'std' => 'show',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Navigation text color', 'autoroyal' ),
            'value' => array(
                esc_html__( 'White', 'autoroyal' ) => 'white',
                esc_html__( 'Dark', 'autoroyal' ) => 'dark',
            ),
            'param_name' => 'tabs_nav_color',
            'std' => 'dark',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Centered navigation', 'autoroyal' ),
            'value' => array(
                esc_html__( 'No', 'autoroyal' ) => 'no',
                esc_html__( 'Yes', 'autoroyal' ) => 'yes',
            ),
            'param_name' => 'tabs_nav_centered',
            'description' => esc_html__( 'Center ntabs avigation.', 'autoroyal' ),
            'std' => 'no',
        ),
        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'CSS box', 'autoroyal' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design Options', 'autoroyal' ),
        ),
    ),
    "js_view" => 'VcColumnView'
));

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_tabs extends WPBakeryShortCodesContainer {
    }
}

