<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function tab_func( $atts, $content ) {
    extract(shortcode_atts(array(
        'title'  => '',
        'add_icon' => '',
        'icon_type' => 'material',
        'icon_material' => '3d_rotation',
        'icon_fontawesome' => '',
        'icon_openiconic' => '',
        'icon_typicons' => '',
        'icon_entypo' => '',
        'icon_linecons' => '',
        'icon_monosocial' => '',
        'icon_bg_type' => 'circle',
        'tab_id' => '',
    ), $atts));

    global $single_tab_array;
    $single_tab_array[] = array(
        'title' => $title, 
        'add_icon' => $add_icon,
        'icon_type' => $icon_type,
        'icon_material' => $icon_material,
        'icon_fontawesome' => $icon_fontawesome,
        'icon_openiconic' => $icon_openiconic,
        'icon_typicons' => $icon_typicons,
        'icon_entypo' => $icon_entypo,
        'icon_linecons' => $icon_linecons,
        'icon_monosocial' => $icon_monosocial,
        'icon_bg_type' => $icon_bg_type,
        'tab_id' => $tab_id, 
        'content' => trim(do_shortcode($content))
    );
    //return $single_tab_array;

}
add_shortcode('tab', 'tab_func');

$var_id = 'tab-' . uniqid();

vc_map( array(
    'name' => esc_html__( 'Tab', 'autoroyal' ),
    'base' => 'tab',
    'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
    'description' => esc_html__( 'Custom autoRoyal tab', 'autoroyal' ),
    'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
    "content_element" => true,
    "as_child" => array('only' => 'tabs'), 
    "is_container" => true,
    'params' => array(
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Title', 'autoroyal' ),
            'param_name' => 'title',
            'value' => '',
            'admin_label' => true,
            'description' => esc_html__( 'Enter title here.', 'autoroyal' ),
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__( 'Add icon?', 'autoroyal' ),
            'param_name' => 'add_icon',
            'group' => esc_html__( 'Icon', 'autoroyal' ),
            'std' => 'false',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Icon library', 'autoroyal' ),
            'value' => array(
                __( 'Material Icons', 'autoroyal' ) => 'material',
                __( 'Font Awesome', 'autoroyal' ) => 'fontawesome',
                __( 'Open Iconic', 'autoroyal' ) => 'openiconic',
                __( 'Typicons', 'autoroyal' ) => 'typicons',
                __( 'Entypo', 'autoroyal' ) => 'entypo',
                __( 'Linecons', 'autoroyal' ) => 'linecons',
                __( 'Mono Social', 'autoroyal' ) => 'monosocial',
            ),
            'param_name' => 'icon_type',
            'description' => esc_html__( 'Select icon library.', 'autoroyal' ),
            'dependency' => array(
                'element' => 'add_icon',
                'value' => 'true',
            ),
            'std' => 'material',
            'group' => esc_html__( 'Icon', 'autoroyal' ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon', 'autoroyal' ),
            'param_name' => 'icon_material',
            'value' => '3d_rotation', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'material',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'icon_type',
                'value' => 'material',
            ),
            'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
            'group' => esc_html__( 'Icon', 'autoroyal' ),
            
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon', 'autoroyal' ),
            'param_name' => 'icon_fontawesome',
            'value' => 'fa fa-info-circle',
            'settings' => array(
                'emptyIcon' => false,
                // default true, display an "EMPTY" icon?
                'iconsPerPage' => 4000,
                // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'icon_type',
                'value' => 'fontawesome',
            ),
            'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
            'std' => 'fa fa-info-circle',
            'group' => esc_html__( 'Icon', 'autoroyal' ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon', 'autoroyal' ),
            'param_name' => 'icon_openiconic',
            'settings' => array(
                'emptyIcon' => false,
                // default true, display an "EMPTY" icon?
                'type' => 'openiconic',
                'iconsPerPage' => 4000,
                // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'icon_type',
                'value' => 'openiconic',
            ),
            'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
            'group' => esc_html__( 'Icon', 'autoroyal' ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon', 'autoroyal' ),
            'param_name' => 'icon_typicons',
            'settings' => array(
                'emptyIcon' => false,
                // default true, display an "EMPTY" icon?
                'type' => 'typicons',
                'iconsPerPage' => 4000,
                // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'icon_type',
                'value' => 'typicons',
            ),
            'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
            'group' => esc_html__( 'Icon', 'autoroyal' ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon', 'autoroyal' ),
            'param_name' => 'icon_entypo',
            'settings' => array(
                'emptyIcon' => false,
                // default true, display an "EMPTY" icon?
                'type' => 'entypo',
                'iconsPerPage' => 4000,
                // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'icon_type',
                'value' => 'entypo',
            ),
            'group' => esc_html__( 'Icon', 'autoroyal' ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon', 'autoroyal' ),
            'param_name' => 'icon_linecons',
            'settings' => array(
                'emptyIcon' => false,
                // default true, display an "EMPTY" icon?
                'type' => 'linecons',
                'iconsPerPage' => 4000,
                // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'icon_type',
                'value' => 'linecons',
            ),
            'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
            'group' => esc_html__( 'Icon', 'autoroyal' ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon', 'autoroyal' ),
            'param_name' => 'icon_monosocial',
            'value' => 'vc-mono vc-mono-fivehundredpx', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'monosocial',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'icon_type',
                'value' => 'monosocial',
            ),
            'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
            'group' => esc_html__( 'Icon', 'autoroyal' ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Icon background', 'autoroyal' ),
            'value' => array(
                __( 'None', 'autoroyal' ) => 'none',
                __( 'Circle', 'autoroyal' ) => 'circle',
                __( 'Shape 1', 'autoroyal' ) => 'shape_1',
                __( 'Shape 2', 'autoroyal' ) => 'shape_2',
                __( 'Shape 3', 'autoroyal' ) => 'shape_3',
                __( 'Shape 4', 'autoroyal' ) => 'shape_4',
            ),
            'param_name' => 'icon_bg_type',
            'description' => esc_html__( 'Select icon background type.', 'autoroyal' ),
            'dependency' => array(
                'element' => 'add_icon',
                'value' => 'true',
            ),
            'std' => 'default',
            'group' => esc_html__( 'Icon', 'autoroyal' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Tab ID', 'autoroyal' ),
            'param_name' => 'tab_id',
            'value' => $var_id,
            'admin_label' => true,
            'description' => esc_html__( 'Enter tab id the same from tab navigation.', 'autoroyal' ),
        ),
    ),
    "js_view" => 'VcColumnView'
));

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_tab extends WPBakeryShortCodesContainer {
    }
}

