<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_team_func( $atts ) {

	extract( shortcode_atts( array(
		"amount" => "-1",
		"style" => "grid",
    	"css" => "",
   	), $atts ) );

	ob_start();

	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

	?>

	<div class="<?php echo esc_attr($css_class); ?>" >

		<?php if( $style == "grid" ) { ?>

		<div class="row autoroyal-team-cards">

			<?php 

		  		$wp_query_project = null;
				$wp_query_project = new WP_Query();
				$wp_query_project->query('order=ASC&post_type=team&posts_per_page='.$amount);

			?>
			<?php if ( $wp_query_project->have_posts() ) : ?>
				
				<?php while ($wp_query_project->have_posts()) : $wp_query_project->the_post(); ?>

					<div id="post-<?php the_ID(); ?>" <?php post_class('col-lg-4 col-md-6 autoroyal-animated-blk autoroyal-vehicle-grid-block autoroyal-team-block'); ?>>

                        <div class="autoroyal-vehicle-block autoroyal-block-style-2 autoroyal-blog-post">

                        	<?php if ( has_post_thumbnail() ) { $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'autoroyal-team-avatar' ); ?>
                            
                            <div class="autoroyal-vehicle-block-image-wrapper">

                                <a href="<?php the_permalink(); ?>">
                                	<img src="<?php the_post_thumbnail_url( 'autoroyal-team-avatar' ); ?>" alt="<?php the_title(); ?>"/>
                                </a>

                                <div class="autoroyal-team-social">

                                    <?php

			                            $facebook_url = get_post_meta(get_the_ID(), 'autoroyal_facebook_url',true);
			                            $twitter_url = get_post_meta(get_the_ID(), 'autoroyal_twitter_url',true);
			                            $google_plus_url = get_post_meta(get_the_ID(), 'autoroyal_google_plus_url',true);
			                            $linked_in_url = get_post_meta(get_the_ID(), 'autoroyal_linked_in_url',true);

			                            if(!empty($facebook_url) || !empty($twitter_url) || !empty($google_plus_url) || !empty($linked_in_url)){
			                                ?>
		                                    <?php
		                                    if(!empty($facebook_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($facebook_url); ?>">
		                                        	<i class="fab fa-facebook-f" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }
		                                    if(!empty($twitter_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($twitter_url); ?>" >
		                                        	<i class="fab fa-twitter" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }
		                                    if(!empty($linked_in_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($linked_in_url); ?>">
		                                        	<i class="fab fa-linkedin-in" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }

		                                    if(!empty($google_plus_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($google_plus_url); ?>">
		                                        	<i class="fab fa-google-plus-g" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }
		                                    ?>
			                            <?php
			                            }
			                        ?>                            
                                        
                                </div>

                            </div>
							
							<?php } ?>
                                
                            <div class="autoroyal-vehicle-block-meta">

                                <a class="heading" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>

                                <?php $position = get_post_meta(get_the_ID(), 'autoroyal_position',true);  if(!empty($position)) { ?>
                                <div class="entry-title"><?php echo esc_attr($position); ?></div>
                                <?php } ?>

                            </div>

                        </div>

					</div>
					<!-- /post -->
		    			        		            
		        <?php endwhile; ?>
	
			<?php endif; wp_reset_postdata(); ?>

		</div>

		<?php } elseif( $style == "carousel" ) { ?>

		<div class="owl-carousel owl-theme team-carousel">

			<?php 

		  		$wp_query_project = null;
				$wp_query_project = new WP_Query();
				$wp_query_project->query('order=ASC&post_type=team&posts_per_page=-1');

			?>
			<?php if ( $wp_query_project->have_posts() ) : ?>
				
				<?php while ($wp_query_project->have_posts()) : $wp_query_project->the_post(); ?>

					<div id="post-<?php the_ID(); ?>" <?php post_class('item autoroyal-team-holder'); ?>>

                        <div class="autoroyal-team-carousel-image">

                        	<?php if ( has_post_thumbnail() ) { $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'autoroyal-team-carousel-image' ); ?>

                                <a href="<?php the_permalink(); ?>">
                                	<img src="<?php the_post_thumbnail_url( 'autoroyal-team-carousel-image' ); ?>" alt="<?php the_title(); ?>"/>
                                </a>
							
							<?php } ?>

						</div>

						<div class="autoroyal-team-carousel-content">
                                
                            <div class="autoroyal-vehicle-block-meta">

                                <a class="heading" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>

                                <?php $position = get_post_meta(get_the_ID(), 'autoroyal_position',true);  if(!empty($position)) { ?>
                                <div class="entry-title"><?php echo esc_attr($position); ?></div>
                                <?php } ?>

                                <?php $description = get_post_meta(get_the_ID(), 'autoroyal_description',true);  if(!empty($description)) { ?>
                                <div class="description"><p><?php echo esc_attr($description); ?></p></div>
                                <?php } ?>

                                <div class="autoroyal-team-social-style-2">

                                    <?php

			                            $facebook_url = get_post_meta(get_the_ID(), 'autoroyal_facebook_url',true);
			                            $twitter_url = get_post_meta(get_the_ID(), 'autoroyal_twitter_url',true);
			                            $google_plus_url = get_post_meta(get_the_ID(), 'autoroyal_google_plus_url',true);
			                            $linked_in_url = get_post_meta(get_the_ID(), 'autoroyal_linked_in_url',true);

			                            if(!empty($facebook_url) || !empty($twitter_url) || !empty($google_plus_url) || !empty($linked_in_url)){
			                                ?>
		                                    <?php
		                                    if(!empty($facebook_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($facebook_url); ?>">
		                                        	<i class="fab fa-facebook-f" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }
		                                    if(!empty($twitter_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($twitter_url); ?>" >
		                                        	<i class="fab fa-twitter" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }
		                                    if(!empty($linked_in_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($linked_in_url); ?>">
		                                        	<i class="fab fa-linkedin-in" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }

		                                    if(!empty($google_plus_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($google_plus_url); ?>">
		                                        	<i class="fab fa-google-plus-g" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }
		                                    ?>
			                            <?php
			                            }
			                        ?>                            
                                        
                                </div>

                            </div>

                        </div>

					</div>
					<!-- /post -->
		    			        		            
		        <?php endwhile; ?>
	
			<?php endif; wp_reset_postdata(); ?>

		</div>

		<?php } ?>

	</div>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_team', 'autoroyal_team_func' );

vc_map( array(
  	'name' => esc_html__( 'Team', 'autoroyal' ),
	'base' => 'autoroyal_team',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoroyal team', 'autoroyal' ),
	'params' => array(
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'autoroyal' ),
			'description' => esc_html__( 'Block style', 'autoroyal' ),
			'param_name' => 'style',
			'value' => array(
				__( 'Grid', 'autoroyal' ) => 'grid',
				__( 'Carousel', 'autoroyal' ) => 'carousel',
			),
			'std' => 'grid',
			'admin_label' => true,
		),
        array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Team members amount', 'autoroyal' ),
			'param_name' => 'amount',
			'value' => "-1",
			'admin_label' => true,
			'description' => esc_html__( 'Amount of members to display (-1 for all).', 'autoroyal' ),
		),
        array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

