<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	$action_name = "";
	if ( isset( $_GET['action'] ) ) {
        $action_name = $_GET['action'];
    }

	$reservation_ID = "";
	if ( isset( $_GET['reservation_ID'] ) ) {
        $reservation_ID = $_GET['reservation_ID'];
    }

?>

<div id="autoroyal-inventory">

	<div class="table-toolbar">

		<div class="row">

			<div class="col-sm-12">
				
				<?php if ( autoroyal_get_permalink( 'submit_reservation_form' ) ) { ?>
				
					<a id="autoroyal_add_vehicle" href="<?php echo esc_url(autoroyal_get_permalink( 'submit_reservation_form' )); ?>" class="btn btn-default"><i class="fa fa-taxi" aria-hidden="true"></i> <?php esc_html_e( 'New reservation', 'autoroyal' ) ?></a>

				<?php } ?>

			</div>

		</div>

		<div class="row autoroyal-inventory-stats">

			<div class="col-lg-4 col-md-6 col-sm-12">

				<div class="autoroyal-inventory-stats-block">

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'New Reservations', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_get_total_new_reservations(); ?></span>

				</div>

			</div>

			<div class="col-lg-4 col-md-6 col-sm-12">

				<div class="autoroyal-inventory-stats-block">

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'In Progress Reservations', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_get_total_inprogress_reservations(); ?></span>

				</div>

			</div>

		</div>

	</div>

	<div class="table-toolbar">

		<?php 

			$reservations_url = "#";

			if ( autoroyal_get_permalink( 'reservations' ) ) { 

				$reservations_url = autoroyal_get_permalink( 'reservations' );

			} 

		?>

		<form class="autoroyal-reservations-filter" action="<?php echo esc_url($reservations_url); ?>" method="get">

			<div class="row">

				<?php

					$filter = "off";

					$keyword = "";
	        		if ( isset( $_GET['keyword'] ) AND !empty(isset( $_GET['keyword'] ) ) ) {
			            $keyword = $_GET['keyword'];
			        }

					$posts_per_page = "10";
	        		if ( isset( $_GET['posts_per_page'] ) AND !empty($_GET['posts_per_page']) ) {
			            $posts_per_page = $_GET['posts_per_page'];
			        } 

			        $start_date = "";
	        		if ( isset( $_GET['start_date'] ) AND !empty($_GET['start_date']) ) {
			            $start_date = $_GET['start_date'];
			        }

			        $end_date = "";
	        		if ( isset( $_GET['end_date'] ) AND !empty($_GET['end_date']) ) {
			            $end_date = $_GET['end_date'];
			        }

			        $orderby = "default";
	        		if ( isset( $_GET['orderby'] ) AND !empty($_GET['orderby']) ) {
			            $orderby = $_GET['orderby'];
			        }

			        //
			        if( !empty($posts_per_page) AND $posts_per_page != 10) {
			        	$filter = "on";
			        }

			        if( !empty($start_date) AND $start_date != "30daysago") {
			        	$filter = "on";
			        }

			        if( !empty($end_date) AND $end_date != "today") {
			        	$filter = "on";
			        }

			        if( !empty($orderby) AND $orderby != "default") {
			        	$filter = "on";
			        }

			        if( $start_date == "today" ) {
			        	$start_date_query = date('Y-m-d');
			        } elseif( $start_date == "yesterday" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-1 days'));
			        } elseif( $start_date == "7daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-7 days'));
			        } elseif( $start_date == "15daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-15 days'));
			        } elseif( $start_date == "30daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-30 days'));
			        } elseif( $start_date == "60daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-60 days'));
			        } elseif( $start_date == "90daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-90 days'));
			        } elseif( $start_date == "120daysago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-120 days'));
			        } elseif( $start_date == "1yearago" ) {
			        	$start_date_query = date('Y-m-d', strtotime('-1 year'));
			        }

			        if( $end_date == "today" ) {
			        	$end_date_query = date('Y-m-d');
			        } elseif( $end_date == "yesterday" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-1 days'));
			        } elseif( $end_date == "7daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-7 days'));
			        } elseif( $end_date == "15daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-15 days'));
			        } elseif( $end_date == "30daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-30 days'));
			        } elseif( $end_date == "60daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-60 days'));
			        } elseif( $end_date == "90daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-90 days'));
			        } elseif( $end_date == "120daysago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-120 days'));
			        } elseif( $end_date == "1yearago" ) {
			        	$end_date_query = date('Y-m-d', strtotime('-1 year'));
			        }

			        if( !empty($start_date_query) AND !empty($end_date_query) ) {

			        	$search_args = apply_filters( 'autoroyal_get_reservations_args', array(
							'post_type'           => 'rent',
							'post_status'         => 'publish',
							'posts_per_page'      => $posts_per_page,
							'offset'              => ( max( 1, get_query_var('paged') ) - 1 ) * $posts_per_page,
							'orderby'             => 'date',
							'order'               => 'desc',
							'author'              => get_current_user_id(),
							'date_query' => array(
								array(
									'after'     => $start_date_query,
									'before'    => $end_date_query,
									'inclusive' => true,
								),
							),
						) );

			        } else {

			        	$search_args = apply_filters( 'autoroyal_get_reservations_args', array(
							'post_type'           => 'rent',
							'post_status'         => 'publish',
							'posts_per_page'      => $posts_per_page,
							'offset'              => ( max( 1, get_query_var('paged') ) - 1 ) * $posts_per_page,
							'orderby'             => 'date',
							'order'               => 'desc',
							'author'              => get_current_user_id(),
						) );

			        }

					$search_args = apply_filters( 'autoroyal_reservations_search_parameters', $search_args );
					$reservations_query = new WP_Query;
					$reservations = $reservations_query->query( $search_args );

					$max_num_pages = $reservations_query->max_num_pages;

				?>

				<div class="col-sm-5">

					<div class="dataTables_length" id="posts_per_page">

						<?php

							$paged    = max( 1, get_query_var('paged') );
							$per_page = $posts_per_page;
							$total    = $reservations_query->found_posts;
							$first    = ( $per_page * $paged ) - $per_page + 1;
							$last     = min( $total, $posts_per_page * $paged );

							if ( $total <= $per_page || -1 == $per_page ) {
								/* translators: %d: total results */
								printf( _n( 'Showing the single reservation', 'Showing all %d reservations', $total, 'autoroyal' ), $total );
							} else {
								/* translators: 1: first result 2: last result 3: total results */
								printf( _nx( 'Showing the single reservation', 'Showing %1$d to %2$d of %3$d', $total, 'with first and last reservation', 'autoroyal' ), $first, $last, $total );
							}

						?>

					</div>

				</div>

				<div class="col-sm-7">

					<div id="sample_1_filter" class="dataTables_filter">

						<input type="hidden" id="orderby" name="orderby" value="<?php echo esc_attr($orderby); ?>" />

						<?php  if( !empty($start_date_query) AND !empty($end_date_query) ) { ?>

						<label><?php esc_html_e('Start', 'autoroyal' ); ?> 

							<select name="start_date" aria-controls="sample_2" class="input-sm input-xsmall input-inline autoroyal-reservations-select-start-date">
								<option value="today" <?php if( $start_date == 'today' ) { echo "selected"; } ?>><?php esc_html_e('Today', 'autoroyal' ); ?></option>
								<option value="yesterday" <?php if( $start_date == 'yesterday' ) { echo "selected"; } ?>><?php esc_html_e('Yesterday', 'autoroyal' ); ?></option>
								<option value="7daysago" <?php if( $start_date == '7daysago' ) { echo "selected"; } ?>><?php esc_html_e('7 Days Ago', 'autoroyal' ); ?></option>
								<option value="15daysago" <?php if( $start_date == '15daysago' ) { echo "selected"; } ?>><?php esc_html_e('15 Days Ago', 'autoroyal' ); ?></option>
								<option value="30daysago" <?php if( $start_date == '30daysago' ) { echo "selected"; } ?>><?php esc_html_e('30 Days Ago', 'autoroyal' ); ?></option>
								<option value="60daysago" <?php if( $start_date == '60daysago' ) { echo "selected"; } ?>><?php esc_html_e('60 Days Ago', 'autoroyal' ); ?></option>
								<option value="90daysago" <?php if( $start_date == '90daysago' ) { echo "selected"; } ?>><?php esc_html_e('90 Days Ago', 'autoroyal' ); ?></option>
								<option value="120daysago" <?php if( $start_date == '120daysago' ) { echo "selected"; } ?>><?php esc_html_e('120 Days Ago', 'autoroyal' ); ?></option>
								<option value="1yearago" <?php if( $start_date == '1yearago' ) { echo "selected"; } ?>><?php esc_html_e('1 Year Ago', 'autoroyal' ); ?></option>
							</select>

						</label>

						<label><?php esc_html_e('End', 'autoroyal' ); ?> 

							<select name="end_date" aria-controls="sample_2" class="input-sm input-xsmall input-inline autoroyal-reservations-select-end-date">
								<option value="today" <?php if( $end_date == 'today' ) { echo "selected"; } ?>><?php esc_html_e('Today', 'autoroyal' ); ?></option>
								<option value="yesterday" <?php if( $end_date == 'yesterday' ) { echo "selected"; } ?>><?php esc_html_e('Yesterday', 'autoroyal' ); ?></option>
								<option value="7daysago" <?php if( $end_date == '7daysago' ) { echo "selected"; } ?>><?php esc_html_e('7 Days Ago', 'autoroyal' ); ?></option>
								<option value="15daysago" <?php if( $end_date == '15daysago' ) { echo "selected"; } ?>><?php esc_html_e('15 Days Ago', 'autoroyal' ); ?></option>
								<option value="30daysago" <?php if( $end_date == '30daysago' ) { echo "selected"; } ?>><?php esc_html_e('30 Days Ago', 'autoroyal' ); ?></option>
								<option value="60daysago" <?php if( $end_date == '60daysago' ) { echo "selected"; } ?>><?php esc_html_e('60 Days Ago', 'autoroyal' ); ?></option>
								<option value="90daysago" <?php if( $end_date == '90daysago' ) { echo "selected"; } ?>><?php esc_html_e('90 Days Ago', 'autoroyal' ); ?></option>
								<option value="120daysago" <?php if( $end_date == '120daysago' ) { echo "selected"; } ?>><?php esc_html_e('120 Days Ago', 'autoroyal' ); ?></option>
								<option value="1yearago" <?php if( $end_date == '1yearago' ) { echo "selected"; } ?>><?php esc_html_e('1 Year Ago', 'autoroyal' ); ?></option>
							</select>

						</label>

						<?php } ?>

						<label><?php esc_html_e('Show', 'autoroyal' ); ?> 

							<select name="posts_per_page" aria-controls="sample_1" class="input-sm input-xsmall input-inline autoroyal-reservations-select-ppp">
								<option value="10" <?php if( $posts_per_page == '10' ) { echo "selected"; } ?>>10</option>
								<option value="25" <?php if( $posts_per_page == '25' ) { echo "selected"; } ?>>25</option>
								<option value="50" <?php if( $posts_per_page == '50' ) { echo "selected"; } ?>>50</option>
								<option value="-1" <?php if( $posts_per_page == '-1' ) { echo "selected"; } ?>>All</option>
							</select>

						</label>
						
						<?php if($filter == "on") { ?>
							<?php if ( autoroyal_get_permalink( 'reservations' ) ) { ?>
							<a href="<?php echo esc_url(autoroyal_get_permalink( 'reservations' )); ?>" id="clear-reservations-filter"><i class="fa fa-times" aria-hidden="true"></i></a>
							<?php } ?>
						<?php } ?>

						<div id="refresh-reservations-filter">
							<i class="fa fa-refresh" aria-hidden="true"></i> <?php esc_html_e('Refresh', 'autoroyal' ); ?>
						</div>

					</div>

				</div>

			</div>

		</form>

	</div>

	<table id="autoroyal_reservations_table" class="car-manager-cars table-hover" data-edit-url="<?php if ( ! autoroyal_get_permalink( 'submit_reservation_form' ) ) { echo "no-page"; } else { echo esc_url(autoroyal_get_permalink( 'submit_reservation_form' )); } ?>">
		<thead>
			<tr>
				<th class="d-none d-lg-table-cell reservation-sorting-date <?php if($orderby == "date_asc"){ echo "sorting_asc"; } elseif($orderby == "date_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Date', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell reservation-sorting-status <?php if($orderby == "status_asc"){ echo "sorting_asc"; } elseif($orderby == "status_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Status', 'autoroyal' ); ?></th>
				<th class="d-md-table-cell d-lg-none reservation-sorting-name <?php if($orderby == "name_asc"){ echo "sorting_asc"; } elseif($orderby == "name_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Reservation', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell reservation-sorting-pickuplocation <?php if($orderby == "pickuplocation_asc"){ echo "sorting_asc"; } elseif($orderby == "pickuplocation_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Pickup Location', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell reservation-sorting-pickupdate <?php if($orderby == "pickupdate_asc"){ echo "sorting_asc"; } elseif($orderby == "pickupdate_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Pickup Date', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell reservation-sorting-pickuptime <?php if($orderby == "pickuptime_asc"){ echo "sorting_asc"; } elseif($orderby == "pickuptime_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Pickup Time', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell reservation-sorting-returnlocation <?php if($orderby == "returnlocation_asc"){ echo "sorting_asc"; } elseif($orderby == "returnlocation_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Return Location', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell reservation-sorting-returndate <?php if($orderby == "returndate_asc"){ echo "sorting_asc"; } elseif($orderby == "returndate_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Return date', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell reservation-sorting-returntime <?php if($orderby == "returntime_asc"){ echo "sorting_asc"; } elseif($orderby == "returntime_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Return Time', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell reservation-sorting-days <?php if($orderby == "days_asc"){ echo "sorting_asc"; } elseif($orderby == "days_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Days', 'autoroyal' ); ?></th>
				<th class="d-none d-lg-table-cell reservation-sorting-price <?php if($orderby == "price_asc"){ echo "sorting_asc"; } elseif($orderby == "price_desc") { echo "sorting_desc"; } else { echo "sorting"; } ?>"><?php esc_html_e( 'Cost', 'autoroyal' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php 

				if ( ! $reservations ) : 

			?>
				<tr>
					<td colspan="9"><?php esc_html_e( 'You do not have any reservations.', 'autoroyal' ); ?></td>
				</tr>
			<?php else : ?>
				<?php foreach ( $reservations as $reservation ) : ?>

					<?php 

						$reservation_ID = $reservation->ID;
						$rent_status = esc_attr(get_post_meta($reservation_ID, 'rent_status',true));

						$pickup_location = esc_attr(get_post_meta($reservation_ID, 'pickup_location',true));
						$pickup_date = esc_attr(get_post_meta($reservation_ID, 'pickup_date',true));
						$pickup_time = esc_attr(get_post_meta($reservation_ID, 'pickup_time',true));

						$return_location = esc_attr(get_post_meta($reservation_ID, 'return_location',true));
						$return_date = esc_attr(get_post_meta($reservation_ID, 'return_date',true));
						$return_time = esc_attr(get_post_meta($reservation_ID, 'return_time',true));

						$rent_vehicle_id = esc_attr(get_post_meta($reservation_ID, 'rent_vehicle_id',true));

						$extra_options = get_post_meta($reservation_ID, 'extra_options',true);

						$number_of_days = get_post_meta($reservation_ID, 'number_of_days',true);
						if(empty($number_of_days)) { $number_of_days = 1; }

						$price_per_day = get_post_meta($reservation_ID, 'price_per_day',true);
						if(empty($price_per_day)) { $price_per_day = 0; }

						$total_price = get_post_meta($reservation_ID, 'total_price',true);
						if(empty($total_price)) { $total_price = 0; }

						$reserv_car_days = get_post_meta($reservation_ID, 'reserv_car_days',true);

						$rent_first_name = esc_attr(get_post_meta($reservation_ID, 'rent_first_name',true));
						$rent_middle_name = esc_attr(get_post_meta($reservation_ID, 'rent_middle_name',true));
						$rent_last_name = esc_attr(get_post_meta($reservation_ID, 'rent_last_name',true));

						$rent_home_phone = esc_attr(get_post_meta($reservation_ID, 'rent_home_phone',true));
						$rent_mobile_phone = esc_attr(get_post_meta($reservation_ID, 'rent_mobile_phone',true));
						$rent_work_phone = esc_attr(get_post_meta($reservation_ID, 'rent_work_phone',true));

						$reserv_car_days = esc_attr(get_post_meta($reservation_ID, 'reserv_car_days',true));

						$autoroyal_currency = get_option( 'autoroyal_currency' ); 
				    	$currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency );

					?>

					<tr class="listing-item" data-id="<?php echo esc_attr($reservation_ID); ?>">

						<td class="d-none d-lg-table-cell autoroyal-date">
							<?php echo get_the_date( get_option('date_format'), $reservation_ID ); ?>
						</td>

						<td class="d-none d-lg-table-cell autoroyal-status">
							<?php if(!empty($rent_status)) { echo esc_attr($rent_status); } ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php if(!empty($pickup_location)) { echo esc_attr($pickup_location); } ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php if(!empty($pickup_date)) { echo esc_attr($pickup_date); } ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php if(!empty($pickup_time)) { echo esc_attr($pickup_time); } ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php if(!empty($return_location)) { echo esc_attr($return_location); } ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php if(!empty($return_date)) { echo esc_attr($return_date); } ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php if(!empty($return_time)) { echo esc_attr($return_time); } ?>
						</td>

						<td class="d-none d-lg-table-cell autoroyal-days">
							<?php if(!empty($reserv_car_days)) { echo esc_attr($reserv_car_days); } ?> <?php esc_html_e( 'Days', 'autoroyal' ); ?>
						</td>

						<td class="d-none d-lg-table-cell">
							<?php if(!empty($autoroyal_currency)) { echo esc_attr($currency_symbol); } ?><?php if(!empty($total_price)) { echo esc_attr($total_price); } ?>
						</td>

						<td class="d-md-table-cell d-lg-none autoroyal-reservation">
							<strong><?php echo esc_attr($rent_first_name); ?> <?php echo esc_attr($rent_last_name); ?></strong>
							<br><strong><?php esc_html_e( 'Status', 'autoroyal' ); ?></strong>: <?php if(!empty($rent_status)) { echo esc_attr($rent_status); } ?>
							<br><strong><?php esc_html_e( 'Pickup Location', 'autoroyal' ); ?></strong>: <?php if(!empty($pickup_location)) { echo esc_attr($pickup_location); } ?>
							<br><strong><?php esc_html_e( 'Pickup Date', 'autoroyal' ); ?></strong>: <?php if(!empty($pickup_date)) { echo esc_attr($pickup_date); } ?>
							<br><strong><?php esc_html_e( 'Pickup Time', 'autoroyal' ); ?></strong>: <?php if(!empty($pickup_time)) { echo esc_attr($pickup_time); } ?>
							<br><strong><?php esc_html_e( 'Return Location', 'autoroyal' ); ?></strong>: <?php if(!empty($return_location)) { echo esc_attr($return_location); } ?>
							<br><strong><?php esc_html_e( 'Return Date', 'autoroyal' ); ?></strong>: <?php if(!empty($return_date)) { echo esc_attr($return_date); } ?>
							<br><strong><?php esc_html_e( 'Return Time', 'autoroyal' ); ?></strong>: <?php if(!empty($return_time)) { echo esc_attr($return_time); } ?>
							<br><strong><?php esc_html_e( 'Days', 'autoroyal' ); ?></strong>: <?php if(!empty($reserv_car_days)) { echo esc_attr($reserv_car_days); } ?> <?php esc_html_e( 'Days', 'autoroyal' ); ?>
							<br><strong><?php esc_html_e( 'Total Price', 'autoroyal' ); ?></strong>: <?php if(!empty($autoroyal_currency)) { echo esc_attr($currency_symbol); } ?><?php if(!empty($total_price)) { echo esc_attr($total_price); } ?>
						</td>

					</tr>

				<?php endforeach; ?>
			<?php endif; ?>
		</tbody>
	</table>
	<?php get_autoroyal_template( 'pagination.php', array( 'max_num_pages' => $max_num_pages ) ); ?>
</div>
