<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Template Core Functions
 *
 * Template Core Functions specifically created for car listings
 *
 * @author 		Alex Gurghis
 * @category 	Core
 * @package 	autoroyal/Core Functions
 * @version     1.0.2
 */

/**
 * Get and include template files.
 *
 * @param mixed $template_name
 * @param array $args (default: array())
 * @param string $template_path (default: '')
 * @param string $default_path (default: '')
 * @return void
 */

// Core Functions

//Allow Dealers to Add Media
add_action('admin_init', 'autoroyal_allow_dealer_uploads');
 
function autoroyal_allow_dealer_uploads() {
    $dealer = get_role('dealer');
  	// author caps
  	$dealer->add_cap('edit_published_posts');
  	$dealer->add_cap('delete_posts');
  	$dealer->add_cap('edit_posts');
  	$dealer->add_cap('upload_files');
  	// editor caps
  	$dealer->add_cap('edit_others_posts');
  	$dealer->add_cap('edit_published_pages');
}

if ( !function_exists( 'cd_meta_box_add' ) ) {

	add_action( 'add_meta_boxes', 'cd_meta_box_add' );

	function cd_meta_box_add() {
		add_meta_box( 'page_metabox', 'Page Settings', 'td_page_metabox', 'page', 'normal', 'high' );
	}

}

if ( !function_exists( 'td_page_metabox' ) ) {

	function td_page_metabox( $post ) {

		$values = get_post_custom( $post->ID );
		
		$menu_type = isset( $values['menu_type'] ) ? esc_attr( $values['menu_type'][0] ) : '';
		$page_title = isset( $values['page_title'] ) ? esc_attr( $values['page_title'][0] ) : '';
		
		wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );

	?>
		
		<div style="padding:20px 0;">
			
			<div id="page-title-option" style="display: inline-block; margin-bottom: 40px; width: 100%;">
		
				<label style="float: left; width: 260px;" for="menu-type"><strong><?php esc_html_e( 'Menu type', 'autoroyal' ) ?></strong></label>
				
				<div style="margin-left: 30px; float: left; width: 460px;">
					<select name="menu-type" id="menu-type" style="width: 460px;">
						<option value="dark" <?php selected( $menu_type, 'dark' ); ?>><?php esc_html_e( 'Dark', 'autoroyal' ) ?></option>
						<option value="white" <?php selected( $menu_type, 'white' ); ?>><?php esc_html_e( 'White ( with transparent bg )', 'autoroyal' ) ?></option>
					</select>
				</div>
				
			</div>
		
		</div>

		<div style="padding:20px 0;">
			
			<div id="page-title-option" style="display: inline-block; margin-bottom: 40px; width: 100%;">
		
				<label style="float: left; width: 260px;" for="page-title-block"><strong><?php esc_html_e( 'Page title block', 'autoroyal' ) ?></strong></label>
				
				<div style="margin-left: 30px; float: left; width: 460px;">
					<select name="page-title-block" id="page-title-block" style="width: 460px;">
						<option value="1" <?php selected( $page_title, '1' ); ?>><?php esc_html_e( 'Show', 'autoroyal' ) ?></option>
						<option value="2" <?php selected( $page_title, '2' ); ?>><?php esc_html_e( 'Hide', 'autoroyal' ) ?></option>
					</select>
				</div>
				
			</div>
		
		</div>
		
		<?php	
	}

}

if ( !function_exists( 'cd_meta_box_save' ) ) {

	add_action( 'save_post', 'cd_meta_box_save' );

	function cd_meta_box_save( $post_id ) {
		// Bail if we're doing an auto save
		if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
		
		// if our nonce isn't there, or we can't verify it, bail
		if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
		
		// if our current user can't edit this post, bail
		if( !current_user_can( 'edit_post', $post_id ) ) return;
		
		// now we can actually save the data
		$allowed = array( 
			'a' => array( // on allow a tags
				'href' => array() // and those anchords can only have href attribute
			)
		);
		
		// Probably a good idea to make sure your data is set
		if( isset( $_POST['page-title-block'] ) )
			update_post_meta( $post_id, 'page_title', wp_kses( $_POST['page-title-block'], $allowed ) );

		// Probably a good idea to make sure your data is set
		if( isset( $_POST['menu-type'] ) )
			update_post_meta( $post_id, 'menu_type', wp_kses( $_POST['menu-type'], $allowed ) );

	}

}

/*
|--------------------------------------------------------------------------
| Contact Dealer Form
|--------------------------------------------------------------------------
*/
function contactCarDealerForm() {

	ob_start();

	$response['status'] = '';
	$response['email'] = '';

	$userName    = sanitize_text_field( $_POST['userName'] );
	$userMail    = sanitize_text_field( $_POST['userMail'] );
	$userPhone   = sanitize_text_field( $_POST['userPhone'] );
	$textMessage = wp_kses( $_POST['textMessage'], true );
	$car_name    = sanitize_text_field( $_POST['car_name'] );
	$car_url     = esc_url( $_POST['car_url'] );
	$site_name = get_bloginfo('name');
	$email    = sanitize_text_field( $_POST['dealer_email'] );

	$response['email'] = $email;

	if (strtoupper(substr(PHP_OS,0,3)=='WIN')) {
		$eol="\r\n";
	} elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) {
		$eol="\r";
	} else {
		$eol="\n";
	}

	// Message for card dealer
	$from = $userMail;
  	$subject = __('Contact Form from ', 'autoroyal').$site_name;
  	$headers = "From: " . $userMail . $eol;
	$headers .= "Reply-To: " . $userMail . $eol;
	$headers .= "MIME-Version: 1.0".$eol;
	$headers .= "Content-Type: text/html; charset=ISO-8859-1".$eol;
  	$msg = $textMessage . "\n\nVehicle url: $car_url";

  	if ( defined( 'autoroyal_USE_WPMAIL' ) ) {
		$response['status'] = wp_mail( $email, $subject, $msg, $headers );
	} else {
		$response['status'] = mail( $email, $subject, $msg, $headers );
	}

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_contactCarDealerForm', 'contactCarDealerForm' );
add_action( 'wp_ajax_nopriv_contactCarDealerForm', 'contactCarDealerForm' );

/*
|--------------------------------------------------------------------------
| Login Form
|--------------------------------------------------------------------------
*/
function autoroyal_ajax_login() {

	ob_start();

	$MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

	// My Listings
    global $my_listings_page;
    if(strlen($MODS['my_listings_page'])>0) {
        $my_listings_page = $MODS['my_listings_page'];
    }

	$response['status'] = '';
	$response['error_user'] = '';
	$response['error_password'] = '';
	$response['error_default'] = '';
	$response['html'] = '';
	//$response['redirect'] = get_permalink( $my_listings_page );
	$response['redirect'] = '';

	$username = sanitize_text_field($_POST['autoroyal_user_login']);
	$password = $_POST['autoroyal_user_pass'];

	if ( !username_exists( $username ) ) {

		$response['status'] = 'error';
		$response['error_user'] = '<span class="error-title">Error:</span> Invalid username.';

	}

	$user = get_user_by( 'login', $username );

	if ( $user ) {

		if ( wp_check_password( $password, $user->data->user_pass, $user->ID) ) {

		} else {

			$response['status'] = "error";
		  	$response['error_password'] = '<span class="error-title">Error:</span> Incorrect password.';

		}

	}

	$login_data = array();
	$login_data['user_login'] = $username;
	$login_data['user_password'] = $password;
	$user = wp_signon( $login_data, false );

	if ( ! is_wp_error( $user ) ) {

		$response['status'] = 'success';

		$td_user_id = $user->ID;

		$dealer_name = get_user_meta( $td_user_id, 'dealer_name', true );

		if( empty($dealer_name)) {

			$dealer_name = $user->user_nicename;

		}
        

		?>

		<div class="options_group"><h2 class="options_group_heading"><?php echo esc_attr($dealer_name); ?></h2><p><a class="" href="<?php get_author_posts_url($td_user_id); ?>"><?php echo esc_html_e( 'View my Public Profile', 'autoroyal' ); ?></a><span class="pull-right"><a id="autoroyal-ajax-logout" href="<?php wp_logout_url( home_url() ); ?>"><?php echo esc_html_e( 'Log out', 'autoroyal' ); ?></a> <?php echo esc_html_e( 'to choose a different account', 'autoroyal' ); ?></span></p></div>

		<div class="row">

			<div class="col-md-12 autoroyal-checkbox-field">

				<div class="custom-checkbox pull-left">
                  	<label>
                    	<input type="checkbox" id="vehicle_submit_agree" name="vehicle_submit_agree">
                    	<span class="cr"><i class="cr-icon fa fa-check"></i></span>
                    	<?php esc_html_e('I agree with the ', 'autoroyal' ); ?> <a href="#"><?php esc_html_e('Terms & Conditions', 'autoroyal' ); ?></a> <?php esc_html_e('of this website.', 'autoroyal' ); ?>
                  	</label>
                </div>

			</div>

		</div>

		<?php

	}

	$response['html'] = ob_get_clean();

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_ajax_login', 'autoroyal_ajax_login' );
add_action( 'wp_ajax_nopriv_autoroyal_ajax_login', 'autoroyal_ajax_login' );

/*
|--------------------------------------------------------------------------
| Register Form
|--------------------------------------------------------------------------
*/
function autoroyal_register() {

	$MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

	// My Listings
    global $my_listings_page;
    if(strlen($MODS['my_listings_page'])>0) {
        $my_listings_page = $MODS['my_listings_page'];
    }

	$response['status'] = '';
	$response['error_user'] = '';
	$response['error_email'] = '';
	$response['error_default'] = '';
	$response['html'] = '';
	$response['redirect'] = get_permalink( $my_listings_page );

  	$username = sanitize_text_field($_POST['autoroyal_user_login']);
  	$email = sanitize_email($_POST['autoroyal_user_email']);
  	$password = $_POST['autoroyal_user_pass'];


  	if ( username_exists($username) ) {

	  	$response['status'] = 'error';
		$response['error_user'] = '<span class="error-title">Error:</span> Username exists. Please try another one.';

  	} 

  	if( email_exists( $email )) {

	  	$response['status'] = 'error';
		$response['error_email'] = '<span class="error-title">Error:</span> Email exists. Please try another one.';

  	} 

  	$user_ID = wp_create_user( $username, $password, $email );

  	$login_data = array();
  	$login_data['user_login'] = $username;
  	$login_data['user_password'] = $password;
  	$user = wp_signon( $login_data, false );

  	if ( ! is_wp_error( $user ) ) {

		$response['status'] = 'success';

		$from = get_option('admin_email');
	  	$headers = 'From: '.$from . "\r\n";
	  	$subject = "Registration successful";
	  	$msg = "Registration successful.\nYour login details\nUsername: $username\nPassword: $password";
	  	wp_mail( $email, $subject, $msg, $headers );

	  	ob_start();

		$td_user_id = $user->ID;

		$dealer_name = get_user_meta( $td_user_id, 'dealer_name', true );

		if( empty($dealer_name)) {

			$dealer_name = $user->user_nicename;

		}
        

		?>

		<div class="options_group"><h2 class="options_group_heading"><?php echo esc_attr($dealer_name); ?></h2><p><a class="" href="<?php get_author_posts_url($td_user_id); ?>"><?php echo esc_html_e( 'View my Public Profile', 'autoroyal' ); ?></a><span class="pull-right"><a id="autoroyal-ajax-logout" href="<?php wp_logout_url( home_url() ); ?>"><?php echo esc_html_e( 'Log out', 'autoroyal' ); ?></a> <?php echo esc_html_e( 'to choose a different account', 'autoroyal' ); ?></span></p></div>

		<div class="row">

			<div class="col-md-12">

				<div class="custom-checkbox pull-left">
                  	<label>
                    	<input type="checkbox" id="vehicle_submit_agree" name="vehicle_submit_agree">
                    	<span class="cr"><i class="cr-icon fa fa-check"></i></span>
                    	<?php esc_html_e('I agree with the ', 'autoroyal' ); ?> <a href="#"><?php esc_html_e('Terms & Conditions', 'autoroyal' ); ?></a> <?php esc_html_e('of this website.', 'autoroyal' ); ?>
                  	</label>
                </div>

			</div>

		</div>

		<?php

		$response['html'] = ob_get_clean();

	}

  	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_register', 'autoroyal_register' );
add_action( 'wp_ajax_nopriv_autoroyal_register', 'autoroyal_register' );



/*
|--------------------------------------------------------------------------
| Reset Password
|--------------------------------------------------------------------------
*/
function autoroyal_reset_password() {

	$response['status'] = '';
	$response['error_user'] = '';
	$response['error_default'] = '';
	$response['success'] = '';

  	$email = sanitize_email($_POST['user_login']);
  
  	$user = get_user_by( 'email', $email );
  	$user_ID = $user->ID;

  	if( !empty($user_ID)) {

		$new_password = wp_generate_password( 12, false ); 

		if ( isset($new_password) ) {

	  		wp_set_password( $new_password, $user_ID );

	  		$from = get_option('admin_email');
	  		$headers = 'From: '.$from . "\r\n";
	  		$subject = "Password reset!";
	  		$msg = "Reset password.\nYour login details\nNew Password: $new_password";
	  		wp_mail( $email, $subject, $msg, $headers );

	  		$response['status'] = 'success';
	  		$response['success'] = '<span class="error-title">Success:</span> Check your email for new password.';

		}

  	} else {

		$response['status'] = 'error';
		$response['error_user'] = '<span class="error-title">Error:</span> There is no user available for this email.';

  	}

  	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_reset_password', 'autoroyal_reset_password' );
add_action( 'wp_ajax_nopriv_autoroyal_reset_password', 'autoroyal_reset_password' );

/*
|--------------------------------------------------------------------------
| Check Availability
|--------------------------------------------------------------------------
*/
function autoroyal_ajax_place_reservation() {

	ob_start();

	$response['html'] = '';

	$pickup_location  = sanitize_text_field( $_POST['rezerve-pickup-place'] );
	$dropoff_location = sanitize_text_field( $_POST['rezerve-dropoff-place'] );

	$pickup_date      = sanitize_text_field( $_POST['rezerve-pickup-date'] );
	$pickup_time      = sanitize_text_field( $_POST['rezerve-pickup-time'] );

	$dropoff_date     = sanitize_text_field( $_POST['rezerve-dropoff-date'] );
	$dropoff_time     = sanitize_text_field( $_POST['rezerve-dropoff-time'] );

	$days             = sanitize_text_field( $_POST['reserv-car-days'] );
	$day_price        = sanitize_text_field( $_POST['reserv-car-price-day'] );
	$price_total      = sanitize_text_field( $_POST['reserv-car-price-total'] );
	$extras_price     = sanitize_text_field( $_POST['reserv-car-price-extras'] );

	$userName         = sanitize_text_field( $_POST['reserve-name'] );
	$userMail         = sanitize_text_field( $_POST['reserve-email'] );
	$userPhone        = sanitize_text_field( $_POST['reserve-phone'] );
	$userAge          = sanitize_text_field( $_POST['reserve-age'] );
	$textMessage      = wp_kses( $_POST['rent-notes'], true );

	$car_id           = sanitize_text_field( $_POST['reserv-car-id'] );
	$car_name         = get_the_title( $car_id );;
	$car_url          = get_the_permalink( $car_id );
	$site_name        = get_bloginfo('name');

	if (strtoupper(substr(PHP_OS,0,3)=='WIN')) {
		$eol="\r\n";
	} elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) {
		$eol="\r";
	} else {
		$eol="\n";
	}

	$currency = autoroyal_get_currency(); 
	$currency_symbol = autoroyal_get_currency_symbol( $currency );

	// Message for rental owner
	$email = get_option('admin_email');
  	$subject = "[" . $site_name . " - " . __('New Reservation] Rent Car Reservation', 'autoroyal'). " - " .$car_name;
  	$headers = "From: " . $userMail . $eol;
	$headers .= "Reply-To: " . $userMail . $eol;
	$headers .= "MIME-Version: 1.0".$eol;
	$headers .= "Content-Type: text/html; charset=UTF-8".$eol;
  	$msg = '
	<table width="100%" border="0">
		<tr>
			<td colspan="2" style="font-size: 20px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Car rent reservation', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Rent details', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td style="min-width: 100px;">'.__('Pickup date', 'autoroyal').'</td>
			<td>'.$pickup_date.' : '.$pickup_time.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Pickup location', 'autoroyal').'</td>
			<td>'.$pickup_location.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td>'.__('Return date', 'autoroyal').'</td>
			<td>'.$dropoff_date.' : '.$dropoff_time.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Return location', 'autoroyal').'</td>
			<td>'.$dropoff_location.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td>'.__('Days', 'autoroyal').'</td>
			<td>'.$days.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Price per day', 'autoroyal').'</td>
			<td>'.$currency_symbol.''.$day_price.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Extras', 'autoroyal').'</td>
			<td>'.$currency_symbol.''.$extras_price.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Total Price', 'autoroyal').'</td>
			<td>'.$currency_symbol.''.$price_total.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td>'.__('Name', 'autoroyal').'</td>
			<td>'.$userName.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Age', 'autoroyal').'</td>
			<td>'.$userAge.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Phone', 'autoroyal').'</td>
			<td>'.$userPhone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Email', 'autoroyal').'</td>
			<td>'.$userMail.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Car', 'autoroyal').'</td>
			<td>'.$car_name.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Car Link', 'autoroyal').'</td>
			<td>'.$car_url.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Questions and Comments', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2">'.wp_kses($textMessage, true).'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	</table>
	';

  	wp_mail( $email, $subject, $msg, $headers );

  	// Confirmation email
	$email = get_option('admin_email');
  	$subject = "[" . $site_name . "] " . __('Reservation Car Confirmation ', 'autoroyal');
  	$headers = "From: " . $email . $eol;
	$headers .= "Reply-To: " . $email . $eol;
	$headers .= "MIME-Version: 1.0".$eol;
	$headers .= "Content-Type: text/html; charset=ISO-8859-1".$eol;
  	$msg = '
	<table width="100%" border="0">
		<tr>
			<td colspan="2" style="font-size: 20px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Car rent reservation', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Rent details', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td style="min-width: 100px;">'.__('Pickup date', 'autoroyal').'</td>
			<td>'.$pickup_date.' : '.$pickup_time.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Pickup location', 'autoroyal').'</td>
			<td>'.$pickup_location.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td>'.__('Return date', 'autoroyal').'</td>
			<td>'.$dropoff_date.' : '.$dropoff_time.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Return location', 'autoroyal').'</td>
			<td>'.$dropoff_location.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td>'.__('Days', 'autoroyal').'</td>
			<td>'.$days.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Price per day', 'autoroyal').'</td>
			<td>'.$currency_symbol.''.$day_price.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Extras', 'autoroyal').'</td>
			<td>'.$currency_symbol.''.$extras_price.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Total Price', 'autoroyal').'</td>
			<td>'.$currency_symbol.''.$price_total.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td>'.__('Car', 'autoroyal').'</td>
			<td>'.$car_name.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Car Link', 'autoroyal').'</td>
			<td>'.$car_url.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Questions and Comments', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2">'.wp_kses($textMessage, true).'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	</table>
	';

  	wp_mail( $userMail, $subject, $msg, $headers );

  	$autoroyal_currency = get_option( 'autoroyal_currency' ); 
	$currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency );

  	$postNewTitle = "New - ";

	if(!empty($pickup_location)) {
		$postNewTitle .= $pickup_location . " ";
	}

	if(!empty($pickup_date)) {
		$postNewTitle .= $pickup_date . " ";
	}

	if(!empty($pickup_time)) {
		$postNewTitle .= $pickup_time . " - ";
	}

	if(!empty($days)) {
		$postNewTitle .= $days . " Days ";
	}

	if(!empty($price_total)) {
		$postNewTitle .= $currency_symbol . "" . $price_total . " - ";
	}

	if(!empty($userName)) {
		$postNewTitle .= $userName . " - ";
	}

	if(!empty($car_name)) {
		$postNewTitle .= $car_name;
	}

  	// Create Reserve post
  	$my_post = array(
		'post_author'   => '1',
	  	'post_name'     => sanitize_title( $postNewTitle ),
	  	'post_title'    => $postNewTitle,
	  	'post_type'     => 'rent',
	  	'post_status'   => 'publish',
	);
	 
	// Insert the post into the database
	$td_post_id = wp_insert_post( $my_post );

	// Rent Details
	update_post_meta($td_post_id, 'rent_status', "New");

	update_post_meta($td_post_id, 'pickup_location', sanitize_text_field($_POST['rezerve-pickup-place']));
	update_post_meta($td_post_id, 'pickup_date', sanitize_text_field($_POST['rezerve-pickup-date']));
	update_post_meta($td_post_id, 'pickup_time', sanitize_text_field($_POST['rezerve-pickup-time']));

	update_post_meta($td_post_id, 'return_location', sanitize_text_field($_POST['rezerve-dropoff-place']));
	update_post_meta($td_post_id, 'return_date', sanitize_text_field($_POST['rezerve-dropoff-date']));
	update_post_meta($td_post_id, 'return_time', sanitize_text_field($_POST['rezerve-dropoff-time']));

	update_post_meta($td_post_id, 'rent_vehicle_id', sanitize_text_field($_POST['reserv-car-id']));

	update_post_meta($td_post_id, 'number_of_days', sanitize_text_field($_POST['reserv-car-days']));
	update_post_meta($td_post_id, 'price_per_day', sanitize_text_field($_POST['reserv-car-price-day']));
	update_post_meta($td_post_id, 'total_price', sanitize_text_field($_POST['reserv-car-price-total']));
	update_post_meta($td_post_id, 'reserv_car_days', sanitize_text_field($_POST['reserv-car-days']));

	update_post_meta($td_post_id, 'extra_options', $_POST['extra_options']);

	// Rent Customer Info
	update_post_meta($td_post_id, 'rent_first_name', sanitize_text_field($_POST['reserve-name']));
	update_post_meta($td_post_id, 'rent_mobile_phone', sanitize_text_field($_POST['reserve-phone']));
	update_post_meta($td_post_id, 'rent_email', sanitize_text_field($_POST['reserve-email']));
	update_post_meta($td_post_id, 'rent_age', sanitize_text_field($_POST['reserve-age']));
	update_post_meta($td_post_id, 'rent-notes', sanitize_text_field($_POST['rent-notes']));

	$lead_exist = autoroyal_check_if_leads( $_POST['reserve-email'] );

	if( $lead_exist == 0 ) {

		$postNewTitle = sanitize_text_field($_POST['reserve-name']);

		$my_post = array(
		  	'post_name'     => sanitize_title( $postNewTitle ),
		  	'post_title'    => $postNewTitle,
		  	'post_type'     => 'lead',
		  	'post_status'   => 'publish',
		);
		 
		// Insert the post into the database
		$td_post_id = wp_insert_post( $my_post );

		update_post_meta($td_post_id, 'lead_first_name', sanitize_text_field($_POST['reserve-name']));
		update_post_meta($td_post_id, 'lead_mobile_phone', sanitize_text_field($_POST['reserve-phone']));
		update_post_meta($td_post_id, 'lead_email', sanitize_text_field($_POST['reserve-email']));

	}

	$response['html'] = ob_get_clean();

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_ajax_place_reservation', 'autoroyal_ajax_place_reservation' );
add_action( 'wp_ajax_nopriv_autoroyal_ajax_place_reservation', 'autoroyal_ajax_place_reservation' );

/*
|--------------------------------------------------------------------------
| Check Availability
|--------------------------------------------------------------------------
*/
function autoroyal_check_availability() {

	ob_start();

	$response['html'] = '';

	$userName    = sanitize_text_field( $_POST['userName'] );
	$userMail    = sanitize_text_field( $_POST['userMail'] );
	$userPhone   = sanitize_text_field( $_POST['userPhone'] );
	$textMessage = wp_kses( $_POST['textMessage'], true );
	$car_name    = sanitize_text_field( $_POST['car_name'] );
	$car_url     = esc_url( $_POST['car_url'] );
	$email_to    = sanitize_text_field( $_POST['dealer_email'] );
	$site_name   = get_bloginfo('name');

	if (strtoupper(substr(PHP_OS,0,3)=='WIN')) {
		$eol="\r\n";
	} elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) {
		$eol="\r";
	} else {
		$eol="\n";
	}

	// Message for card dealer
	$from = $email_to;
	$email = get_option('admin_email');
  	$subject = __('Check Availability for ', 'autoroyal').$car_name;
  	$headers = "From: " . $email_to . $eol;
	$headers .= "Reply-To: " . $email_to . $eol;
	$headers .= "MIME-Version: 1.0".$eol;
	$headers .= "Content-Type: text/html; charset=ISO-8859-1".$eol;
  	$msg = '
	<table width="100%" border="0">
		<tr>
			<td colspan="2" style="font-size: 20px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Check Availability', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td>'.__('Name', 'autoroyal').'</td>
			<td>'.$userName.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Email', 'autoroyal').'</td>
			<td>'.$userMail.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Phone', 'autoroyal').'</td>
			<td>'.$userPhone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Car', 'autoroyal').'</td>
			<td>'.$car_name.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Car Link', 'autoroyal').'</td>
			<td>'.$car_url.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Questions and Comments', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2">'.wp_kses($textMessage, true).'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	</table>
	';

  	if ( defined( 'autoroyal_USE_WPMAIL' ) ) {
		wp_mail( $email, $subject, $msg, $headers );
	} else {
		mail( $email, $subject, $msg, $headers );
	}

  	$mail_sent = 1;

  	// Create New Lead
	$website_type = get_option("autoroyal_webiste_type");
	if( !empty($website_type) AND $website_type == "marketplace" ) {
		$user_id = sanitize_text_field( $_POST['autoroyal_dealer_id'] );
	} else {
		$user_id = '1';
	}

	$my_post = array(
		'post_author'   => $user_id,
	  	'post_name'     => sanitize_title( $userName ),
	  	'post_title'    => $userName,
	  	'post_type'     => 'lead',
	  	'post_status'   => 'publish',
	);
	 
	// Insert the post into the database
	$td_post_id = wp_insert_post( $my_post );

	// Lead Meta
	update_post_meta($td_post_id, 'lead_first_name', sanitize_text_field($_POST['userName']));

	update_post_meta($td_post_id, 'lead_mobile_phone', sanitize_text_field($_POST['userPhone']));

	update_post_meta($td_post_id, 'lead_email', sanitize_text_field($_POST['userMail']));

	update_post_meta($td_post_id, 'lead_website_lead_type', 'Check Availability');

	//
	$term = get_term_by('name', 'New', 'lead_status');
	$term_id = $term->term_id;

	update_post_meta($td_post_id, 'lead_status', $term_id);
	wp_set_post_terms( $td_post_id, $term_id, "lead_status", false );

	//
	$term = get_term_by('name', 'Internet Up', 'lead_up_type');
	$term_id = $term->term_id;

	wp_set_post_terms( $td_post_id, $term_id, "lead_up_type", false );
	update_post_meta($td_post_id, 'lead_up_type', $term_id);

	//
	$term = get_term_by('name', 'Dealer Website', 'lead_ad_source');
	$term_id = $term->term_id;

	wp_set_post_terms( $td_post_id, $term_id, "lead_ad_source", false );
	update_post_meta($td_post_id, 'lead_ad_source', $term_id);

	// Lead Comments
	update_post_meta($td_post_id, 'lead_comments', wp_kses($_POST['textMessage'], true));

	// Interested in Vehicle
	update_post_meta($td_post_id, 'lead_vehicle_id', sanitize_text_field($_POST['car_id']));
	$lead_vehicle_id = esc_attr(get_post_meta($td_post_id, 'lead_vehicle_id',true));
	$lead_vehicle_sku_own = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_stock',true));
	update_post_meta($td_post_id, 'lead_vehicle_sku', $lead_vehicle_sku_own);
	// End Lead Meta

	$response['html'] = ob_get_clean();

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_check_availability', 'autoroyal_check_availability' );
add_action( 'wp_ajax_nopriv_autoroyal_check_availability', 'autoroyal_check_availability' );

/*
|--------------------------------------------------------------------------
| Pre Qualify
|--------------------------------------------------------------------------
*/
function autoroyal_pre_qualify() {

	ob_start();

	$response['html'] = '';

	// Personal Info
	$lead_first_name      = sanitize_text_field( $_POST['lead_first_name'] );
	$lead_middle_name     = sanitize_text_field( $_POST['lead_middle_name'] );
	$lead_last_name       = sanitize_text_field( $_POST['lead_last_name'] );

	$lead_address_1       = sanitize_text_field( $_POST['lead_address_1'] );
	$lead_address_2       = sanitize_text_field( $_POST['lead_address_2'] );

	$lead_city            = sanitize_text_field( $_POST['lead_city'] );
	$lead_state           = sanitize_text_field( $_POST['lead_state'] );
	$lead_zip             = sanitize_text_field( $_POST['lead_zip'] );

	$lead_home_phone      = sanitize_text_field( $_POST['lead_home_phone'] );
	$lead_mobile_phone    = sanitize_text_field( $_POST['lead_mobile_phone'] );
	$lead_work_phone      = sanitize_text_field( $_POST['lead_work_phone'] );

	$time_at_address      = sanitize_text_field( $_POST['time_at_address'] );
	$residence_type       = sanitize_text_field( $_POST['residence_type'] );
	$residence_price      = sanitize_text_field( $_POST['residence_price'] );

	$lead_email           = sanitize_text_field( $_POST['lead_email'] );
	$lead_birth_date      = sanitize_text_field( $_POST['lead_birth_date'] );

	// Employment Info
	$employer             = $_POST['employer'];
	$employer_name        = $employer[name];
	$employer_income      = $employer[income];
	$employer_occupation  = $employer[occupation];
	$employer_address_1   = $employer[address_1];
	$employer_address_2   = $employer[address_2];
	$employer_city        = $employer[city];
	$employer_state       = $employer[state];
	$employer_zip         = $employer[zip];
	$employer_phone       = $employer[phone];
	$employer_years       = sanitize_text_field( $_POST['employer_years'] );
	$employer_months      = sanitize_text_field( $_POST['employer_months'] );

	// Trade In
	$lead_tradein_vehicle_year    = sanitize_text_field( $_POST['cq-year'] );
	$lead_tradein_vehicle_make    = sanitize_text_field( $_POST['vehicle_make_desc_init'] );
	$lead_tradein_vehicle_model   = sanitize_text_field( $_POST['cq-model'] );
	$lead_tradein_vehicle_trim_id = sanitize_text_field( $_POST['cq-trim'] );
	$lead_tradein_vehicle_trim_desc_init = sanitize_text_field( $_POST['vehicle_trim_desc_init'] );
	$lead_tradein_vehicle_make_desc_init = sanitize_text_field( $_POST['vehicle_make_desc_init'] );

	$lead_tradein_vehicle_vin     = sanitize_text_field( $_POST['lead_tradein_vehicle_vin'] );
	$lead_tradein_vehicle_mileage = sanitize_text_field( $_POST['lead_tradein_vehicle_mileage'] );
	$lead_tradein_vehicle_color   = sanitize_text_field( $_POST['lead_tradein_vehicle_color'] );

	$textMessage = $_POST['lead_comments'];
	$site_name   = get_bloginfo('name');

	// Interested in Vehicle
	$lead_vehicle_id = sanitize_text_field( $_POST['lead_vehicle_id'] );

	$lead_vehicle_sku = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_stock',true));
	$lead_vehicle_year = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_year',true));
	$lead_vehicle_make = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_make_desc_init',true));
	$lead_vehicle_model = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_model',true));
	$lead_vehicle_trim = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_trim_desc_init',true));
	$lead_vehicle_vin = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_vin',true));

	$postNewTitle = $lead_first_name . " " . $lead_middle_name . " " . $lead_last_name;

	// Create New Lead
	$website_type = get_option("autoroyal_webiste_type");
		if( !empty($website_type) AND $website_type == "marketplace" ) {
			$user_id = sanitize_text_field( $_POST['autoroyal_dealer_id'] );
		} else {
			$user_id = '1';
		}

	$my_post = array(
		'post_author'   => $user_id,
	  	'post_name'     => sanitize_title( $postNewTitle ),
	  	'post_title'    => $postNewTitle,
	  	'post_type'     => 'lead',
	  	'post_status'   => 'publish',
	);
	 
	// Insert the post into the database
	$td_post_id = wp_insert_post( $my_post );

	// Lead Meta
	update_post_meta($td_post_id, 'lead_first_name', sanitize_text_field($_POST['lead_first_name']));
	update_post_meta($td_post_id, 'lead_middle_name', sanitize_text_field($_POST['lead_middle_name']));
	update_post_meta($td_post_id, 'lead_last_name', sanitize_text_field($_POST['lead_last_name']));

	update_post_meta($td_post_id, 'lead_address_1', sanitize_text_field($_POST['lead_address_1']));
	update_post_meta($td_post_id, 'lead_address_2', sanitize_text_field($_POST['lead_address_2']));

	update_post_meta($td_post_id, 'lead_city', sanitize_text_field($_POST['lead_city']));
	update_post_meta($td_post_id, 'lead_state', sanitize_text_field($_POST['lead_state']));
	update_post_meta($td_post_id, 'lead_zip', sanitize_text_field($_POST['lead_zip']));

	update_post_meta($td_post_id, 'lead_home_phone', sanitize_text_field($_POST['lead_home_phone']));
	update_post_meta($td_post_id, 'lead_mobile_phone', sanitize_text_field($_POST['lead_mobile_phone']));
	update_post_meta($td_post_id, 'lead_work_phone', sanitize_text_field($_POST['lead_work_phone']));

	update_post_meta($td_post_id, 'lead_email', sanitize_text_field($_POST['lead_email']));
	update_post_meta($td_post_id, 'lead_birth_date', sanitize_text_field($_POST['lead_birth_date']));

	update_post_meta($td_post_id, 'lead_current_residence_years', sanitize_text_field($_POST['time_at_address']));
	update_post_meta($td_post_id, 'lead_current_residence_type', sanitize_text_field($_POST['residence_type']));
	update_post_meta($td_post_id, 'lead_current_residence_price', sanitize_text_field($_POST['residence_price']));

	update_post_meta($td_post_id, 'lead_website_lead_type', 'Pre-Qualify');

	// Employer
	update_post_meta($td_post_id, 'lead_current_employer', $_POST['employer']);
	update_post_meta($td_post_id, 'lead_current_employer_years', sanitize_text_field($_POST['employer_years']));
	update_post_meta($td_post_id, 'lead_current_employer_months', sanitize_text_field($_POST['employer_months']));

	//
	$term = get_term_by('name', 'New', 'lead_status');
	$term_id = $term->term_id;

	update_post_meta($td_post_id, 'lead_status', $term_id);
	wp_set_post_terms( $td_post_id, $term_id, "lead_status", false );

	//
	$term = get_term_by('name', 'Internet Up', 'lead_up_type');
	$term_id = $term->term_id;

	wp_set_post_terms( $td_post_id, $term_id, "lead_up_type", false );
	update_post_meta($td_post_id, 'lead_up_type', $term_id);

	//
	$term = get_term_by('name', 'Dealer Website', 'lead_ad_source');
	$term_id = $term->term_id;

	wp_set_post_terms( $td_post_id, $term_id, "lead_ad_source", false );
	update_post_meta($td_post_id, 'lead_ad_source', $term_id);

	// Lead Comments
	update_post_meta($td_post_id, 'lead_comments', wp_kses($_POST['lead_comments'], true));

	// Co-Buyer
	$lead_cobuyer_current_residence = array(); 
	update_post_meta($td_post_id, 'lead_cobuyer_current_residence', $lead_cobuyer_current_residence);

	$lead_cobuyer_current_employer = array();
	update_post_meta($td_post_id, 'lead_cobuyer_current_employer', $lead_cobuyer_current_employer);

	//
	update_post_meta($td_post_id, 'lead_tradein_vehicle_year', sanitize_text_field($_POST['cq-year']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_make', sanitize_text_field($_POST['cq-make']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_model', sanitize_text_field($_POST['cq-model']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_trim_id', sanitize_text_field($_POST['cq-trim']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_trim_desc_init', sanitize_text_field($_POST['vehicle_trim_desc_init']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_make_desc_init', sanitize_text_field($_POST['vehicle_make_desc_init']));

	update_post_meta($td_post_id, 'lead_tradein_vehicle_vin', sanitize_text_field($_POST['lead_tradein_vehicle_vin']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_mileage', sanitize_text_field($_POST['lead_tradein_vehicle_mileage']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_color', sanitize_text_field($_POST['lead_tradein_vehicle_color']));

	// Interested in Vehicle
	update_post_meta($td_post_id, 'lead_vehicle_id', sanitize_text_field($_POST['lead_vehicle_id']));
	$lead_vehicle_id = esc_attr(get_post_meta($td_post_id, 'lead_vehicle_id',true));
	$lead_vehicle_sku_own = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_stock',true));
	update_post_meta($td_post_id, 'lead_vehicle_sku', $lead_vehicle_sku_own);

	// End Lead Meta


	// Admin Email Content
	$admin_email_content = '
	<table width="100%" border="0">
		<tr>
			<td colspan="2" style="font-size: 20px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Pre-Qualify Application', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Buyer Personal Info', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Name', 'autoroyal').'</td>
			<td>'.$postNewTitle.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 1', 'autoroyal').'</td>
			<td>'.$lead_address_1.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 2', 'autoroyal').'</td>
			<td>'.$lead_address_2.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('City', 'autoroyal').'</td>
			<td>'.$lead_city.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('State', 'autoroyal').'</td>
			<td>'.$lead_state.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Zip', 'autoroyal').'</td>
			<td>'.$lead_zip.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Home Phone', 'autoroyal').'</td>
			<td>'.$lead_home_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Mobile Phone', 'autoroyal').'</td>
			<td>'.$lead_mobile_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Work Phone', 'autoroyal').'</td>
			<td>'.$lead_work_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time at Residence (Years)', 'autoroyal').'</td>
			<td>'.$time_at_address.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Residence Type', 'autoroyal').'</td>
			<td>'.$residence_type.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Rent/Mortgage', 'autoroyal').'</td>
			<td>'.$residence_price.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Email', 'autoroyal').'</td>
			<td>'.$lead_email.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Birth Date', 'autoroyal').'</td>
			<td>'.$lead_birth_date.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Buyer Employment Info', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Employer', 'autoroyal').'</td>
			<td>'.$employer_name.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Monthly Income', 'autoroyal').'</td>
			<td>'.$employer_income.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Occupation', 'autoroyal').'</td>
			<td>'.$employer_occupation.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 1', 'autoroyal').'</td>
			<td>'.$employer_address_1.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 2', 'autoroyal').'</td>
			<td>'.$employer_address_2.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('City', 'autoroyal').'</td>
			<td>'.$employer_city.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('State', 'autoroyal').'</td>
			<td>'.$employer_state.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Zip', 'autoroyal').'</td>
			<td>'.$employer_zip.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Phone Number', 'autoroyal').'</td>
			<td>'.$employer_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time On Job - Years', 'autoroyal').'</td>
			<td>'.$employer_years.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time On Job - Months', 'autoroyal').'</td>
			<td>'.$employer_months.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Questions and Comments', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2">'.wp_kses($textMessage, true).'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Trade-In', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Year', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_year.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Make', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_make.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Model', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_model.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Trim', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_trim_desc_init.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('VIN', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_vin.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Mileage', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_mileage.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Color', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_color.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Interested in Vehicle', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('SKU', 'autoroyal').'</td>
			<td>'.$lead_vehicle_sku.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Year', 'autoroyal').'</td>
			<td>'.$lead_vehicle_year.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Make', 'autoroyal').'</td>
			<td>'.$lead_vehicle_make.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Model', 'autoroyal').'</td>
			<td>'.$lead_vehicle_model.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Trim', 'autoroyal').'</td>
			<td>'.$lead_vehicle_trim.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('VIN', 'autoroyal').'</td>
			<td>'.$lead_vehicle_vin.'</td>
	  	</tr>
	</table>
	';

	// End Post Data

	if (strtoupper(substr(PHP_OS,0,3)=='WIN')) {
		$eol="\r\n";
	} elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) {
		$eol="\r";
	} else {
		$eol="\n";
	}

	// Message for car dealer
	$from = sanitize_text_field( $_POST['lead_email'] );
	
	$website_type = get_option("autoroyal_webiste_type");
		if( !empty($website_type) AND $website_type == "marketplace" ) {
			$email = sanitize_text_field( $_POST['autoroyal_dealer_email'] );
		} else {
			$email = get_option('admin_email');
		}

  	$subject = __('Pre-Qualify Application Form from ', 'autoroyal').$site_name;
  	$headers = "From: " . $from . $eol;
	$headers .= "Reply-To: " . $from . $eol;
	$headers .= "MIME-Version: 1.0".$eol;
	$headers .= "Content-Type: text/html; charset=ISO-8859-1".$eol;

  	$msg = $admin_email_content;

  	add_filter('wp_mail_content_type',create_function('', 'return "text/html"; '));
  	$mail_sent = wp_mail( $email, $subject, $msg, $headers );

	$response['html'] = ob_get_clean();

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_pre_qualify', 'autoroyal_pre_qualify' );
add_action( 'wp_ajax_nopriv_autoroyal_pre_qualify', 'autoroyal_pre_qualify' );

/*
|--------------------------------------------------------------------------
| Financial Application
|--------------------------------------------------------------------------
*/
function autoroyal_ajax_financial_application() {

	ob_start();

	$response['html'] = '';

	// Personal Info
	$lead_first_name      = sanitize_text_field( $_POST['lead_first_name'] );
	$lead_middle_name     = sanitize_text_field( $_POST['lead_middle_name'] );
	$lead_last_name       = sanitize_text_field( $_POST['lead_last_name'] );

	$lead_address_1       = sanitize_text_field( $_POST['lead_address_1'] );
	$lead_address_2       = sanitize_text_field( $_POST['lead_address_2'] );

	$lead_city            = sanitize_text_field( $_POST['lead_city'] );
	$lead_state           = sanitize_text_field( $_POST['lead_state'] );
	$lead_zip             = sanitize_text_field( $_POST['lead_zip'] );

	$lead_home_phone      = sanitize_text_field( $_POST['lead_home_phone'] );
	$lead_mobile_phone    = sanitize_text_field( $_POST['lead_mobile_phone'] );
	$lead_work_phone      = sanitize_text_field( $_POST['lead_work_phone'] );

	$time_at_address      = sanitize_text_field( $_POST['time_at_address'] );
	$residence_type       = sanitize_text_field( $_POST['residence_type'] );
	$residence_price      = sanitize_text_field( $_POST['residence_price'] );

	$lead_email           = sanitize_text_field( $_POST['lead_email'] );
	$lead_birth_date      = sanitize_text_field( $_POST['lead_birth_date'] );
	$lead_social_security = sanitize_text_field( $_POST['lead_social_security'] );

	// Employment Info
	$employer             = $_POST['employer'];
	$employer_name        = $employer[name];
	$employer_income      = $employer[income];
	$employer_occupation  = $employer[occupation];
	$employer_address_1   = $employer[address_1];
	$employer_address_2   = $employer[address_2];
	$employer_city        = $employer[city];
	$employer_state       = $employer[state];
	$employer_zip         = $employer[zip];
	$employer_phone       = $employer[phone];
	$employer_years       = sanitize_text_field( $_POST['employer_years'] );
	$employer_months      = sanitize_text_field( $_POST['employer_months'] );

	// Co-Buyer Personal Info
	$lead_cobuyer_first_name      = sanitize_text_field( $_POST['lead_cobuyer_first_name'] );
	$lead_cobuyer_middle_name     = sanitize_text_field( $_POST['lead_cobuyer_middle_name'] );
	$lead_cobuyer_last_name       = sanitize_text_field( $_POST['lead_cobuyer_last_name'] );

	$lead_cobuyer_address_1       = sanitize_text_field( $_POST['lead_cobuyer_address_1'] );
	$lead_cobuyer_address_2       = sanitize_text_field( $_POST['lead_cobuyer_address_2'] );

	$lead_cobuyer_city            = sanitize_text_field( $_POST['lead_cobuyer_city'] );
	$lead_cobuyer_state           = sanitize_text_field( $_POST['lead_cobuyer_state'] );
	$lead_cobuyer_zip             = sanitize_text_field( $_POST['lead_cobuyer_zip'] );

	$lead_cobuyer_home_phone      = sanitize_text_field( $_POST['lead_cobuyer_home_phone'] );
	$lead_cobuyer_mobile_phone    = sanitize_text_field( $_POST['lead_cobuyer_mobile_phone'] );
	$lead_cobuyer_work_phone      = sanitize_text_field( $_POST['lead_cobuyer_work_phone'] );

	$lead_cobuyer_time_at_address = sanitize_text_field( $_POST['lead_cobuyer_time_at_address'] );
	$lead_cobuyer_residence_type  = sanitize_text_field( $_POST['lead_cobuyer_residence_type'] );
	$lead_cobuyer_residence_price = sanitize_text_field( $_POST['lead_cobuyer_residence_price'] );

	$lead_cobuyer_email           = sanitize_text_field( $_POST['lead_cobuyer_email'] );
	$lead_cobuyer_birth_date      = sanitize_text_field( $_POST['lead_cobuyer_birth_date'] );
	$lead_cobuyer_social_security = sanitize_text_field( $_POST['lead_cobuyer_social_security'] );

	// Co-Buyer Employment Info
	$employer_cobuyer_name        = sanitize_text_field( $_POST['employer_cobuyer_name'] );
	$employer_cobuyer_income      = sanitize_text_field( $_POST['employer_cobuyer_income'] );
	$employer_cobuyer_occupation  = sanitize_text_field( $_POST['employer_cobuyer_occupation'] );
	$employer_cobuyer_address_1   = sanitize_text_field( $_POST['employer_cobuyer_address_1'] );
	$employer_cobuyer_address_2   = sanitize_text_field( $_POST['employer_cobuyer_address_2'] );
	$employer_cobuyer_city        = sanitize_text_field( $_POST['employer_cobuyer_city'] );
	$employer_cobuyer_state       = sanitize_text_field( $_POST['employer_cobuyer_state'] );
	$employer_cobuyer_zip         = sanitize_text_field( $_POST['employer_cobuyer_zip'] );
	$employer_cobuyer_phone       = sanitize_text_field( $_POST['employer_cobuyer_phone'] );
	$employer_cobuyer_years       = sanitize_text_field( $_POST['employer_cobuyer_years'] );
	$employer_cobuyer_months      = sanitize_text_field( $_POST['employer_cobuyer_months'] );

	// Trade In
	$lead_tradein_vehicle_year    = sanitize_text_field( $_POST['cq-year'] );
	$lead_tradein_vehicle_make    = sanitize_text_field( $_POST['vehicle_make_desc_init'] );
	$lead_tradein_vehicle_model   = sanitize_text_field( $_POST['cq-model'] );
	$lead_tradein_vehicle_trim_id = sanitize_text_field( $_POST['cq-trim'] );
	$lead_tradein_vehicle_trim_desc_init = sanitize_text_field( $_POST['vehicle_trim_desc_init'] );
	$lead_tradein_vehicle_make_desc_init = sanitize_text_field( $_POST['vehicle_make_desc_init'] );

	$lead_tradein_vehicle_vin     = sanitize_text_field( $_POST['lead_tradein_vehicle_vin'] );
	$lead_tradein_vehicle_mileage = sanitize_text_field( $_POST['lead_tradein_vehicle_mileage'] );
	$lead_tradein_vehicle_color   = sanitize_text_field( $_POST['lead_tradein_vehicle_color'] );

	$textMessage = $_POST['lead_comments'];
	$site_name   = get_bloginfo('name');

	// Interested in Vehicle
	$lead_vehicle_id = sanitize_text_field( $_POST['lead_vehicle_id'] );

	$lead_vehicle_sku = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_stock',true));
	$lead_vehicle_year = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_year',true));
	$lead_vehicle_make = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_make_desc_init',true));
	$lead_vehicle_model = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_model',true));
	$lead_vehicle_trim = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_trim_desc_init',true));
	$lead_vehicle_vin = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_vin',true));

	$postNewTitle = $lead_first_name . " " . $lead_middle_name . " " . $lead_last_name;

	// Create New Lead
	$website_type = get_option("autoroyal_webiste_type");
		if( !empty($website_type) AND $website_type == "marketplace" ) {
			$user_id = sanitize_text_field( $_POST['autoroyal_dealer_id'] );
		} else {
			$user_id = '1';
		}

	$my_post = array(
		'post_author'   => $user_id,
	  	'post_name'     => sanitize_title( $postNewTitle ),
	  	'post_title'    => $postNewTitle,
	  	'post_type'     => 'lead',
	  	'post_status'   => 'publish',
	);
	 
	// Insert the post into the database
	$td_post_id = wp_insert_post( $my_post );

	// Lead Meta
	update_post_meta($td_post_id, 'lead_first_name', sanitize_text_field($_POST['lead_first_name']));
	update_post_meta($td_post_id, 'lead_middle_name', sanitize_text_field($_POST['lead_middle_name']));
	update_post_meta($td_post_id, 'lead_last_name', sanitize_text_field($_POST['lead_last_name']));

	update_post_meta($td_post_id, 'lead_address_1', sanitize_text_field($_POST['lead_address_1']));
	update_post_meta($td_post_id, 'lead_address_2', sanitize_text_field($_POST['lead_address_2']));

	update_post_meta($td_post_id, 'lead_city', sanitize_text_field($_POST['lead_city']));
	update_post_meta($td_post_id, 'lead_state', sanitize_text_field($_POST['lead_state']));
	update_post_meta($td_post_id, 'lead_zip', sanitize_text_field($_POST['lead_zip']));

	update_post_meta($td_post_id, 'lead_home_phone', sanitize_text_field($_POST['lead_home_phone']));
	update_post_meta($td_post_id, 'lead_mobile_phone', sanitize_text_field($_POST['lead_mobile_phone']));
	update_post_meta($td_post_id, 'lead_work_phone', sanitize_text_field($_POST['lead_work_phone']));

	update_post_meta($td_post_id, 'lead_email', sanitize_text_field($_POST['lead_email']));
	update_post_meta($td_post_id, 'lead_birth_date', sanitize_text_field($_POST['lead_birth_date']));
	update_post_meta($td_post_id, 'lead_social_security', sanitize_text_field($_POST['lead_social_security']));

	update_post_meta($td_post_id, 'lead_current_residence_years', sanitize_text_field($_POST['time_at_address']));
	update_post_meta($td_post_id, 'lead_current_residence_type', sanitize_text_field($_POST['residence_type']));
	update_post_meta($td_post_id, 'lead_current_residence_price', sanitize_text_field($_POST['residence_price']));

	update_post_meta($td_post_id, 'lead_website_lead_type', 'Financial Application');

	// Employer
	update_post_meta($td_post_id, 'lead_current_employer', $_POST['employer']);
	update_post_meta($td_post_id, 'lead_current_employer_years', sanitize_text_field($_POST['employer_years']));
	update_post_meta($td_post_id, 'lead_current_employer_months', sanitize_text_field($_POST['employer_months']));

	//
	$term = get_term_by('name', 'New', 'lead_status');
	$term_id = $term->term_id;

	update_post_meta($td_post_id, 'lead_status', $term_id);
	wp_set_post_terms( $td_post_id, $term_id, "lead_status", false );

	//
	$term = get_term_by('name', 'Internet Up', 'lead_up_type');
	$term_id = $term->term_id;

	wp_set_post_terms( $td_post_id, $term_id, "lead_up_type", false );
	update_post_meta($td_post_id, 'lead_up_type', $term_id);

	//
	$term = get_term_by('name', 'Dealer Website', 'lead_ad_source');
	$term_id = $term->term_id;

	wp_set_post_terms( $td_post_id, $term_id, "lead_ad_source", false );
	update_post_meta($td_post_id, 'lead_ad_source', $term_id);

	// Lead Comments
	update_post_meta($td_post_id, 'lead_comments', wp_kses($_POST['lead_comments'], true));

	// Co-Buyer
	// 
	update_post_meta($td_post_id, 'lead_cobuyer_first_name', sanitize_text_field($_POST['lead_cobuyer_first_name']));
	update_post_meta($td_post_id, 'lead_cobuyer_middle_name', sanitize_text_field($_POST['lead_cobuyer_middle_name']));
	update_post_meta($td_post_id, 'lead_cobuyer_last_name', sanitize_text_field($_POST['lead_cobuyer_last_name']));

	update_post_meta($td_post_id, 'lead_cobuyer_address_1', sanitize_text_field($_POST['lead_cobuyer_address_1']));
	update_post_meta($td_post_id, 'lead_cobuyer_address_2', sanitize_text_field($_POST['lead_cobuyer_address_2']));

	update_post_meta($td_post_id, 'lead_cobuyer_city', sanitize_text_field($_POST['lead_cobuyer_city']));
	update_post_meta($td_post_id, 'lead_cobuyer_state', sanitize_text_field($_POST['lead_cobuyer_state']));
	update_post_meta($td_post_id, 'lead_cobuyer_zip', sanitize_text_field($_POST['lead_cobuyer_zip']));

	update_post_meta($td_post_id, 'lead_cobuyer_home_phone', sanitize_text_field($_POST['lead_cobuyer_home_phone']));
	update_post_meta($td_post_id, 'lead_cobuyer_mobile_phone', sanitize_text_field($_POST['lead_cobuyer_mobile_phone']));
	update_post_meta($td_post_id, 'lead_cobuyer_work_phone', sanitize_text_field($_POST['lead_cobuyer_work_phone']));

	update_post_meta($td_post_id, 'lead_cobuyer_email', sanitize_text_field($_POST['lead_cobuyer_email']));
	update_post_meta($td_post_id, 'lead_cobuyer_birth_date', sanitize_text_field($_POST['lead_cobuyer_birth_date']));
	update_post_meta($td_post_id, 'lead_cobuyer_social_security', sanitize_text_field($_POST['lead_cobuyer_social_security']));

	$lead_cobuyer_current_residence = array();
	$lead_cobuyer_current_residence['address_1'] = sanitize_text_field($_POST['lead_cobuyer_address_1']);
	$lead_cobuyer_current_residence['address_2'] = sanitize_text_field($_POST['lead_cobuyer_address_2']);
	$lead_cobuyer_current_residence['city'] = sanitize_text_field($_POST['lead_cobuyer_city']);
	$lead_cobuyer_current_residence['state'] = sanitize_text_field($_POST['lead_cobuyer_state']);
	$lead_cobuyer_current_residence['zip'] = sanitize_text_field($_POST['lead_cobuyer_zip']);
	$lead_cobuyer_current_residence['phone'] = sanitize_text_field($_POST['lead_cobuyer_mobile_phone']);

	// 
	update_post_meta($td_post_id, 'lead_cobuyer_current_residence', $lead_cobuyer_current_residence);
	update_post_meta($td_post_id, 'lead_cobuyer_current_residence_years', sanitize_text_field($_POST['lead_cobuyer_time_at_address']));
	update_post_meta($td_post_id, 'lead_cobuyer_current_residence_type', sanitize_text_field($_POST['lead_cobuyer_residence_type']));
	update_post_meta($td_post_id, 'lead_cobuyer_current_residence_price', sanitize_text_field($_POST['lead_cobuyer_residence_price']));

	$lead_cobuyer_current_employer = array();
	$lead_cobuyer_current_employer['name'] = sanitize_text_field($_POST['employer_cobuyer_name']);
	$lead_cobuyer_current_employer['income'] = sanitize_text_field($_POST['employer_cobuyer_income']);
	$lead_cobuyer_current_employer['occupation'] = sanitize_text_field($_POST['employer_cobuyer_occupation']);
	$lead_cobuyer_current_employer['address_1'] = sanitize_text_field($_POST['employer_cobuyer_address_1']);
	$lead_cobuyer_current_employer['address_2'] = sanitize_text_field($_POST['employer_cobuyer_address_2']);
	$lead_cobuyer_current_employer['city'] = sanitize_text_field($_POST['employer_cobuyer_city']);
	$lead_cobuyer_current_employer['state'] = sanitize_text_field($_POST['employer_cobuyer_state']);
	$lead_cobuyer_current_employer['zip'] = sanitize_text_field($_POST['employer_cobuyer_zip']);
	$lead_cobuyer_current_employer['phone'] = sanitize_text_field($_POST['employer_cobuyer_phone']);

	update_post_meta($td_post_id, 'lead_cobuyer_current_employer', $lead_cobuyer_current_employer);
	update_post_meta($td_post_id, 'lead_cobuyer_current_employer_years', sanitize_text_field($_POST['employer_cobuyer_years']));
	update_post_meta($td_post_id, 'lead_cobuyer_current_employer_months', sanitize_text_field($_POST['employer_cobuyer_months']));

	//
	update_post_meta($td_post_id, 'lead_tradein_vehicle_year', sanitize_text_field($_POST['cq-year']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_make', sanitize_text_field($_POST['cq-make']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_model', sanitize_text_field($_POST['cq-model']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_trim_id', sanitize_text_field($_POST['cq-trim']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_trim_desc_init', sanitize_text_field($_POST['vehicle_trim_desc_init']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_make_desc_init', sanitize_text_field($_POST['vehicle_make_desc_init']));

	update_post_meta($td_post_id, 'lead_tradein_vehicle_vin', sanitize_text_field($_POST['lead_tradein_vehicle_vin']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_mileage', sanitize_text_field($_POST['lead_tradein_vehicle_mileage']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_color', sanitize_text_field($_POST['lead_tradein_vehicle_color']));

	// Interested in Vehicle
	update_post_meta($td_post_id, 'lead_vehicle_id', sanitize_text_field($_POST['lead_vehicle_id']));
	$lead_vehicle_id = esc_attr(get_post_meta($td_post_id, 'lead_vehicle_id',true));
	$lead_vehicle_sku_own = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_stock',true));
	update_post_meta($td_post_id, 'lead_vehicle_sku', $lead_vehicle_sku_own);

	// End Lead Meta


	// Admin Email Content
	$admin_email_content = '
	<table width="100%" border="0">
	  	<tr>
			<td colspan="2" style="font-size: 20px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Financial Application', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Buyer Personal Info', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Name', 'autoroyal').'</td>
			<td>'.$postNewTitle.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 1', 'autoroyal').'</td>
			<td>'.$lead_address_1.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 2', 'autoroyal').'</td>
			<td>'.$lead_address_2.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('City', 'autoroyal').'</td>
			<td>'.$lead_city.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('State', 'autoroyal').'</td>
			<td>'.$lead_state.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Zip', 'autoroyal').'</td>
			<td>'.$lead_zip.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Home Phone', 'autoroyal').'</td>
			<td>'.$lead_home_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Mobile Phone', 'autoroyal').'</td>
			<td>'.$lead_mobile_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Work Phone', 'autoroyal').'</td>
			<td>'.$lead_work_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time at Residence (Years)', 'autoroyal').'</td>
			<td>'.$time_at_address.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Residence Type', 'autoroyal').'</td>
			<td>'.$residence_type.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Rent/Mortgage', 'autoroyal').'</td>
			<td>'.$residence_price.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Email', 'autoroyal').'</td>
			<td>'.$lead_email.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Birth Date', 'autoroyal').'</td>
			<td>'.$lead_birth_date.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Social Security Number', 'autoroyal').'</td>
			<td>'.$lead_social_security.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Buyer Employment Info', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Employer', 'autoroyal').'</td>
			<td>'.$employer_name.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Monthly Income', 'autoroyal').'</td>
			<td>'.$employer_income.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Occupation', 'autoroyal').'</td>
			<td>'.$employer_occupation.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 1', 'autoroyal').'</td>
			<td>'.$employer_address_1.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 2', 'autoroyal').'</td>
			<td>'.$employer_address_2.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('City', 'autoroyal').'</td>
			<td>'.$employer_city.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('State', 'autoroyal').'</td>
			<td>'.$employer_state.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Zip', 'autoroyal').'</td>
			<td>'.$employer_zip.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Phone Number', 'autoroyal').'</td>
			<td>'.$employer_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time On Job - Years', 'autoroyal').'</td>
			<td>'.$employer_years.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time On Job - Months', 'autoroyal').'</td>
			<td>'.$employer_months.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Questions and Comments', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2">'.wp_kses($textMessage, true).'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Co-Buyer Personal Info', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Name', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_first_name.' '.$lead_cobuyer_middle_name.' '.$lead_cobuyer_last_name.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 1', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_address_1.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 2', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_address_2.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('City', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_city.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('State', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_state.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Zip', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_zip.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Home Phone', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_home_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Mobile Phone', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_mobile_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Work Phone', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_work_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time at Residence', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_time_at_address.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Residence Type', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_residence_type.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Rent/Mortgage', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_residence_price.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Email', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_email.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Birth Date', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_birth_date.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Social Security Number', 'autoroyal').'</td>
			<td>'.$lead_cobuyer_social_security.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Co-Buyer Employment Info', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Employer', 'autoroyal').'</td>
			<td>'.$employer_cobuyer_name.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Monthly Income', 'autoroyal').'</td>
			<td>'.$employer_cobuyer_income.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Occupation', 'autoroyal').'</td>
			<td>'.$employer_cobuyer_occupation.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 1', 'autoroyal').'</td>
			<td>'.$employer_cobuyer_address_1.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 2', 'autoroyal').'</td>
			<td>'.$employer_cobuyer_address_2.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('City', 'autoroyal').'</td>
			<td>'.$employer_cobuyer_city.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('State', 'autoroyal').'</td>
			<td>'.$employer_cobuyer_state.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Zip', 'autoroyal').'</td>
			<td>'.$employer_cobuyer_zip.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Phone Number', 'autoroyal').'</td>
			<td>'.$employer_cobuyer_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time On Job - Years', 'autoroyal').'</td>
			<td>'.$employer_cobuyer_years.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time On Job - Months', 'autoroyal').'</td>
			<td>'.$employer_cobuyer_months.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Trade-In', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Year', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_year.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Make', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_make.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Model', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_model.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Trim', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_trim_desc_init.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('VIN', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_vin.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Mileage', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_mileage.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Color', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_color.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Interested in Vehicle', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('SKU', 'autoroyal').'</td>
			<td>'.$lead_vehicle_sku.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Year', 'autoroyal').'</td>
			<td>'.$lead_vehicle_year.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Make', 'autoroyal').'</td>
			<td>'.$lead_vehicle_make.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Model', 'autoroyal').'</td>
			<td>'.$lead_vehicle_model.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Trim', 'autoroyal').'</td>
			<td>'.$lead_vehicle_trim.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('VIN', 'autoroyal').'</td>
			<td>'.$lead_vehicle_vin.'</td>
	  	</tr>
	</table>
	';

	// End Post Data

	if (strtoupper(substr(PHP_OS,0,3)=='WIN')) {
		$eol="\r\n";
	} elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) {
		$eol="\r";
	} else {
		$eol="\n";
	}

	// Message for car dealer
	$from = sanitize_text_field( $_POST['lead_email'] );

	$website_type = get_option("autoroyal_webiste_type");
		if( !empty($website_type) AND $website_type == "marketplace" ) {
			$email = sanitize_text_field( $_POST['autoroyal_dealer_email'] );
		} else {
			$email = get_option('admin_email');
		}

  	$subject = __('Financial Application Form from ', 'autoroyal').$site_name;
  	$headers = "From: " . $from . $eol;
	$headers .= "Reply-To: " . $from . $eol;
	$headers .= "MIME-Version: 1.0".$eol;
	$headers .= "Content-Type: text/html; charset=ISO-8859-1".$eol;

  	$msg = $admin_email_content;

  	add_filter('wp_mail_content_type',create_function('', 'return "text/html"; '));
  	$mail_sent = wp_mail( $email, $subject, $msg, $headers );

	$response['html'] = ob_get_clean();

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_ajax_financial_application', 'autoroyal_ajax_financial_application' );
add_action( 'wp_ajax_nopriv_autoroyal_ajax_financial_application', 'autoroyal_ajax_financial_application' );

/*
|--------------------------------------------------------------------------
| test Drive
|--------------------------------------------------------------------------
*/
function autoroyal_ajax_test_drive() {

	ob_start();

	$response['html'] = '';

	// Personal Info
	$lead_first_name      = sanitize_text_field( $_POST['lead_first_name'] );
	$lead_middle_name     = sanitize_text_field( $_POST['lead_middle_name'] );
	$lead_last_name       = sanitize_text_field( $_POST['lead_last_name'] );

	$lead_address_1       = sanitize_text_field( $_POST['lead_address_1'] );
	$lead_address_2       = sanitize_text_field( $_POST['lead_address_2'] );

	$lead_city            = sanitize_text_field( $_POST['lead_city'] );
	$lead_state           = sanitize_text_field( $_POST['lead_state'] );
	$lead_zip             = sanitize_text_field( $_POST['lead_zip'] );

	$lead_home_phone      = sanitize_text_field( $_POST['lead_home_phone'] );
	$lead_mobile_phone    = sanitize_text_field( $_POST['lead_mobile_phone'] );
	$lead_work_phone      = sanitize_text_field( $_POST['lead_work_phone'] );

	$time_at_address      = sanitize_text_field( $_POST['time_at_address'] );
	$residence_type       = sanitize_text_field( $_POST['residence_type'] );
	$residence_price      = sanitize_text_field( $_POST['residence_price'] );

	$lead_email           = sanitize_text_field( $_POST['lead_email'] );
	$lead_birth_date      = sanitize_text_field( $_POST['lead_birth_date'] );

	$lead_driver_license_state      = sanitize_text_field( $_POST['lead_driver_license_state'] );
	$lead_driver_license_number     = sanitize_text_field( $_POST['lead_driver_license_number'] );
	$lead_driver_license_exp        = sanitize_text_field( $_POST['lead_driver_license_exp'] );

	// Employment Info
	$employer             = $_POST['employer'];
	$employer_name        = $employer['name'];
	$employer_income      = $employer['income'];
	$employer_occupation  = $employer['occupation'];
	$employer_address_1   = $employer['address_1'];
	$employer_address_2   = $employer['address_2'];
	$employer_city        = $employer['city'];
	$employer_state       = $employer['state'];
	$employer_zip         = $employer['zip'];
	$employer_phone       = $employer['phone'];
	$employer_years       = sanitize_text_field( $_POST['employer_years'] );
	$employer_months      = sanitize_text_field( $_POST['employer_months'] );

	$textMessage = $_POST['lead_comments'];
	$site_name   = get_bloginfo('name');

	// Interested in Vehicle
	$lead_vehicle_id = sanitize_text_field( $_POST['lead_vehicle_id'] );

	$lead_vehicle_sku = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_stock',true));
	$lead_vehicle_year = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_year',true));
	$lead_vehicle_make = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_make_desc_init',true));
	$lead_vehicle_model = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_model',true));
	$lead_vehicle_trim = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_trim_desc_init',true));
	$lead_vehicle_vin = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_vin',true));

	$postNewTitle = $lead_first_name . " " . $lead_middle_name . " " . $lead_last_name;

	// Create New Lead
	$website_type = get_option("autoroyal_webiste_type");
		if( !empty($website_type) AND $website_type == "marketplace" ) {
			$user_id = sanitize_text_field( $_POST['autoroyal_dealer_id'] );
		} else {
			$user_id = '1';
		}

	$my_post = array(
		'post_author'   => $user_id,
	  	'post_name'     => sanitize_title( $postNewTitle ),
	  	'post_title'    => $postNewTitle,
	  	'post_type'     => 'lead',
	  	'post_status'   => 'publish',
	);
	 
	// Insert the post into the database
	$td_post_id = wp_insert_post( $my_post );

	// Lead Meta
	update_post_meta($td_post_id, 'lead_first_name', sanitize_text_field($_POST['lead_first_name']));
	update_post_meta($td_post_id, 'lead_middle_name', sanitize_text_field($_POST['lead_middle_name']));
	update_post_meta($td_post_id, 'lead_last_name', sanitize_text_field($_POST['lead_last_name']));

	update_post_meta($td_post_id, 'lead_address_1', sanitize_text_field($_POST['lead_address_1']));
	update_post_meta($td_post_id, 'lead_address_2', sanitize_text_field($_POST['lead_address_2']));

	update_post_meta($td_post_id, 'lead_city', sanitize_text_field($_POST['lead_city']));
	update_post_meta($td_post_id, 'lead_state', sanitize_text_field($_POST['lead_state']));
	update_post_meta($td_post_id, 'lead_zip', sanitize_text_field($_POST['lead_zip']));

	update_post_meta($td_post_id, 'lead_home_phone', sanitize_text_field($_POST['lead_home_phone']));
	update_post_meta($td_post_id, 'lead_mobile_phone', sanitize_text_field($_POST['lead_mobile_phone']));
	update_post_meta($td_post_id, 'lead_work_phone', sanitize_text_field($_POST['lead_work_phone']));

	update_post_meta($td_post_id, 'lead_email', sanitize_text_field($_POST['lead_email']));
	update_post_meta($td_post_id, 'lead_birth_date', sanitize_text_field($_POST['lead_birth_date']));

	update_post_meta($td_post_id, 'lead_driver_license_state', sanitize_text_field($_POST['lead_driver_license_state']));
	update_post_meta($td_post_id, 'lead_driver_license_number', sanitize_text_field($_POST['lead_driver_license_number']));
	update_post_meta($td_post_id, 'lead_driver_license_exp', sanitize_text_field($_POST['lead_driver_license_exp']));

	update_post_meta($td_post_id, 'lead_current_residence_years', sanitize_text_field($_POST['time_at_address']));
	update_post_meta($td_post_id, 'lead_current_residence_type', sanitize_text_field($_POST['residence_type']));
	update_post_meta($td_post_id, 'lead_current_residence_price', sanitize_text_field($_POST['residence_price']));

	update_post_meta($td_post_id, 'lead_website_lead_type', 'Test Drive');

	// Employer
	update_post_meta($td_post_id, 'lead_current_employer', $_POST['employer']);
	update_post_meta($td_post_id, 'lead_current_employer_years', sanitize_text_field($_POST['employer_years']));
	update_post_meta($td_post_id, 'lead_current_employer_months', sanitize_text_field($_POST['employer_months']));

	//
	$term = get_term_by('name', 'New', 'lead_status');
	$term_id = $term->term_id;

	update_post_meta($td_post_id, 'lead_status', $term_id);
	wp_set_post_terms( $td_post_id, $term_id, "lead_status", false );

	//
	$term = get_term_by('name', 'Internet Up', 'lead_up_type');
	$term_id = $term->term_id;

	wp_set_post_terms( $td_post_id, $term_id, "lead_up_type", false );
	update_post_meta($td_post_id, 'lead_up_type', $term_id);

	//
	$term = get_term_by('name', 'Dealer Website', 'lead_ad_source');
	$term_id = $term->term_id;

	wp_set_post_terms( $td_post_id, $term_id, "lead_ad_source", false );
	update_post_meta($td_post_id, 'lead_ad_source', $term_id);

	// Lead Comments
	update_post_meta($td_post_id, 'lead_comments', wp_kses($_POST['lead_comments'], true));

	// Co-Buyer
	$lead_cobuyer_current_residence = array(); 
	update_post_meta($td_post_id, 'lead_cobuyer_current_residence', $lead_cobuyer_current_residence);

	$lead_cobuyer_current_employer = array();
	update_post_meta($td_post_id, 'lead_cobuyer_current_employer', $lead_cobuyer_current_employer);

	// Interested in Vehicle
	update_post_meta($td_post_id, 'lead_vehicle_id', sanitize_text_field($_POST['lead_vehicle_id']));
	$lead_vehicle_id = esc_attr(get_post_meta($td_post_id, 'lead_vehicle_id',true));
	$lead_vehicle_sku_own = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_stock',true));
	update_post_meta($td_post_id, 'lead_vehicle_sku', $lead_vehicle_sku_own);

	// End Lead Meta


	// Admin Email Content
	$admin_email_content = '
	<table width="100%" border="0">
		<tr>
			<td colspan="2" style="font-size: 20px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Test Drive Request', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Buyer Personal Info', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Name', 'autoroyal').'</td>
			<td>'.$postNewTitle.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 1', 'autoroyal').'</td>
			<td>'.$lead_address_1.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 2', 'autoroyal').'</td>
			<td>'.$lead_address_2.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('City', 'autoroyal').'</td>
			<td>'.$lead_city.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('State', 'autoroyal').'</td>
			<td>'.$lead_state.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Zip', 'autoroyal').'</td>
			<td>'.$lead_zip.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Home Phone', 'autoroyal').'</td>
			<td>'.$lead_home_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Mobile Phone', 'autoroyal').'</td>
			<td>'.$lead_mobile_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Work Phone', 'autoroyal').'</td>
			<td>'.$lead_work_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time at Residence (Years)', 'autoroyal').'</td>
			<td>'.$time_at_address.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Residence Type', 'autoroyal').'</td>
			<td>'.$residence_type.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Rent/Mortgage', 'autoroyal').'</td>
			<td>'.$residence_price.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Email', 'autoroyal').'</td>
			<td>'.$lead_email.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Birth Date', 'autoroyal').'</td>
			<td>'.$lead_birth_date.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Driver License State', 'autoroyal').'</td>
			<td>'.$lead_driver_license_state.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Drivers License Number', 'autoroyal').'</td>
			<td>'.$lead_driver_license_number.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Drivers License Exp', 'autoroyal').'</td>
			<td>'.$lead_driver_license_exp.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Buyer Employment Info', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Employer', 'autoroyal').'</td>
			<td>'.$employer_name.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Monthly Income', 'autoroyal').'</td>
			<td>'.$employer_income.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Occupation', 'autoroyal').'</td>
			<td>'.$employer_occupation.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 1', 'autoroyal').'</td>
			<td>'.$employer_address_1.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 2', 'autoroyal').'</td>
			<td>'.$employer_address_2.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('City', 'autoroyal').'</td>
			<td>'.$employer_city.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('State', 'autoroyal').'</td>
			<td>'.$employer_state.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Zip', 'autoroyal').'</td>
			<td>'.$employer_zip.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Phone Number', 'autoroyal').'</td>
			<td>'.$employer_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time On Job - Years', 'autoroyal').'</td>
			<td>'.$employer_years.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time On Job - Months', 'autoroyal').'</td>
			<td>'.$employer_months.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Questions and Comments', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2">'.wp_kses($textMessage, true).'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Interested in Vehicle', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('SKU', 'autoroyal').'</td>
			<td>'.$lead_vehicle_sku.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Year', 'autoroyal').'</td>
			<td>'.$lead_vehicle_year.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Make', 'autoroyal').'</td>
			<td>'.$lead_vehicle_make.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Model', 'autoroyal').'</td>
			<td>'.$lead_vehicle_model.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Trim', 'autoroyal').'</td>
			<td>'.$lead_vehicle_trim.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('VIN', 'autoroyal').'</td>
			<td>'.$lead_vehicle_vin.'</td>
	  	</tr>
	</table>
	';

	// End Post Data

	if (strtoupper(substr(PHP_OS,0,3)=='WIN')) {
		$eol="\r\n";
	} elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) {
		$eol="\r";
	} else {
		$eol="\n";
	}

	// Message for car dealer
	$from = sanitize_text_field( $_POST['lead_email'] );
	
	$website_type = get_option("autoroyal_webiste_type");
		if( !empty($website_type) AND $website_type == "marketplace" ) {
			$email = sanitize_text_field( $_POST['autoroyal_dealer_email'] );
		} else {
			$email = get_option('admin_email');
		}

  	$subject = __('Test Drive Request Form from ', 'autoroyal').$site_name;
  	$headers = "From: " . $from . $eol;
	$headers .= "Reply-To: " . $from . $eol;
	$headers .= "MIME-Version: 1.0".$eol;
	$headers .= "Content-Type: text/html; charset=ISO-8859-1".$eol;

  	$msg = $admin_email_content;

  	add_filter('wp_mail_content_type',create_function('', 'return "text/html"; '));
  	$mail_sent = wp_mail( $email, $subject, $msg, $headers );

	$response['html'] = ob_get_clean();

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_ajax_test_drive', 'autoroyal_ajax_test_drive' );
add_action( 'wp_ajax_nopriv_autoroyal_ajax_test_drive', 'autoroyal_ajax_test_drive' );

/*
|--------------------------------------------------------------------------
| Trade In
|--------------------------------------------------------------------------
*/
function autoroyal_ajax_trade_in() {

	ob_start();

	$response['html'] = '';

	// Personal Info
	$lead_first_name      = sanitize_text_field( $_POST['lead_first_name'] );
	$lead_middle_name     = sanitize_text_field( $_POST['lead_middle_name'] );
	$lead_last_name       = sanitize_text_field( $_POST['lead_last_name'] );

	$lead_address_1       = sanitize_text_field( $_POST['lead_address_1'] );
	$lead_address_2       = sanitize_text_field( $_POST['lead_address_2'] );

	$lead_city            = sanitize_text_field( $_POST['lead_city'] );
	$lead_state           = sanitize_text_field( $_POST['lead_state'] );
	$lead_zip             = sanitize_text_field( $_POST['lead_zip'] );

	$lead_home_phone      = sanitize_text_field( $_POST['lead_home_phone'] );
	$lead_mobile_phone    = sanitize_text_field( $_POST['lead_mobile_phone'] );
	$lead_work_phone      = sanitize_text_field( $_POST['lead_work_phone'] );

	$time_at_address      = sanitize_text_field( $_POST['time_at_address'] );
	$residence_type       = sanitize_text_field( $_POST['residence_type'] );
	$residence_price      = sanitize_text_field( $_POST['residence_price'] );

	$lead_email           = sanitize_text_field( $_POST['lead_email'] );
	$lead_birth_date      = sanitize_text_field( $_POST['lead_birth_date'] );

	// Employment Info
	$employer             = $_POST['employer'];
	$employer_name        = $employer['name'];
	$employer_income      = $employer['income'];
	$employer_occupation  = $employer['occupation'];
	$employer_address_1   = $employer['address_1'];
	$employer_address_2   = $employer['address_2'];
	$employer_city        = $employer['city'];
	$employer_state       = $employer['state'];
	$employer_zip         = $employer['zip'];
	$employer_phone       = $employer['phone'];
	$employer_years       = sanitize_text_field( $_POST['employer_years'] );
	$employer_months      = sanitize_text_field( $_POST['employer_months'] );

	// Trade In
	$lead_tradein_vehicle_year    = sanitize_text_field( $_POST['cq-year'] );
	$lead_tradein_vehicle_make    = sanitize_text_field( $_POST['vehicle_make_desc_init'] );
	$lead_tradein_vehicle_model   = sanitize_text_field( $_POST['cq-model'] );
	$lead_tradein_vehicle_trim_id = sanitize_text_field( $_POST['cq-trim'] );
	$lead_tradein_vehicle_trim_desc_init = sanitize_text_field( $_POST['vehicle_trim_desc_init'] );
	$lead_tradein_vehicle_make_desc_init = sanitize_text_field( $_POST['vehicle_make_desc_init'] );

	$lead_tradein_vehicle_vin     = sanitize_text_field( $_POST['lead_tradein_vehicle_vin'] );
	$lead_tradein_vehicle_mileage = sanitize_text_field( $_POST['lead_tradein_vehicle_mileage'] );
	$lead_tradein_vehicle_color   = sanitize_text_field( $_POST['lead_tradein_vehicle_color'] );

	$textMessage = $_POST['lead_comments'];
	$site_name   = get_bloginfo('name');

	// Interested in Vehicle
	$lead_vehicle_id = sanitize_text_field( $_POST['lead_vehicle_id'] );

	$lead_vehicle_sku = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_stock',true));
	$lead_vehicle_year = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_year',true));
	$lead_vehicle_make = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_make_desc_init',true));
	$lead_vehicle_model = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_model',true));
	$lead_vehicle_trim = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_trim_desc_init',true));
	$lead_vehicle_vin = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_vin',true));

	$postNewTitle = $lead_first_name . " " . $lead_middle_name . " " . $lead_last_name;

	// Create New Lead
	$website_type = get_option("autoroyal_webiste_type");
	if( !empty($website_type) AND $website_type == "marketplace" ) {
		$user_id = sanitize_text_field( $_POST['autoroyal_dealer_id'] );
	} else {
		$user_id = '1';
	}

	$my_post = array(
		'post_author'   => $user_id,
	  	'post_name'     => sanitize_title( $postNewTitle ),
	  	'post_title'    => $postNewTitle,
	  	'post_type'     => 'lead',
	  	'post_status'   => 'publish',
	);
	 
	// Insert the post into the database
	$td_post_id = wp_insert_post( $my_post );

	// Lead Meta
	update_post_meta($td_post_id, 'lead_first_name', sanitize_text_field($_POST['lead_first_name']));
	update_post_meta($td_post_id, 'lead_middle_name', sanitize_text_field($_POST['lead_middle_name']));
	update_post_meta($td_post_id, 'lead_last_name', sanitize_text_field($_POST['lead_last_name']));

	update_post_meta($td_post_id, 'lead_address_1', sanitize_text_field($_POST['lead_address_1']));
	update_post_meta($td_post_id, 'lead_address_2', sanitize_text_field($_POST['lead_address_2']));

	update_post_meta($td_post_id, 'lead_city', sanitize_text_field($_POST['lead_city']));
	update_post_meta($td_post_id, 'lead_state', sanitize_text_field($_POST['lead_state']));
	update_post_meta($td_post_id, 'lead_zip', sanitize_text_field($_POST['lead_zip']));

	update_post_meta($td_post_id, 'lead_home_phone', sanitize_text_field($_POST['lead_home_phone']));
	update_post_meta($td_post_id, 'lead_mobile_phone', sanitize_text_field($_POST['lead_mobile_phone']));
	update_post_meta($td_post_id, 'lead_work_phone', sanitize_text_field($_POST['lead_work_phone']));

	update_post_meta($td_post_id, 'lead_email', sanitize_text_field($_POST['lead_email']));
	update_post_meta($td_post_id, 'lead_birth_date', sanitize_text_field($_POST['lead_birth_date']));

	update_post_meta($td_post_id, 'lead_current_residence_years', sanitize_text_field($_POST['time_at_address']));
	update_post_meta($td_post_id, 'lead_current_residence_type', sanitize_text_field($_POST['residence_type']));
	update_post_meta($td_post_id, 'lead_current_residence_price', sanitize_text_field($_POST['residence_price']));

	update_post_meta($td_post_id, 'lead_website_lead_type', 'Trade-In');

	// Employer
	update_post_meta($td_post_id, 'lead_current_employer', $_POST['employer']);
	update_post_meta($td_post_id, 'lead_current_employer_years', sanitize_text_field($_POST['employer_years']));
	update_post_meta($td_post_id, 'lead_current_employer_months', sanitize_text_field($_POST['employer_months']));

	//
	$term = get_term_by('name', 'New', 'lead_status');
	$term_id = $term->term_id;

	update_post_meta($td_post_id, 'lead_status', $term_id);
	wp_set_post_terms( $td_post_id, $term_id, "lead_status", false );

	//
	$term = get_term_by('name', 'Internet Up', 'lead_up_type');
	$term_id = $term->term_id;

	wp_set_post_terms( $td_post_id, $term_id, "lead_up_type", false );
	update_post_meta($td_post_id, 'lead_up_type', $term_id);

	//
	$term = get_term_by('name', 'Dealer Website', 'lead_ad_source');
	$term_id = $term->term_id;

	wp_set_post_terms( $td_post_id, $term_id, "lead_ad_source", false );
	update_post_meta($td_post_id, 'lead_ad_source', $term_id);

	// Lead Comments
	update_post_meta($td_post_id, 'lead_comments', wp_kses($_POST['lead_comments'], true));

	// Co-Buyer
	$lead_cobuyer_current_residence = array(); 
	update_post_meta($td_post_id, 'lead_cobuyer_current_residence', $lead_cobuyer_current_residence);

	$lead_cobuyer_current_employer = array();
	update_post_meta($td_post_id, 'lead_cobuyer_current_employer', $lead_cobuyer_current_employer);

	//
	update_post_meta($td_post_id, 'lead_tradein_vehicle_year', sanitize_text_field($_POST['cq-year']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_make', sanitize_text_field($_POST['cq-make']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_model', sanitize_text_field($_POST['cq-model']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_trim_id', sanitize_text_field($_POST['cq-trim']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_trim_desc_init', sanitize_text_field($_POST['vehicle_trim_desc_init']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_make_desc_init', sanitize_text_field($_POST['vehicle_make_desc_init']));

	update_post_meta($td_post_id, 'lead_tradein_vehicle_vin', sanitize_text_field($_POST['lead_tradein_vehicle_vin']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_mileage', sanitize_text_field($_POST['lead_tradein_vehicle_mileage']));
	update_post_meta($td_post_id, 'lead_tradein_vehicle_color', sanitize_text_field($_POST['lead_tradein_vehicle_color']));

	// Interested in Vehicle
	update_post_meta($td_post_id, 'lead_vehicle_id', sanitize_text_field($_POST['lead_vehicle_id']));
	$lead_vehicle_id = esc_attr(get_post_meta($td_post_id, 'lead_vehicle_id',true));
	$lead_vehicle_sku_own = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_stock',true));
	update_post_meta($td_post_id, 'lead_vehicle_sku', $lead_vehicle_sku_own);

	// End Lead Meta


	// Admin Email Content
	$admin_email_content = '
	<table width="100%" border="0">
		<tr>
			<td colspan="2" style="font-size: 20px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Trade-In Application', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Buyer Personal Info', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Name', 'autoroyal').'</td>
			<td>'.$postNewTitle.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 1', 'autoroyal').'</td>
			<td>'.$lead_address_1.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 2', 'autoroyal').'</td>
			<td>'.$lead_address_2.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('City', 'autoroyal').'</td>
			<td>'.$lead_city.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('State', 'autoroyal').'</td>
			<td>'.$lead_state.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Zip', 'autoroyal').'</td>
			<td>'.$lead_zip.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Home Phone', 'autoroyal').'</td>
			<td>'.$lead_home_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Mobile Phone', 'autoroyal').'</td>
			<td>'.$lead_mobile_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Work Phone', 'autoroyal').'</td>
			<td>'.$lead_work_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time at Residence (Years)', 'autoroyal').'</td>
			<td>'.$time_at_address.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Residence Type', 'autoroyal').'</td>
			<td>'.$residence_type.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Rent/Mortgage', 'autoroyal').'</td>
			<td>'.$residence_price.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Email', 'autoroyal').'</td>
			<td>'.$lead_email.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Birth Date', 'autoroyal').'</td>
			<td>'.$lead_birth_date.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Buyer Employment Info', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Employer', 'autoroyal').'</td>
			<td>'.$employer_name.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Monthly Income', 'autoroyal').'</td>
			<td>'.$employer_income.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Occupation', 'autoroyal').'</td>
			<td>'.$employer_occupation.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 1', 'autoroyal').'</td>
			<td>'.$employer_address_1.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Address 2', 'autoroyal').'</td>
			<td>'.$employer_address_2.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('City', 'autoroyal').'</td>
			<td>'.$employer_city.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('State', 'autoroyal').'</td>
			<td>'.$employer_state.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Zip', 'autoroyal').'</td>
			<td>'.$employer_zip.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Phone Number', 'autoroyal').'</td>
			<td>'.$employer_phone.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time On Job - Years', 'autoroyal').'</td>
			<td>'.$employer_years.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Time On Job - Months', 'autoroyal').'</td>
			<td>'.$employer_months.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Questions and Comments', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td colspan="2">'.wp_kses($textMessage, true).'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Trade-In', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Year', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_year.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Make', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_make.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Model', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_model.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Trim', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_trim_desc_init.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('VIN', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_vin.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Mileage', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_mileage.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Color', 'autoroyal').'</td>
			<td>'.$lead_tradein_vehicle_color.'</td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="height: 30px;"></td>
	  	</tr>
	  	<tr>
			<td colspan="2" style="font-size: 16px;font-weight:bold;color: #333;padding: 10px 0;">'.__('Interested in Vehicle', 'autoroyal').'</td>
	  	</tr>
	  	<tr>
			<td>'.__('SKU', 'autoroyal').'</td>
			<td>'.$lead_vehicle_sku.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Year', 'autoroyal').'</td>
			<td>'.$lead_vehicle_year.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Make', 'autoroyal').'</td>
			<td>'.$lead_vehicle_make.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Model', 'autoroyal').'</td>
			<td>'.$lead_vehicle_model.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('Trim', 'autoroyal').'</td>
			<td>'.$lead_vehicle_trim.'</td>
	  	</tr>
	  	<tr>
			<td>'.__('VIN', 'autoroyal').'</td>
			<td>'.$lead_vehicle_vin.'</td>
	  	</tr>
	</table>
	';

	// End Post Data

	if (strtoupper(substr(PHP_OS,0,3)=='WIN')) {
		$eol="\r\n";
	} elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) {
		$eol="\r";
	} else {
		$eol="\n";
	}

	// Message for car dealer
	$from = sanitize_text_field( $_POST['lead_email'] );
	
	$website_type = get_option("autoroyal_webiste_type");
	if( !empty($website_type) AND $website_type == "marketplace" ) {
		$email = sanitize_text_field( $_POST['autoroyal_dealer_email'] );
	} else {
		$email = get_option('admin_email');
	}

  	$subject = __('Trade-In Application Form from ', 'autoroyal').$site_name;
  	$headers = "From: " . $from . $eol;
	$headers .= "Reply-To: " . $from . $eol;
	$headers .= "MIME-Version: 1.0".$eol;
	$headers .= "Content-Type: text/html; charset=ISO-8859-1".$eol;

  	$msg = $admin_email_content;

  	add_filter('wp_mail_content_type',create_function('', 'return "text/html"; '));
  	$mail_sent = wp_mail( $email, $subject, $msg, $headers );

	$response['html'] = ob_get_clean();

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_ajax_trade_in', 'autoroyal_ajax_trade_in' );
add_action( 'wp_ajax_nopriv_autoroyal_ajax_trade_in', 'autoroyal_ajax_trade_in' );

function autoroyal_upload_dir( $pathdata ) {

	$dir = untrailingslashit( apply_filters( 'autoroyal_upload_dir', 'autoroyal-uploads/' ) );

	if ( empty( $pathdata['subdir'] ) ) {
		$pathdata['path']   = $pathdata['path'] . '/' . $dir;
		$pathdata['url']    = $pathdata['url'] . '/' . $dir;
		$pathdata['subdir'] = '/' . $dir;
	} else {
		$new_subdir         = '/' . $dir . $pathdata['subdir'];
		$pathdata['path']   = str_replace( $pathdata['subdir'], $new_subdir, $pathdata['path'] );
		$pathdata['url']    = str_replace( $pathdata['subdir'], $new_subdir, $pathdata['url'] );
		$pathdata['subdir'] = $new_subdir;
	}

	return $pathdata;
}

// Upload file and show in Media Library
function upload_user_file( $file = array(), $title = false ) {

	add_filter( 'upload_dir', 'autoroyal_upload_dir' );

	require_once ABSPATH.'wp-admin/includes/admin.php';

	$classyads_upload = true;
	$classyads_uploading_file = $file;

	$file_return = wp_handle_upload($file, array('test_form' => false));

	if(isset($file_return['error']) || isset($file_return['upload_error_handler'])){

		return false;

	} else {

		$filename = $file_return['file'];

		$attachment = array(
			'post_mime_type' => $file_return['type'],
			'post_content' => '',
			'post_type' => 'attachment',
			'post_status' => 'inherit',
			'guid' => $file_return['url']
		);

		if($title){
			$attachment['post_title'] = $title;
		}

		$attachment_id = wp_insert_attachment( $attachment, $filename );

		require_once(ABSPATH . 'wp-admin/includes/image.php');
		
		$attachment_data = wp_generate_attachment_metadata( $attachment_id, $filename );

		wp_update_attachment_metadata( $attachment_id, $attachment_data );

		if( 0 < intval( $attachment_id ) ) {
			return $attachment_id;
		}
	}

	remove_filter( 'upload_dir', 'autoroyal_upload_dir' );

	return false;
}

function autoroyal_custom_submit_image_gallery() {

	ob_start();

	$response['html'] = '';
	$response['image_url'] = '';

	//
	$attachment_id = "0";
	if ( !empty($_FILES['file']) ) {
		$file = $_FILES['file'];
		if( is_array($file) ){
			$attachment_id = upload_user_file( $file, false );
		}
	}
	//

	$response['image_id'] = $attachment_id;
	$response['image_url'] = wp_get_attachment_url( $attachment_id );
	//$response['image_url'] = $attachment_id->url;
	$response['html'] = ob_get_clean();

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_custom_submit_image_gallery', 'autoroyal_custom_submit_image_gallery' );
add_action( 'wp_ajax_nopriv_autoroyal_custom_submit_image_gallery', 'autoroyal_custom_submit_image_gallery' );

function autoroyal_check_if_leads( $email ) {

	$total = "0";
	$leads_search_args = array(
		'post_type'           => 'lead',
		'posts_per_page'      => -1,
		'post_status'         => 'publish',
		'meta_query' => array(
		    array(
		        'key' => 'lead_email',
		        'value' => $email        
		    )
		)
	);

	$leads_query = new WP_Query( $leads_search_args );
	$total    = $leads_query->found_posts;
	wp_reset_postdata();

	return $total;

}

/**
 * Resize and get url of the image
 *
 * @param  string $logo
 * @param  string $size
 * @return string
 */
function autoroyal_get_resized_image( $logo, $size ) {
	
	global $_wp_additional_image_sizes;

	if ( $size !== 'full' && strstr( $logo, WP_CONTENT_URL ) && ( isset( $_wp_additional_image_sizes[ $size ] ) || in_array( $size, array( 'thumbnail', 'medium', 'large' ) ) ) ) {

		if ( in_array( $size, array( 'thumbnail', 'medium', 'large' ) ) ) {
			$img_width  = get_option( $size . '_size_w' );
			$img_height = get_option( $size . '_size_h' );
			$img_crop   = get_option( $size . '_size_crop' );
		} else {
			$img_width  = $_wp_additional_image_sizes[ $size ]['width'];
			$img_height = $_wp_additional_image_sizes[ $size ]['height'];
			$img_crop   = $_wp_additional_image_sizes[ $size ]['crop'];
		}

		$upload_dir        = wp_upload_dir();
		$logo_path         = str_replace( array( $upload_dir['baseurl'], $upload_dir['url'], WP_CONTENT_URL ), array( $upload_dir['basedir'], $upload_dir['path'], WP_CONTENT_DIR ), $logo );
		$path_parts        = pathinfo( $logo_path );
		$resized_logo_path = str_replace( '.' . $path_parts['extension'], '-' . $img_width . 'x' . $img_height . '.' . $path_parts['extension'], $logo_path );

		if ( strstr( $resized_logo_path, 'http:' ) || strstr( $resized_logo_path, 'https:' ) ) {
			return $logo;
		}

		if ( ! file_exists( $resized_logo_path ) ) {
			ob_start();

			$image = wp_get_image_editor( $logo_path );

			if ( ! is_wp_error( $image ) ) {

				$resize = $image->resize( $img_width, $img_height, $img_crop );

			   	if ( ! is_wp_error( $resize ) ) {

			   		$save = $image->save( $resized_logo_path );

					if ( ! is_wp_error( $save ) ) {
						$logo = dirname( $logo ) . '/' . basename( $resized_logo_path );
					}
				}
			}

			ob_get_clean();
		} else {
			$logo = dirname( $logo ) . '/' . basename( $resized_logo_path );
		}
	}

	return $logo;
}

/**
 * Get the price format depending on the currency position.
 *
 * @return string
 */
function get_autoroyal_price_format() {
	$currency_pos = get_option( 'autoroyal_currency_position' );
	$format = '%1$s%2$s';

	switch ( $currency_pos ) {
		case 'left' :
			$format = '%1$s%2$s';
		break;
		case 'right' :
			$format = '%2$s%1$s';
		break;
		case 'left_space' :
			$format = '%1$s&nbsp;%2$s';
		break;
		case 'right_space' :
			$format = '%2$s&nbsp;%1$s';
		break;
	}

	return apply_filters( 'autoroyal_price_format', $format, $currency_pos );
}

/**
 * autoRoyal_get_price_thousand_separator function.
 *
 * @access public
 * @return array
 */
function autoroyal_get_price_thousand_separator() {
	$separator = apply_filters( 'autoroyal_get_price_thousand_separator', get_option( 'autoroyal_thousand_separator' ) );
	return $separator ? stripslashes( $separator ) : '.';
}

/**
 * Return the decimal separator for prices.
 * @since  2.3
 * @return string
 */
function autoroyal_get_price_decimal_separator() {
	$separator = apply_filters( 'autoroyal_get_price_decimal_separator', get_option( 'autoroyal_decimal_separator' ) );
	return $separator ? stripslashes( $separator ) : '.';
}

/**
 * Return the number of decimals after the decimal point.
 * @since  2.3
 * @return int
 */
function autoroyal_get_price_decimals() {
	$decimals = apply_filters( 'autoroyal_get_price_decimals', get_option( 'autoroyal_price_num_decimals', 2 ) );
	return absint( $decimals );
}

/**
 * Clean variables using sanitize_text_field. Arrays are cleaned recursively.
 * Non-scalar values are ignored.
 * @param string|array $var
 * @return string|array
 */
function autoroyal_clean( $var ) {
	if ( is_array( $var ) ) {
		return array_map( 'autoroyal_clean', $var );
	} else {
		return is_scalar( $var ) ? sanitize_text_field( $var ) : $var;
	}
}

/**
 * autoRoyal_format_decimal function.
 *
 * @access public
 * @return array
 */
function autoroyal_format_decimal( $number, $dp = false, $trim_zeros = false ) {
	$locale   = localeconv();
	$decimals = array( autoroyal_get_price_thousand_separator(), $locale['decimal_point'], $locale['mon_decimal_point'] );

	// Remove locale from string.
	if ( ! is_float( $number ) ) {
		$number = autoroyal_clean( str_replace( $decimals, '.', $number ) );
		$number = preg_replace( '/[^0-9\.,-]/', '', $number );
	}

	if ( false !== $dp ) {
		$dp     = intval( '' == $dp ? wc_get_price_decimals() : $dp );
		$number = number_format( floatval( $number ), $dp, '.', '' );

	// DP is false - don't use number format, just return a string in our format
	} elseif ( is_float( $number ) ) {
		$number = autoroyal_clean( str_replace( $decimals, '.', strval( $number ) ) );
	}

	if ( $trim_zeros && strstr( $number, '.' ) ) {
		$number = rtrim( rtrim( $number, '0' ), '.' );
	}

	return $number;
}

/**
 * Get Forms SSL Validation
 *
 * @return string
 */
function get_autoroyal_ssl_hide_forms() {
	return apply_filters( 'autoroyal_ssl_hide_forms', get_option( 'autoroyal_ssl_hide_forms' ) );
}

/**
 * Get Forms SSL Validation
 *
 * @return string
 */
function get_autoroyal_vehicle_forms() {
	return apply_filters( 'autoroyal_vehicle_forms', get_option( 'autoroyal_vehicle_forms' ) );
}

/**
 * Get Google Map API Key
 *
 * @return string
 */
function get_google_map_api_key() {
	return apply_filters( 'autoroyal_googlemap_key', get_option( 'autoroyal_googlemap_key' ) );
}


/**
 * Get full list of currency codes.
 *
 * @return array
 */
function get_autoroyal_currencies() {
	return array_unique(
		apply_filters( 'autoroyal_currencies',
			array(
				'AED' => __( 'United Arab Emirates dirham', 'autoroyal' ),
				'AFN' => __( 'Afghan afghani', 'autoroyal' ),
				'ALL' => __( 'Albanian lek', 'autoroyal' ),
				'AMD' => __( 'Armenian dram', 'autoroyal' ),
				'ANG' => __( 'Netherlands Antillean guilder', 'autoroyal' ),
				'AOA' => __( 'Angolan kwanza', 'autoroyal' ),
				'ARS' => __( 'Argentine peso', 'autoroyal' ),
				'AUD' => __( 'Australian dollar', 'autoroyal' ),
				'AWG' => __( 'Aruban florin', 'autoroyal' ),
				'AZN' => __( 'Azerbaijani manat', 'autoroyal' ),
				'BAM' => __( 'Bosnia and Herzegovina convertible mark', 'autoroyal' ),
				'BBD' => __( 'Barbadian dollar', 'autoroyal' ),
				'BDT' => __( 'Bangladeshi taka', 'autoroyal' ),
				'BGN' => __( 'Bulgarian lev', 'autoroyal' ),
				'BHD' => __( 'Bahraini dinar', 'autoroyal' ),
				'BIF' => __( 'Burundian franc', 'autoroyal' ),
				'BMD' => __( 'Bermudian dollar', 'autoroyal' ),
				'BND' => __( 'Brunei dollar', 'autoroyal' ),
				'BOB' => __( 'Bolivian boliviano', 'autoroyal' ),
				'BRL' => __( 'Brazilian real', 'autoroyal' ),
				'BSD' => __( 'Bahamian dollar', 'autoroyal' ),
				'BTC' => __( 'Bitcoin', 'autoroyal' ),
				'BTN' => __( 'Bhutanese ngultrum', 'autoroyal' ),
				'BWP' => __( 'Botswana pula', 'autoroyal' ),
				'BYR' => __( 'Belarusian ruble', 'autoroyal' ),
				'BZD' => __( 'Belize dollar', 'autoroyal' ),
				'CAD' => __( 'Canadian dollar', 'autoroyal' ),
				'CDF' => __( 'Congolese franc', 'autoroyal' ),
				'CHF' => __( 'Swiss franc', 'autoroyal' ),
				'CLP' => __( 'Chilean peso', 'autoroyal' ),
				'CNY' => __( 'Chinese yuan', 'autoroyal' ),
				'COP' => __( 'Colombian peso', 'autoroyal' ),
				'CRC' => __( 'Costa Rican col&oacute;n', 'autoroyal' ),
				'CUC' => __( 'Cuban convertible peso', 'autoroyal' ),
				'CUP' => __( 'Cuban peso', 'autoroyal' ),
				'CVE' => __( 'Cape Verdean escudo', 'autoroyal' ),
				'CZK' => __( 'Czech koruna', 'autoroyal' ),
				'DJF' => __( 'Djiboutian franc', 'autoroyal' ),
				'DKK' => __( 'Danish krone', 'autoroyal' ),
				'DOP' => __( 'Dominican peso', 'autoroyal' ),
				'DZD' => __( 'Algerian dinar', 'autoroyal' ),
				'EGP' => __( 'Egyptian pound', 'autoroyal' ),
				'ERN' => __( 'Eritrean nakfa', 'autoroyal' ),
				'ETB' => __( 'Ethiopian birr', 'autoroyal' ),
				'EUR' => __( 'Euro', 'autoroyal' ),
				'FJD' => __( 'Fijian dollar', 'autoroyal' ),
				'FKP' => __( 'Falkland Islands pound', 'autoroyal' ),
				'GBP' => __( 'Pound sterling', 'autoroyal' ),
				'GEL' => __( 'Georgian lari', 'autoroyal' ),
				'GGP' => __( 'Guernsey pound', 'autoroyal' ),
				'GHS' => __( 'Ghana cedi', 'autoroyal' ),
				'GIP' => __( 'Gibraltar pound', 'autoroyal' ),
				'GMD' => __( 'Gambian dalasi', 'autoroyal' ),
				'GNF' => __( 'Guinean franc', 'autoroyal' ),
				'GTQ' => __( 'Guatemalan quetzal', 'autoroyal' ),
				'GYD' => __( 'Guyanese dollar', 'autoroyal' ),
				'HKD' => __( 'Hong Kong dollar', 'autoroyal' ),
				'HNL' => __( 'Honduran lempira', 'autoroyal' ),
				'HRK' => __( 'Croatian kuna', 'autoroyal' ),
				'HTG' => __( 'Haitian gourde', 'autoroyal' ),
				'HUF' => __( 'Hungarian forint', 'autoroyal' ),
				'IDR' => __( 'Indonesian rupiah', 'autoroyal' ),
				'ILS' => __( 'Israeli new shekel', 'autoroyal' ),
				'IMP' => __( 'Manx pound', 'autoroyal' ),
				'INR' => __( 'Indian rupee', 'autoroyal' ),
				'IQD' => __( 'Iraqi dinar', 'autoroyal' ),
				'IRR' => __( 'Iranian rial', 'autoroyal' ),
				'IRT' => __( 'Iranian toman', 'autoroyal' ),
				'ISK' => __( 'Icelandic kr&oacute;na', 'autoroyal' ),
				'JEP' => __( 'Jersey pound', 'autoroyal' ),
				'JMD' => __( 'Jamaican dollar', 'autoroyal' ),
				'JOD' => __( 'Jordanian dinar', 'autoroyal' ),
				'JPY' => __( 'Japanese yen', 'autoroyal' ),
				'KES' => __( 'Kenyan shilling', 'autoroyal' ),
				'KGS' => __( 'Kyrgyzstani som', 'autoroyal' ),
				'KHR' => __( 'Cambodian riel', 'autoroyal' ),
				'KMF' => __( 'Comorian franc', 'autoroyal' ),
				'KPW' => __( 'North Korean won', 'autoroyal' ),
				'KRW' => __( 'South Korean won', 'autoroyal' ),
				'KWD' => __( 'Kuwaiti dinar', 'autoroyal' ),
				'KYD' => __( 'Cayman Islands dollar', 'autoroyal' ),
				'KZT' => __( 'Kazakhstani tenge', 'autoroyal' ),
				'LAK' => __( 'Lao kip', 'autoroyal' ),
				'LBP' => __( 'Lebanese pound', 'autoroyal' ),
				'LKR' => __( 'Sri Lankan rupee', 'autoroyal' ),
				'LRD' => __( 'Liberian dollar', 'autoroyal' ),
				'LSL' => __( 'Lesotho loti', 'autoroyal' ),
				'LYD' => __( 'Libyan dinar', 'autoroyal' ),
				'MAD' => __( 'Moroccan dirham', 'autoroyal' ),
				'MDL' => __( 'Moldovan leu', 'autoroyal' ),
				'MGA' => __( 'Malagasy ariary', 'autoroyal' ),
				'MKD' => __( 'Macedonian denar', 'autoroyal' ),
				'MMK' => __( 'Burmese kyat', 'autoroyal' ),
				'MNT' => __( 'Mongolian t&ouml;gr&ouml;g', 'autoroyal' ),
				'MOP' => __( 'Macanese pataca', 'autoroyal' ),
				'MRO' => __( 'Mauritanian ouguiya', 'autoroyal' ),
				'MUR' => __( 'Mauritian rupee', 'autoroyal' ),
				'MVR' => __( 'Maldivian rufiyaa', 'autoroyal' ),
				'MWK' => __( 'Malawian kwacha', 'autoroyal' ),
				'MXN' => __( 'Mexican peso', 'autoroyal' ),
				'MYR' => __( 'Malaysian ringgit', 'autoroyal' ),
				'MZN' => __( 'Mozambican metical', 'autoroyal' ),
				'NAD' => __( 'Namibian dollar', 'autoroyal' ),
				'NGN' => __( 'Nigerian naira', 'autoroyal' ),
				'NIO' => __( 'Nicaraguan c&oacute;rdoba', 'autoroyal' ),
				'NOK' => __( 'Norwegian krone', 'autoroyal' ),
				'NPR' => __( 'Nepalese rupee', 'autoroyal' ),
				'NZD' => __( 'New Zealand dollar', 'autoroyal' ),
				'OMR' => __( 'Omani rial', 'autoroyal' ),
				'PAB' => __( 'Panamanian balboa', 'autoroyal' ),
				'PEN' => __( 'Peruvian nuevo sol', 'autoroyal' ),
				'PGK' => __( 'Papua New Guinean kina', 'autoroyal' ),
				'PHP' => __( 'Philippine peso', 'autoroyal' ),
				'PKR' => __( 'Pakistani rupee', 'autoroyal' ),
				'PLN' => __( 'Polish z&#x142;oty', 'autoroyal' ),
				'PRB' => __( 'Transnistrian ruble', 'autoroyal' ),
				'PYG' => __( 'Paraguayan guaran&iacute;', 'autoroyal' ),
				'QAR' => __( 'Qatari riyal', 'autoroyal' ),
				'RON' => __( 'Romanian leu', 'autoroyal' ),
				'RSD' => __( 'Serbian dinar', 'autoroyal' ),
				'RUB' => __( 'Russian ruble', 'autoroyal' ),
				'RWF' => __( 'Rwandan franc', 'autoroyal' ),
				'SAR' => __( 'Saudi riyal', 'autoroyal' ),
				'SBD' => __( 'Solomon Islands dollar', 'autoroyal' ),
				'SCR' => __( 'Seychellois rupee', 'autoroyal' ),
				'SDG' => __( 'Sudanese pound', 'autoroyal' ),
				'SEK' => __( 'Swedish krona', 'autoroyal' ),
				'SGD' => __( 'Singapore dollar', 'autoroyal' ),
				'SHP' => __( 'Saint Helena pound', 'autoroyal' ),
				'SLL' => __( 'Sierra Leonean leone', 'autoroyal' ),
				'SOS' => __( 'Somali shilling', 'autoroyal' ),
				'SRD' => __( 'Surinamese dollar', 'autoroyal' ),
				'SSP' => __( 'South Sudanese pound', 'autoroyal' ),
				'STD' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe dobra', 'autoroyal' ),
				'SYP' => __( 'Syrian pound', 'autoroyal' ),
				'SZL' => __( 'Swazi lilangeni', 'autoroyal' ),
				'THB' => __( 'Thai baht', 'autoroyal' ),
				'TJS' => __( 'Tajikistani somoni', 'autoroyal' ),
				'TMT' => __( 'Turkmenistan manat', 'autoroyal' ),
				'TND' => __( 'Tunisian dinar', 'autoroyal' ),
				'TOP' => __( 'Tongan pa&#x2bb;anga', 'autoroyal' ),
				'TRY' => __( 'Turkish lira', 'autoroyal' ),
				'TTD' => __( 'Trinidad and Tobago dollar', 'autoroyal' ),
				'TWD' => __( 'New Taiwan dollar', 'autoroyal' ),
				'TZS' => __( 'Tanzanian shilling', 'autoroyal' ),
				'UAH' => __( 'Ukrainian hryvnia', 'autoroyal' ),
				'UGX' => __( 'Ugandan shilling', 'autoroyal' ),
				'USD' => __( 'United States dollar', 'autoroyal' ),
				'UYU' => __( 'Uruguayan peso', 'autoroyal' ),
				'UZS' => __( 'Uzbekistani som', 'autoroyal' ),
				'VEF' => __( 'Venezuelan bol&iacute;var', 'autoroyal' ),
				'VND' => __( 'Vietnamese &#x111;&#x1ed3;ng', 'autoroyal' ),
				'VUV' => __( 'Vanuatu vatu', 'autoroyal' ),
				'WST' => __( 'Samoan t&#x101;l&#x101;', 'autoroyal' ),
				'XAF' => __( 'Central African CFA franc', 'autoroyal' ),
				'XCD' => __( 'East Caribbean dollar', 'autoroyal' ),
				'XOF' => __( 'West African CFA franc', 'autoroyal' ),
				'XPF' => __( 'CFP franc', 'autoroyal' ),
				'YER' => __( 'Yemeni rial', 'autoroyal' ),
				'ZAR' => __( 'South African rand', 'autoroyal' ),
				'ZMW' => __( 'Zambian kwacha', 'autoroyal' ),
			)
		)
	);
}

// Add Menu Order
add_action( 'admin_init', 'posts_order_wpse_91866' );

function posts_order_wpse_91866() {
    add_post_type_support( 'post', 'page-attributes' );
}

/**
 * Maybe set menu_order if the featured status of a car is changed
 */
function autoroyal_update_menu_order( $object_id, $meta_key, $meta_value ) {
	global $wpdb;

	if ( '1' == $meta_value ) {
		$wpdb->update( $wpdb->posts, array( 'menu_order' => -1 ), array( 'ID' => $object_id ) );
	} else {
		$wpdb->update( $wpdb->posts, array( 'menu_order' => 0 ), array( 'ID' => $object_id, 'menu_order' => -1 ) );
	}

	clean_post_cache( $object_id );
}

/**
 * Format the price with a currency symbol.
 *
 * @param float $price
 * @param array $args (default: array())
 * @return string
 */
function autoroyal_price( $price, $args = array() ) {
	extract( apply_filters( 'autoroyal_price_args', wp_parse_args( $args, array(
		'ex_tax_label'       => false,
		'currency'           => '',
		'decimal_separator'  => autoroyal_get_price_decimal_separator(),
		'thousand_separator' => autoroyal_get_price_thousand_separator(),
		'decimals'           => autoroyal_get_price_decimals(),
		'price_format'       => get_autoroyal_price_format(),
	) ) ) );

	$negative        = $price < 0;
	$price           = apply_filters( 'raw_autoroyal_price', floatval( $negative ? $price * -1 : $price ) );
	$price           = apply_filters( 'formatted_autoroyal_price', number_format( $price, $decimals, $decimal_separator, $thousand_separator ), $price, $decimals, $decimal_separator, $thousand_separator );

	$formatted_price = ( $negative ? '-' : '' ) . sprintf( $price_format, '<span class="autoroyal-Price-currencySymbol">' . autoroyal_get_currency_symbol( $currency ) . '</span>', $price );
	$return          = '<span class="autoroyal-Price-amount amount">' . $formatted_price . '</span>';


	return apply_filters( 'autoroyal_price', $return, $price, $args );
}

/**
 * Format the price with a currency symbol.
 *
 * @param float $price
 * @param array $args (default: array())
 * @return string
 */
function autoroyal_clean_price( $price, $args = array() ) {
	extract( apply_filters( 'autoroyal_clean_price_args', wp_parse_args( $args, array(
		'ex_tax_label'       => false,
		'currency'           => '',
		'decimal_separator'  => autoroyal_get_price_decimal_separator(),
		'thousand_separator' => autoroyal_get_price_thousand_separator(),
		'decimals'           => autoroyal_get_price_decimals(),
		'price_format'       => get_autoroyal_price_format(),
	) ) ) );

	$negative        = $price < 0;
	$price           = apply_filters( 'raw_autoroyal_price', floatval( $negative ? $price * -1 : $price ) );
	$price           = apply_filters( 'formatted_autoroyal_price', number_format( $price, $decimals, $decimal_separator, $thousand_separator ), $price, $decimals, $decimal_separator, $thousand_separator );

	$formatted_price = ( $negative ? '-' : '' ) . sprintf( $price_format,  autoroyal_get_currency_symbol( $currency ), $price );
	$return          = $formatted_price;


	return apply_filters( 'autoroyal_clean_price', $return, $price, $args );
}

/**
 * Format the thousand number.
 *
 * @param float $number
 * @param array $args (default: array())
 * @return string
 */
function autoroyal_number( $number, $args = array() ) {
	extract( apply_filters( 'autoroyal_number_args', wp_parse_args( $args, array(
		'thousand_separator' => autoroyal_get_price_thousand_separator(),
	) ) ) );

	$decimals           = get_option( 'autoroyal_price_num_decimals' );
	$decimal_separator  = get_option( 'autoroyal_decimal_separator' );
	$thousand_separator = get_option( 'autoroyal_thousand_separator' );
	$negative           = $number < 0;
	$number             = apply_filters( 'raw_autoroyal_number', floatval( $negative ? $number * -1 : $number ) );
	$number             = apply_filters( 'formatted_autoroyal_number', number_format( $number, $decimals, $decimal_separator, $thousand_separator ), $number, $decimals, $decimal_separator, $thousand_separator );

	$return             = $number;


	return apply_filters( 'autoroyal_number', $return, $number, $args );
}


function cd_category_has_children( $term_ID ) {

	global $wpdb;
	$category_children_check = $wpdb->get_results(" SELECT * FROM {$wpdb->prefix}term_taxonomy WHERE parent = '$term_ID' ");

 	if ($category_children_check) {
      	return true;
 	} else {
      	return false;
 	}

}

if ( defined( 'autoroyal_USE_WPMAIL' ) ) {
	add_filter( 'wp_mail_content_type', 'cd_set_content_type' );
	function cd_set_content_type( $content_type ) {
		return 'text/html; charset=ISO-8859-1';
	}
}

/**
 * True if an the user can edit a car.
 *
 * @return bool
 */
function autoroyal_user_can_edit_car( $car_id ) {
	$can_edit = true;

	if ( ! is_user_logged_in() || ! $car_id ) {
		$can_edit = false;
	} else {
		$car      = get_post( $car_id );

		if ( ! $car || ( absint( $car->post_author ) !== get_current_user_id() && ! current_user_can( 'edit_post', $car_id ) ) ) {
			$can_edit = false;
		}
	}

	return apply_filters( 'autoroyal_user_can_edit_car', $can_edit, $car_id );
}

if ( ! function_exists( 'autoroyal_search' ) ) {
	/**
	 * Properties Search Filter
	 *
	 * @param $search_args
	 * @return mixed
	 */
	function autoroyal_search( $search_args ) {

		$tax_query = array();   // taxonomy query array
		$meta_query = array();  // meta query qrray

		/* Keyword Based Search */
		if ( isset ( $_GET[ 'keyword' ] ) ) {
			$keyword = trim( $_GET[ 'keyword' ] );
			if ( ! empty( $keyword ) ) {
				$search_args[ 's' ] = $keyword;
			}
		}

		/* Filter by */
		if ( ( ! empty( $_GET[ 'filterby' ] ) ) && ( $_GET[ 'filterby' ] != 'all' ) && ( $_GET[ 'filterby' ] != 'Sold' ) && ( $_GET[ 'filterby' ] != 'Featured' )  && ( $_GET[ 'filterby' ] != 'Promoted' )  && ( $_GET[ 'filterby' ] != 'Pending' )  && ( $_GET[ 'filterby' ] != 'For_Rent' )  && ( $_GET[ 'filterby' ] != 'Draft' ) ) {
			$meta_query[] = array(
				'key' => 'vehicle_condition',
				'value' => $_GET[ 'filterby' ],
			);
		}

		if ( ( ! empty( $_GET[ 'filterby' ] ) ) && ( $_GET[ 'filterby' ] == 'Sold' ) ) {
			$meta_query[] = array(
				'key' => '_sold',
				'value' => 1,
			);
		} else {
			$meta_query[] = array(
				'key' => '_sold',
				'value' => 0,
			);
		}

		if ( ( ! empty( $_GET[ 'filterby' ] ) ) && ( $_GET[ 'filterby' ] == 'Featured' ) ) {
			$meta_query[] = array(
				'key' => '_featured',
				'value' => 1,
			);
		}

		if ( ( ! empty( $_GET[ 'filterby' ] ) ) && ( $_GET[ 'filterby' ] == 'Promoted' ) ) {
			$meta_query[] = array(
				'key' => '_promoted',
				'value' => 1,
			);
		}

		if ( ( ! empty( $_GET[ 'filterby' ] ) ) && ( $_GET[ 'filterby' ] == 'For_Rent' ) ) {
			$meta_query[] = array(
				'key' => 'vehicle_for_rent',
				'value' => 1,
			);
		}

		/* Sort By Year */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'year_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_year';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'year_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_year';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Make */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'make_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'vehicle_make';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'make_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'vehicle_make';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Model */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'model_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'vehicle_model';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'model_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'vehicle_model';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Mileage */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'mileage_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_mileage';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'mileage_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_mileage';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Cost */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'cost_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_cost';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'cost_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_cost';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Price */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'price_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_price';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'price_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_price';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Price */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'age_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'date';
			$search_args[ 'order' ] = 'DESC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'age_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'date';
			$search_args[ 'order' ] = 'ASC';
		}


		/* if more than one taxonomies exist then specify the relation */
		$tax_count = count( $tax_query );
		if ( $tax_count > 1 ) {
			$tax_query[ 'relation' ] = 'AND';
		}

		/* if more than one meta query elements exist then specify the relation */
		$meta_count = count( $meta_query );
		if ( $meta_count > 1 ) {
			$meta_query[ 'relation' ] = 'AND';
		}

		if ( $tax_count > 0 ) {
			$search_args[ 'tax_query' ] = $tax_query;
		}

		/* if meta query has some values then add it to base home page query */
		if ( $meta_count > 0 ) {
			$search_args[ 'meta_query' ] = $meta_query;
		}

		return $search_args;
	}

	add_filter( 'autoroyal_search_parameters', 'autoroyal_search' );
}

if ( ! function_exists( 'autoroyal_leads_search' ) ) {
	/**
	 * Properties Search Filter
	 *
	 * @param $search_args
	 * @return mixed
	 */
	function autoroyal_leads_search( $search_args ) {

		$tax_query = array();   // taxonomy query array
		$meta_query = array();  // meta query qrray

		/* Sort By Year */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'date_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'date';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'date_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'date';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Make */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'name_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'name';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'name_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'name';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Model */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'sku_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'lead_vehicle_sku';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'sku_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'lead_vehicle_sku';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Mileage */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'status_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_status';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'status_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_status';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Cost */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'uptype_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_up_type';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'uptype_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_up_type';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Price */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'adsource_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_ad_source';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'adsource_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_ad_source';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Price */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'webleadtype_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_websiteleadtype';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'webleadtype_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_websiteleadtype';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Price */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'appointment_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_appointment_strtotime';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'appointment_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_appointment_strtotime';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Price */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'phone_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_mobile_phone';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'phone_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'lead_mobile_phone';
			$search_args[ 'order' ] = 'DESC';
		}

		/* if more than one taxonomies exist then specify the relation */
		$tax_count = count( $tax_query );
		if ( $tax_count > 1 ) {
			$tax_query[ 'relation' ] = 'AND';
		}

		/* if more than one meta query elements exist then specify the relation */
		$meta_count = count( $meta_query );
		if ( $meta_count > 1 ) {
			$meta_query[ 'relation' ] = 'AND';
		}

		if ( $tax_count > 0 ) {
			$search_args[ 'tax_query' ] = $tax_query;
		}

		/* if meta query has some values then add it to base home page query */
		if ( $meta_count > 0 ) {
			$search_args[ 'meta_query' ] = $meta_query;
		}

		return $search_args;
	}

	add_filter( 'autoroyal_leads_search_parameters', 'autoroyal_leads_search' );
}

if ( ! function_exists( 'autoroyal_reservations_search' ) ) {
	/**
	 * Properties Search Filter
	 *
	 * @param $search_args
	 * @return mixed
	 */
	function autoroyal_reservations_search( $search_args ) {

		$tax_query = array();   // taxonomy query array
		$meta_query = array();  // meta query qrray

		/* Sort By Year */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'date_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'date';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'date_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'date';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Rent Sort By Status */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'rent_status_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'rent_status';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'rent_status_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'rent_status';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Rent Sort By Name */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'rent_name_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'rent_first_name';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'rent_name_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'rent_first_name';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Rent Sort By Pickup Location */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'pickuplocation_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'pickup_location';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'pickuplocation_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'pickup_location';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Rent Sort By Pickup Date */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'pickupdate_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'pickup_date';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'pickupdate_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'pickup_date';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Rent Sort By Pickup Time */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'pickuptime_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'pickup_time';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'pickuptime_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'pickup_time';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Rent Sort By Return Location */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'returnlocation_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'return_location';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'returnlocation_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'return_location';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Rent Sort By Return Date */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'returndate_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'return_date';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'returndate_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'return_date';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Rent Sort By Return Time */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'returntime_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'return_time';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'returntime_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'return_time';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Rent Sort By Renting Days */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'days_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'reserv_car_days';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'days_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'reserv_car_days';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Rent Sort By Renting Total Price */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'price_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'total_price';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'price_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'total_price';
			$search_args[ 'order' ] = 'DESC';
		}

		/* if more than one taxonomies exist then specify the relation */
		$tax_count = count( $tax_query );
		if ( $tax_count > 1 ) {
			$tax_query[ 'relation' ] = 'AND';
		}

		/* if more than one meta query elements exist then specify the relation */
		$meta_count = count( $meta_query );
		if ( $meta_count > 1 ) {
			$meta_query[ 'relation' ] = 'AND';
		}

		if ( $tax_count > 0 ) {
			$search_args[ 'tax_query' ] = $tax_query;
		}

		/* if meta query has some values then add it to base home page query */
		if ( $meta_count > 0 ) {
			$search_args[ 'meta_query' ] = $meta_query;
		}

		return $search_args;
	}

	add_filter( 'autoroyal_reservations_search_parameters', 'autoroyal_reservations_search' );
}

if ( ! function_exists( 'autoroyal_deals_search' ) ) {
	/**
	 * Properties Search Filter
	 *
	 * @param $search_args
	 * @return mixed
	 */
	function autoroyal_deals_search( $search_args ) {

		$tax_query = array();   // taxonomy query array
		$meta_query = array();  // meta query qrray

		/* Sort By Year */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'date_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'date';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'date_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'date';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Make */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'name_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'name';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'name_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'name';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Vehicle SKU */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'sku_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_vehicle_sku';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'sku_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_vehicle_sku';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Vehicle Name */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'vehicle_name_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_vehicle_name';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'vehicle_name_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_vehicle_name';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Vehicle Price */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'price_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_vehicle_price';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'price_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_vehicle_price';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Vehicle Profit */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'profit_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_vehicle_profit';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'profit_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_vehicle_profit';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Vehicle Age */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'age_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_vehicle_age';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'age_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_vehicle_age';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Vehicle Next Payment */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'next_payment_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_loan_next_payments_date';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'next_payment_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'deal_loan_next_payments_date';
			$search_args[ 'order' ] = 'DESC';
		}

		/* if more than one taxonomies exist then specify the relation */
		$tax_count = count( $tax_query );
		if ( $tax_count > 1 ) {
			$tax_query[ 'relation' ] = 'AND';
		}

		/* if more than one meta query elements exist then specify the relation */
		$meta_count = count( $meta_query );
		if ( $meta_count > 1 ) {
			$meta_query[ 'relation' ] = 'AND';
		}

		if ( $tax_count > 0 ) {
			$search_args[ 'tax_query' ] = $tax_query;
		}

		/* if meta query has some values then add it to base home page query */
		if ( $meta_count > 0 ) {
			$search_args[ 'meta_query' ] = $meta_query;
		}

		return $search_args;
	}

	add_filter( 'autoroyal_deals_search_parameters', 'autoroyal_deals_search' );
}


/**
 * Duplicate a listing.
 * @param  int $post_id
 * @return int 0 on fail or the post ID.
 */
function autoroyal_duplicate_listing( $post_id ) {
	if ( empty( $post_id ) || ! ( $post = get_post( $post_id ) ) ) {
		return 0;
	}

	global $wpdb;

	/**
	 * Duplicate the post.
	 */
	$new_post_id = wp_insert_post( array(
		'comment_status' => $post->comment_status,
		'ping_status'    => $post->ping_status,
		'post_author'    => $post->post_author,
		'post_content'   => $post->post_content,
		'post_excerpt'   => $post->post_excerpt,
		'post_name'      => $post->post_name,
		'post_parent'    => $post->post_parent,
		'post_password'  => $post->post_password,
		'post_status'    => 'draft',
		'post_title'     => $post->post_title,
		'post_type'      => $post->post_type,
		'to_ping'        => $post->to_ping,
		'menu_order'     => $post->menu_order
	) );

	/**
	 * Copy taxonomies.
	 */
	$taxonomies = get_object_taxonomies( $post->post_type );

	foreach ( $taxonomies as $taxonomy ) {
		$post_terms = wp_get_object_terms( $post_id, $taxonomy, array( 'fields' => 'slugs' ) );
		wp_set_object_terms( $new_post_id, $post_terms, $taxonomy, false );
	}

	/*
	 * Duplicate post meta, aside from some reserved fields.
	 */
	$post_meta = $wpdb->get_results( $wpdb->prepare( "SELECT meta_key, meta_value FROM {$wpdb->postmeta} WHERE post_id=%d", $post_id ) );

	if ( ! empty( $post_meta ) ) {
		$post_meta = wp_list_pluck( $post_meta, 'meta_value', 'meta_key' );
		foreach ( $post_meta as $meta_key => $meta_value ) {
			if ( in_array( $meta_key, apply_filters( 'autoroyal_duplicate_listing_ignore_keys', array( '_sold', '_submit_fee', '_promoted', 'vehicle_for_rent', '_featured', '_paid_featured', 'vehicle_expenses', 'vehicle_image_gallery', 'vehicle_image_extended_gallery' ) ) ) ) {
				continue;
			}
			update_post_meta( $new_post_id, $meta_key, $meta_value );
		}
	}

	$vehicle_image_gallery = get_post_meta($post_id, 'vehicle_image_gallery',true);
	$vehicle_image_extended_gallery = get_post_meta($post_id, 'vehicle_image_extended_gallery',true);
	$vehicle_expenses = get_post_meta($post_id, 'vehicle_expenses',true);

	update_post_meta( $new_post_id, 'vehicle_image_gallery', $vehicle_image_gallery );
	update_post_meta( $new_post_id, 'vehicle_image_extended_gallery', $vehicle_image_extended_gallery );
	update_post_meta( $new_post_id, 'vehicle_expenses', $vehicle_expenses );

	update_post_meta( $new_post_id, '_sold', 0 );
	update_post_meta( $new_post_id, '_promoted', 0 );
	update_post_meta( $new_post_id, '_featured', 0 );
	update_post_meta( $new_post_id, '_paid_featured', 0 );
	update_post_meta( $new_post_id, '_sold_date', "" );
	update_post_meta( $new_post_id, '_submit_fee', 0 );
	update_post_meta( $new_post_id, 'vehicle_for_rent', 0 );

	return $new_post_id;
}

/**
 * Get the page ID of a page if set, with PolyLang compat.
 * @param  string $page e.g. car_dashboard, submit_car_form, cars
 * @return int
 */
function autoroyal_get_page_id( $page ) {
	$page_id = get_option( 'autoroyal_' . $page . '_page_id', false );
	if ( $page_id ) {
		return apply_filters( 'wpml_object_id', absint( function_exists( 'pll_get_post' ) ? pll_get_post( $page_id ) : $page_id ), 'page', TRUE );
	} else {
		return 0;
	}
}

/**
 * Get the permalink of a page if set
 * @param  string $page e.g. car_dashboard, submit_car_form, cars
 * @return string|bool
 */
function autoroyal_get_permalink( $page ) {
	if ( $page_id = autoroyal_get_page_id( $page ) ) {
		return get_permalink( $page_id );
	} else {
		return false;
	}
}


/**
 * Class wrapper for Front End Media example
 */
class Front_End_Media {

	/**
	 * A simple call to init when constructed
	 */
	function __construct() {
		add_action( 'init', array( $this, 'init' ) );
	}

	function init() {
		load_plugin_textdomain(
			'frontend-media',
			false,
			dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_filter( 'ajax_query_attachments_args', array( $this, 'filter_media' ) );
		add_shortcode( 'frontend-button', array( $this, 'frontend_shortcode' ) );
	}

	/**
	 * Call wp_enqueue_media() to load up all the scripts we need for media uploader
	 */
	function enqueue_scripts() {
		wp_enqueue_media();
	}

	/**
	 * This filter insures users only see their own media
	 */
	function filter_media( $query ) {
		// admins get to see everything
		if ( ! current_user_can( 'manage_options' ) )
			$query['author'] = get_current_user_id();

		return $query;
	}

	function frontend_shortcode( $args ) {
		// check if user can upload files
		if ( current_user_can( 'upload_files' ) ) {
			$str = __( 'Select File', 'autoroyal' );
			return '<input id="frontend-button" type="button" value="' . $str . '" class="button" style="position: relative; z-index: 1;"><img id="frontend-image" />';
		}

		return __( 'Please Login To Upload', 'autoroyal' );
	}
}

new Front_End_Media();

// Update _sold and _submit_fee meta on post creation
//add_action( 'transition_post_status', 'autoroyal_add_sold_meta_on_post_creation', 10, 3 );
function autoroyal_add_sold_meta_on_post_creation( $new_status, $old_status, $post ) {
    if ( 'publish' !== $new_status )
        return;

    $subject = 'publish' === $old_status
        ? __( 'Edited: %s', 'autoroyal' )
        : __( 'New post: %s', 'autoroyal' );

    $post_id = $post->ID;
    update_post_meta($post_id, '_sold', 0);
    update_post_meta($post_id, '_submit_fee', 0);
    autoroyal_send_vehicle_notifications( $post_id );
}

// Get Total Vehicles of current author
function autoroyal_get_total_cars() {

	
	$search_args = array(
		'post_type'           => 'vehicle',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish' ),
		'author'              => get_current_user_id(),
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Total vehicles all users
function autoroyal_get_total_cars_all_users() {

	$search_args = array(
		'post_type'           => 'vehicle',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish' ),
		'meta_query' => array(
		    array(
		        'key' => '_sold',
		        'value' => 0
		    )
		)
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Total vehicles by users
function autoroyal_get_total_cars_all_by_user( $user_id ) {

	$search_args = array(
		'post_type'           => 'vehicle',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish' ),
		'author'              => $user_id,
		'meta_query' => array(
		    array(
		        'key' => '_sold',
		        'value' => 0
		    )
		)
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Total vehicles by users
function autoroyal_get_total_featured_cars_all_by_user( $user_id ) {

	$search_args = array(
		'post_type'           => 'vehicle',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish' ),
		'author'              => $user_id,
		'meta_query' => array(
			'relation' => 'AND',
		    array(
		        'key' => '_sold',
		        'value' => 0,
		    ),
		    array(
		        'key' => '_featured',
		        'value' => 1,
		    ),
		)
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Total cars dashboard
function autoroyal_get_total_cars_all() {

	
	$search_args = array(
		'post_type'           => 'vehicle',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish', 'pending', 'draft' ),
		'author'              => get_current_user_id(),
		'meta_query' => array(
		    array(
		        'key' => '_sold',
		        'value' => 0
		    )
		)
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Average Photots
function autoroyal_get_avg_photos() {

	$i = 0;

	$search_args = array(
		'post_type'           => 'vehicle',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish', 'pending', 'draft' ),
		'author'              => get_current_user_id(),
		'meta_query' => array(
		    array(
		        'key' => '_sold',
		        'value' => 0
		    )
		)
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_image_gallery = get_post_meta(get_the_ID(), 'vehicle_image_gallery',true);
			$vehicle_image_extended_gallery = get_post_meta(get_the_ID(), 'vehicle_image_extended_gallery',true);

			if(!empty($vehicle_image_gallery)) {

				foreach ($vehicle_image_gallery as $vehicle_image_gallery_item) {
					
					if( !empty($vehicle_image_gallery_item['url']) ) {
						$i++;
					}

				}

			}

			if(!empty($vehicle_image_extended_gallery)) {

				foreach ($vehicle_image_extended_gallery as $vehicle_image_extended_gallery_item) {
					
					if( !empty($vehicle_image_extended_gallery_item['url']) ) {
						$i++;
					}

				}

			}

		endwhile;

	endif; wp_reset_postdata();

	if( $total != 0 ) {
		$avg_photos = $i / $total;
	} else {
		$avg_photos = $i;
	}

	wp_reset_postdata();

	return $avg_photos;

}

// Average Photots
function autoroyal_get_total_photos_by_car( $card_ID ) {

	$i = 0;
	$results = array();
	$images = array();

	$vehicle_image_gallery = get_post_meta($card_ID, 'vehicle_image_gallery',true);
	$vehicle_image_extended_gallery = get_post_meta($card_ID, 'vehicle_image_extended_gallery',true);

	if(!empty($vehicle_image_gallery)) {

		foreach ($vehicle_image_gallery as $vehicle_image_gallery_item) {
			
			if( !empty($vehicle_image_gallery_item['url']) ) {
				$i++;
				$images[] = $vehicle_image_gallery_item['url'];
			}

		}

	}

	if(!empty($vehicle_image_extended_gallery)) {

		foreach ($vehicle_image_extended_gallery as $vehicle_image_extended_gallery_item) {
			
			if( !empty($vehicle_image_extended_gallery_item['url']) ) {
				$i++;
				$images[] = $vehicle_image_extended_gallery_item['url'];
			}

		}

	}

	$results['total'] = $i;
	$results['images'] = $images;
	wp_reset_postdata();

	return $results;

}

// Average Mileage
function autoroyal_get_avg_mileage() {

	$i = 0;

	
	$search_args = array(
		'post_type'           => 'vehicle',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish', 'pending', 'draft' ),
		'author'              => get_current_user_id(),
		'meta_query' => array(
		    array(
		        'key' => '_sold',
		        'value' => 0
		    )
		)
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_mileage = get_post_meta(get_the_ID(), 'vehicle_mileage',true);
			if(!empty($vehicle_mileage)) {
				$i = $i + $vehicle_mileage;
			}

		endwhile;

	endif; wp_reset_postdata();

	if( $total != 0 ) {
		$avg_mileage = $i / $total;
	} else {
		$avg_mileage = $i;
	}

	wp_reset_postdata();

	return $avg_mileage;

}

// Average Days
function autoroyal_get_avg_days() {

	$i = 0;

	$search_args = array(
		'post_type'           => 'vehicle',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish' ),
		'author'              => get_current_user_id(),
		'meta_query' => array(
		    array(
		        'key' => '_sold',
		        'value' => 0
		    )
		)
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;
	$cars = 0;

	$format = get_option('date_format');

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$pfx_date = get_the_date( $format, get_the_ID() ); 
			$sold = esc_attr(get_post_meta(get_the_ID(), '_sold_date',true));

			if(!empty($sold)) {
				$now = $sold;
			} else {
				$now = strtotime(date("Y-m-d H:i:s")); 
			}

			$days = ($now - strtotime($pfx_date)) / (60 * 60 * 24); 
			$i = $i + round($days);

			$cars++;

		endwhile;

	endif; wp_reset_postdata();

	if( $total != 0 ) {
		$avg_days = $i / $total;
	} else {
		$avg_days = $i;
	}

	wp_reset_postdata();

	return round($avg_days);

}

// Average Cost
function autoroyal_get_avg_cost() {

	$i = 0;

	
	$search_args = array(
		'post_type'           => 'vehicle',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish', 'pending', 'draft' ),
		'author'              => get_current_user_id(),
		'meta_query' => array(
		    array(
		        'key' => '_sold',
		        'value' => 0
		    )
		)
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_cost = esc_attr(get_post_meta(get_the_ID(), 'vehicle_cost',true));
			$i = $i + $vehicle_cost;

		endwhile;

	endif; wp_reset_postdata();

	if( $total != 0 ) {
		$avg_cost = $i / $total;
	} else {
		$avg_cost = $i;
	}

	wp_reset_postdata();

	return $avg_cost;

}

// Total Cost
function autoroyal_get_total_cost() {

	$i = 0;

	
	$search_args = array(
		'post_type'           => 'vehicle',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish' ),
		'author'              => get_current_user_id(),
		'meta_query' => array(
		    array(
		        'key' => '_sold',
		        'value' => 0
		    )
		)
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_cost = esc_attr(get_post_meta(get_the_ID(), 'vehicle_cost',true));
			if(!empty($vehicle_cost)){
				$i = $i + $vehicle_cost;	
			}

		endwhile;

	endif; 
	wp_reset_postdata();

	return $i;

}


// New Leads
function autoroyal_get_new_leads() {

	
	$search_args = array(
		'post_type'           => 'lead',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish' ),
		'author'              => get_current_user_id(),
		'tax_query' => array(
			array(
				'taxonomy' => 'lead_status',
				'field'    => 'slug',
				'terms'    => 'new',
			),
		),
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Total Leads
function autoroyal_get_total_leads() {

	$total = "0";
	$leads_search_args = array(
		'post_type'           => 'lead',
		'posts_per_page'      => -1,
		'post_status'         => 'publish',
		'author'              => get_current_user_id()
	);

	$leads_query = new WP_Query( $leads_search_args );
	$total    = $leads_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Total New Reservations
function autoroyal_get_total_new_reservations() {

	$total = "0";
	$leads_search_args = array(
		'post_type'           => 'rent',
		'posts_per_page'      => -1,
		'post_status'         => 'publish',
		'meta_query' => array(
            'relation' => 'AND',
            array(
                'key'     => 'rent_status',
                'value'   => 'New'
            )
        )
	);

	$leads_query = new WP_Query( $leads_search_args );
	$total    = $leads_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Total In Progress Reservations
function autoroyal_get_total_inprogress_reservations() {

	$total = "0";
	$leads_search_args = array(
		'post_type'           => 'rent',
		'posts_per_page'      => -1,
		'post_status'         => 'publish',
		'meta_query' => array(
            'relation' => 'AND',
            array(
                'key'     => 'rent_status',
                'value'   => 'Picked Up'
            )
        )
	);

	$leads_query = new WP_Query( $leads_search_args );
	$total    = $leads_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Total Reservations
function autoroyal_get_total_reservations() {

	$total = "0";
	$leads_search_args = array(
		'post_type'           => 'rent',
		'posts_per_page'      => -1,
		'post_status'         => 'publish',
	);

	$leads_query = new WP_Query( $leads_search_args );
	$total    = $leads_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Floor Leads
function autoroyal_get_floor_leads() {

	
	$search_args = array(
		'post_type'           => 'lead',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish' ),
		'author'              => get_current_user_id(),
		'tax_query' => array(
			array(
				'taxonomy' => 'lead_up_type',
				'field'    => 'slug',
				'terms'    => 'floor-up',
			),
		),
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Floor Leads
function autoroyal_get_internet_leads() {

	
	$search_args = array(
		'post_type'           => 'lead',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish' ),
		'author'              => get_current_user_id(),
		'tax_query' => array(
			array(
				'taxonomy' => 'lead_up_type',
				'field'    => 'slug',
				'terms'    => 'internet-up',
			),
		),
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Floor Leads
function autoroyal_get_phone_leads() {

	
	$search_args = array(
		'post_type'           => 'lead',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish' ),
		'author'              => get_current_user_id(),
		'tax_query' => array(
			array(
				'taxonomy' => 'lead_up_type',
				'field'    => 'slug',
				'terms'    => 'phone-up',
			),
		),
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Total Deals
function autoroyal_get_total_deals() {

	
	$search_args = array(
		'post_type'           => 'deal',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish', 'pending', 'draft' ),
		'author'              => get_current_user_id()
	);

	$deals_query = new WP_Query( $search_args );
	$total    = $deals_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Closed Deals
function autoroyal_get_closed_deals() {

	
	$search_args = array(
		'post_type'           => 'deal',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish', 'pending', 'draft' ),
		'author'              => get_current_user_id(),
		'meta_query' => array(
		    array(
		        'key' => 'deal_loan_next_payments_date',
		        'value' => 'done'        
		    )
		)
	);

	$deals_query = new WP_Query( $search_args );
	$total    = $deals_query->found_posts;
	wp_reset_postdata();

	return $total;

}

// Total Profit
function autoroyal_get_deals_total_profit() {

	$i = 0;

	
	$search_args = array(
		'post_type'           => 'deal',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1,
		'author'              => get_current_user_id()
	);

	$deals_query = new WP_Query( $search_args );
	$total    = $deals_query->found_posts;
	$total_profit = "";

	if ( $deals_query->have_posts() ) :

		while ( $deals_query->have_posts() ) : $deals_query->the_post();

			$vehicle_profit = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_profit',true));
			$total_profit = $total_profit + $vehicle_profit;

		endwhile;

	endif; wp_reset_postdata();

	return $total_profit;

}

// Average Profit
function autoroyal_get_deals_avg_profit() {

	$i = 0;

	
	$search_args = array(
		'post_type'           => 'deal',
		'posts_per_page'      => -1,
		'post_status'         => array( 'publish' ),
		'author'              => get_current_user_id()
	);

	$deals_query = new WP_Query( $search_args );
	$total    = $deals_query->found_posts;

	if ( $deals_query->have_posts() ) :

		while ( $deals_query->have_posts() ) : $deals_query->the_post();

			$vehicle_profit = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_profit',true));
			$i = $i + $vehicle_profit;

		endwhile;

	endif; wp_reset_postdata();

	if( $total != 0 ) {
		$avg_profit = $i / $total;
	} else {
		$avg_profit = $i;
	}

	return $avg_profit;

}

// Potential Profit
function autoroyal_get_potential_profit() {

	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1,
		'author'              => get_current_user_id(),
		'meta_query' => array(
		    array(
		        'key' => '_sold',
		        'value' => 0
		    )
		)
	);

	$cars_query = new WP_Query( $search_args );
	$total    = $cars_query->found_posts;

	$total_profit = 0;
	$price = 0;
	$cost = 0;
	$profit = 0;

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$price = esc_attr(get_post_meta(get_the_ID(), 'vehicle_price',true));
			$cost = esc_attr(get_post_meta(get_the_ID(), 'vehicle_cost',true));

			if(!empty($price) AND !empty($cost)) {
				$profit = $price - $cost;
			} elseif(!empty($price)) {
				$profit = $price;
			}

			$total_profit = $total_profit + $profit;

		endwhile;

	endif; wp_reset_postdata();

	return $total_profit;

}

// Total Cars by Make
function autoroyal_get_total_cars_by_make() {

	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1,
		'author'              => get_current_user_id(),
		'meta_query' => array(
		    array(
		        'key' => '_sold',
		        'value' => 0
		    )
		)
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$car_makers = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_make_desc_init = esc_attr(get_post_meta(get_the_ID(), 'vehicle_make_desc_init',true));
			$car_makers[] = $vehicle_make_desc_init;

		endwhile;

	endif; wp_reset_postdata();

	$car_makers_unique = array_unique($car_makers);

	$i = 0;
	$total_cars = array();

	foreach ( $car_makers_unique as $car_maker ) {

		$i++;

		
		$search_args = array(
			'post_type'           => 'vehicle',
			'posts_per_page'      => -1,
			'post_status'         => array( 'publish' ),
			'author'              => get_current_user_id(),
			'meta_query' => array(
				'relation' => 'AND',
			    array(
			        'key' => '_sold',
			        'value' => 0
			    ),
			    array(
			        'key' => 'vehicle_make_desc_init',
			        'value' => $car_maker
			    )
			)
		);

		$deals_query = new WP_Query( $search_args );
		$total    = $deals_query->found_posts;

		$total_cars[$i]['make'] = $car_maker;
		$total_cars[$i]['amount'] = $total;

	}

	wp_reset_postdata();

	return $total_cars;

}

// Total Sales by Month
function autoroyal_get_total_sales_by_month( $month ) {

	$total_sales = 0;
	$current_year = date('Y');
	$current_month = $month;

	
	$search_args = array(
		'post_type'           => 'deal',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1,
		'author'              => get_current_user_id(),
		'year'                => $current_year,
        'monthnum'            => $current_month

	);

	$cars_query   = new WP_Query( $search_args );
	$total_sales  = $cars_query->found_posts;

	wp_reset_postdata();

	return $total_sales;

}

// Total Sales by Month Extended
function autoroyal_get_total_sales_by_month_extended( $month, $year ) {

	$total_sales = 0;
	$current_year = $year;
	$current_month = $month;

	
	$search_args = array(
		'post_type'           => 'deal',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1,
		'author'              => get_current_user_id(),
		'year'                => $current_year,
        'monthnum'            => $current_month

	);

	$total_sales = array();
	$profit = 0;

	$cars_query                 = new WP_Query( $search_args );
	$total_sales['sales']         = $cars_query->found_posts;

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$deal_profit = esc_attr(get_post_meta(get_the_ID(), 'deal_profit',true));
			$profit = $profit + $deal_profit;

		endwhile;

	endif; wp_reset_postdata();

	$total_sales['total_profit'] = $profit;

	return $total_sales;

}

// Geat First Deal Date
function autoroyal_get_first_deal_date() {

	$format = get_option('date_format');
	$first_date = date($format); 
	
	$search_args = array(
		'post_type'           => 'deal',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => 1,
		'author'              => get_current_user_id(),
		'orderby' => 'date',
		'order'   => 'ASC',

	);

	$cars_query   = new WP_Query( $search_args );
	
	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$first_date = get_the_date( $format, get_the_ID() );

		endwhile;

	endif; wp_reset_postdata();

	return $first_date;

}

// Total Sales by Year Extended
function autoroyal_get_total_sales_by_year_extended( $year ) {

	$total_sales = 0;

	
	$search_args = array(
		'post_type'           => 'deal',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1,
		'author'              => get_current_user_id(),
		'year'                => $year

	);

	$total_sales = array();
	$profit = 0;

	$cars_query                 = new WP_Query( $search_args );
	$total_sales['sales']         = $cars_query->found_posts;

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$deal_profit = esc_attr(get_post_meta(get_the_ID(), 'deal_profit',true));
			$profit = $profit + $deal_profit;

		endwhile;

	endif; wp_reset_postdata();

	$total_sales['total_profit']  = $profit;

	return $total_sales;

}

// Total Sales by Make
function autoroyal_get_total_sales_by_make() {

	
	$search_args = array(
		'post_type'           => 'deal',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1,
		'author'              => get_current_user_id()
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$car_makers = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$deal_vehicle_make = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_make',true));
			$car_makers[] = $deal_vehicle_make;

		endwhile;

	endif; wp_reset_postdata();

	$car_makers_unique = array_unique($car_makers);

	$i = 0;
	$total_cars = array();

	foreach ( $car_makers_unique as $car_maker ) {

		$i++;

		
		$search_args = array(
			'post_type'           => 'deal',
			'posts_per_page'      => -1,
			'post_status'         => array( 'publish' ),
			'author'              => get_current_user_id(),
			'meta_query' => array(
			    array(
			        'key' => 'deal_vehicle_make',
			        'value' => $car_maker
			    )
			)
		);

		$deals_query = new WP_Query( $search_args );
		$total    = $deals_query->found_posts;

		$cars_age = 0;
		$total_profit = 0;

		if ( $deals_query->have_posts() ) :

			while ( $deals_query->have_posts() ) : $deals_query->the_post();

				$age = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_age',true));
				$cars_age = $cars_age + $age;

				$profit = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_profit',true));
				$total_profit =  $total_profit + $profit;

			endwhile;

		endif; wp_reset_postdata();

		$total_cars[$i]['make'] = $car_maker;
		$total_cars[$i]['amount'] = $total;
		if( $cars_age != 0) {
			$total_cars[$i]['age'] = $cars_age/$total;
		} else {
			$total_cars[$i]['age'] = "0";
		}
		if( $total_profit != 0 ){
			$total_cars[$i]['avg_profit'] = $total_profit/$total;
		} else {
			$total_cars[$i]['avg_profit'] = "0";
		}
		$total_cars[$i]['total_profit'] = $total_profit;

	}

	return $total_cars;

}

// Total Sales by Model
function autoroyal_get_total_sales_by_model() {

	
	$search_args = array(
		'post_type'           => 'deal',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1,
		'author'              => get_current_user_id()
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$car_makers = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$deal_vehicle_make = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_model',true));
			$car_makers[] = $deal_vehicle_make;

		endwhile;

	endif; wp_reset_postdata();

	$car_makers_unique = array_unique($car_makers);

	$i = 0;
	$total_cars = array();

	foreach ( $car_makers_unique as $car_maker ) {

		$i++;

		
		$search_args = array(
			'post_type'           => 'deal',
			'posts_per_page'      => -1,
			'post_status'         => array( 'publish' ),
			'author'              => get_current_user_id(),
			'meta_query' => array(
			    array(
			        'key' => 'deal_vehicle_model',
			        'value' => $car_maker
			    )
			)
		);

		$deals_query = new WP_Query( $search_args );
		$total    = $deals_query->found_posts;

		$cars_age = 0;
		$total_profit = 0;

		if ( $deals_query->have_posts() ) :

			while ( $deals_query->have_posts() ) : $deals_query->the_post();

				$deal_vehicle_make = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_make',true));

				$age = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_age',true));
				$cars_age = $cars_age + $age;

				$profit = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_profit',true));
				$total_profit =  $total_profit + $profit;

			endwhile;

		endif; wp_reset_postdata();

		$total_cars[$i]['make'] = $deal_vehicle_make . " " . $car_maker;
		$total_cars[$i]['amount'] = $total;
		if( $cars_age != 0) {
			$total_cars[$i]['age'] = $cars_age/$total;
		} else {
			$total_cars[$i]['age'] = "0";
		}
		if( $total_profit != 0 ){
			$total_cars[$i]['avg_profit'] = $total_profit/$total;
		} else {
			$total_cars[$i]['avg_profit'] = "0";
		}
		$total_cars[$i]['total_profit'] = $total_profit;

	}

	return $total_cars;

}

// Total Sales by trim
function autoroyal_get_total_sales_by_trim() {

	
	$search_args = array(
		'post_type'           => 'deal',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1,
		'author'              => get_current_user_id()
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$car_makers = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$deal_vehicle_make = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_trim',true));
			$car_makers[] = $deal_vehicle_make;

		endwhile;

	endif; wp_reset_postdata();

	$car_makers_unique = array_unique($car_makers);

	$i = 0;
	$total_cars = array();

	foreach ( $car_makers_unique as $car_maker ) {

		$i++;

		
		$search_args = array(
			'post_type'           => 'deal',
			'posts_per_page'      => -1,
			'post_status'         => array( 'publish' ),
			'author'              => get_current_user_id(),
			'meta_query' => array(
			    array(
			        'key' => 'deal_vehicle_trim',
			        'value' => $car_maker
			    )
			)
		);

		$deals_query = new WP_Query( $search_args );
		$total    = $deals_query->found_posts;

		$cars_age = 0;
		$total_profit = 0;
		$deal_vehicle_model = "";

		if ( $deals_query->have_posts() ) :

			while ( $deals_query->have_posts() ) : $deals_query->the_post();

				$deal_vehicle_make = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_make',true));
				$deal_vehicle_model = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_model',true));

				$age = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_age',true));
				$cars_age = $cars_age + $age;

				$profit = esc_attr(get_post_meta(get_the_ID(), 'deal_vehicle_profit',true));
				$total_profit =  $total_profit + $profit;

			endwhile;

		endif; wp_reset_postdata();

		$total_cars[$i]['make'] = $deal_vehicle_make . " " . $deal_vehicle_model . " " . $car_maker;
		$total_cars[$i]['amount'] = $total;
		if( $cars_age != 0) {
			$total_cars[$i]['age'] = $cars_age/$total;
		} else {
			$total_cars[$i]['age'] = "0";
		}
		if( $total_profit != 0 ){
			$total_cars[$i]['avg_profit'] = $total_profit/$total;
		} else {
			$total_cars[$i]['avg_profit'] = "0";
		}
		$total_cars[$i]['total_profit'] = $total_profit;

	}

	return $total_cars;

}

// Get Car Makes and Models
function autoroyal_get_total_makes_and_models() {
	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$car_makers = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$deal_vehicle_make = esc_attr(get_post_meta(get_the_ID(), 'vehicle_make_desc_init',true));
			$car_makers[] = $deal_vehicle_make;

		endwhile;

	endif; wp_reset_postdata();

	$car_makers_unique = array_unique($car_makers);

	$i = 0;

	foreach ( $car_makers_unique as $car_maker ) {

		$i++;

		
		$search_args = array(
			'post_type'           => 'vehicle',
			'posts_per_page'      => -1,
			'post_status'         => array( 'publish' ),
			'meta_query' => array(
			    array(
			        'key' => 'vehicle_make_desc_init',
			        'value' => $car_maker
			    )
			)
		);

		$deals_query = new WP_Query( $search_args );
		$total    = $deals_query->found_posts;
		$vehicle_models = array();

		if ( $deals_query->have_posts() ) :

			while ( $deals_query->have_posts() ) : $deals_query->the_post();

				$vehicle_make_clean = esc_attr(get_post_meta(get_the_ID(), 'vehicle_make',true));
				$vehicle_models[] = esc_attr(get_post_meta(get_the_ID(), 'vehicle_model',true));

			endwhile;

		endif; wp_reset_postdata();

		$total_cars[$i]['make'] = $car_maker;
		$total_cars[$i]['make_clean'] = $vehicle_make_clean;
		$total_cars[$i]['model'] = array_unique($vehicle_models);

	}

	return $total_cars;

}

// Get Minimum Price
function autoroyal_get_min_price() {
	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$minimum_price = "0";

	$vehicle_prices = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_price = esc_attr(get_post_meta(get_the_ID(), 'vehicle_price',true));
			$vehicle_prices[] = (int)$vehicle_price;

		endwhile;

	endif; wp_reset_postdata();

	if(!empty($vehicle_prices)) {
		$minimum_price = min($vehicle_prices);
	}

	return $minimum_price;

}

// Get Maximum Price
function autoroyal_get_max_price() {
	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$maximum_price = "0";

	$vehicle_prices = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_price = esc_attr(get_post_meta(get_the_ID(), 'vehicle_price',true));
			$vehicle_prices[] = $vehicle_price;

		endwhile;

	endif; wp_reset_postdata();

	if(!empty($vehicle_prices)) {
		$maximum_price = max($vehicle_prices);
	}

	return $maximum_price;

}

// Get Minimum Year
function autoroyal_get_min_year() {
	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$minimum_year = "0";

	$vehicle_years = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_year = esc_attr(get_post_meta(get_the_ID(), 'vehicle_year',true));
			if(!empty($vehicle_year)) {
				$vehicle_years[] = $vehicle_year;
			}

		endwhile;

	endif; wp_reset_postdata();

	if(!empty($vehicle_years)) {
		$minimum_year = min($vehicle_years);
	}

	return $minimum_year;

}

// Get Maximum Year
function autoroyal_get_max_year() {

	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$maximum_year = "0";

	$vehicle_years = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_year = esc_attr(get_post_meta(get_the_ID(), 'vehicle_year',true));
			if(!empty($vehicle_year) AND is_numeric($vehicle_year) ) {
				$vehicle_years[] = $vehicle_year;
			}

		endwhile;

	endif; wp_reset_postdata();

	if(!empty($vehicle_years)) {
		$maximum_year = max($vehicle_years);
	}

	return $maximum_year;

}

// Get Minimum Mileage
function autoroyal_get_min_mileage() {

	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$minimum_mileage = "0";

	$vehicle_mileages = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_mileage = esc_attr(get_post_meta(get_the_ID(), 'vehicle_mileage',true));
			if( !empty($vehicle_mileage) ) {
				$vehicle_mileages[] = $vehicle_mileage;
			} else {
				$vehicle_mileages[] = "0";
			}

		endwhile;

	endif; wp_reset_postdata();

	if(!empty($vehicle_mileages)) {
		$minimum_mileage = min($vehicle_mileages);
	}

	return $minimum_mileage;

}

// Get Maximum Mileage
function autoroyal_get_max_mileage() {

	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$maximum_mileage = "0";

	$vehicle_mileages = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_mileage = esc_attr(get_post_meta(get_the_ID(), 'vehicle_mileage',true));
			if( !empty($vehicle_mileage) ) {
				$vehicle_mileages[] = $vehicle_mileage;
			}

		endwhile;

	endif; wp_reset_postdata();

	if(!empty($vehicle_mileages)) {
		$maximum_mileage = max($vehicle_mileages);
	}

	return $maximum_mileage;

}

// Get Minimum Engine Volume
function autoroyal_get_min_engine_vol() {
	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$minimum_engine_volumes = "0";

	$vehicle_engine_volumes = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_engine_volume_ccm = esc_attr(get_post_meta(get_the_ID(), 'vehicle_engine_volume_ccm',true));
			if( !empty($vehicle_engine_volume_ccm) ) {
				$vehicle_engine_volumes[] = $vehicle_engine_volume_ccm;
			}

		endwhile;

	endif; wp_reset_postdata();

	if(!empty($vehicle_engine_volumes)) {
		$minimum_engine_volumes = min($vehicle_engine_volumes);
	}

	return $minimum_engine_volumes;

}

// Get Maximum Engine Volume
function autoroyal_get_max_engine_vol() {
	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$minimum_engine_volumes = "0";

	$vehicle_engine_volumes = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_engine_volume_ccm = esc_attr(get_post_meta(get_the_ID(), 'vehicle_engine_volume_ccm',true));
			if( !empty($vehicle_engine_volume_ccm) ) {
				$vehicle_engine_volumes[] = $vehicle_engine_volume_ccm;
			}

		endwhile;

	endif; wp_reset_postdata();

	if(!empty($vehicle_engine_volumes)) {
		$minimum_engine_volumes = max($vehicle_engine_volumes);
	}

	return $minimum_engine_volumes;

}

// Get Minimum HP
function autoroyal_get_min_hp() {
	
	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$minimum_engine_volumes = "0";
	$vehicle_engine_volumes = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_engine_volume_ccm = esc_attr(get_post_meta(get_the_ID(), 'vehicle_power_hp',true));
			if( !empty($vehicle_engine_volume_ccm) ) {
				$vehicle_engine_volumes[] = $vehicle_engine_volume_ccm;
			}

		endwhile;

	endif; wp_reset_postdata();

	if(!empty($vehicle_engine_volumes)) {
		$minimum_engine_volumes = min($vehicle_engine_volumes);
	}

	return $minimum_engine_volumes;

}

// Get Maximum HP
function autoroyal_get_max_hp() {

	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$minimum_engine_volumes = "0";

	$vehicle_engine_volumes = array();

	if ( $cars_query->have_posts() ) :

		while ( $cars_query->have_posts() ) : $cars_query->the_post();

			$vehicle_engine_volume_ccm = esc_attr(get_post_meta(get_the_ID(), 'vehicle_power_hp',true));
			if( !empty($vehicle_engine_volume_ccm) ) {
				$vehicle_engine_volumes[] = $vehicle_engine_volume_ccm;
			}

		endwhile;

	endif; wp_reset_postdata();

	if(!empty($vehicle_engine_volumes)) {
		$minimum_engine_volumes = max($vehicle_engine_volumes);
	}

	return $minimum_engine_volumes;

}

// Get Car Makes and Models
function autoroyal_get_total_models_by_make( $make ) {

    $search_args = array(
        'post_type'           => 'vehicle',
        'posts_per_page'      => -1,
        'post_status'         => array( 'publish' ),
        'meta_query' => array(
            array(
                'key' => 'vehicle_make_desc_init',
                'value' => $make
            )
        )
    );

    $deals_query = new WP_Query( $search_args );
    $total    = $deals_query->found_posts;
    $vehicle_models = array();

    if ( $deals_query->have_posts() ) :

        while ( $deals_query->have_posts() ) : $deals_query->the_post();

            $vehicle_models[] = esc_attr(get_post_meta(get_the_ID(), 'vehicle_model',true));

        endwhile;

    endif; wp_reset_postdata();
    $vehicle_models = array_unique($vehicle_models);

    return $vehicle_models;

}

// Get Car Makes and Models
function autoroyal_vehicle_query() {

    // Arrays
    $return = array();

    // Vehicle HP
    $minimum_vehicle_power_hp = "0";
    $maximum_vehicle_power_hp = "0";
	$vehicle_power_hp_array = array();

	// Vehicle Engine Volume
    $minimum_vehicle_engine_volume_ccm = "0";
    $maximum_vehicle_engine_volume_ccm = "0";
	$vehicle_engine_volume_ccm_array = array();

	// Vehicle Mileage
    $minimum_vehicle_mileages = "0";
    $maximum_vehicle_mileages = "0";
	$vehicle_mileages = array();

	// Vehicle Price
    $minimum_vehicle_price = "0";
    $maximum_vehicle_price = "0";
	$vehicle_prices = array();

	// Vehicle Year
    $minimum_vehicle_year = "0";
    $maximum_vehicle_year = "0";
	$vehicle_ears = array();

	// Vehicle fuel type
	$fuel_types = array();

	// Vehicle body style
	$body_styles = array();

	// Vehicle transmission
	$transmissions = array();

	// Vehicle drives
	$vehicle_drives = array();

	// Vehicle colors
	$vehicle_colors = array();

	// Vehicles Querry
	$search_args = array(
        'post_type'           => 'vehicle',
        'posts_per_page'      => -1,
        'post_status'         => array( 'publish' ),
    );

    $vehicle_query  = new WP_Query( $search_args );
    $total          = $vehicle_query->found_posts;

    if ( $vehicle_query->have_posts() ) :

        while ( $vehicle_query->have_posts() ) : $vehicle_query->the_post();

        	// Vehicle HP
            $vehicle_power_hp = esc_attr(get_post_meta(get_the_ID(), 'vehicle_power_hp',true));
			if( !empty($vehicle_power_hp) ) {
				$vehicle_power_hp_array[] = (int)$vehicle_power_hp;
			}

			// Vehicle Engine Volume
			$vehicle_engine_volume_ccm = esc_attr(get_post_meta(get_the_ID(), 'vehicle_engine_volume_ccm',true));
			if( !empty($vehicle_engine_volume_ccm) ) {
				$vehicle_engine_volume_ccm_array[] = (int)$vehicle_engine_volume_ccm;
			}

			// Vehicle Mileage
			$vehicle_mileage = esc_attr(get_post_meta(get_the_ID(), 'vehicle_mileage',true));
			if( !empty($vehicle_mileage) ) {
				$vehicle_mileages[] = (int)$vehicle_mileage;
			}

			// Vehicle Price
			$vehicle_price = esc_attr(get_post_meta(get_the_ID(), 'vehicle_price',true));
			if( !empty($vehicle_price) ) {
				$vehicle_prices[] = (int)$vehicle_price;
			}

			// Vehicle Year
			$vehicle_year = esc_attr(get_post_meta(get_the_ID(), 'vehicle_year',true));
			if( !empty($vehicle_year) ) {
				$vehicle_years[] = (int)$vehicle_year;
			}

			// Vehicles Makes and Models
			$deal_vehicle_make = esc_attr(get_post_meta(get_the_ID(), 'vehicle_make_desc_init',true));
			$car_makers[] = $deal_vehicle_make;

			// Vehicles Fuel Type
			$terms_cat = get_the_terms(get_the_ID(), 'vehicle_fuel_type' );
			if ($terms_cat && ! is_wp_error($terms_cat)) :
				$term_slugs_arr_cat = array();
				foreach ($terms_cat as $term_cat) {
					$fuel_types[] = $term_cat->term_id;
				}
			endif;

			// Vehicles Body Styles
			$terms_cat = get_the_terms(get_the_ID(), 'vehicle_body_style' );
			if ($terms_cat && ! is_wp_error($terms_cat)) :
				$term_slugs_arr_cat = array();
				foreach ($terms_cat as $term_cat) {
					$body_styles[] = $term_cat->term_id;
				}
			endif;

			// Vehicles Transmissions
			$terms_cat = get_the_terms(get_the_ID(), 'vehicle_transmission' );
			if ($terms_cat && ! is_wp_error($terms_cat)) :
				$term_slugs_arr_cat = array();
				foreach ($terms_cat as $term_cat) {
					$transmissions[] = $term_cat->term_id;
				}
			endif;

			// Vehicles drives
			$terms_cat = get_the_terms(get_the_ID(), 'vehicle_drive' );
			if ($terms_cat && ! is_wp_error($terms_cat)) :
				$term_slugs_arr_cat = array();
				foreach ($terms_cat as $term_cat) {
					$vehicle_drives[] = $term_cat->term_id;
				}
			endif;

			// Vehicles drives
			$terms_cat = get_the_terms(get_the_ID(), 'vehicle_exterior_color' );
			if ($terms_cat && ! is_wp_error($terms_cat)) :
				$term_slugs_arr_cat = array();
				foreach ($terms_cat as $term_cat) {
					$vehicle_colors[] = $term_cat->term_id;
				}
			endif;

        endwhile;

    endif; wp_reset_postdata();
    
    // Vehicle HP
    if(!empty($vehicle_power_hp_array)) {
		$minimum_vehicle_power_hp = min($vehicle_power_hp_array);
		$maximum_vehicle_power_hp = max($vehicle_power_hp_array);
	}

	$return["hp_min"] = $minimum_vehicle_power_hp;
	$return["hp_max"] = $maximum_vehicle_power_hp;

	// Vehicle Engine Volume
    if(!empty($vehicle_engine_volume_ccm_array)) {
		$minimum_vehicle_engine_volume_ccm = min($vehicle_engine_volume_ccm_array);
		$maximum_vehicle_engine_volume_ccm = max($vehicle_engine_volume_ccm_array);
	}

	$return["engine_volume_ccm_min"] = $minimum_vehicle_engine_volume_ccm;
	$return["engine_volume_ccm_max"] = $maximum_vehicle_engine_volume_ccm;

	// Vehicle Mileage
    if(!empty($vehicle_mileages)) {
		$minimum_vehicle_mileages = min($vehicle_mileages);
		$maximum_vehicle_mileages = max($vehicle_mileages);
	}

	$return["vehicle_mileages_min"] = $minimum_vehicle_mileages;
	$return["vehicle_mileages_max"] = $maximum_vehicle_mileages;

	// Vehicle Price
    if(!empty($vehicle_prices)) {
		$minimum_vehicle_price = min($vehicle_prices);
		$maximum_vehicle_price = max($vehicle_prices);
	}

	$return["vehicle_price_min"] = $minimum_vehicle_price;
	$return["vehicle_price_max"] = $maximum_vehicle_price;

	// Vehicle Year
    if(!empty($vehicle_years)) {
		$minimum_vehicle_year = min($vehicle_years);
		$maximum_vehicle_year = max($vehicle_years);
	}

	$return["vehicle_year_min"] = $minimum_vehicle_year;
	$return["vehicle_year_max"] = $maximum_vehicle_year;

	// Vehicles Makes and Models
	$car_makers_unique = array_unique($car_makers);

	$i = 0;
	$total_cars = array();
	$total_cars_clean = array();

	foreach ( $car_makers_unique as $car_maker ) {

		$i++;
		
		$search_args = array(
			'post_type'           => 'vehicle',
			'posts_per_page'      => -1,
			'post_status'         => array( 'publish' ),
			'meta_query' => array(
			    array(
			        'key' => 'vehicle_make_desc_init',
			        'value' => $car_maker
			    )
			)
		);

		$deals_query = new WP_Query( $search_args );
		$total    = $deals_query->found_posts;
		$vehicle_models = array();

		if ( $deals_query->have_posts() ) :

			while ( $deals_query->have_posts() ) : $deals_query->the_post();

				$vehicle_make_clean = esc_attr(get_post_meta(get_the_ID(), 'vehicle_make',true));
				$vehicle_models[] = esc_attr(get_post_meta(get_the_ID(), 'vehicle_model',true));

			endwhile;

		endif; wp_reset_postdata();

		$total_cars[$i]['make'] = $car_maker;
		$total_cars[$i]['make_clean'] = $vehicle_make_clean;
		$total_cars[$i]['model'] = array_unique($vehicle_models);

		$total_cars_clean[$vehicle_make_clean]['make'] = $car_maker;
		$total_cars_clean[$vehicle_make_clean]['make_clean'] = $vehicle_make_clean;
		$total_cars_clean[$vehicle_make_clean]['model'] = array_unique($vehicle_models);

	}

	$return["total_cars"] = $total_cars;
	$return["total_cars_clean"] = $total_cars_clean;

	// Vehicle Fuel Types
	$return["fuel_type"] = array_unique($fuel_types);

	// Vehicle Body Styles
	$return["body_style"] = array_unique($body_styles);

	// Vehicle Transmissions
	$return["transmission"] = array_unique($transmissions);

	// Vehicle Drives
	$return["vehicle_drive"] = array_unique($vehicle_drives);

	// Vehicle Colors
	$return["vehicle_color"] = array_unique($vehicle_colors);

    return $return;

}

// Get Car Makes and Models by user
function autoroyal_vehicle_query_by_user( $user_id ) {

    // Arrays
    $return = array();

    // Vehicle HP
    $minimum_vehicle_power_hp = "0";
    $maximum_vehicle_power_hp = "0";
	$vehicle_power_hp_array = array();

	// Vehicle Engine Volume
    $minimum_vehicle_engine_volume_ccm = "0";
    $maximum_vehicle_engine_volume_ccm = "0";
	$vehicle_engine_volume_ccm_array = array();

	// Vehicle Mileage
    $minimum_vehicle_mileages = "0";
    $maximum_vehicle_mileages = "0";
	$vehicle_mileages = array();

	// Vehicle Price
    $minimum_vehicle_price = "0";
    $maximum_vehicle_price = "0";
	$vehicle_prices = array();

	// Vehicle Year
    $minimum_vehicle_year = "0";
    $maximum_vehicle_year = "0";
	$vehicle_ears = array();

	// Vehicle fuel type
	$fuel_types = array();

	// Vehicle body style
	$body_styles = array();

	// Vehicle transmission
	$transmissions = array();

	// Vehicle drives
	$vehicle_drives = array();

	// Vehicle colors
	$vehicle_colors = array();

	// Vehicles Querry
	$search_args = array(
        'post_type'           => 'vehicle',
        'posts_per_page'      => -1,
        'post_status'         => array( 'publish' ),
        'author'              => $user_id,
    );

    $vehicle_query  = new WP_Query( $search_args );
    $total          = $vehicle_query->found_posts;

    if ( $vehicle_query->have_posts() ) :

        while ( $vehicle_query->have_posts() ) : $vehicle_query->the_post();

        	// Vehicle HP
            $vehicle_power_hp = esc_attr(get_post_meta(get_the_ID(), 'vehicle_power_hp',true));
			if( !empty($vehicle_power_hp) ) {
				$vehicle_power_hp_array[] = (int)$vehicle_power_hp;
			}

			// Vehicle Engine Volume
			$vehicle_engine_volume_ccm = esc_attr(get_post_meta(get_the_ID(), 'vehicle_engine_volume_ccm',true));
			if( !empty($vehicle_engine_volume_ccm) ) {
				$vehicle_engine_volume_ccm_array[] = (int)$vehicle_engine_volume_ccm;
			}

			// Vehicle Mileage
			$vehicle_mileage = esc_attr(get_post_meta(get_the_ID(), 'vehicle_mileage',true));
			if( !empty($vehicle_mileage) ) {
				$vehicle_mileages[] = (int)$vehicle_mileage;
			}

			// Vehicle Price
			$vehicle_price = esc_attr(get_post_meta(get_the_ID(), 'vehicle_price',true));
			if( !empty($vehicle_price) ) {
				$vehicle_prices[] = (int)$vehicle_price;
			}

			// Vehicle Year
			$vehicle_year = esc_attr(get_post_meta(get_the_ID(), 'vehicle_year',true));
			if( !empty($vehicle_year) ) {
				$vehicle_years[] = (int)$vehicle_year;
			}

			// Vehicles Makes and Models
			$deal_vehicle_make = esc_attr(get_post_meta(get_the_ID(), 'vehicle_make_desc_init',true));
			$car_makers[] = $deal_vehicle_make;

			// Vehicles Fuel Type
			$terms_cat = get_the_terms(get_the_ID(), 'vehicle_fuel_type' );
			if ($terms_cat && ! is_wp_error($terms_cat)) :
				$term_slugs_arr_cat = array();
				foreach ($terms_cat as $term_cat) {
					$fuel_types[] = $term_cat->term_id;
				}
			endif;

			// Vehicles Body Styles
			$terms_cat = get_the_terms(get_the_ID(), 'vehicle_body_style' );
			if ($terms_cat && ! is_wp_error($terms_cat)) :
				$term_slugs_arr_cat = array();
				foreach ($terms_cat as $term_cat) {
					$body_styles[] = $term_cat->term_id;
				}
			endif;

			// Vehicles Transmissions
			$terms_cat = get_the_terms(get_the_ID(), 'vehicle_transmission' );
			if ($terms_cat && ! is_wp_error($terms_cat)) :
				$term_slugs_arr_cat = array();
				foreach ($terms_cat as $term_cat) {
					$transmissions[] = $term_cat->term_id;
				}
			endif;

			// Vehicles drives
			$terms_cat = get_the_terms(get_the_ID(), 'vehicle_drive' );
			if ($terms_cat && ! is_wp_error($terms_cat)) :
				$term_slugs_arr_cat = array();
				foreach ($terms_cat as $term_cat) {
					$vehicle_drives[] = $term_cat->term_id;
				}
			endif;

			// Vehicles drives
			$terms_cat = get_the_terms(get_the_ID(), 'vehicle_exterior_color' );
			if ($terms_cat && ! is_wp_error($terms_cat)) :
				$term_slugs_arr_cat = array();
				foreach ($terms_cat as $term_cat) {
					$vehicle_colors[] = $term_cat->term_id;
				}
			endif;

        endwhile;

    endif; wp_reset_postdata();
    
    // Vehicle HP
    if(!empty($vehicle_power_hp_array)) {
		$minimum_vehicle_power_hp = min($vehicle_power_hp_array);
		$maximum_vehicle_power_hp = max($vehicle_power_hp_array);
	}

	$return["hp_min"] = $minimum_vehicle_power_hp;
	$return["hp_max"] = $maximum_vehicle_power_hp;

	// Vehicle Engine Volume
    if(!empty($vehicle_engine_volume_ccm_array)) {
		$minimum_vehicle_engine_volume_ccm = min($vehicle_engine_volume_ccm_array);
		$maximum_vehicle_engine_volume_ccm = max($vehicle_engine_volume_ccm_array);
	}

	$return["engine_volume_ccm_min"] = $minimum_vehicle_engine_volume_ccm;
	$return["engine_volume_ccm_max"] = $maximum_vehicle_engine_volume_ccm;

	// Vehicle Mileage
    if(!empty($vehicle_mileages)) {
		$minimum_vehicle_mileages = min($vehicle_mileages);
		$maximum_vehicle_mileages = max($vehicle_mileages);
	}

	$return["vehicle_mileages_min"] = $minimum_vehicle_mileages;
	$return["vehicle_mileages_max"] = $maximum_vehicle_mileages;

	// Vehicle Price
    if(!empty($vehicle_prices)) {
		$minimum_vehicle_price = min($vehicle_prices);
		$maximum_vehicle_price = max($vehicle_prices);
	}

	$return["vehicle_price_min"] = $minimum_vehicle_price;
	$return["vehicle_price_max"] = $maximum_vehicle_price;

	// Vehicle Year
    if(!empty($vehicle_years)) {
		$minimum_vehicle_year = min($vehicle_years);
		$maximum_vehicle_year = max($vehicle_years);
	}

	$return["vehicle_year_min"] = $minimum_vehicle_year;
	$return["vehicle_year_max"] = $maximum_vehicle_year;

	// Vehicles Makes and Models
	$car_makers_unique = array_unique($car_makers);

	$i = 0;
	$total_cars = array();
	$total_cars_clean = array();

	foreach ( $car_makers_unique as $car_maker ) {

		$i++;
		
		$search_args = array(
			'post_type'           => 'vehicle',
			'posts_per_page'      => -1,
			'post_status'         => array( 'publish' ),
			'author'              => $user_id,
			'meta_query' => array(
			    array(
			        'key' => 'vehicle_make_desc_init',
			        'value' => $car_maker
			    )
			)
		);

		$deals_query = new WP_Query( $search_args );
		$total    = $deals_query->found_posts;
		$vehicle_models = array();

		if ( $deals_query->have_posts() ) :

			while ( $deals_query->have_posts() ) : $deals_query->the_post();

				$vehicle_make_clean = esc_attr(get_post_meta(get_the_ID(), 'vehicle_make',true));
				$vehicle_models[] = esc_attr(get_post_meta(get_the_ID(), 'vehicle_model',true));

			endwhile;

		endif; wp_reset_postdata();

		$total_cars[$i]['make'] = $car_maker;
		$total_cars[$i]['make_clean'] = $vehicle_make_clean;
		$total_cars[$i]['model'] = array_unique($vehicle_models);

		$total_cars_clean[$vehicle_make_clean]['make'] = $car_maker;
		$total_cars_clean[$vehicle_make_clean]['make_clean'] = $vehicle_make_clean;
		$total_cars_clean[$vehicle_make_clean]['model'] = array_unique($vehicle_models);

	}

	$return["total_cars"] = $total_cars;
	$return["total_cars_clean"] = $total_cars_clean;

	// Vehicle Fuel Types
	$return["fuel_type"] = array_unique($fuel_types);

	// Vehicle Body Styles
	$return["body_style"] = array_unique($body_styles);

	// Vehicle Transmissions
	$return["transmission"] = array_unique($transmissions);

	// Vehicle Drives
	$return["vehicle_drive"] = array_unique($vehicle_drives);

	// Vehicle Colors
	$return["vehicle_color"] = array_unique($vehicle_colors);

    return $return;

}

// Car Search Filter Total
function autoroyal_search_filter_total() {

	$tax_query = array();   // taxonomy query array
	$meta_query = array();  // meta query qrray

	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	/* Car Make */
	if ( ( ! empty( $_GET[ 'make' ] ) ) && ( $_GET[ 'make' ] != '0' ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_make_desc_init',
			'value' => $_GET[ 'make' ],
		);
	}

	/* Car Model */
	if ( ( ! empty( $_GET[ 'model' ] ) ) && ( $_GET[ 'model' ] != '0' ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_model',
			'value' => $_GET[ 'model' ],
		);
	}

	/* Fuel Type */
	if ( ( ! empty( $_GET[ 'fuel_type' ] ) ) && ( $_GET[ 'fuel_type' ] != '0' ) ) {
		$tax_query[] = array(
			'taxonomy' => 'vehicle_fuel_type',
			'field' => 'term_id',
			'terms' => $_GET[ 'fuel_type' ],
		);
	}

	/* Vehicle Price Min */
    if ( isset( $_GET[ 'price' ] ) && !empty( $_GET[ 'price' ] )) {
        if( isset( $_GET[ 'price_min' ] ) && !empty( $_GET[ 'price_min' ] ) ) {
    		$price_min = $_GET[ 'price_min' ];
    	} else {
    		$price_min = "0";
    	}
        $price_max = $_GET[ 'price' ];
        $meta_query[] = array(
            'key' => 'vehicle_price',
            'value' => array( $price_min, $price_max ),
            'type' => 'NUMERIC',
            'compare' => 'BETWEEN'
        );
    }

    /* Transimission */
    if ( ( ! empty( $_GET[ 'transmission' ] ) ) && ( $_GET[ 'transmission' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_transmission',
            'field' => 'term_id',
            'terms' => $_GET[ 'transmission' ],
            'operator' => 'IN',
        );
    }

    /* Vehicle Exterior Color */
    if ( ( ! empty( $_GET[ 'vehicle_exterior_color' ] ) ) && ( $_GET[ 'vehicle_exterior_color' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_exterior_color',
            'field' => 'term_id',
            'terms' => $_GET[ 'vehicle_exterior_color' ],
            'operator' => 'IN',
        );
    }

    /* Body Style */
    if ( ( ! empty( $_GET[ 'body_style' ] ) ) && ( $_GET[ 'body_style' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_body_style',
            'field' => 'term_id',
            'terms' => $_GET[ 'body_style' ],
            'operator' => 'IN',
        );
    }

	/* Car year min */
    if ( isset( $_GET[ 'vehicle_year_min' ] ) && !empty( $_GET[ 'vehicle_year_min' ] ) && isset( $_GET[ 'vehicle_year_max' ] ) && !empty( $_GET[ 'vehicle_year_max' ] )) {
        $vehicle_year_min = $_GET[ 'vehicle_year_min' ];
        $vehicle_year_max = $_GET[ 'vehicle_year_max' ];
        if ( $vehicle_year_min >= 0 && $vehicle_year_max >= 0 ) {
            $meta_query[] = array(
                'key' => 'vehicle_year',
                'value' => array( $vehicle_year_min, $vehicle_year_max ),
                'type' => 'NUMERIC',
                'compare' => 'BETWEEN'
            );
        }
    }

	/* vehicle Mileage */
    if ( isset( $_GET[ 'mileage' ] ) && !empty( $_GET[ 'mileage' ] ) && isset( $_GET[ 'mileage_min' ] ) && !empty( $_GET[ 'mileage_min' ] )) {
        $mileage = $_GET[ 'mileage' ];
        $mileage = $mileage * 1000;
        $mileage_min = $_GET[ 'mileage_min' ];
        $mileage_min = $mileage_min * 1000;
        if ( $mileage >= 0 && $mileage_min >= 0 ) {
            $meta_query[] = array(
                'key' => 'vehicle_mileage',
                'value' => array( $mileage_min, $mileage ),
                'type' => 'NUMERIC',
                'compare' => 'BETWEEN'
            );
        }
    }

	/* Car Condition */
	if ( ( ! empty( $_GET[ 'vehicle_condition' ] ) ) && isset( $_GET[ 'vehicle_condition' ] ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_condition',
			'value' => $_GET[ 'vehicle_condition' ],
		);
	}

	/* if more than one taxonomies exist then specify the relation */
	$tax_count = count( $tax_query );
	if ( $tax_count > 1 ) {
		$tax_query[ 'relation' ] = 'AND';
	}

	/* if more than one meta query elements exist then specify the relation */
	$meta_count = count( $meta_query );
	if ( $meta_count > 1 ) {
		$meta_query[ 'relation' ] = 'AND';
	}

	if ( $tax_count > 0 ) {
		$search_args[ 'tax_query' ] = $tax_query;
	}

	/* if meta query has some values then add it to base home page query */
	if ( $meta_count > 0 ) {
		$search_args[ 'meta_query' ] = $meta_query;
	}

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	return $total;
}

function autoroyal_search_filter_total_rent() {

	$tax_query = array();   // taxonomy query array
	$meta_query = array();  // meta query qrray

	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1,
		'meta_key'            => 'vehicle_for_rent',
	);

	/* Car Make */
	if ( ( ! empty( $_GET[ 'make' ] ) ) && ( $_GET[ 'make' ] != '0' ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_make_desc_init',
			'value' => $_GET[ 'make' ],
		);
	}

	/* Car Model */
	if ( ( ! empty( $_GET[ 'model' ] ) ) && ( $_GET[ 'model' ] != '0' ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_model',
			'value' => $_GET[ 'model' ],
		);
	}

	/* Fuel Type */
	if ( ( ! empty( $_GET[ 'fuel_type' ] ) ) && ( $_GET[ 'fuel_type' ] != '0' ) ) {
		$tax_query[] = array(
			'taxonomy' => 'vehicle_fuel_type',
			'field' => 'term_id',
			'terms' => $_GET[ 'fuel_type' ],
		);
	}

	/* Vehicle Price Min */
    if ( isset( $_GET[ 'price' ] ) && !empty( $_GET[ 'price' ] )) {
        if( isset( $_GET[ 'price_min' ] ) && !empty( $_GET[ 'price_min' ] ) ) {
    		$price_min = $_GET[ 'price_min' ];
    	} else {
    		$price_min = "0";
    	}
        $price_max = $_GET[ 'price' ];
        $meta_query[] = array(
            'key' => 'vehicle_price',
            'value' => array( $price_min, $price_max ),
            'type' => 'NUMERIC',
            'compare' => 'BETWEEN'
        );
    }

    /* Transimission */
    if ( ( ! empty( $_GET[ 'transmission' ] ) ) && ( $_GET[ 'transmission' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_transmission',
            'field' => 'term_id',
            'terms' => $_GET[ 'transmission' ],
            'operator' => 'IN',
        );
    }

    /* Vehicle Exterior Color */
    if ( ( ! empty( $_GET[ 'vehicle_exterior_color' ] ) ) && ( $_GET[ 'vehicle_exterior_color' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_exterior_color',
            'field' => 'term_id',
            'terms' => $_GET[ 'vehicle_exterior_color' ],
            'operator' => 'IN',
        );
    }

    /* Body Style */
    if ( ( ! empty( $_GET[ 'body_style' ] ) ) && ( $_GET[ 'body_style' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_body_style',
            'field' => 'term_id',
            'terms' => $_GET[ 'body_style' ],
            'operator' => 'IN',
        );
    }

	/* Car year min */
    if ( isset( $_GET[ 'vehicle_year_min' ] ) && !empty( $_GET[ 'vehicle_year_min' ] ) && isset( $_GET[ 'vehicle_year_max' ] ) && !empty( $_GET[ 'vehicle_year_max' ] )) {
        $vehicle_year_min = $_GET[ 'vehicle_year_min' ];
        $vehicle_year_max = $_GET[ 'vehicle_year_max' ];
        if ( $vehicle_year_min >= 0 && $vehicle_year_max >= 0 ) {
            $meta_query[] = array(
                'key' => 'vehicle_year',
                'value' => array( $vehicle_year_min, $vehicle_year_max ),
                'type' => 'NUMERIC',
                'compare' => 'BETWEEN'
            );
        }
    }

	/* vehicle Mileage */
    if ( isset( $_GET[ 'mileage' ] ) && !empty( $_GET[ 'mileage' ] ) && isset( $_GET[ 'mileage_min' ] ) && !empty( $_GET[ 'mileage_min' ] )) {
        $mileage = $_GET[ 'mileage' ];
        $mileage = $mileage * 1000;
        $mileage_min = $_GET[ 'mileage_min' ];
        $mileage_min = $mileage_min * 1000;
        if ( $mileage >= 0 && $mileage_min >= 0 ) {
            $meta_query[] = array(
                'key' => 'vehicle_mileage',
                'value' => array( $mileage_min, $mileage ),
                'type' => 'NUMERIC',
                'compare' => 'BETWEEN'
            );
        }
    }

	/* Car Condition */
	if ( ( ! empty( $_GET[ 'vehicle_condition' ] ) ) && isset( $_GET[ 'vehicle_condition' ] ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_condition',
			'value' => $_GET[ 'vehicle_condition' ],
		);
	}

	/* if more than one taxonomies exist then specify the relation */
	$tax_count = count( $tax_query );
	if ( $tax_count > 1 ) {
		$tax_query[ 'relation' ] = 'AND';
	}

	/* if more than one meta query elements exist then specify the relation */
	$meta_count = count( $meta_query );
	if ( $meta_count > 1 ) {
		$meta_query[ 'relation' ] = 'AND';
	}

	if ( $tax_count > 0 ) {
		$search_args[ 'tax_query' ] = $tax_query;
	}

	/* if meta query has some values then add it to base home page query */
	if ( $meta_count > 0 ) {
		$search_args[ 'meta_query' ] = $meta_query;
	}

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	return $total;
}

/*
|--------------------------------------------------------------------------
| Ajax Update Vehicles Amount
|--------------------------------------------------------------------------
*/
function update_vehicles_amount() {

	ob_start();

	$tax_query = array();   // taxonomy query array
	$meta_query = array();  // meta query qrray

	$search_args = array(
		'post_type'           => 'vehicle',
		'post_status'         => array( 'publish' ),
		'posts_per_page'      => -1
	);

	/* Car Make */
	if ( ( ! empty( $_POST[ 'make' ] ) ) && ( $_POST[ 'make' ] != '0' ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_make_desc_init',
			'value' => $_POST[ 'make' ],
		);
	}

	/* Car Model */
	if ( ( ! empty( $_POST[ 'model' ] ) ) && ( $_POST[ 'model' ] != '0' ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_model',
			'value' => $_POST[ 'model' ],
		);
	}

	/* Fuel Type */
	if ( ( ! empty( $_POST[ 'fuel_type' ] ) ) && ( $_POST[ 'fuel_type' ] != '0' ) ) {
		$tax_query[] = array(
			'taxonomy' => 'vehicle_fuel_type',
			'field' => 'term_id',
			'terms' => $_POST[ 'fuel_type' ],
		);
	}

	/* Vehicle Price Min */
    if ( isset( $_POST[ 'price' ] ) && !empty( $_POST[ 'price' ] )) {
        if( isset( $_POST[ 'price_min' ] ) && !empty( $_POST[ 'price_min' ] ) ) {
    		$price_min = $_POST[ 'price_min' ];
    	} else {
    		$price_min = "0";
    	}
        $price_max = $_POST[ 'price' ];
        $meta_query[] = array(
            'key' => 'vehicle_price',
            'value' => array( $price_min, $price_max ),
            'type' => 'NUMERIC',
            'compare' => 'BETWEEN'
        );
    }

    /* Transimission */
    if ( ( ! empty( $_POST[ 'transmission' ] ) ) && ( $_POST[ 'transmission' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_transmission',
            'field' => 'term_id',
            'terms' => $_POST[ 'transmission' ],
            'operator' => 'IN',
        );
    }

    /* Body Style */
    if ( ( ! empty( $_POST[ 'body_style' ] ) ) && ( $_POST[ 'body_style' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_body_style',
            'field' => 'term_id',
            'terms' => $_POST[ 'body_style' ],
            'operator' => 'IN',
        );
    }

    /* Vehicle Exterior Color */
    if ( ( ! empty( $_POST[ 'vehicle_exterior_color' ] ) ) && ( $_POST[ 'vehicle_exterior_color' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_exterior_color',
            'field' => 'term_id',
            'terms' => $_POST[ 'vehicle_exterior_color' ],
            'operator' => 'IN',
        );
    }

	/* Car year min */
    if ( isset( $_POST[ 'vehicle_year_min' ] ) && !empty( $_POST[ 'vehicle_year_min' ] ) && isset( $_POST[ 'vehicle_year_max' ] ) && !empty( $_POST[ 'vehicle_year_max' ] )) {
        $vehicle_year_min = $_POST[ 'vehicle_year_min' ];
        $vehicle_year_max = $_POST[ 'vehicle_year_max' ];
        if ( $vehicle_year_min >= 0 && $vehicle_year_max >= 0 ) {
            $meta_query[] = array(
                'key' => 'vehicle_year',
                'value' => array( $vehicle_year_min, $vehicle_year_max ),
                'type' => 'NUMERIC',
                'compare' => 'BETWEEN'
            );
        }
    }

	/* vehicle Mileage */
    if ( isset( $_POST[ 'mileage' ] ) && !empty( $_POST[ 'mileage' ] ) && isset( $_POST[ 'mileage_min' ] ) && !empty( $_POST[ 'mileage_min' ] )) {
        $mileage = $_POST[ 'mileage' ];
        $mileage = $mileage * 1000;
        $mileage_min = $_POST[ 'mileage_min' ];
        $mileage_min = $mileage_min * 1000;
        if ( $mileage >= 0 && $mileage_min >= 0 ) {
            $meta_query[] = array(
                'key' => 'vehicle_mileage',
                'value' => array( $mileage_min, $mileage ),
                'type' => 'NUMERIC',
                'compare' => 'BETWEEN'
            );
        }
    }

	/* Car Condition */
	if ( ( ! empty( $_POST[ 'vehicle_condition' ] ) ) && isset( $_POST[ 'vehicle_condition' ] ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_condition',
			'value' => $_POST[ 'vehicle_condition' ],
		);
	}

	/* if more than one taxonomies exist then specify the relation */
	$tax_count = count( $tax_query );
	if ( $tax_count > 1 ) {
		$tax_query[ 'relation' ] = 'AND';
	}

	/* if more than one meta query elements exist then specify the relation */
	$meta_count = count( $meta_query );
	if ( $meta_count > 1 ) {
		$meta_query[ 'relation' ] = 'AND';
	}

	if ( $tax_count > 0 ) {
		$search_args[ 'tax_query' ] = $tax_query;
	}

	/* if meta query has some values then add it to base home page query */
	if ( $meta_count > 0 ) {
		$search_args[ 'meta_query' ] = $meta_query;
	}

	$cars_query = new WP_Query( $search_args );
	$total      = $cars_query->found_posts;

	$response['html'] = ob_get_clean();

	$response['total'] = $total;

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_update_vehicles_amount', 'update_vehicles_amount' );
add_action( 'wp_ajax_nopriv_update_vehicles_amount', 'update_vehicles_amount' );

/*
|--------------------------------------------------------------------------
| Ajax Filter Vehicles
|--------------------------------------------------------------------------
*/
function autoroyal_ajax_filter() {

	ob_start();

	$tax_query = array();   // taxonomy query array
	$meta_query = array();  // meta query qrray

	$posts_per_page = $_POST[ 'posts_per_page' ];
	$paged = $_POST[ 'filter_page' ];
	$columns = $_POST[ 'ajax_columns' ];

	$search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
		'post_type'           => 'vehicle',
		'post_status'         => 'publish',
		'posts_per_page'      => $posts_per_page,
		'offset'              => ( max( 1, $paged ) - 1 ) * $posts_per_page,
		'meta_key'            => '_featured',
		'orderby'             => array('meta_value_num' => 'DESC', 'date' => 'DESC'),
    	'ignore_sticky_posts' => 1,
    	'meta_query' => array(
		    array(
		        'key' => '_sold',
		        'value' => 0
		    )
		)
	) );

	/* Car Make */
	if ( ( ! empty( $_POST[ 'make' ] ) ) && ( $_POST[ 'make' ] != '0' ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_make_desc_init',
			'value' => $_POST[ 'make' ],
		);
	}

	/* Car Model */
	if ( ( ! empty( $_POST[ 'model' ] ) ) && ( $_POST[ 'model' ] != '0' ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_model',
			'value' => $_POST[ 'model' ],
		);
	}

	/* Fuel Type */
	if ( ( ! empty( $_POST[ 'fuel_type' ] ) ) && ( $_POST[ 'fuel_type' ] != '0' ) ) {
		$tax_query[] = array(
			'taxonomy' => 'vehicle_fuel_type',
			'field' => 'term_id',
			'terms' => $_POST[ 'fuel_type' ],
		);
	}

	/* Vehicle Price Min */
    if ( isset( $_POST[ 'price' ] ) && !empty( $_POST[ 'price' ] )) {
        if( isset( $_POST[ 'price_min' ] ) && !empty( $_POST[ 'price_min' ] ) ) {
    		$price_min = $_POST[ 'price_min' ];
    	} else {
    		$price_min = "0";
    	}
        $price_max = $_POST[ 'price' ];
        $meta_query[] = array(
            'key' => 'vehicle_price',
            'value' => array( $price_min, $price_max ),
            'type' => 'NUMERIC',
            'compare' => 'BETWEEN'
        );
    }

    /* Transimission */
    if ( ( ! empty( $_POST[ 'transmission' ] ) ) && ( $_POST[ 'transmission' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_transmission',
            'field' => 'term_id',
            'terms' => $_POST[ 'transmission' ],
            'operator' => 'IN',
        );
    }

    /* Body Style */
    if ( ( ! empty( $_POST[ 'body_style' ] ) ) && ( $_POST[ 'body_style' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_body_style',
            'field' => 'term_id',
            'terms' => $_POST[ 'body_style' ],
            'operator' => 'IN',
        );
    }

    /* Vehicle Exterior Color */
    if ( ( ! empty( $_POST[ 'vehicle_exterior_color' ] ) ) && ( $_POST[ 'vehicle_exterior_color' ] != '0' ) ) {
        $tax_query[] = array(
            'taxonomy' => 'vehicle_exterior_color',
            'field' => 'term_id',
            'terms' => $_POST[ 'vehicle_exterior_color' ],
            'operator' => 'IN',
        );
    }

	/* Car year min */
    if ( isset( $_POST[ 'vehicle_year_min' ] ) && !empty( $_POST[ 'vehicle_year_min' ] ) && isset( $_POST[ 'vehicle_year_max' ] ) && !empty( $_POST[ 'vehicle_year_max' ] )) {
        $vehicle_year_min = $_POST[ 'vehicle_year_min' ];
        $vehicle_year_max = $_POST[ 'vehicle_year_max' ];
        if ( $vehicle_year_min >= 0 && $vehicle_year_max >= 0 ) {
            $meta_query[] = array(
                'key' => 'vehicle_year',
                'value' => array( $vehicle_year_min, $vehicle_year_max ),
                'type' => 'NUMERIC',
                'compare' => 'BETWEEN'
            );
        }
    }

	/* vehicle Mileage */
    if ( isset( $_POST[ 'mileage' ] ) && !empty( $_POST[ 'mileage' ] ) && isset( $_POST[ 'mileage_min' ] ) && !empty( $_POST[ 'mileage_min' ] )) {
        $mileage = $_POST[ 'mileage' ];
        $mileage = $mileage * 1000;
        $mileage_min = $_POST[ 'mileage_min' ];
        $mileage_min = $mileage_min * 1000;
        if ( $mileage >= 0 && $mileage_min >= 0 ) {
            $meta_query[] = array(
                'key' => 'vehicle_mileage',
                'value' => array( $mileage_min, $mileage ),
                'type' => 'NUMERIC',
                'compare' => 'BETWEEN'
            );
        }
    }

	/* Car Condition */
	if ( ( ! empty( $_POST[ 'vehicle_condition' ] ) ) && isset( $_POST[ 'vehicle_condition' ] ) ) {
		$meta_query[] = array(
			'key' => 'vehicle_condition',
			'value' => $_POST[ 'vehicle_condition' ],
		);
	}

	/* Sort By Year */
	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'year_asc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value_num';
		$search_args[ 'meta_key' ] = 'vehicle_year';
		$search_args[ 'order' ] = 'ASC';
	}

	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'year_desc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value_num';
		$search_args[ 'meta_key' ] = 'vehicle_year';
		$search_args[ 'order' ] = 'DESC';
	}

	/* Sort By Make */
	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'make_asc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value';
		$search_args[ 'meta_key' ] = 'vehicle_make';
		$search_args[ 'order' ] = 'ASC';
	}

	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'make_desc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value';
		$search_args[ 'meta_key' ] = 'vehicle_make';
		$search_args[ 'order' ] = 'DESC';
	}

	/* Sort By Model */
	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'model_asc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value';
		$search_args[ 'meta_key' ] = 'vehicle_model';
		$search_args[ 'order' ] = 'ASC';
	}

	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'model_desc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value';
		$search_args[ 'meta_key' ] = 'vehicle_model';
		$search_args[ 'order' ] = 'DESC';
	}

	/* Sort By Mileage */
	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'mileage_asc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value_num';
		$search_args[ 'meta_key' ] = 'vehicle_mileage';
		$search_args[ 'order' ] = 'ASC';
	}

	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'mileage_desc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value_num';
		$search_args[ 'meta_key' ] = 'vehicle_mileage';
		$search_args[ 'order' ] = 'DESC';
	}

	/* Sort By Cost */
	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'cost_asc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value_num';
		$search_args[ 'meta_key' ] = 'vehicle_cost';
		$search_args[ 'order' ] = 'ASC';
	}

	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'cost_desc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value_num';
		$search_args[ 'meta_key' ] = 'vehicle_cost';
		$search_args[ 'order' ] = 'DESC';
	}

	/* Sort By Price */
	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'price_asc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value_num';
		$search_args[ 'meta_key' ] = 'vehicle_price';
		$search_args[ 'order' ] = 'ASC';
	}

	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'price_desc' ) ) ) {
		$search_args[ 'orderby' ] = 'meta_value_num';
		$search_args[ 'meta_key' ] = 'vehicle_price';
		$search_args[ 'order' ] = 'DESC';
	}

	/* Sort By Price */
	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'age_asc' ) ) ) {
		$search_args[ 'orderby' ] = 'date';
		$search_args[ 'order' ] = 'DESC';
	}

	if ( ( isset( $_POST[ 'orderby' ] ) && ( $_POST[ 'orderby' ] == 'age_desc' ) ) ) {
		$search_args[ 'orderby' ] = 'date';
		$search_args[ 'order' ] = 'ASC';
	}

	/* if more than one taxonomies exist then specify the relation */
	$tax_count = count( $tax_query );
	if ( $tax_count > 1 ) {
		$tax_query[ 'relation' ] = 'AND';
	}

	/* if more than one meta query elements exist then specify the relation */
	$meta_count = count( $meta_query );
	if ( $meta_count > 1 ) {
		$meta_query[ 'relation' ] = 'AND';
	}

	if ( $tax_count > 0 ) {
		$search_args[ 'tax_query' ] = $tax_query;
	}

	/* if meta query has some values then add it to base home page query */
	if ( $meta_count > 0 ) {
		$search_args[ 'meta_query' ] = $meta_query;
	}

	
	$search_args   = apply_filters( 'autoroyal_search_filter_parameters', $search_args );
	$cars_query    = new WP_Query;
	$cars          = $cars_query->query( $search_args );
	$total         = $cars_query->found_posts;
	$max_num_pages = $cars_query->max_num_pages;

	if ( ! $cars ) : 

	?>
		<div class="col-md-12">
			<h4><?php esc_html_e( 'No listings were found matching your search criteria.', 'autoroyal' ); ?></h4>
		</div>
	<?php else : ?>
		<?php foreach ( $cars as $car ) : ?>

			<?php 

				$car_ID = $car->ID; 

				$vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
				$vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
				$vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
				$vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
				$vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
				$vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
				$vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

				$vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
				if(!empty($vehicle_exterior_color)) {
					$color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
					$color_id   = $vehicle_exterior_color[0]->term_id;
					$color_name = $vehicle_exterior_color[0]->name;
				} else {
					$color_name = "";
				}

				$vehicle_mileage = esc_attr(get_post_meta($car_ID, 'vehicle_mileage',true));

				$vehicle_cost = esc_attr(get_post_meta($car_ID, 'vehicle_cost',true));
				$vehicle_retail_price = esc_attr(get_post_meta($car_ID, 'vehicle_retail_price',true));
				$vehicle_discounted_price = esc_attr(get_post_meta($car_ID, 'vehicle_discounted_price',true));
				$price = esc_attr(get_post_meta($car_ID, 'vehicle_price',true));

				$vehicle_image_gallery = get_post_meta($car_ID, 'vehicle_image_gallery',true);
				$vehicle_image_extended_gallery = get_post_meta($car_ID, 'vehicle_image_extended_gallery',true);
				$vehicle_image_url = "";

				if(!empty($vehicle_image_gallery[0]['url'])) {

					$vehicle_image_url = $vehicle_image_gallery[0]['url'];

				} elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

					$vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

				}

				$vehicle_cover_image = get_post_meta($car_ID, 'vehicle_cover_image',true);
				if(!empty($vehicle_cover_image)) {
					$vehicle_image_url = $vehicle_cover_image;
				}

				$vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));
				$vehicle_power_hp = esc_attr(get_post_meta($car_ID, 'vehicle_power_hp',true));

				$vehicle_drive = get_the_terms($car_ID, 'vehicle_drive' );
				$terms_vehicle_drive = $vehicle_drive[0]->name;

				// Cars meta
				$vehicle_consumption_urban = esc_attr(get_post_meta($car_ID, 'vehicle_consumption_urban',true));
				$vehicle_consumption_highway = esc_attr(get_post_meta($car_ID, 'vehicle_consumption_highway',true));

				$terms_vehicle_fuel_type = "";
				$term_vehicle_fuel_type = "";
				$vehicle_fuel_type = get_the_terms($car_ID, 'vehicle_fuel_type' );
				if ($vehicle_fuel_type && ! is_wp_error($vehicle_fuel_type)) :
					$term_slugs_arr_cat = array();
						foreach ($vehicle_fuel_type as $term_cat) {
							$term_vehicle_fuel_type = $term_cat->name;
						}
					$terms_vehicle_fuel_type = join( " ", $term_vehicle_fuel_type);
				endif;

				$terms_vehicle_transmission = "";
				$term_vehicle_transmission = "";
				$vehicle_transmission = get_the_terms($car_ID, 'vehicle_transmission' );
				if ($vehicle_transmission && ! is_wp_error($vehicle_transmission)) :
					$term_slugs_arr_cat = array();
						foreach ($vehicle_transmission as $term_cat) {
							$term_vehicle_transmission = $term_cat->name;
						}
					$terms_vehicle_transmission = join( " ", $term_vehicle_transmission);
				endif;

				$vehicle_name = $vehicle_year . " " . $vehicle_make . " " . $vehicle_model;

			?>

			<div class="<?php if( $columns == "3" ) { echo "col-lg-4"; } else { echo "col-lg-3"; } ?> col-md-6 col-sm-12 autoroyal-animated-blk"> 

				<div class="autoroyal-vehicle-block autoroyal-block-style-2">
					
					<div class="autoroyal-vehicle-block-image-wrapper">
						<?php if(!empty($vehicle_image_url)) { $foto_large = autoroyal_get_resized_image( $vehicle_image_url, 'autoroyal-thumbnail-image' ); ?>
						<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-thumbnail" style="background-image: url(<?php echo esc_url($foto_large); ?>);"></a>
						<?php } else { ?>
						<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-no-thumbnail">
							<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 538.043 538.043" style="enable-background:new 0 0 538.043 538.043;" xml:space="preserve"><path d="M526.745,312.866h-15.005c-3.706-18.736-10.307-44.359-20.792-57.941c-49.022-63.573-110.574-97.697-187.945-97.697
			c-50.134,0-82.787,4.902-99.789,14.981c-2.295,1.363-9.063,5.369-27.344,42.135c-26.687,0.419-97.278,5.261-131.127,43.414
			c-16.99,19.143-23.746,39.719-26.352,55.096h-7.078C5.058,312.854,0,317.924,0,324.177c0,6.241,5.058,11.323,11.311,11.323h5.655
			c0.048,0.61,0.096,1.076,0.108,1.219c0.598,5.739,5.464,10.115,11.239,10.115h14.252c8.752,19.968,28.66,33.981,51.831,33.981
			s43.079-14.013,51.855-33.981h215.982c8.74,19.968,28.66,33.981,51.832,33.981c23.172,0,43.091-14.013,51.832-33.981h38.165
			c0.084,0,0.155,0,0.215,0c6.253,0,11.335-5.07,11.335-11.323h11.131c6.241,0,11.299-5.081,11.299-11.323
			C538.044,317.924,532.986,312.866,526.745,312.866z M94.397,358.169c-18.724,0-33.968-15.232-33.968-33.981
			c0-18.748,15.232-33.992,33.968-33.992c18.748,0,34.004,15.245,34.004,33.992C128.402,342.937,113.145,358.169,94.397,358.169z
			 M295.183,226.433c0,3.133-2.523,5.667-5.667,5.667h-87.964c-1.937,0-3.742-1.016-4.783-2.666
			c-1.052-1.662-1.148-3.731-0.287-5.476c4.149-8.537,11.67-23.327,15.269-26.4c11.981-7.616,36.001-11.227,72.002-11.227
			c1.961,0,3.922,0.024,5.906,0.06c3.061,0.072,5.512,2.595,5.512,5.667L295.183,226.433L295.183,226.433z M306.53,226.433V193.66
			c0-1.614,0.705-3.157,1.901-4.233c1.208-1.076,2.81-1.614,4.424-1.399c39.863,4.687,70.519,17.875,82.058,35.272
			c1.16,1.746,1.244,3.97,0.263,5.811c-0.968,1.841-2.905,2.989-4.998,2.989h-78.004C309.077,232.1,306.53,229.565,306.53,226.433z
			 M414.067,358.169c-18.724,0-33.98-15.232-33.98-33.981c0-18.748,15.244-33.992,33.98-33.992c18.736,0,33.98,15.245,33.98,33.992
			C448.047,342.937,432.791,358.169,414.067,358.169z"/></svg>
						</a>
						<?php } ?>
					</div>

					<div class="autoroyal-vehicle-block-meta">

						<a class="heading" href="<?php echo get_permalink( $car_ID ); ?>"><span class="productYear"><?php echo esc_attr($vehicle_year); ?></span> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?></a>

						<ul class="autoroyal-vehicle-block-specs">

							<?php if(!empty($vehicle_mileage)) { ?>

								<li class="autoroyal-vehicle-transmission">

									<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M435.143,129.356c-6.796-6.795-17.463-7.797-25.407-2.384c-29.926,20.398-180.03,122.969-196.162,139.1
				c-23.394,23.395-23.394,61.459,0,84.854c11.697,11.696,27.063,17.545,42.427,17.545c15.364,0,30.729-5.849,42.427-17.545
				c16.131-16.132,118.701-166.236,139.1-196.162C442.939,146.821,441.938,136.153,435.143,129.356z M270.142,322.641
				c-7.797,7.799-20.486,7.799-28.283,0c-7.798-7.797-7.799-20.482-0.004-28.28c6.268-6.194,48.885-36.588,101.319-73.035
				C306.728,273.76,276.334,316.375,270.142,322.641z"/><path d="M92.231,401.523l-24.69,12.044C49.475,381.325,40,345.338,40,308.499c0-26.991,4.977-52.842,14.06-76.683l28.291,13.57
				c2.79,1.338,5.735,1.972,8.636,1.972c7.453,0,14.608-4.185,18.047-11.355c4.776-9.959,0.576-21.906-9.384-26.683l-27.932-13.398
				c34.717-56.62,94.784-96.095,164.283-102.505v30.081c0,11.046,8.954,20,20,20c11.046,0,20-8.954,20-20V93.402
				c23.828,2.169,46.884,8.237,68.771,18.117c10.065,4.545,21.912,0.066,26.457-9.999c4.545-10.068,0.068-21.913-10-26.458
				C328.063,60.091,292.659,52.499,256,52.499c-68.38,0-132.667,26.628-181.02,74.98C26.629,175.832,0,240.119,0,308.499
				c0,50.53,14.998,99.674,43.373,142.115c3.822,5.715,10.141,8.886,16.639,8.886c2.954,0,5.946-0.655,8.757-2.026l41-20
				c9.928-4.843,14.05-16.816,9.207-26.744C114.133,400.803,102.159,396.682,92.231,401.523z"/><path d="M489.436,203.271c-4.544-10.067-16.387-14.547-26.458-10c-10.067,4.545-14.544,16.39-9.999,26.457
				C465.601,247.686,472,277.553,472,308.499c0,36.894-9.506,72.939-27.625,105.218l-25.777-12.275
				c-9.971-4.748-21.906-0.515-26.656,9.459c-4.749,9.972-0.514,21.907,9.459,26.656l42,20c2.763,1.315,5.692,1.944,8.588,1.944
				c6.5,0,12.82-3.175,16.637-8.886C497.002,408.173,512,359.029,512,308.499C512,271.84,504.408,236.436,489.436,203.271z"/></svg>


									<span><?php echo autoroyal_number($vehicle_mileage); ?> <?php $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo "Km"; } else { echo "Mi"; } ?></span>

								</li>

							<?php } else { ?>

								<li class="autoroyal-vehicle-condition">
									<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="48.997px" height="48.998px" viewBox="0 0 48.997 48.998" style="enable-background:new 0 0 48.997 48.998;" xml:space="preserve"><path d="M45.961,18.702c-0.033-0.038-0.061-0.075-0.1-0.112l-1.717-1.657c1.424-0.323,2.957-1.516,2.957-2.74
c0-1.426-1.979-1.932-3.668-1.932c-1.766,0-1.971,1.21-1.992,2.065l-4.43-4.271c-0.9-0.891-2.607-1.592-3.883-1.592H24.5h-0.002
h-8.63c-1.275,0-2.981,0.701-3.882,1.592l-4.429,4.271c-0.023-0.855-0.228-2.065-1.992-2.065c-1.691,0-3.669,0.506-3.669,1.932
c0,1.224,1.534,2.417,2.958,2.74l-1.717,1.657c-0.039,0.037-0.066,0.074-0.1,0.112C1.2,20.272,0,23.184,0,25.297v6.279
c0,1.524,0.601,2.907,1.572,3.938v2.435c0,1.424,1.192,2.585,2.658,2.585h3.214c1.466,0,2.657-1.159,2.657-2.585v-0.623h14.397
H24.5h14.396v0.623c0,1.426,1.19,2.585,2.658,2.585h3.213c1.467,0,2.657-1.161,2.657-2.585v-2.435
c0.972-1.031,1.572-2.414,1.572-3.938v-6.279C48.998,23.184,47.798,20.272,45.961,18.702z M13.613,11.953
c0.623-0.519,1.712-0.913,2.255-0.913h8.63H24.5h8.63c0.543,0,1.632,0.394,2.255,0.913l5.809,5.63H24.5h-0.002H7.805L13.613,11.953
z M1.993,24.347c0-1.546,1.21-2.801,2.704-2.801c1.493,0,6.372,2.864,6.372,4.41s-4.879,1.188-6.372,1.188
C3.203,27.144,1.993,25.894,1.993,24.347z M10.102,34.573H9.587H9.072l-3.055,0.005c-0.848-0.264-1.446-0.572-1.869-0.903
c-0.214-0.167-0.378-0.341-0.506-0.514c-0.129-0.175-0.223-0.347-0.284-0.519c-0.38-1.074,0.405-2.061,0.405-2.061h5.214
l3.476,3.99L10.102,34.573L10.102,34.573z M31.996,34.575H24.5h-0.002h-7.496c-1.563,0-2.832-1.269-2.832-2.831h10.328H24.5h10.328
C34.828,33.308,33.559,34.575,31.996,34.575z M32.654,29.812H24.5h-0.002h-8.154c-1.7,0-3.08-2.096-3.08-4.681h11.234H24.5h11.234
C35.734,27.717,34.354,29.812,32.654,29.812z M45.641,32.644c-0.062,0.172-0.156,0.344-0.285,0.518
c-0.127,0.173-0.291,0.347-0.506,0.514c-0.422,0.331-1.021,0.641-1.869,0.903l-3.055-0.005h-0.515h-0.515h-2.353l3.478-3.99h5.213
C45.234,30.583,46.02,31.568,45.641,32.644z M44.301,27.144c-1.492,0-6.371,0.356-6.371-1.188s4.879-4.41,6.371-4.41
c1.494,0,2.704,1.255,2.704,2.801C47.005,25.892,45.795,27.144,44.301,27.144z"/></svg>

									<span><?php echo esc_attr($vehicle_condition); ?></span>
								</li>

							<?php } ?>

							<?php if(!empty($terms_vehicle_transmission)) { ?>

								<li class="autoroyal-vehicle-transmission">

									<svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M30,94H70A24,24,0,0,0,94,70V30A24,24,0,0,0,70,6H30A24,24,0,0,0,6,30V70A24,24,0,0,0,30,94ZM14,30A16,16,0,0,1,30,14H70A16,16,0,0,1,86,30V70A16,16,0,0,1,70,86H30A16,16,0,0,1,14,70Z"/><path d="M30,74a4,4,0,0,0,4-4V54H46V70a4,4,0,0,0,8,0V54h8A12,12,0,0,0,74,42V30a4,4,0,0,0-8,0V42a4,4,0,0,1-4,4H54V30a4,4,0,0,0-8,0V46H34V30a4,4,0,0,0-8,0V70A4,4,0,0,0,30,74Z"/><circle cx="70" cy="70" r="4"/></svg>

									<span><?php echo esc_attr($terms_vehicle_transmission); ?></span>

								</li>

							<?php } ?>

						</ul>

						<ul class="autoroyal-vehicle-block-specs hidden">

							<?php if( !empty($vehicle_consumption_urban) AND !empty($vehicle_consumption_highway) ) { ?>

								<li class="autoroyal-vehicle-fuel-type">

									<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="200" width="200" fill="#000000" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve"><g><path d="M89.417,36.305c0.18-1.034-0.144-2.146-0.953-2.877l-11.045-9.943c-1.193-1.071-3.198-1.139-4.459-0.146l-1.392,1.098   l0.55-7.6c0.116-1.6-1.102-2.907-2.705-2.907h-4.241V7.292C65.172,3.281,61.892,0,57.88,0H17.819c-4.011,0-7.292,3.281-7.292,7.292   V92.71c0,4.009,3.281,7.29,7.292,7.29H57.88c4.012,0,7.292-3.281,7.292-7.29V70.482h0.241c1.604,0,2.915-1.312,2.915-2.916v-1.449   c1.66,0.897,3.29,2.75,3.75,6.534c0.553,4.566-0.074,8.193-0.579,11.107c-0.301,1.734-0.56,3.231-0.56,4.679   c0,6.78,4.317,10.439,8.38,10.439c2.228,0,4.346-1.059,5.812-2.9c1.49-1.877,2.278-4.481,2.278-7.539   c0-5.536-0.67-10.292-1.318-14.894c-0.787-5.587-1.537-10.905-1.138-17.48c1.454-0.025,2.705-1.127,2.854-2.608l1.653-16.373   C89.488,36.812,89.464,36.554,89.417,36.305z M27.008,35.317c-1.512,0-2.738-1.227-2.738-2.737c0-1.515,1.227-2.738,2.738-2.738   c1.513,0,2.738,1.224,2.738,2.738C29.746,34.091,28.521,35.317,27.008,35.317z M37.851,35.317c-1.511,0-2.737-1.227-2.737-2.737   c0-1.515,1.227-2.738,2.737-2.738c1.514,0,2.739,1.224,2.739,2.738C40.59,34.091,39.364,35.317,37.851,35.317z M48.694,35.317   c-1.512,0-2.737-1.227-2.737-2.737c0-1.515,1.226-2.738,2.737-2.738c1.513,0,2.739,1.224,2.739,2.738   C51.434,34.091,50.207,35.317,48.694,35.317z M59.258,19.937c0,1.604-1.313,2.916-2.917,2.916H19.359   c-1.604,0-2.916-1.312-2.916-2.916v-9.825c0-1.604,1.312-2.916,2.916-2.916h36.981c1.604,0,2.917,1.312,2.917,2.916V19.937z    M81.167,92.824c-1.734,2.182-5.164,0.629-5.164-4.387c0-1.012,0.226-2.311,0.485-3.813c0.531-3.07,1.259-7.277,0.616-12.583   c-0.829-6.815-4.753-10.178-8.776-11.322v-1.161c0-1.604-1.312-2.916-2.915-2.916h-0.241v-13.07h2.096   c1.604,0,3.011-1.308,3.127-2.907l0.331-4.587l7.198,3.511l-0.065,12.875c-0.008,1.316,0.871,2.512,2.067,2.993   c-0.468,7.242,0.35,13.108,1.15,18.797c0.653,4.629,1.27,9.003,1.27,14.185C82.346,90.31,81.927,91.868,81.167,92.824z"/></g></svg>

									<span><?php echo esc_attr($vehicle_consumption_urban); ?>/<?php echo esc_attr($vehicle_consumption_highway); ?></span>

								</li>

							<?php } ?>

							<?php if(!empty($terms_vehicle_transmission)) { ?>

								<li class="autoroyal-vehicle-transmission">

									<svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M50,82A32,32,0,1,0,18,50,32,32,0,0,0,50,82ZM32.88,37a2,2,0,0,1,4,0V48H48V37a2,2,0,0,1,4,0V48H63.13V37a2,2,0,1,1,4,0V63a2,2,0,0,1-4,0V52H52V63a2,2,0,0,1-4,0V52H36.88V63a2,2,0,0,1-4,0Z"/></svg>

									<span><?php echo esc_attr($terms_vehicle_transmission); ?></span>

								</li>

							<?php } ?>

							<?php if(!empty($terms_vehicle_drive)) { ?>

								<li class="autoroyal-vehicle-transmission">

									<svg xmlns:svg="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" version="1.1" x="0px" y="0px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve"><g><path d="M325.763,602.711c-8.066,0-16.135-0.751-23.981-2.23c-10.853-2.046-21.313,5.094-23.359,15.948   c-2.047,10.854,5.093,21.312,15.948,23.359c10.284,1.939,20.846,2.923,31.393,2.923c45.001,0,87.309-17.524,119.129-49.346   c31.82-31.819,49.345-74.127,49.345-119.127c0-92.897-75.577-168.475-168.474-168.475s-168.474,75.577-168.474,168.475   c0,23.322,4.683,45.915,13.919,67.148c4.406,10.129,16.188,14.768,26.318,10.362c10.129-4.406,14.768-16.188,10.361-26.317   c-7.033-16.17-10.599-33.394-10.599-51.193c0-70.842,57.633-128.475,128.474-128.475c70.84,0,128.474,57.633,128.474,128.475   c0,34.315-13.363,66.578-37.629,90.844C392.342,589.347,360.079,602.711,325.763,602.711z"/><path d="M239.7,569.627c-8.199-7.402-20.846-6.756-28.248,1.441c-7.402,8.199-6.756,20.846,1.442,28.248   c5.047,4.557,10.422,8.85,15.976,12.76c3.5,2.464,7.518,3.647,11.496,3.647c6.287,0,12.477-2.956,16.371-8.487   c6.359-9.032,4.191-21.509-4.84-27.867C247.658,576.384,243.554,573.106,239.7,569.627z"/><path d="M617.458,424.134l-50.18-26.548c-4.355-13.725-9.896-27.088-16.545-39.899l16.719-54.28   c2.181-7.083,0.268-14.79-4.973-20.029l-45.856-45.856c-5.239-5.24-12.948-7.154-20.028-4.973l-54.28,16.72   c-12.813-6.649-26.176-12.191-39.9-16.547l-26.549-50.181c-3.465-6.55-10.268-10.646-17.678-10.646h-64.85   c-7.41,0-14.213,4.097-17.679,10.647l-26.547,50.181c-16.496,5.234-32.469,12.183-47.591,20.707   c-9.622,5.425-13.024,17.622-7.6,27.244s17.622,13.024,27.244,7.601c14.868-8.383,30.71-14.952,47.083-19.525   c5.285-1.476,9.731-5.059,12.298-9.909l24.837-46.945h40.758l24.838,46.945c2.566,4.851,7.013,8.434,12.298,9.91   c16.372,4.572,32.214,11.141,47.083,19.524c4.782,2.695,10.463,3.307,15.709,1.691l50.787-15.643l28.822,28.821l-15.643,50.788   c-1.615,5.246-1.004,10.926,1.691,15.707c8.382,14.868,14.95,30.71,19.523,47.085c1.477,5.285,5.06,9.731,9.91,12.298   l46.944,24.836v40.758l-46.944,24.836c-4.851,2.566-8.434,7.014-9.91,12.299c-4.574,16.377-11.143,32.219-19.523,47.084   c-5.424,9.622-2.021,21.82,7.602,27.244c3.104,1.75,6.477,2.581,9.803,2.581c6.984,0,13.767-3.664,17.441-10.182   c8.523-15.12,15.47-31.092,20.705-47.59l50.181-26.548c6.55-3.466,10.646-10.269,10.646-17.678v-64.85   C628.105,434.402,624.009,427.599,617.458,424.134z"/><path d="M534.195,636.813l-37.339,37.34l-50.786-15.644c-5.248-1.616-10.929-1.004-15.711,1.692   c-14.862,8.381-30.703,14.949-47.082,19.523c-5.285,1.477-9.732,5.06-12.299,9.91l-24.835,46.945h-40.76l-24.836-46.945   c-2.566-4.851-7.014-8.434-12.299-9.91c-16.38-4.574-32.221-11.143-47.08-19.523c-4.783-2.696-10.464-3.309-15.711-1.692   l-50.787,15.644l-28.822-28.822l15.643-50.787c1.615-5.247,1.004-10.928-1.692-15.71c-8.382-14.866-14.951-30.707-19.524-47.083   c-1.477-5.285-5.059-9.731-9.909-12.298L63.42,494.617v-40.76l46.945-24.836c4.851-2.566,8.433-7.013,9.909-12.298   c4.573-16.374,11.142-32.215,19.524-47.084c2.696-4.782,3.308-10.462,1.692-15.708l-15.643-50.788l37.339-37.339   c7.81-7.811,7.81-20.474-0.001-28.284s-20.474-7.811-28.284,0l-45.855,45.856c-5.239,5.239-7.152,12.946-4.972,20.029   l16.718,54.279c-6.648,12.813-12.19,26.176-16.546,39.9l-50.18,26.548c-6.55,3.465-10.647,10.268-10.647,17.679v64.852   c0,7.41,4.098,14.214,10.649,17.679l50.178,26.545c4.355,13.727,9.897,27.089,16.546,39.899l-16.718,54.281   c-2.181,7.082-0.268,14.789,4.972,20.028l45.856,45.857c5.24,5.239,12.948,7.153,20.03,4.972l54.278-16.719   c12.808,6.646,26.172,12.189,39.9,16.545l26.547,50.181c3.466,6.55,10.269,10.647,17.679,10.647h64.851   c7.41,0,14.213-4.098,17.679-10.647l26.547-50.181c13.729-4.355,27.092-9.896,39.901-16.545l54.278,16.719   c7.081,2.181,14.79,0.268,20.03-4.972l45.856-45.857c7.81-7.811,7.81-20.474-0.001-28.284S542.006,629.002,534.195,636.813z"/><path d="M642.711,325.764c0-92.898-75.577-168.476-168.475-168.476c-19.059,0-37.769,3.163-55.61,9.401   c-10.427,3.646-15.924,15.054-12.279,25.48c3.646,10.426,15.054,15.923,25.48,12.277c13.588-4.75,27.856-7.159,42.409-7.159   c70.841,0,128.475,57.634,128.475,128.476c0,13.914-2.206,27.588-6.557,40.643c-3.493,10.479,2.171,21.805,12.649,25.298   c2.1,0.699,4.23,1.031,6.327,1.031c8.374,0,16.178-5.301,18.972-13.682C639.814,361.914,642.711,343.984,642.711,325.764z"/><path d="M765.933,275.659l-50.18-26.547c-4.355-13.724-9.896-27.087-16.545-39.9l16.719-54.281   c2.181-7.081,0.268-14.789-4.973-20.028l-45.857-45.857c-5.24-5.24-12.947-7.153-20.029-4.972l-54.278,16.72   c-12.813-6.65-26.177-12.191-39.9-16.546l-26.548-50.179c-3.465-6.551-10.269-10.648-17.679-10.648h-64.85   c-7.41,0-14.213,4.098-17.679,10.647l-26.547,50.18c-13.725,4.354-27.088,9.896-39.9,16.546l-54.282-16.719   c-7.081-2.181-14.788-0.267-20.028,4.973l-45.855,45.855c-7.811,7.811-7.811,20.474-0.001,28.284   c7.811,7.811,20.475,7.811,28.284,0l37.34-37.338l50.787,15.641c5.246,1.617,10.928,1.006,15.71-1.69   c14.869-8.384,30.71-14.952,47.082-19.523c5.286-1.477,9.732-5.06,12.299-9.911l24.837-46.944h40.758l24.837,46.944   c2.566,4.852,7.014,8.435,12.3,9.911c16.371,4.571,32.212,11.14,47.082,19.523c4.783,2.695,10.463,3.308,15.709,1.69l50.786-15.643   l28.823,28.822l-15.643,50.788c-1.615,5.246-1.004,10.925,1.691,15.706c8.383,14.872,14.951,30.714,19.523,47.086   c1.477,5.286,5.059,9.732,9.91,12.299l46.944,24.835v40.759l-46.944,24.838c-4.852,2.566-8.434,7.013-9.91,12.298   c-4.572,16.369-11.141,32.211-19.523,47.084c-2.695,4.781-3.307,10.46-1.691,15.705l15.643,50.79l-37.34,37.336   c-7.811,7.811-7.811,20.474-0.001,28.284c3.905,3.906,9.023,5.859,14.143,5.859c5.118,0,10.237-1.953,14.142-5.857l45.857-45.854   c5.24-5.24,7.154-12.949,4.973-20.031l-16.719-54.282c6.648-12.813,12.189-26.176,16.545-39.896l50.182-26.55   c6.549-3.466,10.646-10.269,10.646-17.678v-64.851C776.58,285.927,772.482,279.124,765.933,275.659z"/></g></svg>

									<span><?php echo esc_attr($terms_vehicle_drive); ?></span>

								</li>

							<?php } ?>

						</ul>

						<h4 class="autoroyal-vehicle-block-meta-price"><?php echo autoroyal_price($price); ?></h4>

						<?php 

	          				$listing_id = $car_ID; 

	          				if ( ! empty( $cars_in_compare ) and in_array( $listing_id, $cars_in_compare ) ) {
								$car_compare_status       = esc_html__( 'Remove from compare', 'autoroyal' );
								$car_compare_status_class = "added";
							} else {
								$car_compare_status       = esc_html__( 'Add to compare', 'autoroyal' );
								$car_compare_status_class = "";
							}

	      				?>

	          			<a href="#" class="fav-button btn btn-danger pull-right add-to-compare <?php echo esc_attr($car_compare_status_class); ?>" data-id="<?php echo esc_attr($listing_id); ?>" data-title="<?php echo esc_attr($vehicle_name); ?>" data-toggle="tooltip" data-placement="top"  data-original-title="<?php echo esc_attr($car_compare_status); ?>">
	          				<svg class="add-to-compare-plus" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve"><path d="M129.2,72.3l-23.1,23.1c-11.2-3.4-23,2.8-26.4,14s2.8,23,14,26.4c11.2,3.4,23-2.8,26.4-14c1.7-5.4,1.1-11.2-1.6-16.2l22-22
	L129.2,72.3z M100,120.7c-2.8,0-5.1-2.3-5.1-5.1s2.3-5.1,5.1-5.1c2.8,0,5.1,2.3,5.1,5.1l0,0C105.1,118.4,102.8,120.7,100,120.7z"/><g><path d="M40.8,30.2c0-5.1,2.2-8,8-8c5.8,0,8,2.9,8,8V54h23.5c4.2,0,8,2.2,8,8c0,5.8-3.8,8-8,8H56.8v23.5c0,5.1-2.2,8-8,8
	c-5.8,0-8-2.9-8-8V70H17.3c-4.2,0-8-2.2-8-8c0-5.8,3.8-8,8-8h23.5V30.2z"/></g><g><path d="M162.6,48c-15.4-15-34.7-23.5-54.6-25.4v15.3c14.2,1.5,27.7,7,38.9,16l-12.2,12.2L146,77.4l12.2-12.2
	c9,11.1,14.5,24.6,16,38.9H157v16h17.2c-1.5,14.2-7,27.7-16,38.9L146,146.8l-11.3,11.3l17.8,17.8c0.1,0.1,0.2,0.3,0.3,0.4
	c3.1,3.1,8.2,3.1,11.3,0c0,0,0,0,0,0C199.1,140.4,198.4,83,162.6,48z"/><path d="M41.8,159c-8.9-11-14.4-24.4-16-38.5H9.7c1.9,20.3,10.6,40.2,26.2,55.8c3.1,3.1,8.2,3.1,11.3,0c0,0,0,0,0,0
	c0.1-0.1,0.2-0.3,0.3-0.4l17.8-17.8L54,146.8L41.8,159z"/></g></svg>
							<svg class="add-to-compare-minus" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve"><path d="M129.2,72.3l-23.1,23.1c-11.2-3.4-23,2.8-26.4,14s2.8,23,14,26.4c11.2,3.4,23-2.8,26.4-14c1.7-5.4,1.1-11.2-1.6-16.2l22-22
	L129.2,72.3z M100,120.7c-2.8,0-5.1-2.3-5.1-5.1s2.3-5.1,5.1-5.1c2.8,0,5.1,2.3,5.1,5.1l0,0C105.1,118.4,102.8,120.7,100,120.7z"/><g><path d="M162.6,48c-15.4-15-34.7-23.5-54.6-25.4v15.3c14.2,1.5,27.7,7,38.9,16l-12.2,12.2L146,77.4l12.2-12.2
	c9,11.1,14.5,24.6,16,38.9H157v16h17.2c-1.5,14.2-7,27.7-16,38.9L146,146.8l-11.3,11.3l17.8,17.8c0.1,0.1,0.2,0.3,0.3,0.4
	c3.1,3.1,8.2,3.1,11.3,0l0,0C199.1,140.4,198.4,83,162.6,48z"/><path d="M41.8,159c-8.9-11-14.4-24.4-16-38.5H9.7c1.9,20.3,10.6,40.2,26.2,55.8c3.1,3.1,8.2,3.1,11.3,0l0,0
	c0.1-0.1,0.2-0.3,0.3-0.4l17.8-17.8L54,146.8L41.8,159z"/></g><path d="M17.3,70.2h23.5v0h16v0h23.5c4.2,0,8-2.2,8-8s-3.8-8-8-8H56.8h-16H17.3c-4.2,0-8,2.2-8,8S13.1,70.2,17.3,70.2z"/></svg>

	          			</a>

						<?php 

							if( is_user_logged_in() ){

								$user_id = get_current_user_id();
	            				$listing_id = $car_ID;
	            				$user_type = "id";

	            			} else {

	            				$user_id = autoroyalGetIP();
	            				$listing_id = $car_ID;
	            				$user_type = "ip";

	            			}

						?>

						<a href="#" type="button" class="fav-button btn btn-danger pull-right favorited add-to-favorite" data-id="<?php echo esc_attr($listing_id); ?>" data-user-id="<?php echo esc_attr($user_id); ?>" data-user-type="<?php echo esc_attr($user_type); ?>"> 
							<?php if( is_added_to_favorite( $user_type, $user_id, $listing_id ) ){ ?><i class="fa fa-heart"></i><?php } else { ?><i class="far fa-heart"></i><?php } ?>
						</a>

					</div>

				</div>

			</div>

		<?php endforeach; 

	endif;

	$response['pagination'] = get_autoroyal_template( 'pagination-ajax.php', array( 'max_num_pages' => $max_num_pages, 'paged' => $paged ) );
	$response['total'] = $total;
	$response['html'] = ob_get_clean();

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_ajax_filter', 'autoroyal_ajax_filter' );
add_action( 'wp_ajax_nopriv_autoroyal_ajax_filter', 'autoroyal_ajax_filter' );

/**
* Car Search Filter
*/
if ( ! function_exists( 'autoroyal_search_filter' ) ) {
	/**
	 * Properties Search Filter
	 *
	 * @param $search_args
	 * @return mixed
	 */
	function autoroyal_search_filter( $search_args ) {

		$tax_query = array();   // taxonomy query array
		$meta_query = array();  // meta query qrray

		/* Car Make */
		if ( ( ! empty( $_GET[ 'make' ] ) ) && ( $_GET[ 'make' ] != '0' ) ) {
			$meta_query[] = array(
				'key' => 'vehicle_make_desc_init',
				'value' => $_GET[ 'make' ],
			);
		}

		/* Car Model */
		if ( ( ! empty( $_GET[ 'model' ] ) ) && ( $_GET[ 'model' ] != '0' ) ) {
			$meta_query[] = array(
				'key' => 'vehicle_model',
				'value' => $_GET[ 'model' ],
			);
		}

		/* Fuel Type */
		if ( ( ! empty( $_GET[ 'fuel_type' ] ) ) && ( $_GET[ 'fuel_type' ] != '0' ) ) {
			$tax_query[] = array(
				'taxonomy' => 'vehicle_fuel_type',
				'field' => 'term_id',
				'terms' => $_GET[ 'fuel_type' ],
			);
		}

		/* Vehicle Price Min */
	    if ( isset( $_GET[ 'price' ] ) && !empty( $_GET[ 'price' ] )) {
	    	if( isset( $_GET[ 'price_min' ] ) && !empty( $_GET[ 'price_min' ] ) ) {
	    		$price_min = $_GET[ 'price_min' ];
	    	} else {
	    		$price_min = "0";
	    	}
	        $price_max = $_GET[ 'price' ];
	        $meta_query[] = array(
                'key' => 'vehicle_price',
                'value' => array( $price_min, $price_max ),
                'type' => 'NUMERIC',
                'compare' => 'BETWEEN'
            );
	    }

	    /* Transimission */
        if ( ( ! empty( $_GET[ 'transmission' ] ) ) && ( $_GET[ 'transmission' ] != '0' ) ) {
            $tax_query[] = array(
                'taxonomy' => 'vehicle_transmission',
                'field' => 'term_id',
                'terms' => $_GET[ 'transmission' ],
                'operator' => 'IN',
            );
        }

        /* Body Style */
        if ( ( ! empty( $_GET[ 'body_style' ] ) ) && ( $_GET[ 'body_style' ] != '0' ) ) {
            $tax_query[] = array(
                'taxonomy' => 'vehicle_body_style',
                'field' => 'term_id',
                'terms' => $_GET[ 'body_style' ],
                'operator' => 'IN',
            );
        }

        /* Vehicle Exterior Color */
	    if ( ( ! empty( $_GET[ 'vehicle_exterior_color' ] ) ) && ( $_GET[ 'vehicle_exterior_color' ] != '0' ) ) {
	        $tax_query[] = array(
	            'taxonomy' => 'vehicle_exterior_color',
	            'field' => 'term_id',
	            'terms' => $_GET[ 'vehicle_exterior_color' ],
	            'operator' => 'IN',
	        );
	    }

		/* Car year min */
	    if ( isset( $_GET[ 'vehicle_year_min' ] ) && !empty( $_GET[ 'vehicle_year_min' ] ) && isset( $_GET[ 'vehicle_year_max' ] ) && !empty( $_GET[ 'vehicle_year_max' ] )) {
	        $vehicle_year_min = $_GET[ 'vehicle_year_min' ];
	        $vehicle_year_max = $_GET[ 'vehicle_year_max' ];
	        if ( $vehicle_year_min >= 0 && $vehicle_year_max >= 0 ) {
	            $meta_query[] = array(
	                'key' => 'vehicle_year',
	                'value' => array( $vehicle_year_min, $vehicle_year_max ),
	                'type' => 'NUMERIC',
	                'compare' => 'BETWEEN'
	            );
	        }
	    }

		/* vehicle Mileage */
	    if ( isset( $_GET[ 'mileage' ] ) && !empty( $_GET[ 'mileage' ] ) && isset( $_GET[ 'mileage_min' ] ) && !empty( $_GET[ 'mileage_min' ] )) {
	        $mileage = $_GET[ 'mileage' ];
	        $mileage = $mileage * 1000;
	        $mileage_min = $_GET[ 'mileage_min' ];
	        $mileage_min = $mileage_min * 1000;
	        if ( $mileage >= 0 && $mileage_min >= 0 ) {
	            $meta_query[] = array(
	                'key' => 'vehicle_mileage',
	                'value' => array( $mileage_min, $mileage ),
	                'type' => 'NUMERIC',
	                'compare' => 'BETWEEN'
	            );
	        }
	    }

		/* Car Condition */
		if ( ( ! empty( $_GET[ 'vehicle_condition' ] ) ) && isset( $_GET[ 'vehicle_condition' ] ) ) {
			$meta_query[] = array(
				'key' => 'vehicle_condition',
				'value' => $_GET[ 'vehicle_condition' ],
			);
		}

		/* Sort By Year */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'year_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_year';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'year_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_year';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Make */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'make_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'vehicle_make';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'make_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'vehicle_make';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Model */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'model_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'vehicle_model';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'model_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value';
			$search_args[ 'meta_key' ] = 'vehicle_model';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Mileage */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'mileage_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_mileage';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'mileage_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_mileage';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Cost */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'cost_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_cost';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'cost_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_cost';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Price */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'price_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_price';
			$search_args[ 'order' ] = 'ASC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'price_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'meta_value_num';
			$search_args[ 'meta_key' ] = 'vehicle_price';
			$search_args[ 'order' ] = 'DESC';
		}

		/* Sort By Price */
		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'age_asc' ) ) ) {
			$search_args[ 'orderby' ] = 'date';
			$search_args[ 'order' ] = 'DESC';
		}

		if ( ( isset( $_GET[ 'orderby' ] ) && ( $_GET[ 'orderby' ] == 'age_desc' ) ) ) {
			$search_args[ 'orderby' ] = 'date';
			$search_args[ 'order' ] = 'ASC';
		}

		/* if more than one taxonomies exist then specify the relation */
		$tax_count = count( $tax_query );
		if ( $tax_count > 1 ) {
			$tax_query[ 'relation' ] = 'AND';
		}

		/* if more than one meta query elements exist then specify the relation */
		$meta_count = count( $meta_query );
		if ( $meta_count > 1 ) {
			$meta_query[ 'relation' ] = 'AND';
		}

		if ( $tax_count > 0 ) {
			$search_args[ 'tax_query' ] = $tax_query;
		}

		/* if meta query has some values then add it to base home page query */
		if ( $meta_count > 0 ) {
			$search_args[ 'meta_query' ] = $meta_query;
		}

		return $search_args;
	}

	add_filter( 'autoroyal_search_filter_parameters', 'autoroyal_search_filter' );
}


/*
|--------------------------------------------------------------------------
| Post views function
|--------------------------------------------------------------------------
*/

// function to display number of posts.
function autoroyal_getPostViews($postID){
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0";
    }
    return $count.'';
}

// function to count views.
function autoroyal_setPostViews($postID) {
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}

// function to set post visited by specific user ( new when added in filter ).
function autoroyal_setPostVisited($postID) {

	if ( is_user_logged_in() ) {

		$user_id = get_current_user_id();

		if( !empty($user_id) ) {
			$filter_user_id = get_post_meta($postID, 'filter_user_'.$user_id, true);
			if( !empty($filter_user_id) ) {
				update_post_meta($postID, 'filter_user_'.$user_id, 'old');
			}
		}

	}

}

// Views Admin Column
add_filter('manage_edit-vehicle_columns', 'vehicle_views_column');
function vehicle_views_column($columns) {
    $columns['views'] = 'Views';
    return $columns;
}

add_action('manage_vehicle_posts_custom_column',  'vehicle_views_show_columns');
function vehicle_views_show_columns($name) {
    global $post;
    switch ($name) {
        case 'views':
            $views = autoroyal_getPostViews( $post->ID );
            echo $views;
    }
}

// Orderby views
add_filter("manage_edit-vehicle_sortable_columns", 'concerts_sort');
function concerts_sort($columns) {
	$custom = array(
		'views' 	=> 'views'
	);
	return wp_parse_args($custom, $columns);
	/* or this way
		$columns['concertdate'] = 'concertdate';
		$columns['city'] = 'city';
		return $columns;
	*/
}

/*
 * ADMIN COLUMN - SORTING - ORDERBY
 * http://scribu.net/wordpress/custom-sortable-columns.html#comment-4732
 */
add_filter( 'request', 'views_column_orderby' );
function views_column_orderby( $vars ) {
	if ( isset( $vars['orderby'] ) && 'views' == $vars['orderby'] ) {
		$vars = array_merge( $vars, array(
			'meta_key' => 'post_views_count',
			//'orderby' => 'meta_value_num', // does not work
			'orderby' => 'meta_value'
			//'order' => 'asc' // don't use this; blocks toggle UI
		) );
	}
	return $vars;
}

// Login / Register / Reset Password Function
add_action('wp_loaded', 'autoroyal_login_register_function');
function autoroyal_login_register_function(){
    
    if( 'POST' == $_SERVER['REQUEST_METHOD'] ) {

		if( isset( $_POST['ajaxLoginFunction_nonce'] ) && wp_verify_nonce( $_POST['ajaxLoginFunction_nonce'], 'ajaxLoginFunction_html' ) ){

			$creds                  = array();
			$creds['user_login']    = stripslashes( trim( $_POST['email'] ) );
			$creds['user_password'] = stripslashes( trim( $_POST['password'] ) );
			$secure_cookie          = null;
			
			if ( ! force_ssl_admin() ) {

				$user = is_email( $creds['user_login'] ) ? get_user_by( 'email', $creds['user_login'] ) : get_user_by( 'login', sanitize_user( $creds['user_login'] ) );

				if ( $user && get_user_option( 'use_ssl', $user->ID ) ) {
					$secure_cookie = true;
					force_ssl_admin( true );
				}

			}

			if ( force_ssl_admin() ) {
				$secure_cookie = true;
			}

			if ( is_null( $secure_cookie ) && force_ssl_login() ) {
				$secure_cookie = false;
			}

			$user = wp_signon( $creds, $secure_cookie );
			header("Refresh:0");

			if ( ! is_wp_error( $user ) ) {
				
			} else {

				if ( $user->errors ) {
					$errors['invalid_user'] = __('<span class="error-title">Error</span>Error with email or password.', 'autoroyal'); 
				} else {
					$errors['invalid_user_credentials'] = __( '<span class="error-title">Error</span>Email and password required.', 'autoroyal' );
				}

			}

		} elseif( isset( $_POST['ajaxResetPasswordFunction_nonce'] ) && wp_verify_nonce( $_POST['ajaxResetPasswordFunction_nonce'], 'ajaxResetPasswordFunction_html' ) ){
			
			$email = stripslashes( trim( $_POST['email'] ) );

			$user = get_user_by( 'email', $email );
			$td_user_id = $user->ID;

			if( !empty($td_user_id)) {

				$new_password = wp_generate_password( 12, false ); 

				if ( isset($new_password) ) {

					wp_set_password( $new_password, $td_user_id );

					$admin_email = get_option( 'admin_email' );
					$headers = "From: ".$admin_email . "\r\n";
					$subject = "Parolă nouă!";
					$msg = "Reset password.\nYour login details\nNew Password: $new_password";
					wp_mail( $email, $subject, $msg, $headers ); 

					$success['success_password_reset'] = __('<span class="success-title">Succes</span>Passwords has been reset. Check your email inbox for new password.', 'autoroyal');

				}

			} else {

				$errors['invalid_email'] = __("<span class='error-title'>Error</span>Email doesn't exist.", 'autoroyal'); 

			} // end if/else

		} elseif( isset( $_POST['ajaxRegisterDealerFunction_nonce'] ) && wp_verify_nonce( $_POST['ajaxRegisterDealerFunction_nonce'], 'ajaxRegisterDealerFunction_html' ) ){

			$username  = stripslashes( trim( $_POST['username'] ) );
			$email     = stripslashes( trim( $_POST['email'] ) );
			$password  = stripslashes( trim( $_POST['password'] ) ); 

			if( email_exists( $email )) {

			  	$errors['invalid_email'] = __('<span class="error-title">Error</span>Email is in use already.', 'autoroyal'); 

			} else {

				$user_id = wp_create_user( $username, $password, $email );
				$user_id_role = new WP_User($user_id);
				$user_id_role->set_role('dealer');

				$from = get_option('admin_email');
			  	$headers = 'From: '.$from . "\r\n";
			  	$subject = "Succesful registration";
			  	$msg = "Succesful registration.\nLogin info:\nEmail: $email\nPassword: $password";
			  	wp_mail( $email, $subject, $msg, $headers );

			  	$login_data = array();
			  	$login_data['user_login'] = $email;
			  	$login_data['user_password'] = $password;
			  	$secure_cookie          = null;

			  	if ( ! force_ssl_admin() ) {

					$user = is_email( $login_data['user_login'] ) ? get_user_by( 'email', $login_data['user_login'] ) : get_user_by( 'login', sanitize_user( $login_data['user_login'] ) );

					if ( $user && get_user_option( 'use_ssl', $user->ID ) ) {
						$secure_cookie = true;
						force_ssl_admin( true );
					}

				}

				if ( force_ssl_admin() ) {
					$secure_cookie = true;
				}

				if ( is_null( $secure_cookie ) && force_ssl_login() ) {
					$secure_cookie = false;
				}

			  	wp_signon( $login_data, $secure_cookie );
			  	header("Refresh:0");

			}

		}

	}
}

//
add_action('after_setup_theme', 'remove_admin_bar');

function remove_admin_bar() {
	if (!current_user_can('administrator') && !is_admin()) {
	  	show_admin_bar(false);
	}
}

// Check if user have sufficient funds
function autoroyal_user_sufficient_funds( $customer_id, $amount ) {
	
	$funds = get_user_meta( $customer_id, 'account_funds', true );

	if( $funds >= $amount ) {
		return true;
	} else {
		return false;
	}

}

/*-----------------------------------------------------------------------------------*/
/*	Send Notifications
/*-----------------------------------------------------------------------------------*/
function autoroyal_send_vehicle_notifications( $vehicle_id ) {

	if ( get_post_type( $vehicle_id ) == 'vehicle' ) {
	
		$vehicle_make = esc_attr(get_post_meta($vehicle_id, 'vehicle_make',true));
		$vehicle_model = esc_attr(get_post_meta($vehicle_id, 'vehicle_model',true));
		$vehicle_year = esc_attr(get_post_meta($vehicle_id, 'vehicle_year',true));
		$vehicle_price = esc_attr(get_post_meta($vehicle_id, 'vehicle_price',true));
		$vehicle_mileage = esc_attr(get_post_meta($vehicle_id, 'vehicle_mileage',true));
		$vehicle_condition = esc_attr(get_post_meta($vehicle_id, 'vehicle_condition',true));
		$vehicle_fuel_type = get_the_terms($vehicle_id, 'vehicle_fuel_type' );
		$term_vehicle_fuel_type = '';
		if(!empty($vehicle_fuel_type)) {
			$term_vehicle_fuel_type = $vehicle_fuel_type[0]->name;
		}

		$vehicle_url = get_permalink( $vehicle_id );
		$vehicle_name = get_the_title( $vehicle_id );

		if( $vehicle_condition == "Used" ) {
			$vehicle_condition = "";
		} elseif( $vehicle_condition == "New" ) {
			$vehicle_condition = "on";
		}

	    //
		$site_name = get_bloginfo('name');

		$email_list = array();

		// New
		$filter_args = array(
			'post_type'           => 'filter',
			'posts_per_page'      => -1,
			'post_status'         => array( 'publish' ),
			'orderby'             => 'ID',
			'order'               => 'DESC'
		);

		$filters_query = new WP_Query;
		$filters = $filters_query->query( $filter_args );

		if ( $filters ) :

			foreach ( $filters as $filter ) :

				$filter_ID = $filter->ID; 

				$post_filter_email = get_post_meta($filter_ID, 'filter_email',true);
				$post_filter_user_id = get_post_meta($filter_ID, 'filter_user_id',true);
		        $post_filter_make = get_post_meta($filter_ID, 'filter_make',true);
		        $post_filter_model = get_post_meta($filter_ID, 'filter_model',true);
		        $post_filter_fuel_type = get_post_meta($filter_ID, 'filter_fuel_type',true);
		        $post_filter_price = get_post_meta($filter_ID, 'filter_price',true);
		        $post_filter_year = get_post_meta($filter_ID, 'filter_year',true);
		        $post_filter_mileage = get_post_meta($filter_ID, 'filter_mileage',true);
		        $post_filter_condition = get_post_meta($filter_ID, 'filter_condition',true);

		        if( $post_filter_make == "0" ) {
					$filter_by_make = 1;
				} elseif( $post_filter_make == $vehicle_make ) {
					$filter_by_make = 1;
				} else {
					$filter_by_make = 0;
				}

				if( $post_filter_model == "0" ) {
					$filter_by_model = 1;
				} elseif( $post_filter_model == $vehicle_model ) {
					$filter_by_model = 1;
				} else {
					$filter_by_model = 0;
				}

				if( $post_filter_fuel_type == "0" ) {
					$filter_by_fuel = 1;
				} elseif( $post_filter_fuel_type == $term_vehicle_fuel_type ) {
					$filter_by_fuel = 1;
				} else {
					$filter_by_fuel = 0;
				}

				if( $post_filter_year <= $vehicle_year ) {
					$filter_by_year = 1;
				} else {
					$filter_by_year = 0;
				}

				if( $post_filter_price >= $vehicle_price ) {
					$filter_by_price = 1;
				} else {
					$filter_by_price = 0;
				}

				if( $post_filter_mileage >= $vehicle_mileage ) {
					$filter_by_mileage = 1;
				} else {
					$filter_by_mileage = 0;
				}

				if( empty($post_filter_condition) ) {
					$filter_by_condition = 1;
				} elseif( $post_filter_condition == $vehicle_condition ) {
					$filter_by_condition = 1;
				} else {
					$filter_by_condition = 0;
				}

		        if ( $filter_by_make == 1 AND $filter_by_model == 1 AND $filter_by_fuel == 1 AND $filter_by_year == 1 AND $filter_by_price == 1 AND $filter_by_mileage == 1 AND $filter_by_condition == 1 ) { 

		        	$email_list[] = $post_filter_email;

		        	// Add to car filter id and view = new;
		        	$filter_IDs = array();
		        	$filter_IDs[] = get_post_meta($vehicle_id, 'filter_ids',true);
		        	$filter_IDs[] = $filter_ID;
		        	$filter_IDs[] = array_unique($filter_IDs);

		        	update_post_meta($vehicle_id, 'filter_ids', $filter_IDs);
		        	update_post_meta($vehicle_id, 'filter_user_'.$post_filter_user_id, 'new');

		        }

			endforeach;

		endif;
		// End New

		$email_list_unique = array_unique($email_list);

	    if( !empty($email_list_unique)) {

	    	foreach($email_list_unique as $email) {

	    		// Send Email
		    	if (strtoupper(substr(PHP_OS,0,3)=='WIN')) {
					$eol="\r\n";
				} elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) {
					$eol="\r";
				} else {
					$eol="\n";
				}

				// Message for car dealer
				$from = get_option('admin_email');
			  	$subject = __('Vehicle notification from ', 'autoroyal').$site_name;
			  	$headers = "From: " . $from . $eol;
				$headers .= "Reply-To: " . $from . $eol;
				$headers .= "MIME-Version: 1.0".$eol;
				$headers .= "Content-Type: text/html; charset=ISO-8859-1".$eol;

				$email_content = "".__('New vehicle added matching your criteria', 'autoroyal')."<br><br><a href='".$vehicle_url."'>".$vehicle_name."</a>";

			  	$msg = $email_content;

			  	//add_filter('wp_mail_content_type', create_function('', 'return "text/html"; '));
			  	$mail_sent = wp_mail( $email, $subject, $msg, $headers );

			  	// Add new notification
			  	$user = get_user_by( 'email', $email );
			  	if(!empty($user)) {

			  		$user_id = $user->ID;
			  		$notifications = array();
			  		$notifications = get_user_meta( $user_id, 'vehicle_notifications' );
			  		$notifications[] = $vehicle_id;
			  		update_user_meta( $user_id, 'vehicle_notifications', $notifications );

			  	}

	    	}

	    }

	}

}

/*-----------------------------------------------------------------------------------*/
/*	Subscribe to Filter
/*-----------------------------------------------------------------------------------*/
add_action( 'wp_ajax_autoroyal_subscribe_filter', 'autoroyal_subscribe_filter' );
add_action( 'wp_ajax_nopriv_autoroyal_subscribe_filter', 'autoroyal_subscribe_filter' );
function autoroyal_subscribe_filter() {

	if( isset($_POST['filter_email']) ){

        $filter_email = esc_attr($_POST['filter_email']);
        $filter_make = esc_attr($_POST['filter_make']);
        $filter_model = esc_attr($_POST['filter_model']);
        $filter_fuel_type = esc_attr($_POST['filter_fuel_type']);
        $filter_price = esc_attr($_POST['filter_price']);
        $filter_year = esc_attr($_POST['filter_year']);
        $filter_mileage = esc_attr($_POST['filter_mileage']);
        $filter_condition = esc_attr($_POST['filter_condition']);

        if( !empty($filter_email) ){

        	$filter_exists = 0;
        	$new_filter_exists = 0;

        	// Add filter subscription as custom post type
        	$filter_args = array(
				'post_type'           => 'filter',
				'posts_per_page'      => -1,
				'post_status'         => array( 'publish' )
			);

			$filters_query = new WP_Query;
			$filters = $filters_query->query( $filter_args );

			if ( $filters ) :

				foreach ( $filters as $filter ) :

					$filter_ID = $filter->ID; 

					$post_filter_email = "";
			        $post_filter_make = "";
			        $post_filter_model = "";
			        $post_filter_fuel_type = "";
			        $post_filter_price = "";
			        $post_filter_year = "";
			        $post_filter_mileage = "";
			        $post_filter_condition = "";

					$post_filter_email = get_post_meta($filter_ID, 'filter_email',true);
			        $post_filter_make = get_post_meta($filter_ID, 'filter_make',true);
			        $post_filter_model = get_post_meta($filter_ID, 'filter_model',true);
			        $post_filter_fuel_type = get_post_meta($filter_ID, 'filter_fuel_type',true);
			        $post_filter_price = get_post_meta($filter_ID, 'filter_price',true);
			        $post_filter_year = get_post_meta($filter_ID, 'filter_year',true);
			        $post_filter_mileage = get_post_meta($filter_ID, 'filter_mileage',true);
			        $post_filter_condition = get_post_meta($filter_ID, 'filter_condition',true);

			        if ( $post_filter_email == $filter_email AND $post_filter_make == $filter_make AND $post_filter_model == $filter_model AND $post_filter_fuel_type == $filter_fuel_type AND $post_filter_price == $filter_price AND $post_filter_year == $filter_year AND $post_filter_mileage == $filter_mileage AND $post_filter_condition == $filter_condition ) { 

			        	$new_filter_exists = 1;

			        }
					

				endforeach;

			endif;

			if( $new_filter_exists == 0 ) {

        		// Add new custom post type "filter" with filter meta
        		$postNewTitle = $filter_email . " " . $filter_make . " " . $filter_model . " " . $filter_fuel_type . " " . $filter_price . " " . $filter_year . " " . $filter_mileage . " " . $filter_condition;

				$my_post = array(
					'post_author'   => 1,
				  	'post_name'     => sanitize_title( $postNewTitle ),
				  	'post_title'    => $postNewTitle,
				  	'post_status'   => 'publish',
				  	'post_type'     => 'filter',
				);
				 
				// Insert the post into the database
				$td_post_id = wp_insert_post( $my_post );

				$user = get_user_by( 'email', $filter_email );
				$filter_user_id = $user->ID;

				// Filter Meta
				update_post_meta($td_post_id, 'filter_email', $filter_email);
				update_post_meta($td_post_id, 'filter_user_id', $filter_user_id);
				update_post_meta($td_post_id, 'filter_make', $filter_make);
				update_post_meta($td_post_id, 'filter_model', $filter_model);
				update_post_meta($td_post_id, 'filter_fuel_type', $filter_fuel_type);
				update_post_meta($td_post_id, 'filter_price', $filter_price);
				update_post_meta($td_post_id, 'filter_year', $filter_year);
				update_post_meta($td_post_id, 'filter_mileage', $filter_mileage);
				update_post_meta($td_post_id, 'filter_condition', $filter_condition);

				// Sene email to admin
		    	if (strtoupper(substr(PHP_OS,0,3)=='WIN')) {
					$eol="\r\n";
				} elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) {
					$eol="\r";
				} else {
					$eol="\n";
				}

				$site_name = get_bloginfo('name');

				// Message for car dealer
				$email = get_option('admin_email');
				$from = $filter_email;
			  	$subject = __('Filter notification from ', 'autoroyal').$site_name;
			  	$headers = "From: " . $from . $eol;
				$headers .= "Reply-To: " . $from . $eol;
				$headers .= "MIME-Version: 1.0".$eol;
				$headers .= "Content-Type: text/html; charset=ISO-8859-1".$eol;

				$email_content = "".__('New filter subscription', 'autoroyal')."<br><br>".__('Email', 'autoroyal').": ".$filter_email."<br>".__('Make', 'autoroyal').": ".$filter_make."<br>".__('Model', 'autoroyal').": ".$filter_model."<br>".__('Fuel Type', 'autoroyal').": ".$filter_fuel_type."<br>".__('Price to', 'autoroyal').": ".$filter_price."<br>".__('From Year', 'autoroyal').": ".$filter_year."<br>".__('Mileage up to', 'autoroyal').": ".$filter_mileage."<br>".__('Condition', 'autoroyal').": ".$filter_condition;
  
			  	$msg = $email_content;

			  	add_filter('wp_mail_content_type',create_function('', 'return "text/html"; '));
			  	$mail_sent = wp_mail( $email, $subject, $msg, $headers );

        	}
			// End

        }

    } else {

        _e('Invalid Paramenters!', 'autoroyal');

    }

    die;

}

/*-----------------------------------------------------------------------------------*/
/*	Delete Filter
/*-----------------------------------------------------------------------------------*/
add_action( 'wp_ajax_remove_filter_set', 'autoroyal_remove_filter_set_ajax_handler' );
function autoroyal_remove_filter_set_ajax_handler() {

	if( isset($_POST['filter_id']) ){

		$filter_id = $_POST['filter_id'];
		if ( autoroyal_user_can_edit_car( $filter_id ) ) {

			wp_trash_post( $filter_id );

		}

	} else {

        _e('Invalid Paramenters!', 'autoroyal');

    }

    die;

}

/*-----------------------------------------------------------------------------------*/
/*	Add to favorite
/*-----------------------------------------------------------------------------------*/
function add_to_favorite() {

	ob_start();

	$response['fav_type'] = '';
	$response['fav_icon'] = '';
	$response['error'] = '';
	$response['html'] = '';

	$response['listing_id'] = '';
	$response['user_id'] = '';
	$response['user_type'] = '';

	$response['users_fav'] = '';

	if( isset($_POST['listing_id']) AND isset($_POST['user_id']) ){

		$listing_id = $_POST['listing_id'];
        $user_type = esc_attr($_POST['user_type']);
        $user_id = $_POST['user_id'];

        $response['listing_id'] = $listing_id;
		$response['user_id'] = $user_id;
		$response['user_type'] = $user_type;

		if( !is_added_to_favorite( $user_type, $user_id, $listing_id ) ){

	        if( !empty($listing_id) && !empty($user_id) ){

	        	if( $user_type == 'id' ) {

	        		$vehicle_favs_id = array();
	            	$vehicle_favs_id = get_post_meta($listing_id, 'users_fav',true);
	            	$vehicle_favs_id[] = $user_id;

	            	update_post_meta($listing_id, 'users_fav', $vehicle_favs_id);

	            	$response['users_fav'] = $vehicle_favs_id;

	        	} elseif( $user_type == 'ip' ) {

	        		$vehicle_favs_ip = array();
	            	$vehicle_favs_ip = get_post_meta($listing_id, 'ips_fav',true);
	            	if( empty($vehicle_favs_ip) ) {
		        		$vehicle_favs_ip = array($user_id);
		        	} else {
		        		array_push( $vehicle_favs_ip, $user_id );
		        	}

	            	update_post_meta($listing_id, 'ips_fav', $vehicle_favs_ip);

	        	}

	        }

	        $response['fav_type'] = 'add';
			$response['fav_icon'] = '<i class="fa fa-heart"></i>';

	    } else {

	        if( $user_type == "id" ) {

	    		$vehicle_favs = array();
	        	$vehicle_favs = get_post_meta($listing_id, 'users_fav',true);
	        	$vehicle_favs = array_diff($vehicle_favs, array($user_id));

	        	update_post_meta($listing_id, 'users_fav', $vehicle_favs);

	        	$response['users_fav'] = $vehicle_favs;

	    	} elseif( $user_type == "ip" ) {

	    		$vehicle_favs = array();
	        	$vehicle_favs = get_post_meta($listing_id, 'ips_fav',true);
	        	$vehicle_favs = array_diff($vehicle_favs, array($user_id));

	        	update_post_meta($listing_id, 'ips_fav', $vehicle_favs);

	    	}

	    	$response['fav_type'] = 'remove';
			$response['fav_icon'] = '<i class="far fa-heart"></i>';

	    }

    } else {

        $response['error'] = 'Invalid Paramenters!';

    }

    $response['html'] = ob_get_clean();

    echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_add_to_favorite', 'add_to_favorite' );
add_action( 'wp_ajax_nopriv_add_to_favorite', 'add_to_favorite' );

/*-----------------------------------------------------------------------------------*/
/*	Already added to favorite
/*-----------------------------------------------------------------------------------*/
if( !function_exists( 'is_added_to_favorite' ) ){

    function is_added_to_favorite( $user_type, $user_id, $listing_id ){
        global $wpdb;

        if( $user_type == 'id' ) {

    		$vehicle_favs = array();
        	$vehicle_favs = get_post_meta($listing_id, 'users_fav',true);

    	} elseif( $user_type == 'ip' ) {

    		$vehicle_favs = array();
        	$vehicle_favs = get_post_meta($listing_id, 'ips_fav',true);

    	}

        if ( !empty($vehicle_favs) AND in_array( $user_id, $vehicle_favs )) {
            return true;
        } else {
            return false;
        }

    }

}

/*-----------------------------------------------------------------------------------*/
/*	Get USer IP Address
/*-----------------------------------------------------------------------------------*/
function autoroyalGetIP() {
    foreach (array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR') as $key) {
        if (array_key_exists($key, $_SERVER) === true) {
            foreach (array_map('trim', explode(',', $_SERVER[$key])) as $ip) {
                if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false) {
                    return $ip;
                }
            }
        }
    }
}


/*-----------------------------------------------------------------------------------*/
/*	Save user payout information
/*-----------------------------------------------------------------------------------*/
function autoroyal_user_save_payout( $user_id, $amount, $car_id, $payment_type ) {

	if( !empty($user_id) ) {

		$payouts = array();
		$payouts_data = array();
		$payouts = get_user_meta( $user_id, 'account_payouts', true );

		$payouts_data['user_id'] = $user_id;
		$payouts_data['date'] = date("Y-m-d H:i:s");
		$payouts_data['amount'] = $amount;
		$payouts_data['car_id'] = $car_id;
		$payouts_data['car_url'] = get_permalink($car_id);
		$payouts_data['car_title'] = get_the_title($car_id);
		$payouts_data['car_sku'] = esc_attr(get_post_meta($car_id, 'vehicle_stock',true));
		$payouts_data['payment_type'] = $payment_type;

		$payouts[] = $payouts_data;
		update_user_meta( $user_id, 'account_payouts', $payouts );

	}

}

/*-----------------------------------------------------------------------------------*/
/*	Check if user exists
/*-----------------------------------------------------------------------------------*/
function autoroyal_user_id_exists($user){

    global $wpdb;
    $count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $wpdb->users WHERE ID = %d", $user));
    if($count == 1){ return true; }else{ return false; }

}


/*-----------------------------------------------------------------------------------*/
/*	Dealer User Meta
/*-----------------------------------------------------------------------------------*/
add_action( 'show_user_profile', 'dealer_user_meta_fields' );
add_action( 'edit_user_profile', 'dealer_user_meta_fields' );
add_action( 'personal_options_update', 'save_dealer_user_meta_fields' );
add_action( 'edit_user_profile_update', 'save_dealer_user_meta_fields' );

function dealer_user_meta_fields( $user ) {
	if ( in_array( 'dealer', (array) $user->roles ) OR in_array( 'administrator', (array) $user->roles ) ) {
		$dealer_name = get_user_meta( $user->ID, 'dealer_name', true );
		$mobile_phone = get_user_meta( $user->ID, 'mobile_phone', true );
		$office_phone = get_user_meta( $user->ID, 'office_phone', true );
	    ?>
		<h3><?php _e( 'Dealer Info', 'autoroyal' ); ?></h3>
		<table class="form-table">
			<tr>
                <th><label for="dealer_name"><?php _e( 'Name', 'autoroyal' ); ?></label></th>
                <td>
                    <input type="text" name="dealer_name" id="dealer_name" value="<?php echo esc_attr( $dealer_name ); ?>" class="regular-text" /><br/>
                </td>
            </tr>
            <tr>
                <th><label for="mobile_phone"><?php _e( 'Mobile Phone', 'autoroyal' ); ?></label></th>
                <td>
                    <input type="text" name="mobile_phone" id="mobile_phone" value="<?php echo esc_attr( $mobile_phone ); ?>" class="regular-text" /><br/>
                </td>
            </tr>
            <tr>
                <th><label for="office_phone"><?php _e( 'Office Phone', 'autoroyal' ); ?></label></th>
                <td>
                    <input type="text" name="office_phone" id="office_phone" value="<?php echo esc_attr( $office_phone ); ?>" class="regular-text" /><br/>
                </td>
            </tr>
		</table>
		<?php
	}
}

function save_dealer_user_meta_fields( $user_id ) {

	if(isset($_POST['dealer_name'])) {
		$dealer_name = $_POST['dealer_name'];
	} else {
		$dealer_name = "";
	}
	update_user_meta( $user_id, 'dealer_name', esc_attr($dealer_name) );

	if(isset($_POST['mobile_phone'])) {
		$mobile_phone = $_POST['mobile_phone'];
	} else {
		$mobile_phone = "";
	}
	update_user_meta( $user_id, 'mobile_phone', esc_attr($mobile_phone) );

	if(isset($_POST['office_phone'])) {
		$office_phone = $_POST['office_phone'];
	} else {
		$office_phone = "";
	}
	update_user_meta( $user_id, 'office_phone', esc_attr($office_phone) );

}

/*-----------------------------------------------------------------------------------*/
/*	Dealer User Meta
/*-----------------------------------------------------------------------------------*/
add_action( 'show_user_profile', 'demo_user_meta_fields' );
add_action( 'edit_user_profile', 'demo_user_meta_fields' );
add_action( 'personal_options_update', 'save_demo_user_meta_fields' );
add_action( 'edit_user_profile_update', 'save_demo_user_meta_fields' );

function demo_user_meta_fields( $user ) {
	if ( in_array( 'dealer', (array) $user->roles ) ) {
		$demo_account = get_user_meta( $user->ID, 'demo_account', true );
	    ?>
		<h3><?php _e( 'Demo Account', 'autoroyal' ); ?></h3>
		<table class="form-table">
			<tr>
                <th><label for="demo_account"><?php _e( 'Demo', 'autoroyal' ); ?></label></th>
                <td>
                    <input type="checkbox" name="demo_account" <?php if( $demo_account == "on" ) { echo "checked"; } ?>>
                </td>
            </tr>
		</table>
		<?php
	}
}

function save_demo_user_meta_fields( $user_id ) {

	if(isset($_POST['demo_account'])) {
		$demo_account = $_POST['demo_account'];
	} else {
		$demo_account = "";
	}
	update_user_meta( $user_id, 'demo_account', esc_attr($demo_account) );

}

/*-----------------------------------------------------------------------------------*/
/*	Vehcile back end extra columns
/*-----------------------------------------------------------------------------------*/
add_filter('manage_edit-vehicle_columns', 'vehicle_extra_columns');
function vehicle_extra_columns($columns) {
    $columns['owner'] = 'Owner';
    $columns['type'] = 'Type';
    return $columns;
}

add_action('manage_vehicle_posts_custom_column',  'vehicle_extra_show_columns');
function vehicle_extra_show_columns($name) {
    global $post;
    switch ($name) {
        case 'owner':
            $author_id = $post->post_author;
            $dealer_name = get_user_meta( $author_id, 'dealer_name', true );
            if( empty($dealer_name)) {
            	$user = get_userdata( $author_id ); 
				$dealer_name = $user->user_nicename;
            }
            echo $dealer_name;
            break;
        case 'type':
        	$car_ID = $post->ID;
            if ( get_post_status ( $car_ID ) == 'publish' )  {
				$sold = esc_attr(get_post_meta($car_ID, '_sold',true));
				$featured = esc_attr(get_post_meta($car_ID, '_featured',true));
				$promoted = esc_attr(get_post_meta($car_ID, '_promoted',true));
				if( $sold == 1 ) {
					$vehicle_type = esc_html_e( 'Sold', 'autoroyal' );
				} elseif( $featured == 1 ) {
					$vehicle_type = esc_html_e( 'Featured', 'autoroyal' );
				} elseif( $promoted == 1 ) {
					$vehicle_type = esc_html_e( 'Promoted', 'autoroyal' );
				} else {
					$vehicle_type = esc_html_e( 'Published', 'autoroyal' );
				}
			} else {
				$vehicle_type = get_post_status ( $car_ID );
			}
            echo $vehicle_type;
    }
}

/*-----------------------------------------------------------------------------------*/
/*	Vehicle back end extra columns
/*-----------------------------------------------------------------------------------*/
$acc_funds = get_option( 'autoroyal_enable_account_funds' );
if ( $acc_funds == 1 AND !is_woocommerce_active() ) {
  	add_action( 'admin_notices', 'my_wc_notice' );
}

function my_wc_notice() {
  	?>
  	<div class="notice notice-error is-dismissible">
      	<p><?php _e( 'Please install WooCommerce, it is required for monetization to work properly!', 'autoroyal' ); ?></p>
  	</div>
  	<?php
}

function autoroyal_count_photos( $car_id ) {

	$vehicle_image_gallery = get_post_meta($car_id, 'vehicle_image_gallery',true);
	$vehicle_image_extended_gallery = get_post_meta($car_id, 'vehicle_image_extended_gallery',true);

	$images = array();
	$i = 0;

	if(!empty($vehicle_image_gallery) AND is_array($vehicle_image_gallery)) {

		foreach ($vehicle_image_gallery as $vehicle_image_gallery_item) {
			
			if( !empty($vehicle_image_gallery_item['url']) ) {

				$i++;
				$images[] = $vehicle_image_gallery_item['url'];

			}

		}

	}
	if(!empty($vehicle_image_extended_gallery)) {

		foreach ($vehicle_image_extended_gallery as $vehicle_image_extended_gallery_item) {
			
			if( !empty($vehicle_image_extended_gallery_item['url']) ) {

				$i++;
				$images[] = $vehicle_image_gallery_item['url'];

			}

		}

	}

	$results['total'] = $i;
	$results['image'] = $images;

	return $results;

}