<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Shortcode_Submit_Reservation class.
 */
class autoroyal_Shortcode_Submit_Reservation {

	/**
	 * Inventory message
	 *
	 * @access private
	 * @var string
	 */
	private $reservation_submit_message = '';
	private $reservation_submit_status = '0';
	private $reservation_delete_status = '0';
	private $reservation_id = '';

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'wp', array( $this, 'shortcode_submit_reservation_action_handler' ) );
		add_shortcode( 'autoroyal_submit_reservation', array( $this, 'autoroyal_submit_reservation' ) );
	}

	/**
	 * Handle actions which need to be run before the shortcode e.g. post actions
	 */
	public function shortcode_submit_reservation_action_handler() {
		global $post;

		if ( is_page() && strstr( $post->post_content, '[autoroyal_submit_reservation' ) ) {
			$this->reservation_submit_handler();
		}
	}

	/**
	 * Handles actions on autoroyal dashboard
	 */
	public function reservation_submit_handler() {

		if ( ! empty( $_REQUEST['action'] ) && ! empty( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], 'autoroyal_reservation_actions' ) ) {

			$td_post_id = $_REQUEST['reservation_id'];
			$action = $_REQUEST['action'];

			try {
				// Get reservation
				$reservation    = get_post( $td_post_id );

				// Check ownership
				if ( ! autoroyal_user_can_edit_car( $td_post_id ) ) {
					throw new Exception( __( 'Invalid ID', 'autoroyal' ) );
				}

				switch ( $action ) {
					case 'delete' :
						// Trash it
						wp_trash_post( $td_post_id );

						// Message
						$this->reservation_submit_message = '<div class="car-manager-message">' . sprintf( __( '%s has been deleted', 'autoroyal' ), $reservation->post_title ) . '</div>';
						$this->reservation_delete_status = '1';

						break;
					default :
						do_action( 'autoroyal_reservations_do_action_' . $action );
						break;
				}

				do_action( 'autoroyal_my_reservation_do_action', $action, $td_post_id );

			} catch ( Exception $e ) {
				$this->reservation_submit_message = '<div class="car-manager-error">' . $e->getMessage() . '</div>';
			}
		}

		if( 'POST' == $_SERVER['REQUEST_METHOD'] ) {

			if( isset( $_POST['submitreservationFunction_nonce'] ) && wp_verify_nonce( $_POST['submitreservationFunction_nonce'], 'submitreservationFunction_html' ) ){

				$td_post_id = $_POST['reservation_id'];
				$action = $_POST['action_name'];

				$pickup_location  = sanitize_text_field( $_POST['pickup_location'] );
				$dropoff_location = sanitize_text_field( $_POST['return_location'] );

				$pickup_date      = sanitize_text_field( $_POST['pickup_date'] );
				$pickup_time      = sanitize_text_field( $_POST['pickup_time'] );

				$dropoff_date     = sanitize_text_field( $_POST['return_date'] );
				$dropoff_time     = sanitize_text_field( $_POST['return_time'] );

				$days             = sanitize_text_field( $_POST['reserv-car-days'] );
				$day_price        = sanitize_text_field( $_POST['reserv-car-price-day'] );
				$price_total      = sanitize_text_field( $_POST['reserv-car-price-total'] );
				$extras_price     = sanitize_text_field( $_POST['reserv-car-price-extras'] );

				$userName         = sanitize_text_field( $_POST['rent_first_name'] );

				$rent_vehicle_id  = sanitize_text_field($_POST['reserv-car-id-2'] );

				$rent_vehicle_year = esc_attr(get_post_meta($rent_vehicle_id, 'vehicle_year',true));
				$rent_vehicle_make = esc_attr(get_post_meta($rent_vehicle_id, 'vehicle_make_desc_init',true));
				$rent_vehicle_model = esc_attr(get_post_meta($rent_vehicle_id, 'vehicle_model',true));
				$rent_vehicle_trim = esc_attr(get_post_meta($rent_vehicle_id, 'vehicle_trim_desc_init',true));

				$autoroyal_currency = get_option( 'autoroyal_currency' ); 
				$currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency );

			  	$postNewTitle = "New - ";

				if(!empty($pickup_location)) {
					$postNewTitle .= $pickup_location . " ";
				}

				if(!empty($pickup_date)) {
					$postNewTitle .= $pickup_date . " ";
				}

				if(!empty($pickup_time)) {
					$postNewTitle .= $pickup_time . " - ";
				}

				if(!empty($days)) {
					$postNewTitle .= $days . " Days ";
				}

				if(!empty($price_total)) {
					$postNewTitle .= $currency_symbol . "" . $price_total . " - ";
				}

				if(!empty($userName)) {
					$postNewTitle .= $userName . " - ";
				}

				$rentVehicleName = $rent_vehicle_make . " " . $rent_vehicle_model . " " . $rent_vehicle_trim . " " . $rent_vehicle_year;

				if(!empty($rentVehicleName)) {
					$postNewTitle .= $rentVehicleName;
				}

				if( !empty($td_post_id) AND ! autoroyal_user_can_edit_car( $td_post_id ) ) {

					$this->reservation_submit_message = "<div class='car-manager-error'>" . __( 'Invalid ID', 'autoroyal' ). "</div>";
					$this->reservation_submit_status = "1";

				} else {

					if( empty($td_post_id) ) {

						$my_post = array(
						  	'post_name'     => sanitize_title( $postNewTitle ),
						  	'post_title'    => $postNewTitle,
						  	'post_type'     => 'rent',
						  	'post_status'   => 'publish',
						);
						 
						// Insert the post into the database
						$td_post_id = wp_insert_post( $my_post );

						//

						$my_post = array(
							'ID'            => $td_post_id,
						  	'post_name'     => sanitize_title( $postNewTitle ),
						  	'post_title'    => $postNewTitle,
						  	'post_type'     => 'rent',
						  	'post_status'   => 'publish',
						);

						wp_update_post( $my_post );

					} else {

						//

						$my_post = array(
							'ID'            => $td_post_id,
						  	'post_name'     => sanitize_title( $postNewTitle ),
						  	'post_title'    => $postNewTitle,
						  	'post_type'     => 'rent',
						  	'post_status'   => 'publish',
						);

						wp_update_post( $my_post );

					}

					$this->reservation_id = $td_post_id;

					// Rent Details
					update_post_meta($td_post_id, 'rent_status', sanitize_text_field($_POST['rent_status']));

					update_post_meta($td_post_id, 'pickup_location', sanitize_text_field($_POST['pickup_location']));
					update_post_meta($td_post_id, 'pickup_date', sanitize_text_field($_POST['pickup_date']));
					update_post_meta($td_post_id, 'pickup_time', sanitize_text_field($_POST['pickup_time']));

					update_post_meta($td_post_id, 'return_location', sanitize_text_field($_POST['return_location']));
					update_post_meta($td_post_id, 'return_date', sanitize_text_field($_POST['return_date']));
					update_post_meta($td_post_id, 'return_time', sanitize_text_field($_POST['return_time']));

					update_post_meta($td_post_id, 'rent_vehicle_id', sanitize_text_field($_POST['reserv-car-id-2']));

					update_post_meta($td_post_id, 'number_of_days', sanitize_text_field($_POST['reserv_car_days']));
					update_post_meta($td_post_id, 'price_per_day', sanitize_text_field($_POST['reserv-car-price-day']));
					update_post_meta($td_post_id, 'total_price', sanitize_text_field($_POST['reserv-car-price-total']));
					update_post_meta($td_post_id, 'total_price_no_extras', sanitize_text_field($_POST['reserv-car-price-without-extras']));
					update_post_meta($td_post_id, 'reserv_car_days', sanitize_text_field($_POST['reserv_car_days']));

					update_post_meta($td_post_id, 'extra_options', $_POST['extra_options']);

					update_post_meta($td_post_id, 'rent-notes', $_POST['rent-notes']);

					// Rent Customer Info
					update_post_meta($td_post_id, 'customer_type', sanitize_text_field($_POST['customer_type']));
					update_post_meta($td_post_id, 'existing_customer', sanitize_text_field($_POST['existing_customer']));

					update_post_meta($td_post_id, 'rent_first_name', sanitize_text_field($_POST['rent_first_name']));
					update_post_meta($td_post_id, 'rent_middle_name', sanitize_text_field($_POST['rent_middle_name']));
					update_post_meta($td_post_id, 'rent_last_name', sanitize_text_field($_POST['rent_last_name']));

					update_post_meta($td_post_id, 'rent_address_1', sanitize_text_field($_POST['rent_address_1']));
					update_post_meta($td_post_id, 'rent_address_2', sanitize_text_field($_POST['rent_address_2']));

					update_post_meta($td_post_id, 'rent_city', sanitize_text_field($_POST['rent_city']));
					update_post_meta($td_post_id, 'rent_state', sanitize_text_field($_POST['rent_state']));
					update_post_meta($td_post_id, 'rent_zip', sanitize_text_field($_POST['rent_zip']));

					update_post_meta($td_post_id, 'rent_home_phone', sanitize_text_field($_POST['rent_home_phone']));
					update_post_meta($td_post_id, 'rent_mobile_phone', sanitize_text_field($_POST['rent_mobile_phone']));
					update_post_meta($td_post_id, 'rent_work_phone', sanitize_text_field($_POST['rent_work_phone']));

					update_post_meta($td_post_id, 'rent_email', sanitize_text_field($_POST['rent_email']));
					update_post_meta($td_post_id, 'rent_age', sanitize_text_field($_POST['rent_age']));
					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'rent_birth_date', sanitize_text_field($_POST['rent_birth_date']));
						update_post_meta($td_post_id, 'rent_social_security', sanitize_text_field($_POST['rent_social_security']));
					}

					update_post_meta($td_post_id, 'rent_driver_license_state', sanitize_text_field($_POST['rent_driver_license_state']));
					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'rent_driver_license_number', sanitize_text_field($_POST['rent_driver_license_number']));
					}
					update_post_meta($td_post_id, 'rent_driver_license_exp', sanitize_text_field($_POST['rent_driver_license_exp']));

					//
					$reservation_first_name = esc_attr(get_post_meta($td_post_id, 'reservation_first_name',true));
					$reservation_middle_name = esc_attr(get_post_meta($td_post_id, 'reservation_middle_name',true));
					$reservation_last_name = esc_attr(get_post_meta($td_post_id, 'reservation_last_name',true));

					$postNewTitle = $_POST['rent_status'] . " - ";

					if(!empty($_POST['pickup_location'])) {
						$postNewTitle .= $_POST['pickup_location'] . " ";
					}

					if(!empty($_POST['pickup_date'])) {
						$postNewTitle .= $_POST['pickup_date'] . " ";
					}

					if(!empty($_POST['pickup_time'])) {
						$postNewTitle .= $_POST['pickup_time'] . " - ";
					}

					if(!empty($_POST['reserv_car_days'])) {
						$postNewTitle .= $_POST['reserv_car_days'] . " Days ";
					}

					$autoroyal_currency = get_option( 'autoroyal_currency' ); 
		    		$currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency );

					if(!empty($_POST['reserv-car-price-total'])) {
						$postNewTitle .= $currency_symbol . "" . $_POST['reserv-car-price-total'] . " ";
					}

					$this->reservation_submit_message = '<div class="car-manager-message">' . sprintf( __( '%s reservation has been saved', 'autoroyal' ), $postNewTitle ) . '</div>';
					$this->reservation_submit_status = "0";

				}

			}

		}

	}

	/**
	 * Shortcode which lists the logged in user's cars
	 */
	public function autoroyal_submit_reservation( $atts ) {
		
		if ( ! is_user_logged_in() ) {
			ob_start();
			get_autoroyal_template( 'autoroyal-login.php' );
			return ob_get_clean();
		}

		// Enqueue styles
		wp_enqueue_style( 'jquery-ui' );
		wp_enqueue_style( 'bootstrap-select' );

		// Enqueue scripts
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'jquery-ui-autocomplete' );
		wp_enqueue_script( 'time-picker' );
		wp_enqueue_script( 'bootstrap-select' );

		ob_start();

		// If doing an action, show conditional content if needed....
		if ( ! empty( $_REQUEST['action'] ) ) {
			$action = sanitize_title( $_REQUEST['action'] );

			// Show alternative content if a plugin wants to
			if ( has_action( 'autoroyal_submit_reservation_content_' . $action ) ) {
				do_action( 'autoroyal_submit_reservation_content_' . $action, $atts );

				return ob_get_clean();
			}
		}

		echo $this->reservation_submit_message;

		if($this->reservation_submit_status == 0) {

			get_autoroyal_template( 'autoroyal-submit-reservation.php', array( 'reservation_id' => $this->reservation_id ) );

		}

		return ob_get_clean();
	}

}

new autoroyal_Shortcode_Submit_Reservation();
