<?php
/**
 * Loads Meta Box Plugin and Related Extensions
 * Also, Loads related configuration file
 */

/**
 * Deactivate Meta Box Plugin and related extensions if Installed.
 * As Real Homes theme already have those embedded
 */
add_action( 'admin_init', function() {

    include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

} );

$file = dirname(__FILE__) . '/autoroyal.php';
$plugin_path = plugin_dir_path($file);


$plugin_dir = plugins_url( 'autoroyal.php', __FILE__ );
$plugin_url = plugin_dir_url( __FILE__ ) . 'autoroyal.php';

/**
 * Embedded Meta Box Plugin
 */
if ( ! class_exists( 'RW_Meta_Box' ) ) {
    define( 'RWMB_DIR', $plugin_path . 'meta-box-plugin/' );
    define( 'RWMB_URL', $plugin_path . 'meta-box-plugin/' );
    require_once RWMB_DIR . 'meta-box.php';
}


/**
 * Columns Extension
 */
if ( !class_exists( 'RWMB_Columns' ) ) {
    require_once( $plugin_path . 'extensions/meta-box-columns/meta-box-columns.php' );
}


/**
 * Tabs Extension
 */
if ( !class_exists( 'RWMB_Tabs' ) ) {
    require_once( $plugin_path . 'extensions/meta-box-tabs/meta-box-tabs.php' );
}


/**
 * Show Hide Extension
 */
if ( !class_exists( 'RWMB_Show_Hide' ) ) {
    require_once( $plugin_path . 'extensions/meta-box-show-hide/meta-box-show-hide.php' );
}


/**
 * Group Extension
 */
if ( !class_exists( 'RWMB_Group' ) ) {
    require_once( $plugin_path . 'extensions/meta-box-group/meta-box-group.php' );
}


/**
 * Meta Box Configuration File
 */
require_once( $plugin_path . 'config-meta-boxes.php' );


/**
 * Custom Meta Box Script - To provide additional details feature
 */
require_once( $plugin_path . 'additional-details-metabox.php' );

