<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_map_shortcode_func( $atts ) {

	extract( shortcode_atts( array(
    	"lat" => "47.02552795015715",
        "lng" => "28.830285722137432",
    	"zoom" => 17,
    	'image' => '',
        'logo' => '',
        "width" => "100",
        "width_type" => "%",
        "height" => "450",
        "height_type" => "px",
        "bg_color" => "#f0f7ff",
        "pattern_color" => "#f0f7ff",
        "heading_title" => "",
        "address_label" => "Address:",
        "address_value" => "",
        "phone_label" => "Phone Number:",
        "phone_value" => "",
        "working_label" => "Working Hours:",
        "working_value" => "",
        "dragging_mobile" => "true",
        "dragging_desktop" => "true",
    	"css" => "",
   	), $atts ) );

	ob_start();

    wp_enqueue_script( 'autoroyal-gmap3' );

	$img_id = preg_replace( '/[^\d]/', '', $image );
	$link_image = wp_get_attachment_image_src( $img_id, 'large' );
	$img_src = $link_image[0];

    $logo_id = preg_replace( '/[^\d]/', '', $logo );
    $link_image_logo = wp_get_attachment_image_src( $logo_id, 'full' );
    $logo_src = $link_image_logo[0];

	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

	$unique_id = uniqid();

	if($height != '')
    {
        $add_map_height = 'height: '. $height . $height_type.'; ';
    }

    if($width != '')
    {
        $add_map_width = 'width: '. $width . $width_type.'; ';

    }

    if(wp_is_mobile())
    {
        $dragging = $dragging_mobile;
    }
    else
    {
        $dragging = $dragging_desktop;
    }

    $unique_id = uniqid();
    $map_class = "autoroyal_map_block_" . $unique_id;

   	?>

   	<div class="autoroyal-custom-maps <?php echo esc_attr($map_class); ?>">

        <div class="map-content-wrapper">
            <div class="map-content-inner">
                <?php if(!empty($logo_src)){ ?><div class="logo-map"><img src="<?php echo esc_url($logo_src); ?>" alt=""></div><?php } ?>
                <?php if(!empty($address_label)){ ?><span class="eyebrow mb-0"><?php echo esc_attr($address_label); ?></span><?php } ?>
                <?php if(!empty($address_value)){ ?><p class="text-primary mb-4 fw-medium"><?php echo esc_attr($address_value); ?></p><?php } ?>
                <?php if(!empty($phone_label)){ ?><span class="eyebrow mb-0"><?php echo esc_attr($phone_label); ?></span><?php } ?>
                <?php if(!empty($phone_value)){ ?><p class="text-primary mb-4 fw-medium"><?php echo esc_attr($phone_value); ?></p><?php } ?>
                <?php if(!empty($working_label)){ ?><span class="eyebrow mb-0"><?php echo esc_attr($working_label); ?></span><?php } ?>
                <?php if(!empty($working_value)){ ?><p class="text-primary mb-4 fw-medium"><?php echo esc_attr($working_value); ?></p><?php } ?>
            </div>
            <div class="map-content-bg"></div>
            <div class="map-content-pattern" data-color="<?php echo esc_attr($pattern_color); ?>"></div>
        </div>

	   	<div id="main-map-<?php echo esc_attr($unique_id); ?>" class="bordered <?php echo esc_attr($css_class); ?>" style="<?php echo esc_attr($add_map_height); echo ' '; echo esc_attr($add_map_width); ?>"></div>

	    <script type="text/javascript">
			var mapDiv,
				map,
				infobox;
			jQuery(document).ready(function($) {

				mapDiv = $("#main-map-<?php echo esc_attr($unique_id); ?>");
				mapDiv.height(<?php echo esc_attr($height); ?>).gmap3({
					map: {
						options: {
							"center": [<?php echo esc_attr($lat); ?>,<?php echo esc_attr($lng); ?>]
							,"zoom": <?php echo esc_attr($zoom); ?>
							,"mapTypeControl": true
							,"mapTypeId": google.maps.MapTypeId.ROADMAP
							,"scrollwheel": false
							,"panControl": true
							,"rotateControl": false
							,"scaleControl": true
							,"streetViewControl": true
							,"zoomControl": true
							,"draggable": <?php echo esc_attr($dragging); ?>
						}
					}
					,marker: {
						values: [

						{

							latLng: [<?php echo esc_attr($lat); ?>,<?php echo esc_attr($lng); ?>],
							options: {
								icon: "<?php echo esc_url($img_src); ?>",
								shadow: "<?php echo get_template_directory_uri() ?>/images/shadow.png",
							}
						}	
								
						],
						options:{
							draggable: false
						}
					}
				});

				map = mapDiv.gmap3("get");
			    infobox = new InfoBox({
			    	pixelOffset: new google.maps.Size(-50, -65),
			    	closeBoxURL: '',
			    	enableEventPropagation: true
			    });
			    mapDiv.delegate('.infoBox .close','click',function () {
			    	infobox.close();
			    });

			});
		</script>

	</div>

    <?php

    wp_enqueue_style(
        'autoroyal-custom-style-gmap',
        get_template_directory_uri() . '/assets/css/custom-styles.css'
    );

    if(!empty($bg_color)) {

        $custom_bg_color = "

                .{$map_class} .map-content-bg { 
                    background-color: {$bg_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-gmap', $custom_bg_color );

    }

    return ob_get_clean();

}
add_shortcode( 'autoroyal_map_shortcode', 'autoroyal_map_shortcode_func' );

vc_map( array(
  	'name' => esc_html__( 'Google Map', 'autoroyal' ),
	'base' => 'autoroyal_map_shortcode',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoRoyal google map', 'autoroyal' ),
	'params' => array(
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Latitude", "autoroyal"),
            "param_name" => "lat",
            "admin_label" => false,
            "value" => "47.02552795015715",
            "group" => "Location"
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Longitude", "autoroyal"),
            "param_name" => "lng",
            "admin_label" => false,
            "value" => "28.830285722137432",
            "group" => "Location"
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Zoom", "autoroyal"),
            "param_name" => "zoom",
            "admin_label" => false,
            "value" => "17",
            "group" => "Styling",
            "description" => "Map zoom level"
        ),
        array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Map pin', 'autoroyal' ),
			'param_name' => 'image',
			'value' => '',
			'description' => esc_html__( 'Use .png file for best results', 'autoroyal' ),
            "group" => "Styling",
		),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Width", "autoroyal"),
            "param_name" => "width",
            "admin_label" => false,
            "value" => "100",
            "group" => "Styling",
            'edit_field_class' => 'vc_col-sm-6 vc_column'
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Width Type", "autoroyal"),
            "param_name" => "width_type",
            "admin_label" => false,
            "value" => array( esc_html__("Pixels", "autoroyal") => "px", esc_html__("Percentage", "autoroyal") => "%"),
            "group" => "Styling",
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            "std" => "%"
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Height", "autoroyal"),
            "param_name" => "height",
            "admin_label" => false,
            "value" => "450",
            "group" => "Styling",
            'edit_field_class' => 'vc_col-sm-6 vc_column'
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Height Type", "autoroyal"),
            "param_name" => "height_type",
            "admin_label" => false,
            "value" => array( esc_html__("Pixels", "autoroyal") => "px", esc_html__("Percentage", "autoroyal") => "%"),
            "group" => "Styling",
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            "std" => "px"
        ),
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Logo', 'autoroyal' ),
            'param_name' => 'logo',
            'value' => '',
            'description' => esc_html__( 'Select image from media library.', 'autoroyal' ),
            'group' => esc_html__( 'Content', 'autoroyal' ),
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Address Label", "autoroyal"),
            "param_name" => "address_label",
            "value" => "Address:",
            "group" => "Content",
            'edit_field_class' => 'vc_col-sm-6 vc_column'
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Address", "autoroyal"),
            "param_name" => "address_value",
            "value" => "",
            "group" => "Content",
            'edit_field_class' => 'vc_col-sm-6 vc_column'
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Phone Number Label", "autoroyal"),
            "param_name" => "phone_label",
            "value" => "Phone Number:",
            "group" => "Content",
            'edit_field_class' => 'vc_col-sm-6 vc_column'
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Phone Number", "autoroyal"),
            "param_name" => "phone_value",
            "value" => "",
            "group" => "Content",
            'edit_field_class' => 'vc_col-sm-6 vc_column'
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Working Hours Label", "autoroyal"),
            "param_name" => "working_label",
            "value" => "Working Hours:",
            "group" => "Content",
            'edit_field_class' => 'vc_col-sm-6 vc_column'
        ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Working Hours", "autoroyal"),
            "param_name" => "working_value",
            "value" => "",
            "group" => "Content",
            'edit_field_class' => 'vc_col-sm-6 vc_column'
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Box background color', 'autoroyal' ),
            'param_name' => 'bg_color',
            'description' => esc_html__( 'Select color for text box background.', 'autoroyal' ),
            'group' => esc_html__( 'Content', 'autoroyal' ),
            'std' => '#f0f7ff',
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Box pattern color', 'autoroyal' ),
            'param_name' => 'pattern_color',
            'description' => esc_html__( 'Select color for text box pattern background.', 'autoroyal' ),
            'group' => esc_html__( 'Content', 'autoroyal' ),
            'std' => '#f0f7ff',
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Dragging on Mobile", "autoroyal"),
            "param_name" => "dragging_mobile",
            "value" => array( esc_html__("Enable", "autoroyal") => "true", esc_html__("Disable", "autoroyal") => "false"),
            "group" => "Advanced",
            "std" => "true"
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Dragging on Desktop", "autoroyal"),
            "param_name" => "dragging_desktop",
            "value" => array( esc_html__("Enable", "autoroyal") => "true", esc_html__("Disable", "autoroyal") => "false"),
            "group" => "Advanced",
            "std" => "true"
        ),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

?>