<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_locations_big_func( $atts, $content ) {

	extract( shortcode_atts( array(
		'location_id' => '',
    	'css' => '',
   	), $atts ) );

	ob_start();

	wp_enqueue_script( 'autoroyal-gmap3' );

	$class_to_filter = '';
    $class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
    $css_class = $class_to_filter;

    $unique_map_id = uniqid();

    $vehicle_location_name = get_term_meta( $location_id, 'vehicle_location_name', true );
	$vehicle_location_phone = get_term_meta( $location_id, 'vehicle_location_phone', true );
	$vehicle_location_email = get_term_meta( $location_id, 'vehicle_location_email', true );
	$vehicle_location_address = get_term_meta( $location_id, 'vehicle_location_address', true );
	$vehicle_location_latitude = get_term_meta( $location_id, 'vehicle_location_latitude', true );
	$vehicle_location_longitude = get_term_meta( $location_id, 'vehicle_location_longitude', true );

	$map_pin = get_template_directory_uri().'/assets/images/map-pin.png';
	$get_directions_link = '//maps.google.com/maps?daddr=' . $vehicle_location_latitude . ',' . $vehicle_location_longitude;

	?>

	<div class="autoroyal-locations-map <?php echo esc_attr($css_class); ?>">

		<div class="autoroyal-location-big">

			<div id="main-map-<?php echo esc_attr($unique_map_id); ?>" class="location-big-map"></div>

			<script type="text/javascript">
				var mapDiv,
					map,
					infobox;
				jQuery(document).ready(function($) {

					mapDiv = $("#main-map-<?php echo esc_attr($unique_map_id); ?>");
					mapDiv.height(600).gmap3({
						map: {
							options: {
								"center": [<?php echo esc_attr($vehicle_location_latitude); ?>, <?php echo esc_attr($vehicle_location_longitude); ?>]
								,"zoom": 17							
								,"mapTypeControl": true
								,"mapTypeId": google.maps.MapTypeId.ROADMAP
								,"scrollwheel": false
								,"panControl": true
								,"rotateControl": false
								,"scaleControl": true
								,"streetViewControl": true
								,"zoomControl": true
								,"draggable": true						}
						}
						,marker: {
							values: [

							{

								latLng: [<?php echo esc_attr($vehicle_location_latitude); ?>, <?php echo esc_attr($vehicle_location_longitude); ?>],
								options: {
									icon: "<?php echo esc_attr($map_pin); ?>",
									shadow: "",
								}
							}	
									
							],
							options:{
								draggable: false
							}
						}
					});

					map = mapDiv.gmap3("get");
				    infobox = new InfoBox({
				    	pixelOffset: new google.maps.Size(-50, -65),
				    	closeBoxURL: '',
				    	enableEventPropagation: true
				    });
				    mapDiv.delegate('.infoBox .close','click',function () {
				    	infobox.close();
				    });

				});
			</script>

			<div class="autoroyal-icon-box autoroyal-icon-box-side autoroyal-icon-box-style-boxed location-card">
				
				<div class="autoroyal-icon-box-icon">
					<i class="fa fa-dot-circle-o"></i> 
				</div>

				<div class="autoroyal-icon-box-content">

					<h4><?php echo esc_attr($vehicle_location_name); ?></h4>
					
					<div class="autoroyal-location-block">
						<div class="address">
							<span class="heading-font first-line"><?php esc_html_e('Visit Us', 'autoroyal' ); ?>:</span>
							<span class="heading-font"><a href="//maps.google.com/maps?daddr=<?php echo esc_attr($vehicle_location_latitude); echo ",";  echo esc_attr($vehicle_location_longitude); ?>" target="_blank"><?php echo esc_attr($vehicle_location_address); ?></a></span>
						</div>
					</div>

					<div class="autoroyal-location-block">
						<div class="address">
							<span class="heading-font first-line"><?php esc_html_e('Call Us', 'autoroyal' ); ?>:</span>
							<span class="heading-font"><a href="tel:<?php echo esc_attr($vehicle_location_phone); ?>"><?php echo esc_attr($vehicle_location_phone); ?></a></span>
						</div>
					</div>

					<div class="autoroyal-location-block">
						<div class="address">
							<span class="heading-font first-line"><?php esc_html_e('Mail Us', 'autoroyal' ); ?>:</span>
							<span class="heading-font"><a href="mailto:<?php echo esc_attr($vehicle_location_email); ?>"><?php echo esc_attr($vehicle_location_email); ?></a></span>
						</div>
					</div>

					<a href="<?php echo esc_url($get_directions_link); ?>" class="autoroyal-button button-icon-right autoroyal-button-align-left" target="_blank"><?php esc_html_e('Get Directions', 'autoroyal' ); ?> <i class="fa fa-map-signs"></i></a>

				</div>

			</div>

		</div>

    </div>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_locations_big', 'autoroyal_locations_big_func' );

$locations_array = array();

$vehicle_location = get_categories( array('taxonomy' => 'vehicle_location', 'hide_empty' => false,  'parent' => 0) );
foreach ($vehicle_location as $category) {
	$category_name = $category->name;
	$locations_array[$category_name] = $category->term_id;
}

vc_map( array(
  	'name' => esc_html__( 'Locations Big', 'autoroyal' ),
	'base' => 'autoroyal_locations_big',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoroyal one locations big block', 'autoroyal' ),
	'params' => array(
		array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Select Location', 'autoroyal' ),
            'param_name' => 'location_id',
            'admin_label' => true,
            'value' => $locations_array,
            'std' => '',
        ),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),

));

