<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_price_box_func( $atts, $content ) {

	extract( shortcode_atts( array(
		'featured' => 'false',
		'title' => 'Premium',
		'subtitle' => 'Perfect for small startups that have less than 10 team members',
		'price' => '99',
		'currency' => '$',
		'period' => 'month',
		'button_href' => '#',
		'button_text' => 'Subscribe',
		'bg_style' => 'light',
		'image' => '',
		'background_color' => '#3b3a38',
		'align' => 'left',
    	'use_theme_fonts' => '',
    	'google_fonts' => '',
    	'google_fonts_data' => '',
    	'add_icon' => '',
    	'icon_type' => 'fontawesome',
    	'icon_fontawesome' => '',
		'icon_openiconic' => '',
		'icon_typicons' => '',
		'icon_entypo' => '',
		'icon_linecons' => '',
		'icon_monosocial' => '',
    	'css' => '',
   	), $atts ) );

	ob_start();

	$img_id = preg_replace( '/[^\d]/', '', $image );
	$link_image = wp_get_attachment_image_src( $img_id, 'large' );
	$img_src = $link_image[0];

	$google_fonts_field = $google_fonts;
	$font_container = '';
	$font_container_field = '';

	$font_container_obj = new Vc_Font_Container();
	$google_fonts_obj = new Vc_Google_Fonts();
	$font_container_field_settings = isset( $font_container_field['settings'], $font_container_field['settings']['fields'] ) ? $font_container_field['settings']['fields'] : array();
	$google_fonts_field_settings = isset( $google_fonts_field['settings'], $google_fonts_field['settings']['fields'] ) ? $google_fonts_field['settings']['fields'] : array();
	$font_container_data = $font_container_obj->_vc_font_container_parse_attributes( $font_container_field_settings, $font_container );
	$google_fonts_data = strlen( $google_fonts ) > 0 ? $google_fonts_obj->_vc_google_fonts_parse_attributes( $google_fonts_field_settings, $google_fonts ) : '';

	$styles = array();
	if ( ! empty( $font_container_data ) && isset( $font_container_data['values'] ) ) {
		foreach ( $font_container_data['values'] as $key => $value ) {
			if ( 'tag' !== $key && strlen( $value ) ) {
				if ( preg_match( '/description/', $key ) ) {
					continue;
				}
				if ( 'font_size' === $key || 'line_height' === $key ) {
					$value = preg_replace( '/\s+/', '', $value );
				}
				if ( 'font_size' === $key ) {
					$pattern = '/^(\d*(?:\.\d+)?)\s*(px|\%|in|cm|mm|em|rem|ex|pt|pc|vw|vh|vmin|vmax)?$/';
					// allowed metrics: http://www.w3schools.com/cssref/css_units.asp
					$regexr = preg_match( $pattern, $value, $matches );
					$value = isset( $matches[1] ) ? (float) $matches[1] : (float) $value;
					$unit = isset( $matches[2] ) ? $matches[2] : 'px';
					$value = $value . $unit;
				}
				if ( strlen( $value ) > 0 ) {
					$styles[] = str_replace( '_', '-', $key ) . ': ' . $value;
				}
			}
		}
	}
	if ( ( ! isset( $atts['use_theme_fonts'] ) || 'yes' !== $atts['use_theme_fonts'] ) && ! empty( $google_fonts_data ) && isset( $google_fonts_data['values'], $google_fonts_data['values']['font_family'], $google_fonts_data['values']['font_style'] ) ) {
		$google_fonts_family = explode( ':', $google_fonts_data['values']['font_family'] );
		$styles[] = 'font-family:' . $google_fonts_family[0];
		$google_fonts_styles = explode( ':', $google_fonts_data['values']['font_style'] );
		$styles[] = 'font-weight:' . $google_fonts_styles[1];
		$styles[] = 'font-style:' . $google_fonts_styles[2];
	}

	$settings = get_option( 'wpb_js_google_fonts_subsets' );
	if ( is_array( $settings ) && ! empty( $settings ) ) {
		$subsets = '&subset=' . implode( ',', $settings );
	} else {
		$subsets = '';
	}

	if ( isset( $google_fonts_data['values']['font_family'] ) ) {
		wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $google_fonts_data['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $google_fonts_data['values']['font_family'] . $subsets );
	}

	if ( ! empty( $styles ) ) {
		$styles_final = "";
		foreach ($styles as $key => $value) {
			$styles_final .= $value.";";
		}
	}

	if ( 'true' === $add_icon ) {
		vc_icon_element_fonts_enqueue( $icon_type );

		if ( isset( ${'icon_' . $icon_type} ) ) {
			$icon_class = ${'icon_' . $icon_type};
		} else {
			$icon_class = 'fa fa-adjust';
		}
	}

	$class_to_filter = vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

	?>

	<div class="autoroyal-price-box <?php echo esc_attr($css_class); ?> <?php if ( 'true' === $featured ) { echo "featured-autoroyal-price-box"; } ?> <?php if($bg_style == "dark") { echo " autoroyal-price-box-dark"; } ?> autoroyal-price-box-align-<?php echo esc_attr($align); ?>" style="<?php if($bg_style == "dark" && !empty($img_src)) { ?>background-image: url(<?php echo esc_url($img_src); ?>);<?php } ?> <?php if( !empty($background_color) && $bg_style == "dark" ) { ?>background-color: <?php echo esc_attr($background_color); ?>;<?php } ?>">

		<?php if ( 'true' === $add_icon ) { ?>
		<div class="autoroyal-price-box-icon">
			<?php echo "<i class='" . wp_kses($icon_class, true) . "'></i>"; ?>
		</div>
		<?php } ?>

		<div class="autoroyal-price-box-title">
			<h4 style="<?php echo esc_attr($styles_final); ?>"><?php echo esc_attr($title); ?></h4>
		</div>
		<div class="autoroyal-price-box-subtitle"><?php echo esc_attr($subtitle); ?></div>

		<div class="autoroyal-price-box-price">
			<div class="autoroyal-price-box-price-currency"><?php echo esc_attr($currency); ?></div>
			<div class="autoroyal-price-box-price-amount" style="<?php echo esc_attr($styles_final); ?>"><?php echo esc_attr($price); ?></div>	
			<?php if(!empty($period)) { ?><div class="autoroyal-price-box-price-period">/<?php echo esc_attr($period); ?></div><?php } ?>
		</div>

		<div class="autoroyal-price-box-features"><?php echo wp_kses($content, true); ?></div>

		<?php if(!empty($button_href)) { ?>
		<a class="autoroyal-button button-icon-right autoroyal-button-align-<?php echo esc_attr($align); ?>" href="<?php echo esc_url($button_href); ?>"><?php echo esc_attr($button_text); ?> <i class="fa fa-check" aria-hidden="true"></i></a>
		<?php } ?>

	</div>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_price_box', 'autoroyal_price_box_func' );

vc_map( array(
  	'name' => esc_html__( 'Pricing Box', 'autoroyal' ),
	'base' => 'autoroyal_price_box',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoroyal pricing box', 'autoroyal' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Title', 'autoroyal' ),
			'param_name' => 'title',
			'admin_label' => true,
			'value' => esc_html__( 'Premium', 'autoroyal' ),
			'group' => esc_html__( 'Content', 'autoroyal' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Sub title', 'autoroyal' ),
			'param_name' => 'subtitle',
			'value' => esc_html__( 'Perfect for small startups that have less than 10 team members', 'autoroyal' ),
			'group' => esc_html__( 'Content', 'autoroyal' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Price', 'autoroyal' ),
			'param_name' => 'price',
			'admin_label' => true,
			'value' => esc_html__( '99', 'autoroyal' ),
			'group' => esc_html__( 'Content', 'autoroyal' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Currency Symbol', 'autoroyal' ),
			'param_name' => 'currency',
			'admin_label' => true,
			'value' => esc_html__( '$', 'autoroyal' ),
			'group' => esc_html__( 'Content', 'autoroyal' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Pricing Period', 'autoroyal' ),
			'param_name' => 'period',
			'admin_label' => true,
			'value' => esc_html__( 'month', 'autoroyal' ),
			'group' => esc_html__( 'Content', 'autoroyal' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Featured?', 'autoroyal' ),
			'param_name' => 'featured',
			'group' => esc_html__( 'Content', 'autoroyal' ),
			'std' => 'false',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Button URL', 'autoroyal' ),
			'param_name' => 'button_href',
			'value' => esc_html__( '#', 'autoroyal' ),
			'group' => esc_html__( 'Content', 'autoroyal' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Button Text', 'autoroyal' ),
			'param_name' => 'button_text',
			'value' => esc_html__( 'Subscribe', 'autoroyal' ),
			'group' => esc_html__( 'Content', 'autoroyal' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textarea_html',
			'heading' => esc_html__( 'Features', 'autoroyal' ),
			'param_name' => 'content',
			'value' => '',
			'group' => esc_html__( 'Content', 'autoroyal' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Align', 'autoroyal' ),
			'description' => esc_html__( 'Align content .', 'autoroyal' ),
			'param_name' => 'align',
			'value' => array(
				__( 'Left', 'autoroyal' ) => 'left',
				__( 'Center', 'autoroyal' ) => 'center',
				__( 'Right', 'autoroyal' ) => 'right',
			),
			'std' => 'left',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Background', 'autoroyal' ),
			'description' => esc_html__( 'Select background type.', 'autoroyal' ),
			'param_name' => 'bg_style',
			'value' => array(
				__( 'Light', 'autoroyal' ) => 'light',
				__( 'Dark', 'autoroyal' ) => 'dark',
			),
			'std' => 'light',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Background Image', 'autoroyal' ),
			'param_name' => 'image',
			'value' => '',
			'description' => esc_html__( 'Select image from media library.', 'autoroyal' ),
			'group' => esc_html__( 'Style', 'autoroyal' ),
			'dependency' => array(
				'element' => 'bg_style',
				'value_not_equal_to' => 'light',
			),
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Background Color', 'autoroyal' ),
			'param_name' => 'background_color',
			'value' => '#3b3a38',
			'description' => esc_html__( 'Select custom background color for your element.', 'autoroyal' ),
			'dependency' => array(
				'element' => 'bg_style',
				'value_not_equal_to' => 'light',
			),
			'edit_field_class' => 'vc_col-sm-6',
			'std' => '#3b3a38',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Use title theme default font family?', 'autoroyal' ),
			'param_name' => 'use_theme_fonts',
			'value' => array( esc_html__( 'Yes', 'autoroyal' ) => 'yes' ),
			'description' => esc_html__( 'Use font family from the theme.', 'autoroyal' ),
			'std' => 'yes',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'google_fonts',
			'param_name' => 'google_fonts',
			'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal',
			'settings' => array(
				'fields' => array(
					'font_family_description' => esc_html__( 'Select font family.', 'autoroyal' ),
					'font_style_description' => esc_html__( 'Select font styling.', 'autoroyal' ),
				),
			),
			'dependency' => array(
				'element' => 'use_theme_fonts',
				'value_not_equal_to' => 'yes',
			),
			'std' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Add icon?', 'autoroyal' ),
			'param_name' => 'add_icon',
			'group' => esc_html__( 'Style', 'autoroyal' ),
			'std' => 'false',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon library', 'autoroyal' ),
			'value' => array(
				__( 'Font Awesome', 'autoroyal' ) => 'fontawesome',
				__( 'Open Iconic', 'autoroyal' ) => 'openiconic',
				__( 'Typicons', 'autoroyal' ) => 'typicons',
				__( 'Entypo', 'autoroyal' ) => 'entypo',
				__( 'Linecons', 'autoroyal' ) => 'linecons',
				__( 'Mono Social', 'autoroyal' ) => 'monosocial',
			),
			'param_name' => 'icon_type',
			'description' => esc_html__( 'Select icon library.', 'autoroyal' ),
			'dependency' => array(
				'element' => 'add_icon',
				'value' => 'true',
			),
			'std' => 'fontawesome',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_fontawesome',
			'value' => 'fa fa-info-circle',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'fontawesome',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'std' => 'fa fa-info-circle',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_openiconic',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'openiconic',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'openiconic',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_typicons',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'typicons',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'typicons',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_entypo',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'entypo',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'entypo',
			),
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_linecons',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon?
				'type' => 'linecons',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'linecons',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'autoroyal' ),
			'param_name' => 'icon_monosocial',
			'value' => 'vc-mono vc-mono-fivehundredpx', // default value to backend editor admin_label
			'settings' => array(
				'emptyIcon' => false, // default true, display an "EMPTY" icon?
				'type' => 'monosocial',
				'iconsPerPage' => 4000, // default 100, how many icons per/page to display
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'monosocial',
			),
			'description' => esc_html__( 'Select icon from library.', 'autoroyal' ),
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),

));

