<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_search_by_make_func( $atts ) {

    extract( shortcode_atts( array(
        "columns" => "4",
        "amount" => -1,
        "css" => "",
    ), $atts ) );

	ob_start();

	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

    $MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

    $vehicles_search_url = "";
    $vehicles_search_url = get_option("autoroyal_search_vehicles_page_id");

	?>

    <div class="autoroyal-search-by-make <?php echo esc_attr($css_class); ?>">

        <div class="row">

            <?php 

                $total_cars_by_make = autoroyal_get_total_makes_and_models();

                if( !empty($total_cars_by_make) ) {

                    sort($total_cars_by_make);
                    $total = count($total_cars_by_make);
                    $total_rows = ceil($total / $columns);

                    if( $amount != -1 AND $amount < $total ) {
                        $total = $amount;
                    }

                    $current = 0;

                    for( $i = 0; $i <= ($total - 1); ++$i ){

                        $current++;

                        $term = get_term_by( 'name', $total_cars_by_make[$i]['make_clean'], 'vehicle_model');

                        $term_slug = $term->slug;
                        $term_name = $term->name;

                        $items = get_posts( array(
                            'post_type'   => 'vehicle',
                            'post_status' => 'publish',
                            'numberposts' => -1,
                            'meta_query' => array(
                                    array(
                                        'key' => 'vehicle_make_desc_init',
                                        'value' => $term_name
                                    )
                                )
                            ) );

                        $count = count( $items );

                        $car_cover = autoroyal_get_term_icon_url( $term->term_id, 'full' );
                        if(empty($car_cover)) {
                            $car_cover = get_template_directory_uri().'/assets/images/car-body-style.png';
                        }

                        if(!empty($total_cars_by_make[$i]['make_clean'])) {

                            ?>
                            <div class="<?php if($columns == "4") { ?>col-lg-3<?php } else if($columns == "3") { ?>col-lg-4<?php } elseif($columns == "2") { ?>col-lg-6<?php } elseif($columns == "1") { ?>col-lg-12<?php } ?> col-md-12 col-sm-12">
                            
                                <a href="<?php echo get_permalink( $vehicles_search_url ); ?>?make=<?php echo esc_attr($total_cars_by_make[$i]['make_clean']); ?>">
                                    <?php echo esc_attr($term_name); ?> <span class="text-muted"><?php echo esc_attr($count); ?></span>
                                </a>

                            </div>
                            
                            <?php

                        }

                    }

                }

            ?>

        </div>

    </div>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_search_by_make', 'autoroyal_search_by_make_func' );

vc_map( array(
  	'name' => esc_html__( 'Search By Make - List', 'autoroyal' ),
	'base' => 'autoroyal_search_by_make',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Search by make', 'autoroyal' ),
	'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Columns', 'autoroyal' ),
            'value' => array(
                __( '4 Columns', 'autoroyal' ) => '4',
                __( '3 Columns', 'autoroyal' ) => '3',
                __( '2 Columns', 'autoroyal' ) => '2',
                __( '1 Column', 'autoroyal' ) => '1',
            ),
            'param_name' => 'columns',
            'description' => esc_html__( 'Select the number of columns.', 'autoroyal' ),
            'std' => '4',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Amount', 'autoroyal' ),
            'param_name' => 'amount',
            'value' => '-1',
            'description' => esc_html__( 'Enter the amont (-1 for all).', 'autoroyal' ),
        ),
        array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

