<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	$show_filter = 1;

	if( !empty($cars_type) AND $cars_type == "featured") {
		$show_filter = 0;
	}

	if( !empty($cars_type) AND $cars_type == "recent") {
		$show_filter = 0;
	}

	if( !empty($cars_type) AND $cars_type == "popular") {
		$show_filter = 0;
	}

	$posts_per_page_set = get_option("autoroyal_posts_per_page");
	if( isset($posts_per_page_set) AND !empty($posts_per_page_set) AND $posts_per_page_set != 0 ) {
		
		$posts_per_page = $posts_per_page_set;

	} else {

		$posts_per_page = "9";

	}

	if( !empty($show) ) {
		$posts_per_page = $show;
	}

    $post_status = array( 'publish' );

    if ( is_home() || is_front_page() ) {
   		$paged = get_query_var( 'page' ) ? get_query_var( 'page' ) : 1;
   	} else {
   		$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
   	}
    
    if( !empty($cars_type) AND $cars_type == "featured" ) {

		$search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
			'post_type'           => 'vehicle',
			'post_status'         => $post_status,
			'posts_per_page'      => $posts_per_page,
	    	'meta_key'            => '_featured',
	    	'meta_value'          => 1,
	    	'ignore_sticky_posts' => 1,
	    	'orderby'             => 'date', 
	    	'order'               => 'DESC',
	    	'meta_query' => array(
			    array(
			        'key' => '_sold',
			        'value' => 0
			    )
			)

		) );

	} elseif( !empty($cars_type) AND $cars_type == "recent" ) {

		$search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
			'post_type'           => 'vehicle',
			'post_status'         => $post_status,
			'posts_per_page'      => $posts_per_page,
			'orderby'             => 'date', 
	    	'order'               => 'DESC',
	    	'ignore_sticky_posts' => 1,
	    	'meta_query' => array(
			    array(
			        'key' => '_sold',
			        'value' => 0
			    )
			)

		) );

	} elseif( !empty($cars_type) AND $cars_type == "popular" ) {

		$search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
			'post_type'           => 'vehicle',
			'post_status'         => $post_status,
			'posts_per_page'      => $posts_per_page,
			'orderby'             => 'meta_value_num',
			'meta_key'            => 'post_views_count',
			'order'               => 'DESC',
			'ignore_sticky_posts' => 1,
			'meta_query' => array(
			    array(
			        'key' => '_sold',
			        'value' => 0
			    )
			)

		) );

	} else {

		$search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
			'post_type'           => 'vehicle',
			'post_status'         => $post_status,
			'posts_per_page'      => $posts_per_page,
			'offset'              => ( max( 1, $paged ) - 1 ) * $posts_per_page,
			'meta_key'            => '_featured',
			'orderby'             => array('meta_value_num' => 'DESC', 'date' => 'DESC'),
	    	'ignore_sticky_posts' => 1,
	    	'meta_query' => array(
			    array(
			        'key' => '_sold',
			        'value' => 0
			    )
			)
		) );

	}

	$search_args = apply_filters( 'autoroyal_search_filter_parameters', $search_args );
	$cars_query = new WP_Query;
	$cars = $cars_query->query( $search_args );

	$max_num_pages = $cars_query->max_num_pages;

?>

<?php if( $show_filter == 1 ) { $shortcode_filter = 0; autoroyal_horizontal_search_filter( $shortcode_filter ); } ?>

<div id="autoroyal-inventory">

	<div class="row">

		<?php 

			if ( ! $cars ) : 

		?>
			<div class="col-md-12">
				<h4><?php esc_html_e( 'No listings were found matching your search criteria.', 'autoroyal' ); ?></h4>
			</div>
		<?php else : ?>
			<?php foreach ( $cars as $car ) : ?>

				<?php 

					$car_ID = $car->ID; 

					$vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
					$vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
					$vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
					$vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
					$vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
					$vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
					$vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

					$vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
					if(!empty($vehicle_exterior_color)) {
						$color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
						$color_id   = $vehicle_exterior_color[0]->term_id;
						$color_name = $vehicle_exterior_color[0]->name;
					} else {
						$color_name = "";
					}

					$vehicle_mileage = esc_attr(get_post_meta($car_ID, 'vehicle_mileage',true));

					$vehicle_cost = esc_attr(get_post_meta($car_ID, 'vehicle_cost',true));
					$vehicle_retail_price = esc_attr(get_post_meta($car_ID, 'vehicle_retail_price',true));
					$vehicle_discounted_price = esc_attr(get_post_meta($car_ID, 'vehicle_discounted_price',true));
					$price = esc_attr(get_post_meta($car_ID, 'vehicle_price',true));

					$vehicle_image_gallery = get_post_meta($car_ID, 'vehicle_image_gallery',true);
					$vehicle_image_extended_gallery = get_post_meta($car_ID, 'vehicle_image_extended_gallery',true);
					$vehicle_image_url = "";

					if(!empty($vehicle_image_gallery[0]['url'])) {

						$vehicle_image_url = $vehicle_image_gallery[0]['url'];

					} elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

						$vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

					}

					$vehicle_cover_image = get_post_meta($car_ID, 'vehicle_cover_image',true);
					if(!empty($vehicle_cover_image)) {
						$vehicle_image_url = $vehicle_cover_image;
					}

					$vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));
					$vehicle_power_hp = esc_attr(get_post_meta($car_ID, 'vehicle_power_hp',true));

					$vehicle_drive = get_the_terms($car_ID, 'vehicle_drive' );
					$terms_vehicle_drive = $vehicle_drive[0]->name;

				?>

				<div class="col-lg-4 col-md-4 col-sm-6"> 

					<div class="autoroyal-vehicle-block">
						
						<div class="autoroyal-vehicle-block-image-wrapper">
							<?php if(!empty($vehicle_image_url)) { ?>
							<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-thumbnail" style="background-image: url(<?php echo esc_url($vehicle_image_url); ?>);"></a>
							<?php } else { ?>
							<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-no-thumbnail">
								<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 538.043 538.043" style="enable-background:new 0 0 538.043 538.043;" xml:space="preserve"><path d="M526.745,312.866h-15.005c-3.706-18.736-10.307-44.359-20.792-57.941c-49.022-63.573-110.574-97.697-187.945-97.697
			c-50.134,0-82.787,4.902-99.789,14.981c-2.295,1.363-9.063,5.369-27.344,42.135c-26.687,0.419-97.278,5.261-131.127,43.414
			c-16.99,19.143-23.746,39.719-26.352,55.096h-7.078C5.058,312.854,0,317.924,0,324.177c0,6.241,5.058,11.323,11.311,11.323h5.655
			c0.048,0.61,0.096,1.076,0.108,1.219c0.598,5.739,5.464,10.115,11.239,10.115h14.252c8.752,19.968,28.66,33.981,51.831,33.981
			s43.079-14.013,51.855-33.981h215.982c8.74,19.968,28.66,33.981,51.832,33.981c23.172,0,43.091-14.013,51.832-33.981h38.165
			c0.084,0,0.155,0,0.215,0c6.253,0,11.335-5.07,11.335-11.323h11.131c6.241,0,11.299-5.081,11.299-11.323
			C538.044,317.924,532.986,312.866,526.745,312.866z M94.397,358.169c-18.724,0-33.968-15.232-33.968-33.981
			c0-18.748,15.232-33.992,33.968-33.992c18.748,0,34.004,15.245,34.004,33.992C128.402,342.937,113.145,358.169,94.397,358.169z
			 M295.183,226.433c0,3.133-2.523,5.667-5.667,5.667h-87.964c-1.937,0-3.742-1.016-4.783-2.666
			c-1.052-1.662-1.148-3.731-0.287-5.476c4.149-8.537,11.67-23.327,15.269-26.4c11.981-7.616,36.001-11.227,72.002-11.227
			c1.961,0,3.922,0.024,5.906,0.06c3.061,0.072,5.512,2.595,5.512,5.667L295.183,226.433L295.183,226.433z M306.53,226.433V193.66
			c0-1.614,0.705-3.157,1.901-4.233c1.208-1.076,2.81-1.614,4.424-1.399c39.863,4.687,70.519,17.875,82.058,35.272
			c1.16,1.746,1.244,3.97,0.263,5.811c-0.968,1.841-2.905,2.989-4.998,2.989h-78.004C309.077,232.1,306.53,229.565,306.53,226.433z
			 M414.067,358.169c-18.724,0-33.98-15.232-33.98-33.981c0-18.748,15.244-33.992,33.98-33.992c18.736,0,33.98,15.245,33.98,33.992
			C448.047,342.937,432.791,358.169,414.067,358.169z"/></svg>
							</a>
							<?php } ?>
						</div>

						<div class="autoroyal-vehicle-block-meta">

							<a class="heading" href="<?php echo get_permalink( $car_ID ); ?>"><?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?> <?php echo esc_attr($vehicle_trim_desc_init); ?> <span class="productYear"><?php echo esc_attr($vehicle_year); ?></span></a>

							<span class="autoroyal-vehicle-block-specs"><?php echo autoroyal_number($vehicle_mileage); ?> <?php $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo "Km"; } else { echo "Mi"; } ?>, <?php echo esc_attr($vehicle_engine_volume_l); ?>, <?php echo esc_attr($vehicle_power_hp); ?> hp, <?php if(!empty($terms_vehicle_drive)) { echo esc_attr($terms_vehicle_drive); } ?></span>

							<hr class="separator">

							<h4 class="autoroyal-vehicle-block-meta-price"><?php echo autoroyal_price($price); ?></h4>

							<?php 

								if( is_user_logged_in() ){

									$user_id = get_current_user_id();
	                				$listing_id = $car_ID;
	                				$user_type = "id";

	                			} else {

	                				$user_id = autoroyalGetIP();
	                				$listing_id = $car_ID;
	                				$user_type = "ip";

	                			}

							?>

							<a href="#" type="button" class="fav-button btn btn-danger pull-right favorited add-to-favorite" data-id="<?php echo esc_attr($listing_id); ?>" data-user-id="<?php echo esc_attr($user_id); ?>" data-user-type="<?php echo esc_attr($user_type); ?>"> 
								<?php if( is_added_to_favorite( $user_type, $user_id, $listing_id ) ){ ?><i class="fa fa-heart"></i><?php } else { ?><i class="far fa-heart"></i><?php } ?>
							</a>

						</div>

					</div>

				</div>

			<?php endforeach; ?>
		<?php endif; ?>

		<?php if( $show_filter == 1 ) { ?>

		<div class="col-md-12"> 

			<?php get_autoroyal_template( 'pagination.php', array( 'max_num_pages' => $max_num_pages ) ); ?>

		</div>

		<?php } ?>

	</div>

</div>
