<?php
	
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	$td_user        = wp_get_current_user();
	$td_user_id     = $td_user->ID; // You can set $td_user_id to any users, but this gets the current users ID.
	$td_user_info   = get_userdata($td_user_id);
	$userName       = $td_user_info->display_name;

?>

<div id="autoroyal-dashboard">
	
	<div class="table-toolbar">

		<div class="row">

			<div class="col-sm-12">

				<div class="row">

					<div class="col-lg-6 col-md-12 mb-4">

						<h3 class="d-inline"><?php esc_html_e( 'Howdy', 'autoroyal' ) ?>, <?php echo esc_attr($userName); ?>!</h3>

					</div>

					<div class="col-lg-6 col-md-12">
				
						<?php if ( autoroyal_get_permalink( 'submit_deal_form' ) ) { ?>
						
							<a id="autoroyal_add_vehicle" href="<?php echo esc_url(autoroyal_get_permalink( 'submit_deal_form' )); ?>" class="btn btn-default button-icon-left"><i class="material-icons">monetization_on</i> <?php esc_html_e( 'Add Deal', 'autoroyal' ) ?></a>

						<?php } ?>

						<?php if ( autoroyal_get_permalink( 'submit_lead_form' ) ) { ?>
						
							<a id="autoroyal_add_lead" href="<?php echo esc_url(autoroyal_get_permalink( 'submit_lead_form' )); ?>" class="btn btn-default button-icon-left"><i class="material-icons">person_add</i> <?php esc_html_e( 'Add Lead', 'autoroyal' ) ?></a>

						<?php } ?>

						<?php if ( autoroyal_get_permalink( 'submit_car_form' ) ) { ?>
						
							<a id="autoroyal_add_deal" href="<?php echo esc_url(autoroyal_get_permalink( 'submit_car_form' )); ?>" class="btn btn-default button-icon-left"><i class="material-icons">directions_car</i> <?php esc_html_e( 'Add Vehicle', 'autoroyal' ) ?></a>

						<?php } ?>

					</div>

				</div>

			</div>

		</div>

		<div class="row autoroyal-inventory-stats">

			<div class="col-lg-2 col-md-6 col-sm-12">

				<?php

					$leads_url = "";

					if ( autoroyal_get_permalink( 'leads' ) ) {

						$leads_url = esc_url(autoroyal_get_permalink( 'leads' ));

					}

					$new_leads = autoroyal_get_new_leads();

					if($new_leads == 0) {

				?>

				<div class="autoroyal-inventory-stats-block <?php if(!empty($leads_url)) { echo "autoroyal-stats-has-url"; } ?>" <?php if(!empty($leads_url)) { echo "data-url=" . $leads_url; } ?>>

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'Total Leads', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_get_total_leads(); ?></span>

				</div>

				<?php } else { ?>

				<div class="autoroyal-inventory-stats-block <?php if(!empty($leads_url)) { echo "autoroyal-stats-has-url"; } ?> autoroyal-new-leads" <?php if(!empty($leads_url)) { echo "data-url=" . $leads_url; } ?>>

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'New Leads & Ups', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo esc_attr($new_leads); ?></span>

				</div>

				<?php } ?>

			</div>

			<div class="col-lg-2 col-md-6 col-sm-12">

				<?php

					$vehicles_url = "";

					if ( autoroyal_get_permalink( 'inventory' ) ) {

						$vehicles_url = esc_url(autoroyal_get_permalink( 'inventory' ));

					}

				?>

				<div class="autoroyal-inventory-stats-block <?php if(!empty($vehicles_url)) { echo "autoroyal-stats-has-url"; } ?>" <?php if(!empty($vehicles_url)) { echo "data-url=" . $vehicles_url; } ?>>

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'Total Vehicles', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_get_total_cars(); ?></span>

				</div>

			</div>

			<div class="col-lg-2 col-md-6 col-sm-12">

				<?php

					$deals_url = "";

					if ( autoroyal_get_permalink( 'deals' ) ) {

						$deals_url = esc_url(autoroyal_get_permalink( 'deals' ));

					}

				?>

				<div class="autoroyal-inventory-stats-block <?php if(!empty($deals_url)) { echo "autoroyal-stats-has-url"; } ?>" <?php if(!empty($deals_url)) { echo "data-url=" . $deals_url; } ?>>

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'Total Deals', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_get_total_deals(); ?></span>

				</div>

			</div>

			<div class="col-lg-2 col-md-6 col-sm-12">

				<div class="autoroyal-inventory-stats-block">

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'Avg. Days', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_get_avg_days(); ?></span>

				</div>

			</div>

			<div class="col-lg-2 col-md-6 col-sm-12">

				<div class="autoroyal-inventory-stats-block">

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'Total Cost', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_clean_price(autoroyal_get_total_cost()); ?></span>

				</div>

			</div>

			<div class="col-lg-2 col-md-6 col-sm-12">

				<div class="autoroyal-inventory-stats-block autoroyal-green-background">

					<span class="autoroyal-inventory-stats-block-title"><?php esc_html_e( 'Potential Profit', 'autoroyal' ) ?></span>
					<span class="autoroyal-inventory-stats-block-value" class="overviewText"><?php echo autoroyal_clean_price(autoroyal_get_potential_profit()); ?></span>

				</div>

			</div>

		</div>

		<?php

			$webiste_type = get_option( 'autoroyal_webiste_type' );

			if( $webiste_type == "marketplace" ) {

				$acc_funds = get_option( 'autoroyal_enable_account_funds' );

				if( $acc_funds == 1 ) {

					/**
					 * Get HTML string for topup form in my account.
					 *
					 * @since 2.0.12
					 *
					 * @return string HTML string
					 */
					function get_my_account_topup() {
						ob_start();
						my_account_topup();
						return ob_get_clean();
					}

					if ( is_woocommerce_active() ) {

						/**
						 * Show top up form
						 */
						function my_account_topup() {
							$min_topup     = get_option( 'autoroyal_account_funds_min_topup' );
							$max_topup     = get_option( 'autoroyal_account_funds_max_topup' );
							$items_in_cart = _get_topup_items_in_cart();
							$topup_in_cart = array_shift( $items_in_cart );
							if ( ! empty( $max_topup ) && ! empty( $topup_in_cart ) ) {
								printf(
									'<p class="woocommerce-info"><a href="%s" class="button wc-forward">%s</a> %s</p>',
									wc_get_page_permalink( 'cart' ),
									__( 'View Cart', 'autoroyal' ),
									sprintf( __( 'You have "%s" in your cart.', 'autoroyal' ), $topup_in_cart['data']->get_title() )
								);
								return;
							}

							$vars = array(
								'min_topup' => $min_topup,
								'max_topup' => $max_topup,
							);

							wc_get_template( 'myaccount/topup-form.php', $vars, '', autoroyal_PLUGIN_DIR . '/templates/' );
						}

						/**
						 * Get topup items in cart.
						 */
						function _get_topup_items_in_cart() {
							$item = "";
							$topup_items = array();
							if ( ! WC()->cart->is_empty() ) {
								$topup_items = array_filter( WC()->cart->get_cart(), 'filter_topup_items' );
							}

							return $topup_items;
						}

						/**
						 * Cart items filter callback to filter topup product.
						 *
						 * @return bool Returns true if item is topup product
						 */
						function filter_topup_items( $item ) {
							if ( isset( $item['data'] ) && is_callable( array( $item['data'], 'get_type' ) ) ) {
								return ( 'topup' === $item['data']->get_type() );
							}

							return false;
						}

						/**
						 * Endpoint HTML content.
						 */
						function endpoint_content() {
							$topup      = '';
							$products   = '';
							$payouts    = '';

							$topup = get_my_account_topup();
							$recent_deposits = "";

							$vars = array(
								'funds'           => autoroyal_WC_Account_Funds::get_account_funds(),
								'topup'           => $topup,
								'products'        => $products,
								'payouts'         => $payouts,
								'recent_deposits' => $recent_deposits,
							);

							wc_get_template( 'myaccount/account-funds.php', $vars, '', autoroyal_PLUGIN_DIR . '/templates/' );
						}

				?>

				<div class="options_group">

					<div class="row">

						<div class="col-md-12">

							<h2 class="options_group_heading heading_with_border"><?php esc_html_e('Account Funds', 'autoroyal' ); ?></h2>

							<?php endpoint_content(); ?>

						</div>

					</div>

				</div>

				<?php } ?>

			<?php } ?>

		<?php } ?>

		<?php

			$search_args = array(
				'post_type'           => 'lead',
				'posts_per_page'      => -1,
				'post_status'         => array( 'publish' ),
				'author'              => get_current_user_id()
			) ;

			$leads_query = new WP_Query;
			$leads = $leads_query->query( $search_args );

			$current = 0;
			$leads_array = array();

			if ( $leads ) : 

				foreach ( $leads as $lead ) :

					$lead_ID = $lead->ID; 

					$lead_first_name = esc_attr(get_post_meta($lead_ID, 'lead_first_name',true));
					$lead_last_name = esc_attr(get_post_meta($lead_ID, 'lead_last_name',true));

					$lead_vehicle_id = esc_attr(get_post_meta($lead_ID, 'lead_vehicle_id',true));
					$vehicle_year = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_year',true));
					$vehicle_model = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_model',true));
					$vehicle_trim_desc_init = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_trim_desc_init',true));
					$vehicle_make_desc_init = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_make_desc_init',true));

					$vehicle_name = $vehicle_year . " " . $vehicle_make_desc_init . " " . $vehicle_model . " " . $vehicle_trim_desc_init;

					$lead_mobile_phone = esc_attr(get_post_meta($lead_ID, 'lead_mobile_phone',true));

					$lead_appointment_strtotime = esc_attr(get_post_meta($lead_ID, 'lead_appointment_strtotime',true));
					$now = strtotime(date("Y-m-d H:i:s")); 

					if( !empty($lead_appointment_strtotime) AND ($lead_appointment_strtotime > $now) ) {

						$current++;
						$leads_array[$current]['id'] = $lead_ID;
						$leads_array[$current]['first_name'] = $lead_first_name;
						$leads_array[$current]['last_name'] = $lead_last_name;
						$leads_array[$current]['vehicle_name'] = $vehicle_name;
						$leads_array[$current]['phone'] = $lead_mobile_phone;
						$leads_array[$current]['date'] = $lead_appointment_strtotime;

					}

				endforeach;

			endif;

			if( $current > 0) {

		?>

		<div class="options_group">

			<div class="row">

				<div class="col-md-12">

					<h2 class="options_group_heading"><?php esc_html_e('Appointments', 'autoroyal' ); ?></h2>

					<table id="autoroyal_lead_appointments_table" class="car-manager-cars table-hover" data-edit-url="<?php if ( ! autoroyal_get_permalink( 'submit_lead_form' ) ) { echo "no-page"; } else { echo esc_url(autoroyal_get_permalink( 'submit_lead_form' )); } ?>">

						<thead>
							<tr>
								<th class="text-center"><?php esc_html_e( 'Name', 'autoroyal' ); ?></th>
								<th><?php esc_html_e( 'Vehicle', 'autoroyal' ); ?></th>
								<th class="text-center"><?php esc_html_e( 'Phone', 'autoroyal' ); ?></th>
								<th class="text-center"><?php esc_html_e( 'Date', 'autoroyal' ); ?></th>
							</tr>
						</thead>

						<tbody>

						<?php

						for( $i = 1; $i <= $current; ++$i ){

							?>

							<tr data-id="<?php echo esc_attr($leads_array[$i]['id']); ?>">
								<td class="text-center"><?php echo esc_attr($leads_array[$i]['first_name']); ?> <?php echo esc_attr($leads_array[$i]['last_name']); ?></td>
								<td><?php echo wp_kses($leads_array[$i]['vehicle_name'], true); ?></td>
								<td class="text-center"><?php echo esc_attr($leads_array[$i]['phone']); ?></td>
								<td class="text-center"><?php echo date( 'Y-m-d h:i A', $leads_array[$i]['date'] ); ?></td>
							</tr>

							<?php

						}

						?>

						</tbody>

					</table>

				</div>

			</div>

		</div>

		<?php } ?>

		<div class="row">

			<div class="col-md-6">

				<div class="options_group">

					<h2 class="options_group_heading heading_with_border"><?php esc_html_e('Sales', 'autoroyal' ); ?> <?php $current_year = date('Y'); echo esc_attr($current_year); ?></h2>

					<div id="myChart" class="bar-chart"></div>

					<script type="text/javascript">

						(function( $ ) {
							'use strict';

							jQuery("document").ready(function(){
	    				
			    				google.charts.load('current', {'packages':['bar']});
						      	google.charts.setOnLoadCallback(drawChart);

						      	function drawChart() {
						        
							        var data = google.visualization.arrayToDataTable([
							          // ['Month', 'Orders', 'Customers'],
							          ['Month', 'Sales'],
							          ['<?php esc_html_e('Jan.', 'autoroyal' ); ?>',     <?php echo autoroyal_get_total_sales_by_month( 1 ); ?>],
							          ['<?php esc_html_e('Feb.', 'autoroyal' ); ?>',     <?php echo autoroyal_get_total_sales_by_month( 2 ); ?>],
							          ['<?php esc_html_e('Mar.', 'autoroyal' ); ?>',     <?php echo autoroyal_get_total_sales_by_month( 3 ); ?>],
							          ['<?php esc_html_e('Apr.', 'autoroyal' ); ?>',     <?php echo autoroyal_get_total_sales_by_month( 4 ); ?>],
							          ['<?php esc_html_e('May', 'autoroyal' ); ?>',      <?php echo autoroyal_get_total_sales_by_month( 5 ); ?>],
							          ['<?php esc_html_e('Jun.', 'autoroyal' ); ?>',     <?php echo autoroyal_get_total_sales_by_month( 6 ); ?>],
							          ['<?php esc_html_e('Jul.', 'autoroyal' ); ?>',     <?php echo autoroyal_get_total_sales_by_month( 7 ); ?>],
							          ['<?php esc_html_e('Aug.', 'autoroyal' ); ?>',     <?php echo autoroyal_get_total_sales_by_month( 8 ); ?>],
							          ['<?php esc_html_e('Sep.', 'autoroyal' ); ?>',     <?php echo autoroyal_get_total_sales_by_month( 9 ); ?>],
							          ['<?php esc_html_e('Oct.', 'autoroyal' ); ?>',     <?php echo autoroyal_get_total_sales_by_month( 10 ); ?>],
							          ['<?php esc_html_e('Nov.', 'autoroyal' ); ?>',     <?php echo autoroyal_get_total_sales_by_month( 11 ); ?>],
							          ['<?php esc_html_e('Dec.', 'autoroyal' ); ?>',     <?php echo autoroyal_get_total_sales_by_month( 12 ); ?>]
							        ]);

							        var options = {
							          bars: 'vertical',
							          vAxis: {format: 'decimal'},
							          height: 320,
							          margin: 0,
							          bar: {groupWidth: 30},
							          colors: ['#d5effb', '#7cb8ee']
							        };

							        var chart = new google.charts.Bar(document.getElementById('myChart'));
							        chart.draw(data, google.charts.Bar.convertOptions(options));

						      	}

						    });
							///// end document ready /////

						})( jQuery );

		    		</script>

				</div>

			</div>

			<?php 

				$total_cars_by_make = autoroyal_get_total_cars_by_make();

				if( !empty($total_cars_by_make) ) {

					$total = count($total_cars_by_make);

			?>

			<div class="col-md-6">

				<div class="options_group">

					<h2 class="options_group_heading heading_with_border"><?php esc_html_e('Inventory', 'autoroyal' ); ?></h2>

					<div id="piechart"></div>

					<script type="text/javascript">

						(function( $ ) {
							'use strict';

							jQuery("document").ready(function(){
	    				
			    				google.charts.load('current', {'packages':['corechart']});
						      	google.charts.setOnLoadCallback(drawPie);

						      	function drawPie() {

							        var data = google.visualization.arrayToDataTable([
						          		['<?php esc_html_e('Make', 'autoroyal' ); ?>',        '<?php esc_html_e('Amount', 'autoroyal' ); ?>'],
						          		<?php

						          			for( $i = 1; $i <= $total; ++$i ){

						          				?>
						          				['<?php echo esc_attr($total_cars_by_make[$i]['make']); ?>', <?php echo esc_attr($total_cars_by_make[$i]['amount']); ?>],
						          				<?php

						          			}

						          		?>
							        ]);

							        var options = {
							          	colors: [
							          		<?php

							          			for( $i = 1; $i <= $total; ++$i ){

							          				$rand = array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f');
    												$color = '#'.$rand[rand(0,15)].$rand[rand(0,15)].$rand[rand(0,15)].$rand[rand(0,15)].$rand[rand(0,15)].$rand[rand(0,15)];
							          				//$color = dechex(rand(0x000000, 0xFFFFFF));
							          				echo "'".$color."',";

							          			}

							          		?>
							          		],
							          	height: 320,
							          	is3D: true
							        };

							        var chart = new google.visualization.PieChart(document.getElementById('piechart'));
							        chart.draw(data, options);

						    	}

						    });
							///// end document ready /////

						})( jQuery );

		    		</script>

		    	</div>

			</div>

			<?php } ?>

			<div class="col-md-12">

				<div class="options_group">

					<h2 class="options_group_heading heading_with_border"><?php esc_html_e('Views', 'autoroyal' ); ?></h2>

					<div id="myViews" style="width: 100%; height: 700px;"></div>

					<script type="text/javascript">

						(function( $ ) {
							'use strict';

							jQuery("document").ready(function(){
	    				
			    				google.charts.load('current', {'packages':['bar']});
      							google.charts.setOnLoadCallback(drawStuff);

						      	function drawStuff() {
							      	var data = new google.visualization.arrayToDataTable([
								        ['<?php esc_html_e('Vehicles', 'autoroyal' ); ?>', '<?php esc_html_e('Views', 'autoroyal' ); ?>'],

								        <?php

								        	$search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
												'post_type'           => 'vehicle',
												'post_status'         => 'publish',
												'posts_per_page'      => '20',
												'orderby'             => 'meta_value_num',
												'meta_key'            => 'post_views_count',
												'order'               => 'DESC',
												'ignore_sticky_posts' => 1,
												'author'              => get_current_user_id()

											) );

											$search_args = apply_filters( 'autoroyal_search_filter_parameters', $search_args );
											$cars_query = new WP_Query;
											$cars = $cars_query->query( $search_args );

											foreach ( $cars as $car ) {

												$car_ID = $car->ID; 

												$vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
												$vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
												$vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
												$vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
												$vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
												$vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
												$vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

												$vehicle_full_name = $vehicle_year . " " . $vehicle_make_desc_init . " " . $vehicle_model . " " . $vehicle_trim_desc_init . " " . $vehicle_stock;

												echo "['" . $vehicle_full_name . "', " . autoroyal_getPostViews($car_ID) . "],";
											}

								        ?>
							      	]);

							      	var options = {
							          	width: '100%',
							          	legend: { position: 'none' },
							          	bars: 'horizontal', // Required for Material Bar Charts.
							          	axes: {
							            	x: {
							              		0: { side: 'top', label: '<?php esc_html_e('Views', 'autoroyal' ); ?>'} // Top x-axis.
							            	}
							          	},
							          	bar: { groupWidth: "100%" }
							        };

							      	var chart = new google.charts.Bar(document.getElementById('myViews'));
        							chart.draw(data, options);
    							}

						    });
							///// end document ready /////

						})( jQuery );

		    		</script>

				</div>

			</div>

		</div>

	</div>

</div>
