<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	$action = "";
	if ( isset( $_GET['action'] ) ) {
        $action = $_GET['action'];
    }

    if( empty($lead_id) AND isset( $_GET['lead_id']) ) {
    	$lead_id = $_GET['lead_id'];
    }

    if( $action == "edit" ) {

	    if ( ! autoroyal_user_can_edit_car( $lead_id ) ) {

	    	echo "<div class='car-manager-error'>" . __( 'Invalid ID', 'autoroyal' ) . "</div>";

	    } else {

	    	autoroyal_load_submit_lead_form( $lead_id );

	    }

	} elseif( $action == "delete" ) {
		
	} else {

		autoroyal_load_submit_lead_form( $lead_id );

	}

?>

<?php function autoroyal_load_submit_lead_form( $lead_id ) { ?>

<div id="autoroyal-submit">
	
	<?php
	
		// Enqueue styles
		wp_enqueue_style( 'jquery-ui' );
		wp_enqueue_style( 'bootstrap-select' );

		// Enqueue scripts
		wp_enqueue_script( 'jquery-ui-autocomplete' );
		wp_enqueue_script( 'time-picker' );
		wp_enqueue_script( 'bootstrap-select' );

        $lead_first_name = esc_attr(get_post_meta($lead_id, 'lead_first_name',true));
		$lead_middle_name = esc_attr(get_post_meta($lead_id, 'lead_middle_name',true));
		$lead_last_name = esc_attr(get_post_meta($lead_id, 'lead_last_name',true));

		$lead_address_1 = esc_attr(get_post_meta($lead_id, 'lead_address_1',true));
		$lead_address_2 = esc_attr(get_post_meta($lead_id, 'lead_address_2',true));

		$lead_city = esc_attr(get_post_meta($lead_id, 'lead_city',true));
		$lead_state = esc_attr(get_post_meta($lead_id, 'lead_state',true));
		$lead_zip = esc_attr(get_post_meta($lead_id, 'lead_zip',true));

		$lead_home_phone = esc_attr(get_post_meta($lead_id, 'lead_home_phone',true));
		$lead_mobile_phone = esc_attr(get_post_meta($lead_id, 'lead_mobile_phone',true));
		$lead_work_phone = esc_attr(get_post_meta($lead_id, 'lead_work_phone',true));

		$lead_email = esc_attr(get_post_meta($lead_id, 'lead_email',true));
		$lead_birth_date = esc_attr(get_post_meta($lead_id, 'lead_birth_date',true));
		$lead_social_security = esc_attr(get_post_meta($lead_id, 'lead_social_security',true));

		$lead_driver_license_state = esc_attr(get_post_meta($lead_id, 'lead_driver_license_state',true));
		$lead_driver_license_number = esc_attr(get_post_meta($lead_id, 'lead_driver_license_number',true));
		$lead_driver_license_exp = esc_attr(get_post_meta($lead_id, 'lead_driver_license_exp',true));

		$lead_vehicle_id = esc_attr(get_post_meta($lead_id, 'lead_vehicle_id',true));

		$lead_vehicle_sku = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_stock',true));
		$lead_vehicle_year = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_year',true));
		$lead_vehicle_make = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_make_desc_init',true));
		$lead_vehicle_model = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_model',true));
		$lead_vehicle_trim = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_trim_desc_init',true));
		$lead_vehicle_vin = esc_attr(get_post_meta($lead_vehicle_id, 'vehicle_vin',true));

		$vehicle_exterior_color = get_the_terms($lead_vehicle_id, 'vehicle_exterior_color' );
		if(!empty($vehicle_exterior_color)) {
			$color              = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
			$color_id           = $vehicle_exterior_color[0]->term_id;
			$lead_vehicle_color = $vehicle_exterior_color[0]->name;
		} else {
			$lead_vehicle_color = "";
		}

		$lead_vehicle_mileage = autoroyal_number(get_post_meta($lead_vehicle_id, 'vehicle_mileage',true));
		$lead_vehicle_price = autoroyal_clean_price(get_post_meta($lead_vehicle_id, 'vehicle_price',true));

		$lead_history = get_post_meta($lead_id, 'lead_history',true);

		$lead_appointment_date = esc_attr(get_post_meta($lead_id, 'lead_appointment_date',true));
		$lead_appointment_time = esc_attr(get_post_meta($lead_id, 'lead_appointment_time',true));

		$lead_comments = esc_attr(get_post_meta($lead_id, 'lead_comments',true));

		$lead_history = get_post_meta($lead_id, 'lead_history',true);
		$lead_notes = esc_attr(get_post_meta($lead_id, 'lead_notes',true));

		// Current Residence
		$lead_current_residence_years = esc_attr(get_post_meta($lead_id, 'lead_current_residence_years',true));
		$lead_current_residence_months = esc_attr(get_post_meta($lead_id, 'lead_current_residence_months',true));
		$lead_current_residence_type = esc_attr(get_post_meta($lead_id, 'lead_current_residence_type',true));
		$lead_current_residence_price = esc_attr(get_post_meta($lead_id, 'lead_current_residence_price',true));

		// Previous Residence
		$lead_previous_residence = get_post_meta($lead_id, 'lead_previous_residence',true);
		$lead_previous_residence_years = esc_attr(get_post_meta($lead_id, 'lead_previous_residence_years',true));
		$lead_previous_residence_months = esc_attr(get_post_meta($lead_id, 'lead_previous_residence_months',true));
		$lead_previous_residence_type = esc_attr(get_post_meta($lead_id, 'lead_previous_residence_type',true));
		$lead_previous_residence_price = esc_attr(get_post_meta($lead_id, 'lead_previous_residence_price',true));

		// Previous2 Residence
		$lead_previous2_residence = get_post_meta($lead_id, 'lead_previous2_residence',true);
		$lead_previous2_residence_years = esc_attr(get_post_meta($lead_id, 'lead_previous2_residence_years',true));
		$lead_previous2_residence_months = esc_attr(get_post_meta($lead_id, 'lead_previous2_residence_months',true));
		$lead_previous2_residence_type = esc_attr(get_post_meta($lead_id, 'lead_previous2_residence_type',true));
		$lead_previous2_residence_price = esc_attr(get_post_meta($lead_id, 'lead_previous2_residence_price',true));

		// Previous3 Residence
		$lead_previous3_residence = get_post_meta($lead_id, 'lead_previous3_residence',true);
		$lead_previous3_residence_years = esc_attr(get_post_meta($lead_id, 'lead_previous3_residence_years',true));
		$lead_previous3_residence_months = esc_attr(get_post_meta($lead_id, 'lead_previous3_residence_months',true));
		$lead_previous3_residence_type = esc_attr(get_post_meta($lead_id, 'lead_previous3_residence_type',true));
		$lead_previous3_residence_price = esc_attr(get_post_meta($lead_id, 'lead_previous3_residence_price',true));

		// Previous4 Residence
		$lead_previous4_residence = get_post_meta($lead_id, 'lead_previous4_residence',true);
		$lead_previous4_residence_years = esc_attr(get_post_meta($lead_id, 'lead_previous4_residence_years',true));
		$lead_previous4_residence_months = esc_attr(get_post_meta($lead_id, 'lead_previous4_residence_months',true));
		$lead_previous4_residence_type = esc_attr(get_post_meta($lead_id, 'lead_previous4_residence_type',true));
		$lead_previous4_residence_price = esc_attr(get_post_meta($lead_id, 'lead_previous4_residence_price',true));

		// Current Employer
		$lead_current_employer = get_post_meta($lead_id, 'lead_current_employer',true);
		$lead_current_employer_years = esc_attr(get_post_meta($lead_id, 'lead_current_employer_years',true));
		$lead_current_employer_months = esc_attr(get_post_meta($lead_id, 'lead_current_employer_months',true));

		// Previous Employer
		$lead_previous_employer = get_post_meta($lead_id, 'lead_previous_employer',true);
		$lead_previous_employer_years = esc_attr(get_post_meta($lead_id, 'lead_previous_employer_years',true));
		$lead_previous_employer_months = esc_attr(get_post_meta($lead_id, 'lead_previous_employer_months',true));

		// Previous2 Employer
		$lead_previous2_employer = get_post_meta($lead_id, 'lead_previous2_employer',true);
		$lead_previous2_employer_years = esc_attr(get_post_meta($lead_id, 'lead_previous2_employer_years',true));
		$lead_previous2_employer_months = esc_attr(get_post_meta($lead_id, 'lead_previous2_employer_months',true));

		// Previous3 Employer
		$lead_previous3_employer = get_post_meta($lead_id, 'lead_previous3_employer',true);
		$lead_previous3_employer_years = esc_attr(get_post_meta($lead_id, 'lead_previous3_employer_years',true));
		$lead_previous3_employer_months = esc_attr(get_post_meta($lead_id, 'lead_previous3_employer_months',true));

		// Previous4 Employer
		$lead_previous4_employer = get_post_meta($lead_id, 'lead_previous4_employer',true);
		$lead_previous4_employer_years = esc_attr(get_post_meta($lead_id, 'lead_previous4_employer_years',true));
		$lead_previous4_employer_months = esc_attr(get_post_meta($lead_id, 'lead_previous4_employer_months',true));

		$lead_cobuyer_first_name = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_first_name',true));
		$lead_cobuyer_middle_name = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_middle_name',true));
		$lead_cobuyer_last_name = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_last_name',true));

		$lead_cobuyer_home_phone = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_home_phone',true));
		$lead_cobuyer_mobile_phone = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_mobile_phone',true));
		$lead_cobuyer_work_phone = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_work_phone',true));

		$lead_cobuyer_email = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_email',true));
		$lead_cobuyer_birth_date = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_birth_date',true));
		$lead_cobuyer_social_security = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_social_security',true));

		$lead_cobuyer_driver_license_state = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_driver_license_state',true));
		$lead_cobuyer_driver_license_number = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_driver_license_number',true));
		$lead_cobuyer_driver_license_exp = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_driver_license_exp',true));

		// Current Residence
		$lead_cobuyer_current_residence = get_post_meta($lead_id, 'lead_cobuyer_current_residence',true);
		$lead_cobuyer_current_residence_years = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_current_residence_years',true));
		$lead_cobuyer_current_residence_months = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_current_residence_months',true));
		$lead_cobuyer_current_residence_type = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_current_residence_type',true));
		$lead_cobuyer_current_residence_price = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_current_residence_price',true));

		// Previous Residence
		$lead_cobuyer_previous_residence = get_post_meta($lead_id, 'lead_cobuyer_previous_residence',true);
		$lead_cobuyer_previous_residence_years = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous_residence_years',true));
		$lead_cobuyer_previous_residence_months = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous_residence_months',true));
		$lead_cobuyer_previous_residence_type = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous_residence_type',true));
		$lead_cobuyer_previous_residence_price = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous_residence_price',true));

		// Previous2 Residence
		$lead_cobuyer_previous2_residence = get_post_meta($lead_id, 'lead_cobuyer_previous2_residence',true);
		$lead_cobuyer_previous2_residence_years = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous2_residence_years',true));
		$lead_cobuyer_previous2_residence_months = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous2_residence_months',true));
		$lead_cobuyer_previous2_residence_type = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous2_residence_type',true));
		$lead_cobuyer_previous2_residence_price = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous2_residence_price',true));

		// Previous3 Residence
		$lead_cobuyer_previous3_residence = get_post_meta($lead_id, 'lead_cobuyer_previous3_residence',true);
		$lead_cobuyer_previous3_residence_years = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous3_residence_years',true));
		$lead_cobuyer_previous3_residence_months = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous3_residence_months',true));
		$lead_cobuyer_previous3_residence_type = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous3_residence_type',true));
		$lead_cobuyer_previous3_residence_price = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous3_residence_price',true));

		// Previous4 Residence
		$lead_cobuyer_previous4_residence = get_post_meta($lead_id, 'lead_cobuyer_previous4_residence',true);
		$lead_cobuyer_previous4_residence_years = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous4_residence_years',true));
		$lead_cobuyer_previous4_residence_months = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous4_residence_months',true));
		$lead_cobuyer_previous4_residence_type = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous4_residence_type',true));
		$lead_cobuyer_previous4_residence_price = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous4_residence_price',true));
		
		// Current Employer
		$lead_cobuyer_current_employer = get_post_meta($lead_id, 'lead_cobuyer_current_employer',true);
		$lead_cobuyer_current_employer_years = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_current_employer_years',true));
		$lead_cobuyer_current_employer_months = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_current_employer_months',true));

		// Previous Employer
		$lead_cobuyer_previous_employer = get_post_meta($lead_id, 'lead_cobuyer_previous_employer',true);
		$lead_cobuyer_previous_employer_years = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous_employer_years',true));
		$lead_cobuyer_previous_employer_months = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous_employer_months',true));

		// Previous2 Employer
		$lead_cobuyer_previous2_employer = get_post_meta($lead_id, 'lead_cobuyer_previous2_employer',true);
		$lead_cobuyer_previous2_employer_years = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous2_employer_years',true));
		$lead_cobuyer_previous2_employer_months = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous2_employer_months',true));

		// Previous3 Employer
		$lead_cobuyer_previous3_employer = get_post_meta($lead_id, 'lead_cobuyer_previous3_employer',true);
		$lead_cobuyer_previous3_employer_years = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous3_employer_years',true));
		$lead_cobuyer_previous3_employer_months = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous3_employer_months',true));

		// Previous4 Employer
		$lead_cobuyer_previous4_employer = get_post_meta($lead_id, 'lead_cobuyer_previous4_employer',true);
		$lead_cobuyer_previous4_employer_years = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous4_employer_years',true));
		$lead_cobuyer_previous4_employer_months = esc_attr(get_post_meta($lead_id, 'lead_cobuyer_previous4_employer_months',true));

		$lead_tradein_vehicle_year = esc_attr(get_post_meta($lead_id, 'lead_tradein_vehicle_year',true));
		$lead_tradein_vehicle_make = esc_attr(get_post_meta($lead_id, 'lead_tradein_vehicle_make',true));
		$lead_tradein_vehicle_model = esc_attr(get_post_meta($lead_id, 'lead_tradein_vehicle_model',true));
		$lead_tradein_vehicle_trim_id = esc_attr(get_post_meta($lead_id, 'lead_tradein_vehicle_trim_id',true));
		$lead_tradein_vehicle_trim_desc_init = esc_attr(get_post_meta($lead_id, 'lead_tradein_vehicle_trim_desc_init',true));
		$lead_tradein_vehicle_make_desc_init = esc_attr(get_post_meta($lead_id, 'lead_tradein_vehicle_make_desc_init',true));

		$lead_tradein_vehicle_vin = esc_attr(get_post_meta($lead_id, 'lead_tradein_vehicle_vin',true));
		$lead_tradein_vehicle_mileage = esc_attr(get_post_meta($lead_id, 'lead_tradein_vehicle_mileage',true));
		$lead_tradein_vehicle_color = esc_attr(get_post_meta($lead_id, 'lead_tradein_vehicle_color',true));

		$lead_tradein_payoff = esc_attr(get_post_meta($lead_id, 'lead_tradein_payoff',true));
		$lead_tradein_payoff_good = esc_attr(get_post_meta($lead_id, 'lead_tradein_payoff_good',true));
		$lead_tradein_lien_holder_name = esc_attr(get_post_meta($lead_id, 'lead_tradein_lien_holder_name',true));
		$lead_tradein_lien_holder_addres_1 = esc_attr(get_post_meta($lead_id, 'lead_tradein_lien_holder_addres_1',true));
		$lead_tradein_lien_holder_addres_2 = esc_attr(get_post_meta($lead_id, 'lead_tradein_lien_holder_addres_2',true));
		$lead_tradein_lien_holder_city = esc_attr(get_post_meta($lead_id, 'lead_tradein_lien_holder_city',true));
		$lead_tradein_lien_holder_state = esc_attr(get_post_meta($lead_id, 'lead_tradein_lien_holder_state',true));
		$lead_tradein_lien_holder_zip = esc_attr(get_post_meta($lead_id, 'lead_tradein_lien_holder_zip',true));
		$lead_tradein_lien_holder_phone = esc_attr(get_post_meta($lead_id, 'lead_tradein_lien_holder_phone',true));
		$lead_tradein_lien_holder_acc_number = esc_attr(get_post_meta($lead_id, 'lead_tradein_lien_holder_acc_number',true));

		//
		$lead_bank_checking_account_number = esc_attr(get_post_meta($lead_id, 'lead_bank_checking_account_number',true));
		$lead_bank_checking_name = esc_attr(get_post_meta($lead_id, 'lead_bank_checking_name',true));
		$lead_bank_checking_address_1 = esc_attr(get_post_meta($lead_id, 'lead_bank_checking_address_1',true));
		$lead_bank_checking_address_2 = esc_attr(get_post_meta($lead_id, 'lead_bank_checking_address_2',true));
		$lead_bank_checking_city = esc_attr(get_post_meta($lead_id, 'lead_bank_checking_city',true));
		$lead_bank_checking_state = esc_attr(get_post_meta($lead_id, 'lead_bank_checking_state',true));
		$lead_bank_checking_zip = esc_attr(get_post_meta($lead_id, 'lead_bank_checking_zip',true));
		$lead_bank_checking_phone = esc_attr(get_post_meta($lead_id, 'lead_bank_checking_phone',true));

		//
		$lead_bank_savings_account_number = esc_attr(get_post_meta($lead_id, 'lead_bank_savings_account_number',true));
		$lead_bank_savings_name = esc_attr(get_post_meta($lead_id, 'lead_bank_savings_name',true));
		$lead_bank_savings_address_1 = esc_attr(get_post_meta($lead_id, 'lead_bank_savings_address_1',true));
		$lead_bank_savings_address_2 = esc_attr(get_post_meta($lead_id, 'lead_bank_savings_address_2',true));
		$lead_bank_savings_city = esc_attr(get_post_meta($lead_id, 'lead_bank_savings_city',true));
		$lead_bank_savings_state = esc_attr(get_post_meta($lead_id, 'lead_bank_savings_state',true));
		$lead_bank_savings_zip = esc_attr(get_post_meta($lead_id, 'lead_bank_savings_zip',true));
		$lead_bank_savings_phone = esc_attr(get_post_meta($lead_id, 'lead_bank_savings_phone',true));

		//
		$lead_financing_preferred = esc_attr(get_post_meta($lead_id, 'lead_financing_preferred',true));
		$lead_financing_loan_term = esc_attr(get_post_meta($lead_id, 'lead_financing_loan_term',true));
		$lead_financing_amount_req = esc_attr(get_post_meta($lead_id, 'lead_financing_amount_req',true));
		$lead_financing_downpayment = esc_attr(get_post_meta($lead_id, 'lead_financing_downpayment',true));

	?>

	<form action="<?php echo get_permalink(); ?>?action=edit&lead_id=<?php echo esc_attr($lead_id); ?>" method="post" id="submit-lead-autoroyal-form" class="autoroyal-form" enctype="multipart/form-data">

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Buyer', 'autoroyal' ); ?></h2>

			<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>

		    	<h5 class="autoroyal-https-error"><?php esc_html_e('This page is not secure!', 'autoroyal' ); ?><br><br><?php esc_html_e('Sensitive fields will be hidden.', 'autoroyal' ); ?><br><br><?php esc_html_e('Please contact the site administrator for more information.', 'autoroyal' ); ?></h5>

		    <?php } ?>

			<fieldset>
					
				<div class="row">

					<div class="col-lg-4 col-md-6">

						<label for="lead_first_name" class="control-label"><?php esc_html_e('First Name:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_first_name" name="lead_first_name" value="<?php echo esc_attr($lead_first_name); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_middle_name" class="control-label"><?php esc_html_e('Middle Name:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_middle_name" name="lead_middle_name" value="<?php echo esc_attr($lead_middle_name); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_last_name" class="control-label"><?php esc_html_e('Last Name:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_last_name" name="lead_last_name" value="<?php echo esc_attr($lead_last_name); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_address_1" name="lead_address_1" value="<?php echo esc_attr($lead_address_1); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_address_2" name="lead_address_2" value="<?php echo esc_attr($lead_address_2); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_city" name="lead_city" value="<?php echo esc_attr($lead_city); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_state" name="lead_state" value="<?php echo esc_attr($lead_state); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_zip" name="lead_zip" value="<?php echo esc_attr($lead_zip); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_home_phone" class="control-label"><?php esc_html_e('Home Phone:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_home_phone" name="lead_home_phone" value="<?php echo esc_attr($lead_home_phone); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_mobile_phone" class="control-label"><?php esc_html_e('Mobile Phone:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_mobile_phone" name="lead_mobile_phone" value="<?php echo esc_attr($lead_mobile_phone); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_work_phone" class="control-label"><?php esc_html_e('Work Phone:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_work_phone" name="lead_work_phone" value="<?php echo esc_attr($lead_work_phone); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_email" class="control-label"><?php esc_html_e('Email Address:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_email" name="lead_email" value="<?php echo esc_attr($lead_email); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_birth_date" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Date of Birth:', 'autoroyal' ); ?></label>

						<div class="autoroyal-input-has-icon">
							<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
								<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
							<?php } else { ?>
								<input class="date_picker_past autoroyal-input-icon-left" type="text" class="lead_birth_date" name="lead_birth_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($lead_birth_date); ?>" />
								<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
							<?php } ?>
						</div>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_social_security" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Social Security Number:', 'autoroyal' ); ?></label>
						<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
							<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
						<?php } else { ?>
							<input type="text" id="lead_social_security" name="lead_social_security" value="<?php echo esc_attr($lead_social_security); ?>" placeholder="" />
						<?php } ?>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_driver_license_state" class="control-label"><?php esc_html_e('Drivers License State:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_driver_license_state" name="lead_driver_license_state" value="<?php echo esc_attr($lead_driver_license_state); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_driver_license_number" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Drivers License Number:', 'autoroyal' ); ?></label>
						<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
							<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
						<?php } else { ?>
							<input type="text" id="lead_driver_license_number" name="lead_driver_license_number" value="<?php echo esc_attr($lead_driver_license_number); ?>" placeholder="" />
						<?php } ?>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_driver_license_exp" class="control-label"><?php esc_html_e('Drivers License Exp:', 'autoroyal' ); ?></label>

						<div class="autoroyal-input-has-icon">
							<input class="date_picker_future autoroyal-input-icon-left" type="text" id="lead_driver_license_exp" name="lead_driver_license_exp" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($lead_driver_license_exp); ?>" />
							<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
						</div>

					</div>

				</div>
				
			</fieldset>

			<fieldset>

				<div class="row">

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Vehicle Information', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-md-12">

						<label for="lead_vehicle_id" class="control-label"><?php esc_html_e('Select Vehicle', 'autoroyal' ); ?></label>
						<select class="chosen-select" name="lead_vehicle_id" id="lead_vehicle_id">

							<?php 

								$search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
									'post_type'           => 'vehicle',
									'post_status'         => 'publish',
									'posts_per_page'      => -1,
									'orderby'             => 'date',
									'order'               => 'desc'
								) );
								$cars_query = new WP_Query;
								$cars = $cars_query->query( $search_args );

								if ( $cars ) : 

									foreach ( $cars as $car ) :

										$car_ID = $car->ID; 

										$vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
										$vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
										$vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
										$vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
										$vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
										$vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
										$vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

										$vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
										if(!empty($vehicle_exterior_color)) {
											$color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
											$color_id   = $vehicle_exterior_color[0]->term_id;
											$color_name = $vehicle_exterior_color[0]->name;
										} else {
											$color_name = "";
										}

										$vehicle_mileage = esc_attr(get_post_meta($car_ID, 'vehicle_mileage',true));

										$price = esc_attr(get_post_meta($car_ID, 'vehicle_price',true));

							?>
								<option data-sku="<?php echo esc_attr($vehicle_stock); ?>" data-year="<?php echo esc_attr($vehicle_year); ?>" data-make="<?php echo esc_attr($vehicle_make_desc_init); ?>" data-model="<?php echo esc_attr($vehicle_model); ?>" data-trim="<?php echo esc_attr($vehicle_trim_desc_init); ?>" data-vin="<?php echo esc_attr($vehicle_vin); ?>" data-color="<?php echo esc_attr($color_name); ?>" data-mileage="<?php echo autoroyal_number($vehicle_mileage); ?>" data-price="<?php echo autoroyal_clean_price($price); ?>" value="<?php echo esc_attr($car_ID); ?>" <?php selected( $car_ID, $lead_vehicle_id ); ?>><?php if(!empty($vehicle_stock)) { echo esc_attr($vehicle_stock); } else { echo esc_attr($car_ID); } ?> - <?php echo esc_attr($vehicle_year); ?> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?> <?php echo esc_attr($vehicle_trim_desc_init); ?></option>
							<?php 

									endforeach; 

								endif;

							?>
							
						</select>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_vehicle_sku" class="control-label"><?php esc_html_e('Stock Number:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_vehicle_sku" name="lead_vehicle_sku" value="<?php echo esc_attr($lead_vehicle_sku); ?>" placeholder="" disabled="disabled" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_vehicle_year" class="control-label"><?php esc_html_e('Year:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_vehicle_year" name="lead_vehicle_year" value="<?php echo esc_attr($lead_vehicle_year); ?>" placeholder="" disabled="disabled" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_vehicle_make" class="control-label"><?php esc_html_e('Make:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_vehicle_make" name="lead_vehicle_make" value="<?php echo esc_attr($lead_vehicle_make); ?>" placeholder="" disabled="disabled" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_vehicle_model" class="control-label"><?php esc_html_e('Model:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_vehicle_model" name="lead_vehicle_model" value="<?php echo esc_attr($lead_vehicle_model); ?>" placeholder="" disabled="disabled" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_vehicle_trim" class="control-label"><?php esc_html_e('Trim:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_vehicle_trim" name="lead_vehicle_trim" value="<?php echo esc_attr($lead_vehicle_trim); ?>" placeholder="" disabled="disabled" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_vehicle_vin" class="control-label"><?php esc_html_e('VIN:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_vehicle_vin" name="lead_vehicle_vin" value="<?php echo esc_attr($lead_vehicle_vin); ?>" placeholder="" disabled="disabled" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_vehicle_color" class="control-label"><?php esc_html_e('Color:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_vehicle_color" name="lead_vehicle_color" value="<?php echo esc_attr($lead_vehicle_color); ?>" placeholder="" disabled="disabled" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_vehicle_mileage" class="control-label"><?php esc_html_e('Mileage:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_vehicle_mileage" name="lead_vehicle_mileage" value="<?php echo esc_attr($lead_vehicle_mileage); ?>" placeholder="" disabled="disabled" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_vehicle_price" class="control-label"><?php esc_html_e('Price:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
						<input type="text" id="lead_vehicle_price" name="lead_vehicle_price" value="<?php echo esc_attr($lead_vehicle_price); ?>" placeholder="" disabled="disabled" />

					</div>

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Lead Information', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_status" class="control-label"><?php esc_html_e('Lead Status:', 'autoroyal' ); ?></label>
						
						<select name="lead_status" id="lead_status">

							<?php

								$terms_slug_str_cat = "";
								$terms_cat = get_the_terms($lead_id, 'lead_status' );
								if ($terms_cat && ! is_wp_error($terms_cat)) :
									$term_slugs_arr_cat = array();
										foreach ($terms_cat as $term_cat) {
											$term_slugs_arr_cat[] = $term_cat->slug;
										}
									$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
								endif;

								$categories = get_categories( array('taxonomy' => 'lead_status', 'hide_empty' => false,  'parent' => 0) );

								foreach ($categories as $category) {
									$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
									$option .= $category->cat_name;
									$option .= '</option>';

									$catID = $category->term_id;

									$categories_child = get_categories( array('taxonomy' => 'lead_status', 'hide_empty' => false,  'parent' => $catID) );

									foreach ($categories_child as $category_child) {
										$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
										$option .= $category_child->cat_name;
										$option .= '</option>';

									}

									echo $option;
								}

							?>
							
						</select>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_vehicle_price" class="control-label"><?php esc_html_e('Up Type:', 'autoroyal' ); ?></label>
						<select name="lead_up_type" id="lead_up_type">

							<?php

								$terms_slug_str_cat = "";
								$terms_cat = get_the_terms($lead_id, 'lead_up_type' );
								if ($terms_cat && ! is_wp_error($terms_cat)) :
									$term_slugs_arr_cat = array();
										foreach ($terms_cat as $term_cat) {
											$term_slugs_arr_cat[] = $term_cat->slug;
										}
									$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
								endif;

								$categories = get_categories( array('taxonomy' => 'lead_up_type', 'hide_empty' => false,  'parent' => 0) );

								foreach ($categories as $category) {
									$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
									$option .= $category->cat_name;
									$option .= '</option>';

									$catID = $category->term_id;

									$categories_child = get_categories( array('taxonomy' => 'lead_up_type', 'hide_empty' => false,  'parent' => $catID) );

									foreach ($categories_child as $category_child) {
										$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
										$option .= $category_child->cat_name;
										$option .= '</option>';

									}

									echo $option;
								}

							?>
							
						</select>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_vehicle_price" class="control-label"><?php esc_html_e('Advertising Source:', 'autoroyal' ); ?></label>
						<select name="lead_ad_source" id="lead_ad_source">

							<?php

								$terms_cat = get_the_terms($lead_id, 'lead_ad_source' );
								if ($terms_cat && ! is_wp_error($terms_cat)) :
									$term_slugs_arr_cat = array();
										foreach ($terms_cat as $term_cat) {
											$term_slugs_arr_cat[] = $term_cat->slug;
										}
									$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
								endif;

								$categories = get_categories( array('taxonomy' => 'lead_ad_source', 'hide_empty' => false,  'parent' => 0) );

								foreach ($categories as $category) {
									$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
									$option .= $category->cat_name;
									$option .= '</option>';

									$catID = $category->term_id;

									$categories_child = get_categories( array('taxonomy' => 'lead_ad_source', 'hide_empty' => false,  'parent' => $catID) );

									foreach ($categories_child as $category_child) {
										$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
										$option .= $category_child->cat_name;
										$option .= '</option>';

									}

									echo $option;
								}

							?>
							
						</select>

					</div>

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Set Appointment', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-md-6">

						<label for="lead_appointment_date" class="control-label"><?php esc_html_e('Select Date:', 'autoroyal' ); ?></label>

						<div class="autoroyal-input-has-icon">
							<input class="date_picker_future autoroyal-input-icon-left" type="text" id="lead_appointment_date" name="lead_appointment_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($lead_appointment_date); ?>" />
							<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
						</div>

					</div>

					<div class="col-md-6">

						<label for="lead_appointment_time" class="control-label"><?php esc_html_e('Select Time:', 'autoroyal' ); ?></label>

						<div class="autoroyal-input-has-icon">
							<input class="time_picker autoroyal-input-icon-left" type="text" id="lead_appointment_time" name="lead_appointment_time" placeholder="<?php esc_attr_e('Select Time', 'autoroyal' ); ?>" value="<?php echo esc_attr($lead_appointment_time); ?>" />
							<span class="fa fa-clock-o autoroyal-input-icon left" aria-hidden="true"></span>
						</div>

					</div>

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Customer Comments', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-md-12">

						<textarea cols="20" rows="7" class="input-text" name="lead_comments" placeholder=""><?php if(!empty($lead_comments)) { echo wp_kses( $lead_comments, true ); } ?></textarea>

					</div>

				</div>

			</fieldset>

		</div>

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Lead History & Notes', 'autoroyal' ); ?></h2>

			<fieldset>
					
				<div class="row">

					<?php if(!empty($lead_history)) { ?>

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Lead History', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-md-12">

						<table id="lead_history_table" class="table table-bordered table-hover table-striped" width="100%">
                            
                            <thead>
                                <tr>
                                    <!-- Phone View -->
                                    <th class=""><?php esc_html_e('Status', 'autoroyal' ); ?></th>
                                    <th class=""><?php esc_html_e('Date', 'autoroyal' ); ?></th>
                                </tr>
                            </thead>
                            
                            <tbody>

                            	<?php 

                            		if(!empty($lead_history)) {

                            			$reversed_lead_history = array_reverse($lead_history);

										foreach ($reversed_lead_history as $lead_history_item) {
											
											if( !empty($lead_history_item['status']) ) {

											?>
												
												<tr style="cursor: pointer;" id="rowTitle">
			                                        <td class=""><?php echo esc_attr($lead_history_item['status']); ?></td>
			                                        <td class=""><?php echo date(get_option('date_format'), $lead_history_item['date']); ?></td>
			                                    </tr>

											<?php

											}

										}

									}

                            	?>
                                    
                            </tbody>

                        </table>

					</div>

					<?php } ?>

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Lead Notes', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-md-12">

						<textarea cols="20" rows="7" class="input-text" name="lead_notes" placeholder=""><?php if(!empty($lead_notes)) { echo wp_kses( $lead_notes, true ); } ?></textarea>

					</div>

				</div>
				
			</fieldset>

		</div>

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Buyer Residence', 'autoroyal' ); ?></h2>

			<fieldset>
					
				<div class="row">

					<div class="col-md-12">

						<div class="btn-group" id="btnGroupResidence">
                            <button id="btn-current-buyer" data-target="lead_current_buyer_residence" class="btn btn btn-default active" type="button"><?php esc_html_e('Current', 'autoroyal' ); ?></button>
                            <button id="btn-previous-buyer" data-target="lead_previous_buyer_residence" class="btn btn btn-default" type="button"><?php esc_html_e('Previous', 'autoroyal' ); ?></button>
                            <button id="btn-previous2-buyer" data-target="lead_previous2_buyer_residence" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 2', 'autoroyal' ); ?></button>
                            <button id="btn-previous3-buyer" data-target="lead_previous3_buyer_residence" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 3', 'autoroyal' ); ?></button>
                            <button id="btn-previous4-buyer" data-target="lead_previous4_buyer_residence" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 4', 'autoroyal' ); ?></button>
                        </div>

					</div>

					<div class="col-md-12">

						<div id="lead_current_buyer_residence" class="lead_buyer_residences active">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time At Residence', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_current_residence_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_current_residence_years" id="lead_current_residence_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_current_residence_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_current_residence_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_current_residence_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_current_residence_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_current_residence_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_current_residence_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_current_residence_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_current_residence_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_current_residence_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_current_residence_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_current_residence_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_current_residence_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_current_residence_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_current_residence_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_current_residence_months" id="lead_current_residence_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_current_residence_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_current_residence_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_current_residence_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_current_residence_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_current_residence_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_current_residence_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_current_residence_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_current_residence_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_current_residence_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_current_residence_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_current_residence_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_current_residence_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_current_residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
									<select name="lead_current_residence_type" id="lead_current_residence_type" class="form-control input-lg">
										<option value=""></option>
										<option value="Rent" <?php selected( "Rent", $lead_current_residence_type ); ?>><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
										<option value="Own" <?php selected( "Own", $lead_current_residence_type ); ?>><?php esc_html_e('Own', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_current_residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_current_residence_price" name="lead_current_residence_price" value="<?php echo esc_attr($lead_current_residence_price); ?>" placeholder="" />

								</div>

							</div>

						</div>

						<div id="lead_previous_buyer_residence"  class="lead_buyer_residences">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Buyer has been at current Residence for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous_residence_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_residence_address_1" name="lead_previous_residence[address_1]" value="<?php if(!empty($lead_previous_residence['address_1'])) { echo esc_attr($lead_previous_residence['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_residence_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_residence_address_2" name="lead_previous_residence[address_2]" value="<?php if(!empty($lead_previous_residence['address_2'])) { echo esc_attr($lead_previous_residence['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_residence_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_residence_city" name="lead_previous_residence[city]" value="<?php if(!empty($lead_previous_residence['city'])) { echo esc_attr($lead_previous_residence['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_residence_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_residence_state" name="lead_previous_residence[state]" value="<?php if(!empty($lead_previous_residence['state'])) { echo esc_attr($lead_previous_residence['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_residence_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_residence_zip" name="lead_previous_residence[zip]" value="<?php if(!empty($lead_previous_residence['zip'])) { echo esc_attr($lead_previous_residence['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_residence_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_residence_phone" name="lead_previous_residence[phone]" value="<?php if(!empty($lead_previous_residence['phone'])) { echo esc_attr($lead_previous_residence['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time At Residence', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous_residence_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_previous_residence_years" id="lead_previous_residence_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous_residence_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous_residence_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous_residence_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous_residence_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous_residence_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous_residence_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous_residence_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous_residence_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous_residence_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous_residence_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous_residence_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous_residence_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_previous_residence_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous_residence_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_previous_residence_months" id="lead_previous_residence_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous_residence_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous_residence_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous_residence_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous_residence_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous_residence_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous_residence_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous_residence_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous_residence_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous_residence_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous_residence_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous_residence_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous_residence_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous_residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
									<select name="lead_previous_residence_type" id="lead_previous_residence_type" class="form-control input-lg">
										<option value=""></option>
										<option value="Rent" <?php selected( "Rent", $lead_previous_residence_type ); ?>><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
										<option value="Own" <?php selected( "Own", $lead_previous_residence_type ); ?>><?php esc_html_e('Own', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous_residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_previous_residence_price" name="lead_previous_residence_price" value="<?php echo esc_attr($lead_previous_residence_price); ?>" placeholder="" />

								</div>

							</div>

						</div>

						<div id="lead_previous2_buyer_residence"  class="lead_buyer_residences">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Buyer has been at current Residence for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_residence_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_residence_address_1" name="lead_previous2_residence[address_1]" value="<?php if(!empty($lead_previous2_residence['address_1'])) { echo esc_attr($lead_previous2_residence['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_residence_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_residence_address_2" name="lead_previous2_residence[address_2]" value="<?php if(!empty($lead_previous2_residence['address_2'])) { echo esc_attr($lead_previous2_residence['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_residence_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_residence_city" name="lead_previous2_residence[city]" value="<?php if(!empty($lead_previous2_residence['city'])) { echo esc_attr($lead_previous2_residence['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_residence_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_residence_state" name="lead_previous2_residence[state]" value="<?php if(!empty($lead_previous2_residence['state'])) { echo esc_attr($lead_previous2_residence['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_residence_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_residence_zip" name="lead_previous2_residence[zip]" value="<?php if(!empty($lead_previous2_residence['zip'])) { echo esc_attr($lead_previous2_residence['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_residence_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_residence_phone" name="lead_previous2_residence[phone]" value="<?php if(!empty($lead_previous2_residence['phone'])) { echo esc_attr($lead_previous2_residence['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time At Residence', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_residence_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_previous2_residence_years" id="lead_previous2_residence_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous2_residence_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous2_residence_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous2_residence_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous2_residence_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous2_residence_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous2_residence_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous2_residence_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous2_residence_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous2_residence_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous2_residence_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous2_residence_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous2_residence_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_previous2_residence_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_residence_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_previous2_residence_months" id="lead_previous2_residence_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous2_residence_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous2_residence_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous2_residence_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous2_residence_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous2_residence_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous2_residence_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous2_residence_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous2_residence_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous2_residence_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous2_residence_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous2_residence_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous2_residence_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
									<select name="lead_previous2_residence_type" id="lead_previous2_residence_type" class="form-control input-lg">
										<option value=""></option>
										<option value="Rent" <?php selected( "Rent", $lead_previous2_residence_type ); ?>><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
										<option value="Own" <?php selected( "Own", $lead_previous2_residence_type ); ?>><?php esc_html_e('Own', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_previous2_residence_price" name="lead_previous2_residence_price" value="<?php echo esc_attr($lead_previous2_residence_price); ?>" placeholder="" />

								</div>

							</div>

						</div>

						<div id="lead_previous3_buyer_residence"  class="lead_buyer_residences">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Buyer has been at current Residence for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_residence_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_residence_address_1" name="lead_previous3_residence[address_1]" value="<?php if(!empty($lead_previous3_residence['address_1'])) { echo esc_attr($lead_previous3_residence['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_residence_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_residence_address_2" name="lead_previous3_residence[address_2]" value="<?php if(!empty($lead_previous3_residence['address_2'])) { echo esc_attr($lead_previous3_residence['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_residence_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_residence_city" name="lead_previous3_residence[city]" value="<?php if(!empty($lead_previous3_residence['city'])) { echo esc_attr($lead_previous3_residence['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_residence_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_residence_state" name="lead_previous3_residence[state]" value="<?php if(!empty($lead_previous3_residence['state'])) { echo esc_attr($lead_previous3_residence['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_residence_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_residence_zip" name="lead_previous3_residence[zip]" value="<?php if(!empty($lead_previous3_residence['zip'])) { echo esc_attr($lead_previous3_residence['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_residence_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_residence_phone" name="lead_previous3_residence[phone]" value="<?php if(!empty($lead_previous3_residence['phone'])) { echo esc_attr($lead_previous3_residence['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time At Residence', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_residence_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_previous3_residence_years" id="lead_previous3_residence_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous3_residence_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous3_residence_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous3_residence_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous3_residence_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous3_residence_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous3_residence_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous3_residence_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous3_residence_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous3_residence_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous3_residence_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous3_residence_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous3_residence_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_previous3_residence_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_residence_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_previous3_residence_months" id="lead_previous3_residence_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous3_residence_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous3_residence_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous3_residence_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous3_residence_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous3_residence_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous3_residence_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous3_residence_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous3_residence_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous3_residence_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous3_residence_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous3_residence_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous3_residence_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
									<select name="lead_previous3_residence_type" id="lead_previous3_residence_type" class="form-control input-lg">
										<option value=""></option>
										<option value="Rent" <?php selected( "Rent", $lead_previous3_residence_type ); ?>><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
										<option value="Own" <?php selected( "Own", $lead_previous3_residence_type ); ?>><?php esc_html_e('Own', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_previous3_residence_price" name="lead_previous3_residence_price" value="<?php echo esc_attr($lead_previous3_residence_price); ?>" placeholder="" />

								</div>

							</div>

						</div>

						<div id="lead_previous4_buyer_residence"  class="lead_buyer_residences">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Buyer has been at current Residence for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_residence_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_residence_address_1" name="lead_previous4_residence[address_1]" value="<?php if(!empty($lead_previous4_residence['address_1'])) { echo esc_attr($lead_previous4_residence['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_residence_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_residence_address_2" name="lead_previous4_residence[address_2]" value="<?php if(!empty($lead_previous4_residence['address_2'])) { echo esc_attr($lead_previous4_residence['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_residence_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_residence_city" name="lead_previous4_residence[city]" value="<?php if(!empty($lead_previous4_residence['city'])) { echo esc_attr($lead_previous4_residence['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_residence_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_residence_state" name="lead_previous4_residence[state]" value="<?php if(!empty($lead_previous4_residence['state'])) { echo esc_attr($lead_previous4_residence['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_residence_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_residence_zip" name="lead_previous4_residence[zip]" value="<?php if(!empty($lead_previous4_residence['zip'])) { echo esc_attr($lead_previous4_residence['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_residence_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_residence_phone" name="lead_previous4_residence[phone]" value="<?php if(!empty($lead_previous4_residence['phone'])) { echo esc_attr($lead_previous4_residence['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time At Residence', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_residence_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_previous4_residence_years" id="lead_previous4_residence_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous4_residence_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous4_residence_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous4_residence_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous4_residence_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous4_residence_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous4_residence_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous4_residence_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous4_residence_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous4_residence_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous4_residence_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous4_residence_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous4_residence_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_previous4_residence_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_residence_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_previous4_residence_months" id="lead_previous4_residence_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous4_residence_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous4_residence_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous4_residence_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous4_residence_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous4_residence_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous4_residence_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous4_residence_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous4_residence_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous4_residence_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous4_residence_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous4_residence_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous4_residence_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
									<select name="lead_previous4_residence_type" id="lead_previous4_residence_type" class="form-control input-lg">
										<option value=""></option>
										<option value="Rent" <?php selected( "Rent", $lead_previous4_residence_type ); ?>><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
										<option value="Own" <?php selected( "Own", $lead_previous4_residence_type ); ?>><?php esc_html_e('Own', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_previous4_residence_price" name="lead_previous4_residence_price" value="<?php echo esc_attr($lead_previous4_residence_price); ?>" placeholder="" />

								</div>

							</div>

						</div>

					</div>

				</div>
				
			</fieldset>

		</div>

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Buyer Employer', 'autoroyal' ); ?></h2>

			<fieldset>
					
				<div class="row">

					<div class="col-md-12">

						<div class="btn-group" id="btnGroupEmployer">
                            <button id="btn-current-buyer-employer" data-target="lead_current_buyer_employer" class="btn btn btn-default active" type="button"><?php esc_html_e('Current', 'autoroyal' ); ?></button>
                            <button id="btn-previous-buyer-employer" data-target="lead_previous_buyer_employer" class="btn btn btn-default" type="button"><?php esc_html_e('Previous', 'autoroyal' ); ?></button>
                            <button id="btn-previous2-buyer-employer" data-target="lead_previous2_buyer_employer" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 2', 'autoroyal' ); ?></button>
                            <button id="btn-previous3-buyer-employer" data-target="lead_previous3_buyer_employer" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 3', 'autoroyal' ); ?></button>
                            <button id="btn-previous4-buyer-employer" data-target="lead_previous4_buyer_employer" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 4', 'autoroyal' ); ?></button>
                        </div>

					</div>

					<div class="col-md-12">

						<div id="lead_current_buyer_employer" class="lead_buyer_employers active">

							<div class="row">

								<div class="col-md-6">

									<label for="lead_current_employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_current_employer_name" name="lead_current_employer[name]" value="<?php if(!empty($lead_current_employer['name'])) { echo esc_attr($lead_current_employer['name']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_current_employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_current_employer_income" name="lead_current_employer[income]" value="<?php if(!empty($lead_current_employer['income'])) { echo esc_attr($lead_current_employer['income']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_current_employer_Ocupation" class="control-label"><?php esc_html_e('Ocupation:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_current_employer_Ocupation" name="lead_current_employer[ocupation]" value="<?php if(!empty($lead_current_employer['ocupation'])) { echo esc_attr($lead_current_employer['ocupation']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_current_employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_current_employer_address_1" name="lead_current_employer[address_1]" value="<?php if(!empty($lead_current_employer['address_1'])) { echo esc_attr($lead_current_employer['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_current_employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_current_employer_address_2" name="lead_current_employer[address_2]" value="<?php if(!empty($lead_current_employer['address_2'])) { echo esc_attr($lead_current_employer['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_current_employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_current_employer_city" name="lead_current_employer[city]" value="<?php if(!empty($lead_current_employer['city'])) { echo esc_attr($lead_current_employer['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_current_employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_current_employer_state" name="lead_current_employer[state]" value="<?php if(!empty($lead_current_employer['state'])) { echo esc_attr($lead_current_employer['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_current_employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_current_employer_zip" name="lead_current_employer[zip]" value="<?php if(!empty($lead_current_employer['zip'])) { echo esc_attr($lead_current_employer['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="lead_current_employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_current_employer_phone" name="lead_current_employer[phone]" value="<?php if(!empty($lead_current_employer['phone'])) { echo esc_attr($lead_current_employer['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time On Job', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_current_employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_current_employer_years" id="lead_current_employer_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_current_employer_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_current_employer_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_current_employer_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_current_employer_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_current_employer_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_current_employer_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_current_employer_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_current_employer_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_current_employer_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_current_employer_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_current_employer_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_current_employer_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_current_employer_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_current_employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_current_employer_months" id="lead_current_employer_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_current_employer_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_current_employer_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_current_employer_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_current_employer_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_current_employer_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_current_employer_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_current_employer_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_current_employer_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_current_employer_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_current_employer_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_current_employer_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_current_employer_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

							</div>

						</div>

						<div id="lead_previous_buyer_employer" class="lead_buyer_employers">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Buyer has been at current Employer for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous_employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_employer_name" name="lead_previous_employer[name]" value="<?php if(!empty($lead_previous_employer['name'])) { echo esc_attr($lead_previous_employer['name']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_previous_employer_income" name="lead_previous_employer[income]" value="<?php if(!empty($lead_previous_employer['income'])) { echo esc_attr($lead_previous_employer['income']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_employer_Ocupation" class="control-label"><?php esc_html_e('Ocupation:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_employer_Ocupation" name="lead_previous_employer[ocupation]" value="<?php if(!empty($lead_previous_employer['ocupation'])) { echo esc_attr($lead_previous_employer['ocupation']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_employer_address_1" name="lead_previous_employer[address_1]" value="<?php if(!empty($lead_previous_employer['address_1'])) { echo esc_attr($lead_previous_employer['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_employer_address_2" name="lead_previous_employer[address_2]" value="<?php if(!empty($lead_previous_employer['address_2'])) { echo esc_attr($lead_previous_employer['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_employer_city" name="lead_previous_employer[city]" value="<?php if(!empty($lead_previous_employer['city'])) { echo esc_attr($lead_previous_employer['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_employer_state" name="lead_previous_employer[state]" value="<?php if(!empty($lead_previous_employer['state'])) { echo esc_attr($lead_previous_employer['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous_employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_employer_zip" name="lead_previous_employer[zip]" value="<?php if(!empty($lead_previous_employer['zip'])) { echo esc_attr($lead_previous_employer['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="lead_previous_employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous_employer_phone" name="lead_previous_employer[phone]" value="<?php if(!empty($lead_previous_employer['phone'])) { echo esc_attr($lead_previous_employer['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time On Job', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous_employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_previous_employer_years" id="lead_previous_employer_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous_employer_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous_employer_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous_employer_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous_employer_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous_employer_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous_employer_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous_employer_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous_employer_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous_employer_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous_employer_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous_employer_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous_employer_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_previous_employer_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous_employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_previous_employer_months" id="lead_previous_employer_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous_employer_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous_employer_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous_employer_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous_employer_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous_employer_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous_employer_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous_employer_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous_employer_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous_employer_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous_employer_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous_employer_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous_employer_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

							</div>

						</div>

						<div id="lead_previous2_buyer_employer" class="lead_buyer_employers">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Buyer has been at current Employer for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_employer_name" name="lead_previous2_employer[name]" value="<?php if(!empty($lead_previous2_employer['name'])) { echo esc_attr($lead_previous2_employer['name']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_previous2_employer_income" name="lead_previous2_employer[income]" value="<?php if(!empty($lead_previous2_employer['income'])) { echo esc_attr($lead_previous2_employer['income']);}  ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_employer_Ocupation" class="control-label"><?php esc_html_e('Ocupation:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_employer_Ocupation" name="lead_previous2_employer[ocupation]" value="<?php if(!empty($lead_previous2_employer['ocupation'])) { echo esc_attr($lead_previous2_employer['ocupation']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_employer_address_1" name="lead_previous2_employer[address_1]" value="<?php if(!empty($lead_previous2_employer['address_1'])) { echo esc_attr($lead_previous2_employer['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_employer_address_2" name="lead_previous2_employer[address_2]" value="<?php if(!empty($lead_previous2_employer['address_2'])) { echo esc_attr($lead_previous2_employer['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_employer_city" name="lead_previous2_employer[city]" value="<?php if(!empty($lead_previous2_employer['city'])) { echo esc_attr($lead_previous2_employer['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_employer_state" name="lead_previous2_employer[state]" value="<?php if(!empty($lead_previous2_employer['state'])) { echo esc_attr($lead_previous2_employer['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_employer_zip" name="lead_previous2_employer[zip]" value="<?php if(!empty($lead_previous2_employer['zip'])) { echo esc_attr($lead_previous2_employer['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="lead_previous2_employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous2_employer_phone" name="lead_previous2_employer[phone]" value="<?php if(!empty($lead_previous2_employer['phone'])) { echo esc_attr($lead_previous2_employer['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time On Job', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_previous2_employer_years" id="lead_previous2_employer_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous2_employer_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous2_employer_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous2_employer_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous2_employer_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous2_employer_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous2_employer_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous2_employer_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous2_employer_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous2_employer_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous2_employer_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous2_employer_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous2_employer_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_previous2_employer_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous2_employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_previous2_employer_months" id="lead_previous2_employer_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous2_employer_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous2_employer_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous2_employer_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous2_employer_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous2_employer_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous2_employer_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous2_employer_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous2_employer_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous2_employer_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous2_employer_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous2_employer_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous2_employer_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

							</div>

						</div>

						<div id="lead_previous3_buyer_employer" class="lead_buyer_employers">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Buyer has been at current Employer for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_employer_name" name="lead_previous3_employer[name]" value="<?php if(!empty($lead_previous3_employer['name'])) { echo esc_attr($lead_previous3_employer['name']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_previous3_employer_income" name="lead_previous3_employer[income]" value="<?php if(!empty($lead_previous3_employer['income'])) { echo esc_attr($lead_previous3_employer['income']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_employer_Ocupation" class="control-label"><?php esc_html_e('Ocupation:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_employer_Ocupation" name="lead_previous3_employer[ocupation]" value="<?php if(!empty($lead_previous3_employer['ocupation'])) { echo esc_attr($lead_previous3_employer['ocupation']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_employer_address_1" name="lead_previous3_employer[address_1]" value="<?php if(!empty($lead_previous3_employer['address_1'])) { echo esc_attr($lead_previous3_employer['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_employer_address_2" name="lead_previous3_employer[address_2]" value="<?php if(!empty($lead_previous3_employer['address_2'])) { echo esc_attr($lead_previous3_employer['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_employer_city" name="lead_previous3_employer[city]" value="<?php if(!empty($lead_previous3_employer['city'])) { echo esc_attr($lead_previous3_employer['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_employer_state" name="lead_previous3_employer[state]" value="<?php if(!empty($lead_previous3_employer['state'])) { echo esc_attr($lead_previous3_employer['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_employer_zip" name="lead_previous3_employer[zip]" value="<?php if(!empty($lead_previous3_employer['zip'])) { echo esc_attr($lead_previous3_employer['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="lead_previous3_employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous3_employer_phone" name="lead_previous3_employer[phone]" value="<?php if(!empty($lead_previous3_employer['phone'])) { echo esc_attr($lead_previous3_employer['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time On Job', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_previous3_employer_years" id="lead_previous3_employer_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous3_employer_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous3_employer_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous3_employer_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous3_employer_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous3_employer_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous3_employer_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous3_employer_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous3_employer_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous3_employer_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous3_employer_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous3_employer_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous3_employer_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_previous3_employer_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous3_employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_previous3_employer_months" id="lead_previous3_employer_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous3_employer_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous3_employer_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous3_employer_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous3_employer_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous3_employer_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous3_employer_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous3_employer_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous3_employer_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous3_employer_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous3_employer_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous3_employer_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous3_employer_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

							</div>

						</div>

						<div id="lead_previous4_buyer_employer" class="lead_buyer_employers">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Buyer has been at current Employer for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_employer_name" name="lead_previous4_employer[name]" value="<?php if(!empty($lead_previous4_employer['name'])) { echo esc_attr($lead_previous4_employer['name']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_previous4_employer_income" name="lead_previous4_employer[income]" value="<?php if(!empty($lead_previous4_employer['income'])) { echo esc_attr($lead_previous4_employer['income']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_employer_Ocupation" class="control-label"><?php esc_html_e('Ocupation:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_employer_Ocupation" name="lead_previous4_employer[ocupation]" value="<?php if(!empty($lead_previous4_employer['ocupation'])) { echo esc_attr($lead_previous4_employer['ocupation']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_employer_address_1" name="lead_previous4_employer[address]" value="<?php if(!empty($lead_previous4_employer['address'])) { echo esc_attr($lead_previous4_employer['address']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_employer_address_2" name="lead_previous4_employer[address_2]" value="<?php if(!empty($lead_previous4_employer['address_2'])) { echo esc_attr($lead_previous4_employer['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_employer_city" name="lead_previous4_employer[city]" value="<?php if(!empty($lead_previous4_employer['city'])) { echo esc_attr($lead_previous4_employer['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_employer_state" name="lead_previous4_employer[state]" value="<?php if(!empty($lead_previous4_employer['state'])) { echo esc_attr($lead_previous4_employer['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_employer_zip" name="lead_previous4_employer[zip]" value="<?php if(!empty($lead_previous4_employer['zip'])) { echo esc_attr($lead_previous4_employer['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="lead_previous4_employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_previous4_employer_phone" name="lead_previous4_employer[phone]" value="<?php if(!empty($lead_previous4_employer['phone'])) { echo esc_attr($lead_previous4_employer['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time On Job', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_previous4_employer_years" id="lead_previous4_employer_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous4_employer_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous4_employer_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous4_employer_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous4_employer_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous4_employer_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous4_employer_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous4_employer_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous4_employer_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous4_employer_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous4_employer_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous4_employer_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous4_employer_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_previous4_employer_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_previous4_employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_previous4_employer_months" id="lead_previous4_employer_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_previous4_employer_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_previous4_employer_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_previous4_employer_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_previous4_employer_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_previous4_employer_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_previous4_employer_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_previous4_employer_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_previous4_employer_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_previous4_employer_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_previous4_employer_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_previous4_employer_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_previous4_employer_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

							</div>

						</div>

					</div>

				</div>
				
			</fieldset>

		</div>

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Co-Buyer', 'autoroyal' ); ?></h2>

			<fieldset>
					
				<div class="row">

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_first_name" class="control-label"><?php esc_html_e('First Name:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_cobuyer_first_name" name="lead_cobuyer_first_name" value="<?php echo esc_attr($lead_cobuyer_first_name); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_middle_name" class="control-label"><?php esc_html_e('Middle Name:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_cobuyer_middle_name" name="lead_cobuyer_middle_name" value="<?php echo esc_attr($lead_cobuyer_middle_name); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_last_name" class="control-label"><?php esc_html_e('Last Name:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_cobuyer_last_name" name="lead_cobuyer_last_name" value="<?php echo esc_attr($lead_cobuyer_last_name); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_home_phone" class="control-label"><?php esc_html_e('Home Phone:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_cobuyer_home_phone" name="lead_cobuyer_home_phone" value="<?php echo esc_attr($lead_cobuyer_home_phone); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_mobile_phone" class="control-label"><?php esc_html_e('Mobile Phone:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_cobuyer_mobile_phone" name="lead_cobuyer_mobile_phone" value="<?php echo esc_attr($lead_cobuyer_mobile_phone); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_work_phone" class="control-label"><?php esc_html_e('Work Phone:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_cobuyer_work_phone" name="lead_cobuyer_work_phone" value="<?php echo esc_attr($lead_cobuyer_work_phone); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_email" class="control-label"><?php esc_html_e('Email Address:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_cobuyer_email" name="lead_cobuyer_email" value="<?php echo esc_attr($lead_cobuyer_email); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_birth_date" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Date of Birth:', 'autoroyal' ); ?></label>

						<div class="autoroyal-input-has-icon">
							<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
								<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
							<?php } else { ?>
								<input class="date_picker_past autoroyal-input-icon-left" type="text" id="lead_cobuyer_birth_date" name="lead_cobuyer_birth_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($lead_cobuyer_birth_date); ?>" />
								<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
							<?php } ?>
						</div>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_social_security" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Social Security:', 'autoroyal' ); ?></label>
						<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
							<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
						<?php } else { ?>
							<input type="text" id="lead_cobuyer_social_security" name="lead_cobuyer_social_security" value="<?php echo esc_attr($lead_cobuyer_social_security); ?>" placeholder="" />
						<?php } ?>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_driver_license_state" class="control-label"><?php esc_html_e('Drivers License State:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_cobuyer_driver_license_state" name="lead_cobuyer_driver_license_state" value="<?php echo esc_attr($lead_cobuyer_driver_license_state); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_driver_license_number" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Drivers License Number:', 'autoroyal' ); ?></label>
						<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
							<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
						<?php } else { ?>
							<input type="text" id="lead_cobuyer_driver_license_number" name="lead_cobuyer_driver_license_number" value="<?php echo esc_attr($lead_cobuyer_driver_license_number); ?>" placeholder="" />
						<?php } ?>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_cobuyer_driver_license_exp" class="control-label"><?php esc_html_e('Drivers License Exp:', 'autoroyal' ); ?></label>

						<div class="autoroyal-input-has-icon">
							<input class="date_picker_future autoroyal-input-icon-left" type="text" id="lead_cobuyer_driver_license_exp" name="lead_cobuyer_driver_license_exp" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($lead_cobuyer_driver_license_exp); ?>" />
							<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
						</div>

					</div>

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Residence', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-md-12">

						<div class="btn-group" id="btnGroupCoBuyerResidence">
                            <button id="btn-current-buyer-cobuyer" data-target="lead_current_buyer_cobuyer_residence" class="btn btn btn-default active" type="button"><?php esc_html_e('Current', 'autoroyal' ); ?></button>
                            <button id="btn-previous-buyer-cobuyer" data-target="lead_previous_buyer_cobuyer_residence" class="btn btn btn-default" type="button"><?php esc_html_e('Previous', 'autoroyal' ); ?></button>
                            <button id="btn-previous2-buyer-cobuyer" data-target="lead_previous2_buyer_cobuyer_residence" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 2', 'autoroyal' ); ?></button>
                            <button id="btn-previous3-buyer-cobuyer" data-target="lead_previous3_buyer_cobuyer_residence" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 3', 'autoroyal' ); ?></button>
                            <button id="btn-previous4-buyer-cobuyer" data-target="lead_previous4_buyer_cobuyer_residence" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 4', 'autoroyal' ); ?></button>
                        </div>

					</div>

					<div class="col-md-12">

						<div id="lead_current_buyer_cobuyer_residence"  class="lead_cobuyer_buyer_residences active">

							<div class="row">

								<div class="col-md-6">

									<label for="lead_cobuyer_current_residence" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_residence_address_1" name="lead_cobuyer_current_residence[address_1]" value="<?php if(!empty($lead_cobuyer_current_residence['address_1'])) { echo esc_attr($lead_cobuyer_current_residence['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_residence_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_residence_address_2" name="lead_cobuyer_current_residence[address_2]" value="<?php if(!empty($lead_cobuyer_current_residence['address_2'])) { echo esc_attr($lead_cobuyer_current_residence['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_residence_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_residence_city" name="lead_cobuyer_current_residence[city]" value="<?php if(!empty($lead_cobuyer_current_residence['city'])) { echo esc_attr($lead_cobuyer_current_residence['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_residence_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_residence_state" name="lead_cobuyer_current_residence[state]" value="<?php if(!empty($lead_cobuyer_current_residence['state'])) { echo esc_attr($lead_cobuyer_current_residence['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_residence_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_residence_zip" name="lead_cobuyer_current_residence[zip]" value="<?php if(!empty($lead_cobuyer_current_residence['zip'])) { echo esc_attr($lead_cobuyer_current_residence['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_residence_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_residence_phone" name="lead_cobuyer_current_residence[phone]" value="<?php if(!empty($lead_cobuyer_current_residence['phone'])) { echo esc_attr($lead_cobuyer_current_residence['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time At Residence', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_residence_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_current_residence_years" id="lead_cobuyer_current_residence_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_cobuyer_current_residence_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_residence_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_current_residence_months" id="lead_cobuyer_current_residence_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_current_residence_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_current_residence_type" id="lead_cobuyer_current_residence_type" class="form-control input-lg">
										<option value=""></option>
										<option value="Rent" <?php selected( "Rent", $lead_cobuyer_current_residence_type ); ?>><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
										<option value="Own" <?php selected( "Own", $lead_cobuyer_current_residence_type ); ?>><?php esc_html_e('Own', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_cobuyer_current_residence_price" name="lead_cobuyer_current_residence_price" value="<?php echo esc_attr($lead_cobuyer_current_residence_price); ?>" placeholder="" />

								</div>

							</div>

						</div>

						<div id="lead_previous_buyer_cobuyer_residence"  class="lead_cobuyer_buyer_residences">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Co-Buyer has been at current Residence for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_residence_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_residence_address_1" name="lead_cobuyer_previous_residence[address_1]" value="<?php if(!empty($lead_cobuyer_previous_residence['address_1'])) { echo esc_attr($lead_cobuyer_previous_residence['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_residence_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_residence_address_2" name="lead_cobuyer_previous_residence[address_2]" value="<?php if(!empty($lead_cobuyer_previous_residence['address_2'])) { echo esc_attr($lead_cobuyer_previous_residence['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_residence_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_residence_city" name="lead_cobuyer_previous_residence[city]" value="<?php if(!empty($lead_cobuyer_previous_residence['city'])) { echo esc_attr($lead_cobuyer_previous_residence['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_residence_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_residence_state" name="lead_cobuyer_previous_residence[state]" value="<?php if(!empty($lead_cobuyer_previous_residence['state'])) { echo esc_attr($lead_cobuyer_previous_residence['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_residence_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_residence_zip" name="lead_cobuyer_previous_residence[zip]" value="<?php if(!empty($lead_cobuyer_previous_residence['zip'])) { echo esc_attr($lead_cobuyer_previous_residence['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_residence_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_residence_phone" name="lead_cobuyer_previous_residence[phone]" value="<?php if(!empty($lead_cobuyer_previous_residence['phone'])) { echo esc_attr($lead_cobuyer_previous_residence['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time At Residence', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_residence_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous_residence_years" id="lead_cobuyer_previous_residence_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_cobuyer_previous_residence_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_residence_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous_residence_months" id="lead_cobuyer_previous_residence_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous_residence_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous_residence_type" id="lead_cobuyer_previous_residence_type" class="form-control input-lg">
										<option value=""></option>
										<option value="Rent" <?php selected( "Rent", $lead_cobuyer_previous_residence_type ); ?>><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
										<option value="Own" <?php selected( "Own", $lead_cobuyer_previous_residence_type ); ?>><?php esc_html_e('Own', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_cobuyer_previous_residence_price" name="lead_cobuyer_previous_residence_price" value="<?php echo esc_attr($lead_cobuyer_previous_residence_price); ?>" placeholder="" />

								</div>

							</div>

						</div>

						<div id="lead_previous2_buyer_cobuyer_residence"  class="lead_cobuyer_buyer_residences">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Co-Buyer has been at current Residence for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_residence_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_residence_address_1" name="lead_cobuyer_previous2_residence[address_1]" value="<?php if(!empty($lead_cobuyer_previous2_residence['address_1'])) { echo esc_attr($lead_cobuyer_previous2_residence['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_residence_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_residence_address_2" name="lead_cobuyer_previous2_residence[address_2]" value="<?php if(!empty($lead_cobuyer_previous2_residence['address_2'])) { echo esc_attr($lead_cobuyer_previous2_residence['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_residence_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_residence_city" name="lead_cobuyer_previous2_residence[city]" value="<?php if(!empty($lead_cobuyer_previous2_residence['city'])) { echo esc_attr($lead_cobuyer_previous2_residence['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_residence_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_residence_state" name="lead_cobuyer_previous2_residence[state]" value="<?php if(!empty($lead_cobuyer_previous2_residence['state'])) { echo esc_attr($lead_cobuyer_previous2_residence['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_residence_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_residence_zip" name="lead_cobuyer_previous2_residence[zip]" value="<?php if(!empty($lead_cobuyer_previous2_residence['zip'])) { echo esc_attr($lead_cobuyer_previous2_residence['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_residence_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_residence_phone" name="lead_cobuyer_previous2_residence[phone]" value="<?php if(!empty($lead_cobuyer_previous2_residence['phone'])) { echo esc_attr($lead_cobuyer_previous2_residence['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time At Residence', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_residence_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous2_residence_years" id="lead_cobuyer_previous2_residence_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_cobuyer_previous2_residence_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_residence_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous2_residence_months" id="lead_cobuyer_previous2_residence_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous2_residence_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous2_residence_type" id="lead_cobuyer_previous2_residence_type" class="form-control input-lg">
										<option value=""></option>
										<option value="Rent" <?php selected( "Rent", $lead_cobuyer_previous2_residence_type ); ?>><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
										<option value="Own" <?php selected( "Own", $lead_cobuyer_previous2_residence_type ); ?>><?php esc_html_e('Own', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_cobuyer_previous2_residence_price" name="lead_cobuyer_previous2_residence_price" value="<?php echo esc_attr($lead_cobuyer_previous2_residence_price); ?>" placeholder="" />

								</div>

							</div>

						</div>

						<div id="lead_previous3_buyer_cobuyer_residence"  class="lead_cobuyer_buyer_residences">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Co-Buyer has been at current Residence for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_residence_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_residence_address_1" name="lead_cobuyer_previous3_residence[address_1]" value="<?php if(!empty($lead_cobuyer_previous3_residence['address_1'])) { echo esc_attr($lead_cobuyer_previous3_residence['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_residence_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_residence_address_2" name="lead_cobuyer_previous3_residence[address_2]" value="<?php if(!empty($lead_cobuyer_previous3_residence['address_2'])) { echo esc_attr($lead_cobuyer_previous3_residence['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_residence_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_residence_city" name="lead_cobuyer_previous3_residence[city]" value="<?php if(!empty($lead_cobuyer_previous3_residence['city'])) { echo esc_attr($lead_cobuyer_previous3_residence['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_residence_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_residence_state" name="lead_cobuyer_previous3_residence[state]" value="<?php if(!empty($lead_cobuyer_previous3_residence['state'])) { echo esc_attr($lead_cobuyer_previous3_residence['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_residence_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_residence_zip" name="lead_cobuyer_previous3_residence[zip]" value="<?php if(!empty($lead_cobuyer_previous3_residence['zip'])) { echo esc_attr($lead_cobuyer_previous3_residence['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_residence_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_residence_phone" name="lead_cobuyer_previous3_residence[phone]" value="<?php if(!empty($lead_cobuyer_previous3_residence['phone'])) { echo esc_attr($lead_cobuyer_previous3_residence['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time At Residence', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_residence_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous3_residence_years" id="lead_cobuyer_previous3_residence_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_cobuyer_previous3_residence_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_residence_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous3_residence_months" id="lead_cobuyer_previous3_residence_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous3_residence_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous3_residence_type" id="lead_cobuyer_previous3_residence_type" class="form-control input-lg">
										<option value=""></option>
										<option value="Rent" <?php selected( "Rent", $lead_cobuyer_previous3_residence_type ); ?>><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
										<option value="Own" <?php selected( "Own", $lead_cobuyer_previous3_residence_type ); ?>><?php esc_html_e('Own', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_cobuyer_previous3_residence_price" name="lead_cobuyer_previous3_residence_price" value="<?php echo esc_attr($lead_cobuyer_previous3_residence_price); ?>" placeholder="" />

								</div>

							</div>

						</div>

						<div id="lead_previous4_buyer_cobuyer_residence"  class="lead_cobuyer_buyer_residences">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Co-Buyer has been at current Residence for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_residence_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_residence_address_1" name="lead_cobuyer_previous4_residence[address_1]" value="<?php if(!empty($lead_cobuyer_previous4_residence['address_1'])) { echo esc_attr($lead_cobuyer_previous4_residence['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_residence_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_residence_address_2" name="lead_cobuyer_previous4_residence[address_2]" value="<?php if(!empty($lead_cobuyer_previous4_residence['address_2'])) { echo esc_attr($lead_cobuyer_previous4_residence['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_residence_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_residence_city" name="lead_cobuyer_previous4_residence[city]" value="<?php if(!empty($lead_cobuyer_previous4_residence['city'])) { echo esc_attr($lead_cobuyer_previous4_residence['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_residence_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_residence_state" name="lead_cobuyer_previous4_residence[state]" value="<?php if(!empty($lead_cobuyer_previous4_residence['state'])) { echo esc_attr($lead_cobuyer_previous4_residence['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_residence_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_residence_zip" name="lead_cobuyer_previous4_residence[zip]" value="<?php if(!empty($lead_cobuyer_previous4_residence['zip'])) { echo esc_attr($lead_cobuyer_previous4_residence['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_residence_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_residence_phone" name="lead_cobuyer_previous4_residence[phone]" value="<?php if(!empty($lead_cobuyer_previous4_residence['phone'])) { echo esc_attr($lead_cobuyer_previous4_residence['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time At Residence', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_residence_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous4_residence_years" id="lead_cobuyer_previous4_residence_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_cobuyer_previous4_residence_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_residence_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous4_residence_months" id="lead_cobuyer_previous4_residence_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous4_residence_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous4_residence_type" id="lead_cobuyer_previous4_residence_type" class="form-control input-lg">
										<option value=""></option>
										<option value="Rent" <?php selected( "Rent", $lead_cobuyer_previous4_residence_type ); ?>><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
										<option value="Own" <?php selected( "Own", $lead_cobuyer_previous4_residence_type ); ?>><?php esc_html_e('Own', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_cobuyer_previous4_residence_price" name="lead_cobuyer_previous4_residence_price" value="<?php echo esc_attr($lead_cobuyer_previous4_residence_price); ?>" placeholder="" />

								</div>

							</div>

						</div>

					</div>

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Employer', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-md-12">

						<div class="btn-group" id="btnGroupCoBuyerEmployer">
                            <button id="btn-current-cobuyer-employer" data-target="lead_cobuyer_current_buyer_employer" class="btn btn btn-default active" type="button"><?php esc_html_e('Current', 'autoroyal' ); ?></button>
                            <button id="btn-previous-cobuyer-employer" data-target="lead_cobuyer_previous_buyer_employer" class="btn btn btn-default" type="button"><?php esc_html_e('Previous', 'autoroyal' ); ?></button>
                            <button id="btn-previous2-cobuyer-employer" data-target="lead_cobuyer_previous2_buyer_employer" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 2', 'autoroyal' ); ?></button>
                            <button id="btn-previous3-cobuyer-employer" data-target="lead_cobuyer_previous3_buyer_employer" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 3', 'autoroyal' ); ?></button>
                            <button id="btn-previous4-cobuyer-employer" data-target="lead_cobuyer_previous4_buyer_employer" class="btn btn btn-default" type="button"><?php esc_html_e('Previous 4', 'autoroyal' ); ?></button>
                        </div>

					</div>

					<div class="col-md-12">

						<div id="lead_cobuyer_current_buyer_employer" class="lead_cobuyer_buyer_employers active">

							<div class="row">

								<div class="col-md-6">

									<label for="lead_cobuyer_current_employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_employer_name" name="lead_cobuyer_current_employer[name]" value="<?php if(!empty($lead_cobuyer_current_employer['name'])) { echo esc_attr($lead_cobuyer_current_employer['name']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_cobuyer_current_employer_income" name="lead_cobuyer_current_employer[income]" value="<?php if(!empty($lead_cobuyer_current_employer['income'])) { echo esc_attr($lead_cobuyer_current_employer['income']);}  ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_employer_Ocupation" class="control-label"><?php esc_html_e('Ocupation:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_employer_Ocupation" name="lead_cobuyer_current_employer[ocupation]" value="<?php if(!empty($lead_cobuyer_current_employer['ocupation'])) { echo esc_attr($lead_cobuyer_current_employer['ocupation']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_employer_address_1" name="lead_cobuyer_current_employer[address_1]" value="<?php if(!empty($lead_cobuyer_current_employer['address_1'])) { echo esc_attr($lead_cobuyer_current_employer['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_employer_address_2" name="lead_cobuyer_current_employer[address_2]" value="<?php if(!empty($lead_cobuyer_current_employer['address_2'])) { echo esc_attr($lead_cobuyer_current_employer['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_employer_city" name="lead_cobuyer_current_employer[city]" value="<?php if(!empty($lead_cobuyer_current_employer['city'])) { echo esc_attr($lead_cobuyer_current_employer['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_employer_state" name="lead_cobuyer_current_employer[state]" value="<?php if(!empty($lead_cobuyer_current_employer['state'])) { echo esc_attr($lead_cobuyer_current_employer['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_employer_zip" name="lead_cobuyer_current_employer[zip]" value="<?php if(!empty($lead_cobuyer_current_employer['zip'])) { echo esc_attr($lead_cobuyer_current_employer['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="lead_cobuyer_current_employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_current_employer_phone" name="lead_cobuyer_current_employer[phone]" value="<?php if(!empty($lead_cobuyer_current_employer['phone'])) { echo esc_attr($lead_cobuyer_current_employer['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time On Job', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_current_employer_years" id="lead_cobuyer_current_employer_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_cobuyer_current_employer_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_current_employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_current_employer_months" id="lead_cobuyer_current_employer_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_current_employer_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

							</div>

						</div>

						<div id="lead_cobuyer_previous_buyer_employer" class="lead_cobuyer_buyer_employers">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Co-Buyer has been at current Employer for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_employer_name" name="lead_cobuyer_previous_employer[name]" value="<?php if(!empty($lead_cobuyer_previous_employer['name'])) { echo esc_attr($lead_cobuyer_previous_employer['name']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_cobuyer_previous_employer_income" name="lead_cobuyer_previous_employer[income]" value="<?php if(!empty($lead_cobuyer_previous_employer['income'])) { echo esc_attr($lead_cobuyer_previous_employer['income']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_employer_Ocupation" class="control-label"><?php esc_html_e('Ocupation:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_employer_Ocupation" name="lead_cobuyer_previous_employer[ocupation]" value="<?php if(!empty($lead_cobuyer_previous_employer['ocupation'])) { echo esc_attr($lead_cobuyer_previous_employer['ocupation']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_employer_address_1" name="lead_cobuyer_previous_employer[address_1]" value="<?php if(!empty($lead_cobuyer_previous_employer['address_1'])) { echo esc_attr($lead_cobuyer_previous_employer['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_employer_address_2" name="lead_cobuyer_previous_employer[address_2]" value="<?php if(!empty($lead_cobuyer_previous_employer['address_2'])) { echo esc_attr($lead_cobuyer_previous_employer['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_employer_city" name="lead_cobuyer_previous_employer[city]" value="<?php if(!empty($lead_cobuyer_previous_employer['city'])) { echo esc_attr($lead_cobuyer_previous_employer['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_employer_state" name="lead_cobuyer_previous_employer[state]" value="<?php if(!empty($lead_cobuyer_previous_employer['state'])) { echo esc_attr($lead_cobuyer_previous_employer['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_employer_zip" name="lead_cobuyer_previous_employer[zip]" value="<?php if(!empty($lead_cobuyer_previous_employer['zip'])) { echo esc_attr($lead_cobuyer_previous_employer['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="lead_cobuyer_previous_employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous_employer_phone" name="lead_cobuyer_previous_employer[phone]" value="<?php if(!empty($lead_cobuyer_previous_employer['phone'])) { echo esc_attr($lead_cobuyer_previous_employer['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time On Job', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous_employer_years" id="lead_cobuyer_previous_employer_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_cobuyer_previous_employer_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous_employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous_employer_months" id="lead_cobuyer_previous_employer_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous_employer_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

							</div>

						</div>

						<div id="lead_cobuyer_previous2_buyer_employer" class="lead_cobuyer_buyer_employers">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Co-Buyer has been at current Employer for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_employer_name" name="lead_cobuyer_previous2_employer[name]" value="<?php if(!empty($lead_cobuyer_previous2_employer['name'])) { echo esc_attr($lead_cobuyer_previous2_employer['name']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_cobuyer_previous2_employer_income" name="lead_cobuyer_previous2_employer[income]" value="<?php if(!empty($lead_cobuyer_previous2_employer['income'])) { echo esc_attr($lead_cobuyer_previous2_employer['income']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_employer_Ocupation" class="control-label"><?php esc_html_e('Ocupation:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_employer_Ocupation" name="lead_cobuyer_previous2_employer[ocupation]" value="<?php if(!empty($lead_cobuyer_previous2_employer['ocupation'])) { echo esc_attr($lead_cobuyer_previous2_employer['ocupation']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_employer_address_1" name="lead_cobuyer_previous2_employer[address_1]" value="<?php if(!empty($lead_cobuyer_previous2_employer['address_1'])) { echo esc_attr($lead_cobuyer_previous2_employer['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_employer_address_2" name="lead_cobuyer_previous2_employer[address_2]" value="<?php if(!empty($lead_cobuyer_previous2_employer['address_2'])) { echo esc_attr($lead_cobuyer_previous2_employer['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_employer_city" name="lead_cobuyer_previous2_employer[city]" value="<?php if(!empty($lead_cobuyer_previous2_employer['city'])) { echo esc_attr($lead_cobuyer_previous2_employer['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_employer_state" name="lead_cobuyer_previous2_employer[state]" value="<?php if(!empty($lead_cobuyer_previous2_employer['state'])) { echo esc_attr($lead_cobuyer_previous2_employer['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_employer_zip" name="lead_cobuyer_previous2_employer[zip]" value="<?php if(!empty($lead_cobuyer_previous2_employer['zip'])) { echo esc_attr($lead_cobuyer_previous2_employer['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="lead_cobuyer_previous2_employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous2_employer_phone" name="lead_cobuyer_previous2_employer[phone]" value="<?php if(!empty($lead_cobuyer_previous2_employer['phone'])) { echo esc_attr($lead_cobuyer_previous2_employer['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time On Job', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous2_employer_years" id="lead_cobuyer_previous2_employer_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_cobuyer_previous2_employer_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous2_employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous2_employer_months" id="lead_cobuyer_previous2_employer_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous2_employer_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

							</div>

						</div>

						<div id="lead_cobuyer_previous3_buyer_employer" class="lead_cobuyer_buyer_employers">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Co-Buyer has been at current Employer for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_employer_name" name="lead_cobuyer_previous3_employer[name]" value="<?php if(!empty($lead_cobuyer_previous3_employer['name'])) { echo esc_attr($lead_cobuyer_previous3_employer['name']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_cobuyer_previous3_employer_income" name="lead_cobuyer_previous3_employer[income]" value="<?php if(!empty($lead_cobuyer_previous3_employer['income'])) { echo esc_attr($lead_cobuyer_previous3_employer['income']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_employer_Ocupation" class="control-label"><?php esc_html_e('Ocupation:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_employer_Ocupation" name="lead_cobuyer_previous3_employer[ocupation]" value="<?php if(!empty($lead_cobuyer_previous3_employer['ocupation'])) { echo esc_attr($lead_cobuyer_previous3_employer['ocupation']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_employer_address_1" name="lead_cobuyer_previous3_employer[address_1]" value="<?php if(!empty($lead_cobuyer_previous3_employer['address_1'])) { echo esc_attr($lead_cobuyer_previous3_employer['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_employer_address_2" name="lead_cobuyer_previous3_employer[address_2]" value="<?php if(!empty($lead_cobuyer_previous3_employer['address_2'])) { echo esc_attr($lead_cobuyer_previous3_employer['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_employer_city" name="lead_cobuyer_previous3_employer[city]" value="<?php if(!empty($lead_cobuyer_previous3_employer['city'])) { echo esc_attr($lead_cobuyer_previous3_employer['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_employer_state" name="lead_cobuyer_previous3_employer[state]" value="<?php if(!empty($lead_cobuyer_previous3_employer['state'])) { echo esc_attr($lead_cobuyer_previous3_employer['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_employer_zip" name="lead_cobuyer_previous3_employer[zip]" value="<?php if(!empty($lead_cobuyer_previous3_employer['zip'])) { echo esc_attr($lead_cobuyer_previous3_employer['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="lead_cobuyer_previous3_employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous3_employer_phone" name="lead_cobuyer_previous3_employer[phone]" value="<?php if(!empty($lead_cobuyer_previous3_employer['phone'])) { echo esc_attr($lead_cobuyer_previous3_employer['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time On Job', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous3_employer_years" id="lead_cobuyer_previous3_employer_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_cobuyer_previous3_employer_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous3_employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous3_employer_months" id="lead_cobuyer_previous3_employer_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous3_employer_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

							</div>

						</div>

						<div id="lead_cobuyer_previous4_buyer_employer" class="lead_cobuyer_buyer_employers">

							<div class="row">

								<div class="col-md-12">

									<h2 class="options_group_header"><span><i class="fa fa-info-circle"></i> <?php esc_html_e('Complete if Co-Buyer has been at current Employer for less than 2 years.', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_employer_name" name="lead_cobuyer_previous4_employer[name]" value="<?php if(!empty($lead_cobuyer_previous4_employer['name'])) { echo esc_attr($lead_cobuyer_previous4_employer['name']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="lead_cobuyer_previous4_employer_income" name="lead_cobuyer_previous4_employer[income]" value="<?php if(!empty($lead_cobuyer_previous4_employer['income'])) { echo esc_attr($lead_cobuyer_previous4_employer['income']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_employer_Ocupation" class="control-label"><?php esc_html_e('Ocupation:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_employer_Ocupation" name="lead_cobuyer_previous4_employer[ocupation]" value="<?php if(!empty($lead_cobuyer_previous4_employer['ocupation'])) { echo esc_attr($lead_cobuyer_previous4_employer['ocupation']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_employer_address_1" name="lead_cobuyer_previous4_employer[address_1]" value="<?php if(!empty($lead_cobuyer_previous4_employer['address_1'])) { echo esc_attr($lead_cobuyer_previous4_employer['address_1']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_employer_address_2" name="lead_cobuyer_previous4_employer[address_2]" value="<?php if(!empty($lead_cobuyer_previous4_employer['address_2'])) { echo esc_attr($lead_cobuyer_previous4_employer['address_2']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_employer_city" name="lead_cobuyer_previous4_employer[city]" value="<?php if(!empty($lead_cobuyer_previous4_employer['city'])) { echo esc_attr($lead_cobuyer_previous4_employer['city']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_employer_state" name="lead_cobuyer_previous4_employer[state]" value="<?php if(!empty($lead_cobuyer_previous4_employer['state'])) { echo esc_attr($lead_cobuyer_previous4_employer['state']); } ?>" placeholder="" />

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_employer_zip" name="lead_cobuyer_previous4_employer[zip]" value="<?php if(!empty($lead_cobuyer_previous4_employer['zip'])) { echo esc_attr($lead_cobuyer_previous4_employer['zip']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<label for="lead_cobuyer_previous4_employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
									<input type="text" id="lead_cobuyer_previous4_employer_phone" name="lead_cobuyer_previous4_employer[phone]" value="<?php if(!empty($lead_cobuyer_previous4_employer['phone'])) { echo esc_attr($lead_cobuyer_previous4_employer['phone']); } ?>" placeholder="" />

								</div>

								<div class="col-md-12">

									<h2 class="options_group_header"><span><?php esc_html_e('Time On Job', 'autoroyal' ); ?></span></h2>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous4_employer_years" id="lead_cobuyer_previous4_employer_years" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
										<option value="12" <?php selected( "12", $lead_cobuyer_previous4_employer_years ); ?>><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

									</select>

								</div>

								<div class="col-md-6">

									<label for="lead_cobuyer_previous4_employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
									<select name="lead_cobuyer_previous4_employer_months" id="lead_cobuyer_previous4_employer_months" class="form-control input-lg">
										<option value=""></option>
										<option value="0" <?php selected( "0", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
										<option value="1" <?php selected( "1", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
										<option value="2" <?php selected( "2", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
										<option value="3" <?php selected( "3", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
										<option value="4" <?php selected( "4", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
										<option value="5" <?php selected( "5", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
										<option value="6" <?php selected( "6", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
										<option value="7" <?php selected( "7", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
										<option value="8" <?php selected( "8", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
										<option value="9" <?php selected( "9", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
										<option value="10" <?php selected( "10", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
										<option value="11" <?php selected( "11", $lead_cobuyer_previous4_employer_months ); ?>><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

									</select>

								</div>

							</div>

						</div>

					</div>

				</div>
				
			</fieldset>

		</div>

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Trade-In', 'autoroyal' ); ?></h2>

			<input id="vehicle_year_init" type="hidden" name="vehicle_year_init" value="<?php echo esc_attr($lead_tradein_vehicle_year); ?>" />
			<input id="vehicle_make_init" type="hidden" name="vehicle_make_init" value="<?php echo esc_attr($lead_tradein_vehicle_make); ?>" />
			<input id="vehicle_model_init" type="hidden" name="vehicle_model_init" value="<?php echo esc_attr($lead_tradein_vehicle_model); ?>" />
			<input id="vehicle_trim_id_init" type="hidden" name="vehicle_trim_id_init" value="<?php echo esc_attr($lead_tradein_vehicle_trim_id); ?>" />
			<input id="vehicle_trim_desc_init" type="hidden" name="vehicle_trim_desc_init" value="<?php echo esc_attr($lead_tradein_vehicle_trim_desc_init); ?>" />
			<input id="vehicle_make_desc_init" type="hidden" name="vehicle_make_desc_init" value="<?php echo esc_attr($lead_tradein_vehicle_make_desc_init); ?>" />

			<fieldset class="select-car-model-table">

				<table id="select-car-model">

					<tbody>

						<tr valign="bottom">
							<th><?php esc_html_e('Make', 'autoroyal' ); ?></th>
							<th><?php esc_html_e('Model', 'autoroyal' ); ?></th>
							<th><?php esc_html_e('Year', 'autoroyal' ); ?></th>
							<th><?php esc_html_e('Trim', 'autoroyal' ); ?></th>
						</tr>

						<tr>

							<td>
								<select name="cq-make" id="cq-make" class="cq-make"></select>
							</td>

							<td>
								<select name="cq-model" id="cq-model" class="cq-model" <?php if(empty($lead_tradein_vehicle_model)) { ?>disabled<?php } ?>></select>
							</td>

							<td>
								<select name="cq-year" id="cq-year" class="cq-year" <?php if(empty($lead_tradein_vehicle_year)) { ?>disabled<?php } ?>></select>
							</td>

							<td>
								<select name="cq-trim" id="cq-trim" class="cq-trim" <?php if(empty($lead_tradein_vehicle_trim_id)) { ?>disabled<?php } ?>></select>
							</td>

						</tr>

					</tbody>

				</table>

			</fieldset>

			<fieldset>
				
				<div class="row">

					<div class="col-lg-4 col-md-6">

						<label for="lead_tradein_vehicle_vin" class="control-label"><?php esc_html_e('VIN:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_tradein_vehicle_vin" name="lead_tradein_vehicle_vin" value="<?php echo esc_attr($lead_tradein_vehicle_vin); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_tradein_vehicle_mileage" class="control-label"><?php esc_html_e('Mileage:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_tradein_vehicle_mileage" name="lead_tradein_vehicle_mileage" value="<?php echo esc_attr($lead_tradein_vehicle_mileage); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_tradein_vehicle_color" class="control-label"><?php esc_html_e('Color:', 'autoroyal' ); ?></label>
						<input type="text" class="lead_tradein_vehicle_color" name="lead_tradein_vehicle_color" value="<?php echo esc_attr($lead_tradein_vehicle_color); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_tradein_payoff" class="control-label"><?php esc_html_e('Trade Payoff:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
						<input type="text" id="lead_tradein_payoff" name="lead_tradein_payoff" value="<?php echo esc_attr($lead_tradein_payoff); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_tradein_payoff_good" class="control-label"><?php esc_html_e('Trade Payoff Good Thru:', 'autoroyal' ); ?></label>
						<div class="autoroyal-input-has-icon">
							<input class="date_picker_future autoroyal-input-icon-left" type="text" id="lead_tradein_payoff_good" name="lead_tradein_payoff_good" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($lead_tradein_payoff_good); ?>" />
							<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
						</div>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_tradein_lien_holder_name" class="control-label"><?php esc_html_e('Lien Holder Name:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_tradein_lien_holder_name" name="lead_tradein_lien_holder_name" value="<?php echo esc_attr($lead_tradein_lien_holder_name); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_tradein_lien_holder_addres_1" class="control-label"><?php esc_html_e('Lien Holder Address 1:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_tradein_lien_holder_addres_1" name="lead_tradein_lien_holder_addres_1" value="<?php echo esc_attr($lead_tradein_lien_holder_addres_1); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_tradein_lien_holder_addres_2" class="control-label"><?php esc_html_e('Lien Holder Address 2:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_tradein_lien_holder_addres_2" name="lead_tradein_lien_holder_addres_2" value="<?php echo esc_attr($lead_tradein_lien_holder_addres_2); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_tradein_lien_holder_city" class="control-label"><?php esc_html_e('Lien Holder City:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_tradein_lien_holder_city" name="lead_tradein_lien_holder_city" value="<?php echo esc_attr($lead_tradein_lien_holder_city); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_tradein_lien_holder_state" class="control-label"><?php esc_html_e('Lien Holder State:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_tradein_lien_holder_state" name="lead_tradein_lien_holder_state" value="<?php echo esc_attr($lead_tradein_lien_holder_state); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="lead_tradein_lien_holder_zip" class="control-label"><?php esc_html_e('Lien Holder Zip:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_tradein_lien_holder_zip" name="lead_tradein_lien_holder_zip" value="<?php echo esc_attr($lead_tradein_lien_holder_zip); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_tradein_lien_holder_phone" class="control-label"><?php esc_html_e('Lien Holder Phone:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_tradein_lien_holder_phone" name="lead_tradein_lien_holder_phone" value="<?php echo esc_attr($lead_tradein_lien_holder_phone); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_tradein_lien_holder_acc_number" class="control-label"><?php esc_html_e('Lien Holder Account Number:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_tradein_lien_holder_acc_number" name="lead_tradein_lien_holder_acc_number" value="<?php echo esc_attr($lead_tradein_lien_holder_acc_number); ?>" placeholder="" />

					</div>

				</div>
				
			</fieldset>

		</div>

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Banking & Financing', 'autoroyal' ); ?></h2>

			<fieldset>
					
				<div class="row">

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Checking Account', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-md-6">

						<label for="lead_bank_checking_account_number" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Account Number:', 'autoroyal' ); ?></label>
						<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
							<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
						<?php } else { ?>
							<input type="text" id="lead_bank_checking_account_number" name="lead_bank_checking_account_number" value="<?php echo esc_attr($lead_bank_checking_account_number); ?>" placeholder="" />
						<?php } ?>

					</div>

					<div class="col-md-6">

						<label for="lead_bank_checking_name" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Bank Name:', 'autoroyal' ); ?></label>
						<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
							<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
						<?php } else { ?>
							<input type="text" id="lead_bank_checking_name" name="lead_bank_checking_name" value="<?php echo esc_attr($lead_bank_checking_name); ?>" placeholder="" />
						<?php } ?>

					</div>

					<div class="col-md-6">

						<label for="lead_bank_checking_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_checking_address_1" name="lead_bank_checking_address_1" value="<?php echo esc_attr($lead_bank_checking_address_1); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_bank_checking_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_checking_address_2" name="lead_bank_checking_address_2" value="<?php echo esc_attr($lead_bank_checking_address_2); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_bank_checking_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_checking_city" name="lead_bank_checking_city" value="<?php echo esc_attr($lead_bank_checking_city); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_bank_checking_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_checking_state" name="lead_bank_checking_state" value="<?php echo esc_attr($lead_bank_checking_state); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_bank_checking_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_checking_zip" name="lead_bank_checking_zip" value="<?php echo esc_attr($lead_bank_checking_zip); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_bank_checking_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_checking_phone" name="lead_bank_checking_phone" value="<?php echo esc_attr($lead_bank_checking_phone); ?>" placeholder="" />

					</div>

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Savings Account', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-md-6">

						<label for="lead_bank_savings_account_number" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Account Number:', 'autoroyal' ); ?></label>
						<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
							<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
						<?php } else { ?>
							<input type="text" id="lead_bank_savings_account_number" name="lead_bank_savings_account_number" value="<?php echo esc_attr($lead_bank_savings_account_number); ?>" placeholder="" />
						<?php } ?>

					</div>

					<div class="col-md-6">

						<label for="lead_bank_savings_name" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Bank Name:', 'autoroyal' ); ?></label>
						<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
							<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
						<?php } else { ?>
							<input type="text" id="lead_bank_savings_name" name="lead_bank_savings_name" value="<?php echo esc_attr($lead_bank_savings_name); ?>" placeholder="" />
						<?php } ?>

					</div>

					<div class="col-md-6">

						<label for="lead_bank_savings_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_savings_address_1" name="lead_bank_savings_address_1" value="<?php echo esc_attr($lead_bank_savings_address_1); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_bank_savings_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_savings_address_2" name="lead_bank_savings_address_2" value="<?php echo esc_attr($lead_bank_savings_address_2); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_bank_savings_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_savings_city" name="lead_bank_savings_city" value="<?php echo esc_attr($lead_bank_savings_city); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_bank_savings_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_savings_state" name="lead_bank_savings_state" value="<?php echo esc_attr($lead_bank_savings_state); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_bank_savings_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_savings_zip" name="lead_bank_savings_zip" value="<?php echo esc_attr($lead_bank_savings_zip); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_bank_savings_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
						<input type="text" id="lead_bank_savings_phone" name="lead_bank_savings_phone" value="<?php echo esc_attr($lead_bank_savings_phone); ?>" placeholder="" />

					</div>

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Financing Information', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-md-6">

						<label for="lead_financing_preferred" class="control-label"><?php esc_html_e('Financing Preferred:', 'autoroyal' ); ?></label>
						<select name="lead_financing_preferred" id="lead_financing_preferred" class="form-control input-lg">
							<option value=""></option>
							<option value="Purchase" <?php selected( "Purchase", $lead_financing_preferred ); ?>><?php esc_html_e('Purchase', 'autoroyal' ); ?></option>
							<option value="Lease" <?php selected( "Lease", $lead_financing_preferred ); ?>><?php esc_html_e('Lease', 'autoroyal' ); ?></option>

						</select>

					</div>

					<div class="col-md-6">

						<label for="lead_financing_loan_term" class="control-label"><?php esc_html_e('Loan Term(Months):', 'autoroyal' ); ?></label>
						<input type="text" id="lead_financing_loan_term" name="lead_financing_loan_term" value="<?php echo esc_attr($lead_financing_loan_term); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_financing_amount_req" class="control-label"><?php esc_html_e('Amount Required:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
						<input type="text" id="lead_financing_amount_req" name="lead_financing_amount_req" value="<?php echo esc_attr($lead_financing_amount_req); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="lead_financing_downpayment" class="control-label"><?php esc_html_e('Downpayment:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
						<input type="text" id="lead_financing_downpayment" name="lead_financing_downpayment" value="<?php echo esc_attr($lead_financing_downpayment); ?>" placeholder="" />

					</div>

				</div>
				
			</fieldset>

			<fieldset class="autoroyal-last-fieldset">

				<div class="row">

					<div class="col-md-12">

						<input type="hidden" name="lead_id" value="<?php echo esc_attr($lead_id); ?>" />
						<input type="hidden" name="action_name" value="<?php if(!empty($_GET['action'])) { echo $_GET['action']; } ?>" />
											
						<input type="hidden" name="action" value="submitLeadFunction" />
						<?php wp_nonce_field( 'submitLeadFunction_html', 'submitLeadFunction_nonce' ); ?>

						<a id="autoroyal_submit_lead" href="#" class="btn btn-default"><?php esc_html_e( 'Save lead', 'autoroyal' ) ?></a>

						<a id="autoroyal_discard_lead" href="<?php echo esc_url(autoroyal_get_permalink( 'leads' )); ?>" class="btn btn-default"><?php esc_html_e( 'Cancel', 'autoroyal' ) ?></a>

						<?php 

							$action_url = add_query_arg( array( 'action' => 'delete', 'lead_id' => $lead_id ) );
							$action_url = wp_nonce_url( $action_url, 'autoroyal_lead_actions' ); 

						?>

						<a id="autoroyal_submit_lead" href="<?php echo esc_url( $action_url ); ?>" class="btn btn-default"><?php esc_html_e( 'Delete', 'autoroyal' ) ?></a>

					</div>

				</div>

			</fieldset>

		</div>

	</form>
	
</div>

<?php } ?>
