<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	$action = "";
	if ( isset( $_GET['action'] ) ) {
        $action = $_GET['action'];
    }

    if( empty($reservation_id) AND isset( $_GET['reservation_id']) ) {
    	$reservation_id = $_GET['reservation_id'];
    }

    if( $action == "edit" ) {

	    if ( ! autoroyal_user_can_edit_car( $reservation_id ) ) {

	    	echo "<div class='car-manager-error'>" . __( 'Invalid ID', 'autoroyal' ) . "</div>";

	    } else {

	    	autoroyal_load_submit_reservation_form( $reservation_id );

	    }

	} elseif( $action == "delete" ) {
		
	} else {

		autoroyal_load_submit_reservation_form( $reservation_id );

	}

?>

<?php function autoroyal_load_submit_reservation_form( $reservation_id ) { ?>

<div id="autoroyal-submit">
	
	<?php
	
		// Enqueue styles
		wp_enqueue_style( 'jquery-ui' );
		wp_enqueue_style( 'bootstrap-select' );

		// Enqueue scripts
		wp_enqueue_script( 'jquery-ui-autocomplete' );
		wp_enqueue_script( 'time-picker' );
		wp_enqueue_script( 'bootstrap-select' );

        $reservation_first_name = esc_attr(get_post_meta($reservation_id, 'reservation_first_name',true));
		
		// get the post meta data
		$rent_status = esc_attr(get_post_meta($reservation_id, 'rent_status',true));

		$pickup_location = esc_attr(get_post_meta($reservation_id, 'pickup_location',true));
		$pickup_date = esc_attr(get_post_meta($reservation_id, 'pickup_date',true));
		$pickup_time = esc_attr(get_post_meta($reservation_id, 'pickup_time',true));

		$return_location = esc_attr(get_post_meta($reservation_id, 'return_location',true));
		$return_date = esc_attr(get_post_meta($reservation_id, 'return_date',true));
		$return_time = esc_attr(get_post_meta($reservation_id, 'return_time',true));

		$rent_vehicle_id = esc_attr(get_post_meta($reservation_id, 'rent_vehicle_id',true));

		$extra_options = get_post_meta($reservation_id, 'extra_options',true);

		$number_of_days = get_post_meta($reservation_id, 'number_of_days',true);
		if(empty($number_of_days)) { $number_of_days = 1; }

		$price_per_day = get_post_meta($reservation_id, 'price_per_day',true);
		if(empty($price_per_day)) { $price_per_day = 0; }

		$total_price = get_post_meta($reservation_id, 'total_price',true);
		if(empty($total_price)) { $total_price = "0"; }

		$total_price_no_extras = get_post_meta($reservation_id, 'total_price_no_extras',true);
		if(empty($total_price_no_extras)) { $total_price_no_extras = "0"; }

		$rent_notes = get_post_meta($reservation_id, 'rent-notes',true);

		$vehicle_image_gallery = get_post_meta($rent_vehicle_id, 'vehicle_image_gallery',true);
	    $vehicle_image_extended_gallery = get_post_meta($rent_vehicle_id, 'vehicle_image_extended_gallery',true);
	    $vehicle_image_url = "";

	    if(!empty($vehicle_image_gallery[0]['url'])) {

	        $vehicle_image_url = $vehicle_image_gallery[0]['url'];

	    } elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

	        $vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

	    }

	    $vehicle_cover_image = get_post_meta($reservation_id, 'vehicle_cover_image',true);
	    if(!empty($vehicle_cover_image)) {
	        $vehicle_image_url = $vehicle_cover_image;
	    }

	    //
	    $terms_vehicle_doors = "";
	    $terms_vehicle_doors_name = "";
	    $vehicle_vehicle_doors = get_the_terms($rent_vehicle_id, 'vehicle_doors' );
	    if ($vehicle_vehicle_doors && ! is_wp_error($vehicle_vehicle_doors)) :
	        $terms_vehicle_doors = $vehicle_vehicle_doors[0]->term_id;
	        $terms_vehicle_doors_name = $vehicle_vehicle_doors[0]->name;
	    endif;

	    //
	    $terms_vehicle_seats = "";
	    $terms_vehicle_seats_name = "";
	    $vehicle_vehicle_seats = get_the_terms($rent_vehicle_id, 'vehicle_seats' );
	    if ($vehicle_vehicle_seats && ! is_wp_error($vehicle_vehicle_seats)) :
	        $terms_vehicle_seats = $vehicle_vehicle_seats[0]->term_id;
	        $terms_vehicle_seats_name = $vehicle_vehicle_seats[0]->name;
	    endif;

	    //
	    $terms_vehicle_rent_age = "";
	    $terms_vehicle_rent_age_name = "";
	    $vehicle_vehicle_rent_age = get_the_terms($rent_vehicle_id, 'vehicle_rent_age' );
	    if ($vehicle_vehicle_rent_age && ! is_wp_error($vehicle_vehicle_rent_age)) :
	        $terms_vehicle_rent_age = $vehicle_vehicle_rent_age[0]->term_id;
	        $terms_vehicle_rent_age_name = $vehicle_vehicle_rent_age[0]->name;
	    endif;

	    //
	    $terms_vehicle_luggages = "";
	    $terms_vehicle_luggages_name = "";
	    $vehicle_vehicle_luggages = get_the_terms($rent_vehicle_id, 'vehicle_luggages' );
	    if ($vehicle_vehicle_luggages && ! is_wp_error($vehicle_vehicle_luggages)) :
	        $terms_vehicle_luggages = $vehicle_vehicle_luggages[0]->term_id;
	        $terms_vehicle_luggages_name = $vehicle_vehicle_luggages[0]->name;
	    endif;

	    $terms_vehicle_transmission = "";
	    $terms_vehicle_transmission_id = "";
	    $vehicle_transmission = get_the_terms($rent_vehicle_id, 'vehicle_transmission' );
	    if ($vehicle_transmission && ! is_wp_error($vehicle_transmission)) :
	        $terms_vehicle_transmission = $vehicle_transmission[0]->name;
	        $terms_vehicle_transmission_id = $vehicle_transmission[0]->term_id;
	    endif;

	    $vehicle_navigation = get_post_meta($rent_vehicle_id, 'vehicle_navigation',true);
	    $vehicle_ac = get_post_meta($rent_vehicle_id, 'vehicle_ac',true);
	    $rent_deposit = get_post_meta($rent_vehicle_id, 'rent_deposit',true);
	    $mileage_limit = get_post_meta($rent_vehicle_id, 'mileage_limit',true);

	    $reserv_car_days = get_post_meta($reservation_id, 'reserv_car_days',true);
	    if(empty($reserv_car_days)) {
	    	$reserv_car_days = 3;
	    }

	    $customer_type = esc_attr(get_post_meta($reservation_id, 'customer_type',true));
		$existing_customer = esc_attr(get_post_meta($reservation_id, 'existing_customer',true));

		$rent_first_name = esc_attr(get_post_meta($reservation_id, 'rent_first_name',true));
		$rent_middle_name = esc_attr(get_post_meta($reservation_id, 'rent_middle_name',true));
		$rent_last_name = esc_attr(get_post_meta($reservation_id, 'rent_last_name',true));

		$rent_address_1 = esc_attr(get_post_meta($reservation_id, 'rent_address_1',true));
		$rent_address_2 = esc_attr(get_post_meta($reservation_id, 'rent_address_2',true));

		$rent_city = esc_attr(get_post_meta($reservation_id, 'rent_city',true));
		$rent_state = esc_attr(get_post_meta($reservation_id, 'rent_state',true));
		$rent_zip = esc_attr(get_post_meta($reservation_id, 'rent_zip',true));

		$rent_home_phone = esc_attr(get_post_meta($reservation_id, 'rent_home_phone',true));
		$rent_mobile_phone = esc_attr(get_post_meta($reservation_id, 'rent_mobile_phone',true));
		$rent_work_phone = esc_attr(get_post_meta($reservation_id, 'rent_work_phone',true));

		$rent_email = esc_attr(get_post_meta($reservation_id, 'rent_email',true));
		$rent_age = esc_attr(get_post_meta($reservation_id, 'rent_age',true));
		$rent_birth_date = esc_attr(get_post_meta($reservation_id, 'rent_birth_date',true));
		$rent_social_security = esc_attr(get_post_meta($reservation_id, 'rent_social_security',true));

		$rent_driver_license_state = esc_attr(get_post_meta($reservation_id, 'rent_driver_license_state',true));
		$rent_driver_license_number = esc_attr(get_post_meta($reservation_id, 'rent_driver_license_number',true));
		$rent_driver_license_exp = esc_attr(get_post_meta($reservation_id, 'rent_driver_license_exp',true));

		$currency_pos = get_option( 'autoroyal_currency_position' );

	?>

	<form action="<?php echo get_permalink(); ?>?action=edit&reservation_id=<?php echo esc_attr($reservation_id); ?>" method="post" id="submit-reservation-autoroyal-form" class="autoroyal-form" enctype="multipart/form-data">

		<div class='options_group'>

			<fieldset>

				<div class="row">

					<div class="col-lg-4 col-md-6">

						<label for="rent_status" class="control-label"><?php esc_html_e('Rent Status', 'autoroyal' ); ?></label>
						<select id="rent_status" name="rent_status">
	                      	<option value="New" <?php selected( $rent_status, "New" ); ?>><?php esc_html_e('New', 'autoroyal'); ?></option>
	                      	<option value="Confirmed" <?php selected( $rent_status, "Confirmed" ); ?>><?php esc_html_e('Confirmed', 'autoroyal'); ?></option>
	                      	<option value="Picked Up" <?php selected( $rent_status, "Picked Up" ); ?>><?php esc_html_e('Picked Up', 'autoroyal'); ?></option>
	                      	<option value="Returned" <?php selected( $rent_status, "Returned" ); ?>><?php esc_html_e('Returned', 'autoroyal'); ?></option>
						</select>

					</div>

				</div>
				
				<div class="row">

					<div class="col-lg-4 col-md-6">

						<label for="pickup_location" class="control-label"><?php esc_html_e('Pickup Location:', 'autoroyal' ); ?></label>
						<select id="pickup_location" name="pickup_location">
	                      	<option value="-"><?php esc_html_e('Select location', 'autoroyal'); ?></option>
	                      	<?php

	                      		$categories = get_categories( array('taxonomy' => 'vehicle_rent_pickup', 'hide_empty' => false,  'parent' => 0) );
								foreach ($categories as $category) {

							?>
							<option value="<?php echo esc_attr($category->cat_name); ?>" <?php selected( $pickup_location, $category->cat_name ); ?>><?php echo esc_attr($category->cat_name); ?></option>
							<?php } ?>
						</select>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="pickup_date" class="control-label"><?php esc_html_e('Pickup date:', 'autoroyal' ); ?></label>
						
						<div class="autoroyal-input-has-icon">
							<input class="date_picker_future autoroyal-input-icon-left" type="text" id="pickup_date" name="pickup_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($pickup_date); ?>" />
							<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
						</div>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="pickup_time" class="control-label"><?php esc_html_e('Pickup time:', 'autoroyal' ); ?></label>

						<div class="autoroyal-input-has-icon">
							<input class="time_picker autoroyal-input-icon-left" type="text" id="pickup_time" name="pickup_time" placeholder="<?php esc_attr_e('Select Time', 'autoroyal' ); ?>" value="<?php echo esc_attr($pickup_time); ?>" />
							<span class="fa fa-clock-o autoroyal-input-icon left" aria-hidden="true"></span>
						</div>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="return_location" class="control-label"><?php esc_html_e('Return Location:', 'autoroyal' ); ?></label>
						<select id="return_location" name="return_location">
	                      	<option value="-"><?php esc_html_e('Select location', 'autoroyal'); ?></option>
	                      	<?php

	                      		$categories = get_categories( array('taxonomy' => 'vehicle_rent_pickup', 'hide_empty' => false,  'parent' => 0) );
								foreach ($categories as $category) {

							?>
							<option value="<?php echo esc_attr($category->cat_name); ?>" <?php selected( $return_location, $category->cat_name ); ?>><?php echo esc_attr($category->cat_name); ?></option>
							<?php } ?>
						</select>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="return_date" class="control-label"><?php esc_html_e('Return date:', 'autoroyal' ); ?></label>
						
						<div class="autoroyal-input-has-icon">
							<input class="date_picker_future autoroyal-input-icon-left" type="text" id="return_date" name="return_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($return_date); ?>" />
							<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
						</div>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="return_time" class="control-label"><?php esc_html_e('Return time:', 'autoroyal' ); ?></label>

						<div class="autoroyal-input-has-icon">
							<input class="time_picker autoroyal-input-icon-left" type="text" id="return_time" name="return_time" placeholder="<?php esc_attr_e('Select Time', 'autoroyal' ); ?>" value="<?php echo esc_attr($return_time); ?>" />
							<span class="fa fa-clock-o autoroyal-input-icon left" aria-hidden="true"></span>
						</div>

					</div>

					<div class="col-md-12">

						<label for="rent_vehicle_id" class="control-label"><?php esc_html_e('Select Vehicle', 'autoroyal' ); ?></label>
						<input type="hidden" id="reserv-car-id" name="reserv-car-id" value="<?php echo esc_attr($rent_vehicle_id); ?>">
						<input type="hidden" id="reserv-car-id-2" name="reserv-car-id-2" value="<?php echo esc_attr($rent_vehicle_id); ?>">

						<select class="" name="rent_vehicle_id" id="rent_vehicle_id" >

							<?php 

								$search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
									'post_type'           => 'vehicle',
									'post_status'         => 'publish',
									'posts_per_page'      => -1,
									'orderby'             => 'date',
									'order'               => 'desc',
									'meta_key'            => 'vehicle_for_rent',
								) );
								$cars_query = new WP_Query;
								$cars = $cars_query->query( $search_args );
								$current = 0;

								if ( $cars ) : 

									foreach ( $cars as $car ) :

										$car_ID = $car->ID; 
										$current++;

										$vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
										$vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
										$vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
										$vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
										$vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
										$vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
										$vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

										$vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
										if(!empty($vehicle_exterior_color)) {
											$color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
											$color_id   = $vehicle_exterior_color[0]->term_id;
											$color_name = $vehicle_exterior_color[0]->name;
										} else {
											$color_name = "";
										}

							?>
								<option value="<?php echo esc_attr($current); ?>" data-id="<?php echo esc_attr($car_ID); ?>" <?php selected( $car_ID, $rent_vehicle_id ); ?>><?php echo esc_attr($vehicle_year); ?> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?> <?php echo esc_attr($vehicle_trim_desc_init); ?><?php if( $rent_vehicle_id == $car_ID ) { echo " - Selected by customer"; } ?></option>
							<?php 

									endforeach; 

								endif;

								$autoroyal_currency = get_option( 'autoroyal_currency' ); 
						    	$currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency );

							?>
							
						</select>

					</div>
					
					<div class="col-md-12">

						<div id="car-rent-details"></div>

					</div>

					<div class="col-lg-4 col-md-6">

						<h2 class="options_group_header"><span><?php esc_html_e('Price Sets', 'autoroyal' ); ?></span></h2>
						
						<ul id="rent-price-table" class="list-unstyled"></ul>

					</div>

					<div class="col-lg-4 col-md-6">

						<h2 class="options_group_header"><span><?php esc_html_e('Extras', 'autoroyal' ); ?></span></h2>

						<?php $rent_extra_options = get_categories( array('taxonomy' => 'rent_extra_options', 'hide_empty' => false,  'parent' => 0, 'orderby' => 'id', 'order' => 'ASC') ); ?>

			  			<input type="hidden" id="extras-currency-symbol" value="<?php if(!empty($autoroyal_currency)) { echo esc_attr($currency_symbol); } ?>">

		  				<?php

		  					foreach ($rent_extra_options as $rent_extra_option) {

		  						$extra_options_type   = get_term_meta( $rent_extra_option->term_id, 'extra_options_type', true );
							    $extra_options_price   = get_term_meta( $rent_extra_option->term_id, 'extra_options_price', true );
							    $extra_options_selection_type   = get_term_meta( $rent_extra_option->term_id, 'extra_options_selection_type', true );

							    if( isset($extra_options[$rent_extra_option->term_id]['checkbox']) ) {
							    	$this_checkbox = "on";
							    } else {
							    	$this_checkbox = "off";
							    }

							    if( isset($extra_options[$rent_extra_option->term_id]['multiselect']) ) {
							    	$this_multiselect = $extra_options[$rent_extra_option->term_id]['multiselect'];
							    } else {
							    	$this_multiselect = "";
							    }

						?>

	                  	<div id="extra-option-<?php echo esc_attr($rent_extra_option->term_id); ?>" class="form-group extra-option-group">

		                    <label class="extra-option-label"><?php echo esc_attr($rent_extra_option->cat_name); ?></label>
							
							<div class="custom-control custom-checkbox my-1 mr-sm-2">
						    	<input name="extra_options[<?php echo esc_attr($rent_extra_option->term_id); ?>][checkbox]" type="checkbox" class="custom-control-input" id="customControlInline_<?php echo esc_attr($rent_extra_option->term_id); ?>" data-price="<?php echo esc_attr($extra_options_price); ?>" data-id="<?php echo esc_attr($rent_extra_option->term_id); ?>" data-type="<?php echo esc_attr($extra_options_type); ?>" data-select-type="<?php echo esc_attr($extra_options_selection_type); ?>" data-name="<?php echo esc_attr($rent_extra_option->cat_name); ?>" <?php if( $this_checkbox == "on" ) { echo "checked"; } ?> >
							    <label class="custom-control-label" for="customControlInline_<?php echo esc_attr($rent_extra_option->term_id); ?>"><?php if(!empty($autoroyal_currency)) { echo esc_attr($currency_symbol); } ?><?php echo esc_attr($extra_options_price); ?></label>
						  	</div>

						  	<span class="extra_option_type"><?php if($extra_options_type == "one_time") { echo "One Time"; } else { echo "Per Day"; } ?> <?php if( $extra_options_selection_type == "multiple" ) { echo "& Per Unit"; }?></span>

		                    <?php if( $extra_options_selection_type == "multiple" ) { ?>

		                    <select name="extra_options[<?php echo esc_attr($rent_extra_option->term_id); ?>][multiselect]" class="extra-options-multiple-selections" data-id="<?php echo esc_attr($rent_extra_option->term_id); ?>" >
		                      	<option value="0" <?php if( $this_multiselect == "0" ) { echo "selected"; } ?>>0</option>
		                      	<option value="1" <?php if( $this_multiselect == "1" ) { echo "selected"; } ?>>1</option>
		                      	<option value="2" <?php if( $this_multiselect == "2" ) { echo "selected"; } ?>>2</option>
		                      	<option value="3" <?php if( $this_multiselect == "3" ) { echo "selected"; } ?>>3</option>
	                    	</select>

		                    <?php } ?>

	                  	</div>

						<?php } ?>

					</div>

					<div id="rent_extra_options" class="col-lg-4 col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Total Price', 'autoroyal' ); ?></span></h2>

						<ul class="list-unstyled result-dates">
		                    <li class="clearfix">
		                      	<span class="pull-left"><?php esc_html_e('Number of days:', 'autoroyal' ); ?></span>
		                      	<span class="pull-right"><b id="daysN"><span><?php echo esc_attr($reserv_car_days); ?></span> <?php esc_html_e('days', 'autoroyal' ); ?></b></span>
		                      	<input type="hidden" id="reserv_car_days" name="reserv_car_days" value="<?php echo esc_attr($reserv_car_days); ?>">
		                      	<input type="hidden" id="reserv-car-days" name="reserv-car-days" value="<?php echo esc_attr($reserv_car_days); ?>">
		                    </li>
		                    <li class="clearfix">
		                      	<span class="pull-left"><?php esc_html_e('Price per day:', 'autoroyal' ); ?></span>
		                      	<span class="pull-right">
		                        	<b id="dayP"><?php if( $currency_pos == "left" OR $currency_pos == "left_space" ) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } } ?><?php if( $currency_pos == "left_space" ) { ?> <?php } ?><span><?php echo esc_attr($price_per_day); ?></span><?php if( $currency_pos == "right_space" ) { ?> <?php } ?><?php if( $currency_pos == "right" OR $currency_pos == "right_space" ) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } } ?></b>
		                      	</span>
		                      	<input type="hidden" id="reserv-car-price-day" name="reserv-car-price-day" value="0">
		                    </li>

		                    <?php

			  					foreach ($rent_extra_options as $rent_extra_option) {

			  						$extra_options_type   = get_term_meta( $rent_extra_option->term_id, 'extra_options_type', true );
								    $extra_options_price   = get_term_meta( $rent_extra_option->term_id, 'extra_options_price', true );
								    $extra_options_selection_type   = get_term_meta( $rent_extra_option->term_id, 'extra_options_selection_type', true );

								    if( isset($extra_options[$rent_extra_option->term_id]['multiselect']) ) {
								    	$this_multiselect = $extra_options[$rent_extra_option->term_id]['multiselect'];
								    } else {
								    	$this_multiselect = "";
								    }

								    $total_extras_price = "0";

								    if( $extra_options_selection_type == "multiple" AND !empty($this_multiselect) ) {
								    	$total_extras_price = $extra_options_price * $this_multiselect;
								    } else {
								    	$total_extras_price = $extra_options_price;
								    }

								    if($extra_options_type == "per_day") {
								    	$total_extras_price = $total_extras_price * $reserv_car_days;
								    }

								    if( isset($extra_options[$rent_extra_option->term_id]['checkbox']) ) {

							?>
							<li id="extra-option-val-<?php echo esc_attr($rent_extra_option->term_id); ?>" class="extra-option-val clearfix" data-id="<?php echo esc_attr($rent_extra_option->term_id); ?>">
								<span class="pull-left"><?php echo esc_attr($rent_extra_option->cat_name); ?></span>
								<span class="pull-right"><b class="extraP"><?php if( $currency_pos == "left" OR $currency_pos == "left_space" ) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } } ?><?php if( $currency_pos == "left_space" ) { ?> <?php } ?><span><?php echo esc_attr($total_extras_price); ?></span><?php echo esc_attr($total_price); ?></span><?php if( $currency_pos == "right_space" ) { ?> <?php } ?><?php if( $currency_pos == "right" OR $currency_pos == "right_space" ) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } } ?></b></span>
							</li>
							<?php } } ?>
		                    <li class="clearfix reservation-total">
		                      	<span class="pull-left"><?php esc_html_e('Total:', 'autoroyal' ); ?></span>
		                      	<span class="pull-right">
		                        	<b class="totDayP"><?php if( $currency_pos == "left" OR $currency_pos == "left_space" ) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } } ?><?php if( $currency_pos == "left_space" ) { ?> <?php } ?><span><?php echo esc_attr($total_price); ?></span><?php if( $currency_pos == "right_space" ) { ?> <?php } ?><?php if( $currency_pos == "right" OR $currency_pos == "right_space" ) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } } ?></b>
		                      	</span>
		                      	<input type="hidden" id="reserv-car-price-total" name="reserv-car-price-total" value="<?php echo esc_attr($total_price); ?>">
		                      	<input type="hidden" id="reserv-car-price-without-extras" name="reserv-car-price-without-extras" value="<?php echo esc_attr($total_price_no_extras); ?>">
		                      	<input type="hidden" id="reserv-car-price-extras" name="reserv-car-price-extras" value="0">
		                    </li>
	                  	</ul>

					</div>

					<div class="col-md-12">

						<h2 class="options_group_header"><span><?php esc_html_e('Additional notes and comments', 'autoroyal' ); ?></span></h2>

						<textarea class="form-control" cols="30" rows="7" id="rent-notes" name="rent-notes" placeholder=""><?php echo wp_kses($rent_notes, true); ?></textarea>

					</div>

				</div>
				
			</fieldset>

			<br>

		</div>	<!-- end review_options_pop -->

		<div class='options_group'>

			<fieldset>
				
				<div class="row">

					<div class="col-md-6">

						<label for="customer_type" class="control-label"><?php esc_html_e('Customer Type:', 'autoroyal' ); ?></label>
						<select name="customer_type" id="customer_type" class="form-control input-lg">
							<option value="New Customer" <?php selected( "New Customer", $customer_type ); ?>><?php esc_html_e('New Customer', 'autoroyal' ); ?></option>
							<option value="Existing Customer" <?php selected( "Existing Customer", $customer_type ); ?>><?php esc_html_e('Existing Customer', 'autoroyal' ); ?></option>
						</select>

					</div>

					<div class="col-md-6">

						<div id="existing_customer_container" <?php if($customer_type == "Existing Customer") { ?>style="display: block;"<?php } ?> >

							<label for="existing_customer" class="control-label"><?php esc_html_e('Existing Customer', 'autoroyal' ); ?></label>
							<select class="chosen-select" name="existing_customer" id="existing_customer">

								<option value="none" <?php selected( "Existing Customer", $customer_type ); ?>><?php esc_html_e('Select Customer', 'autoroyal' ); ?></option>

								<?php 

									$search_args = apply_filters( 'autoroyal_get_leads_args', array(
										'post_type'           => 'lead',
										'post_status'         => 'publish',
										'posts_per_page'      => -1,
										'orderby'             => 'date',
										'order'               => 'desc'
									) );
									$lead_query = new WP_Query;
									$leads = $lead_query->query( $search_args );

									if ( $leads ) : 

										foreach ( $leads as $lead ) :

											$lead_ID = $lead->ID; 

											$lead_first_name = esc_attr(get_post_meta($lead_ID, 'lead_first_name',true));
											$lead_middle_name = esc_attr(get_post_meta($lead_ID, 'lead_middle_name',true));
											$lead_last_name = esc_attr(get_post_meta($lead_ID, 'lead_last_name',true));

											$lead_address_1 = esc_attr(get_post_meta($lead_ID, 'lead_address_1',true));
											$lead_address_2 = esc_attr(get_post_meta($lead_ID, 'lead_address_2',true));

											$lead_city = esc_attr(get_post_meta($lead_ID, 'lead_city',true));
											$lead_state = esc_attr(get_post_meta($lead_ID, 'lead_state',true));
											$lead_zip = esc_attr(get_post_meta($lead_ID, 'lead_zip',true));

											$lead_home_phone = esc_attr(get_post_meta($lead_ID, 'lead_home_phone',true));
											$lead_mobile_phone = esc_attr(get_post_meta($lead_ID, 'lead_mobile_phone',true));
											$lead_work_phone = esc_attr(get_post_meta($lead_ID, 'lead_work_phone',true));

											$lead_email = esc_attr(get_post_meta($lead_ID, 'lead_email',true));
											$lead_birth_date = esc_attr(get_post_meta($lead_ID, 'lead_birth_date',true));
											$lead_social_security = esc_attr(get_post_meta($lead_ID, 'lead_social_security',true));

											$lead_driver_license_state = esc_attr(get_post_meta($lead_ID, 'lead_driver_license_state',true));
											$lead_driver_license_number = esc_attr(get_post_meta($lead_ID, 'lead_driver_license_number',true));
											$lead_driver_license_exp = esc_attr(get_post_meta($lead_ID, 'lead_driver_license_exp',true));

								?>
									<option 

										data-first-name="<?php echo esc_attr($lead_first_name); ?>"
										data-middle-name="<?php echo esc_attr($lead_middle_name); ?>"
										data-last-name="<?php echo esc_attr($lead_last_name); ?>" 
										data-address-1="<?php echo esc_attr($lead_address_1); ?>" 
										data-address-2="<?php echo esc_attr($lead_address_2); ?>" 
										data-city="<?php echo esc_attr($lead_city); ?>" 
										data-state="<?php echo esc_attr($lead_state); ?>" 
										data-zip="<?php echo esc_attr($lead_zip); ?>" 
										data-home-phone="<?php echo esc_attr($lead_home_phone); ?>" 
										data-mobile-phone="<?php echo esc_attr($lead_mobile_phone); ?>" 
										data-work-phone="<?php echo esc_attr($lead_work_phone); ?>" 
										data-email="<?php echo esc_attr($lead_email); ?>" 
										data-birth-date="<?php if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) { echo esc_attr($lead_birth_date); } ?>" 
										data-social-security="<?php if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) { echo esc_attr($lead_social_security); } ?>" 
										data-driver-license-state="<?php echo esc_attr($lead_driver_license_state); ?>" 
										data-driver-license-number="<?php if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) { echo esc_attr($lead_driver_license_number); } ?>" 
										data-driver-license-exp="<?php echo esc_attr($lead_driver_license_exp); ?>" 

										value="<?php echo esc_attr($lead_ID); ?>" 

										<?php selected( $lead_ID, $existing_customer ); ?>><?php echo esc_attr($lead_first_name); ?> <?php echo esc_attr($lead_last_name); ?></option>
								<?php 

										endforeach; 

									endif;

								?>
								
							</select>

						</div>

					</div>

				</div>

			</fieldset>

			<fieldset>
				
				<div class="row">

					<div class="col-lg-4 col-md-6">

						<label for="rent_first_name" class="control-label"><?php esc_html_e('First Name:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_first_name" name="rent_first_name" value="<?php echo esc_attr($rent_first_name); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="rent_middle_name" class="control-label"><?php esc_html_e('Middle Name:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_middle_name" name="rent_middle_name" value="<?php echo esc_attr($rent_middle_name); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="rent_last_name" class="control-label"><?php esc_html_e('Last Name:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_last_name" name="rent_last_name" value="<?php echo esc_attr($rent_last_name); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="rent_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_address_1" name="rent_address_1" value="<?php echo esc_attr($rent_address_1); ?>" placeholder="" />

					</div>

					<div class="col-md-6">

						<label for="rent_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_address_2" name="rent_address_2" value="<?php echo esc_attr($rent_address_2); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="rent_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_city" name="rent_city" value="<?php echo esc_attr($rent_city); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="rent_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_state" name="rent_state" value="<?php echo esc_attr($rent_state); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="rent_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_zip" name="rent_zip" value="<?php echo esc_attr($rent_zip); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="rent_home_phone" class="control-label"><?php esc_html_e('Home Phone:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_home_phone" name="rent_home_phone" value="<?php echo esc_attr($rent_home_phone); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="rent_mobile_phone" class="control-label"><?php esc_html_e('Mobile Phone:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_mobile_phone" name="rent_mobile_phone" value="<?php echo esc_attr($rent_mobile_phone); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="rent_work_phone" class="control-label"><?php esc_html_e('Work Phone:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_work_phone" name="rent_work_phone" value="<?php echo esc_attr($rent_work_phone); ?>" placeholder="" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="rent_email" class="control-label"><?php esc_html_e('Email Address:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_email" name="rent_email" value="<?php echo esc_attr($rent_email); ?>" placeholder="" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="rent_age" class="control-label"><?php esc_html_e('Age:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_age" name="rent_age" value="<?php echo esc_attr($rent_age); ?>" placeholder="" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="rent_birth_date" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Date of Birth:', 'autoroyal' ); ?></label>

						<div class="autoroyal-input-has-icon">
							<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
								<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
							<?php } else { ?>
								<input class="date_picker_past autoroyal-input-icon-left" type="text" id="rent_birth_date" name="rent_birth_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($rent_birth_date); ?>" />
								<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
							<?php } ?>
						</div>

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="rent_social_security" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Social Security:', 'autoroyal' ); ?></label>
						<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
							<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
						<?php } else { ?>
							<input type="text" id="rent_social_security" name="rent_social_security" value="<?php echo esc_attr($rent_social_security); ?>" placeholder="" />
						<?php } ?>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="rent_driver_license_state" class="control-label"><?php esc_html_e('Drivers License State:', 'autoroyal' ); ?></label>
						<input type="text" id="rent_driver_license_state" name="rent_driver_license_state" value="<?php echo esc_attr($rent_driver_license_state); ?>" placeholder="" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="rent_driver_license_number" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Drivers License Number:', 'autoroyal' ); ?></label>
						<?php if( get_autoroyal_ssl_hide_forms() == "1" AND empty( $_SERVER['HTTPS'] ) ) { ?>
							<input class="autoroyal-field-hidden-ssl" type="text" value="<?php esc_html_e('Hidden due to SSL issue.', 'autoroyal' ); ?>" disabled="disabled" />
						<?php } else { ?>
							<input type="text" id="rent_driver_license_number" name="rent_driver_license_number" value="<?php echo esc_attr($rent_driver_license_number); ?>" placeholder="" />
						<?php } ?>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="rent_driver_license_exp" class="control-label"><?php esc_html_e('Drivers License Exp:', 'autoroyal' ); ?></label>

						<div class="autoroyal-input-has-icon">
							<input class="date_picker_future autoroyal-input-icon-left" type="text" id="rent_driver_license_exp" name="rent_driver_license_exp" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="<?php echo esc_attr($rent_driver_license_exp); ?>" />
							<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
						</div>

					</div>

				</div>
				
			</fieldset>

			<br>

		</div>	<!-- end review_options_pop -->

		<div class="options_group">

			<fieldset class="autoroyal-last-fieldset">

				<div class="row">

					<div class="col-md-12">

						<input type="hidden" name="reservation_id" value="<?php echo esc_attr($reservation_id); ?>" />
						<input type="hidden" name="action_name" value="<?php if(!empty($_GET['action'])) { echo $_GET['action']; } ?>" />
											
						<input type="hidden" name="action" value="submitreservationFunction" />
						<?php wp_nonce_field( 'submitreservationFunction_html', 'submitreservationFunction_nonce' ); ?>

						<a id="autoroyal_submit_reservation" href="#" class="btn btn-default"><?php esc_html_e( 'Save reservation', 'autoroyal' ) ?></a>

						<a id="autoroyal_discard_reservation" href="<?php echo esc_url(autoroyal_get_permalink( 'reservations' )); ?>" class="btn btn-default"><?php esc_html_e( 'Cancel', 'autoroyal' ) ?></a>

						<?php 

							$action_url = add_query_arg( array( 'action' => 'delete', 'reservation_id' => $reservation_id ) );
							$action_url = wp_nonce_url( $action_url, 'autoroyal_reservation_actions' ); 

						?>

						<a id="autoroyal_submit_reservation" href="<?php echo esc_url( $action_url ); ?>" class="btn btn-default"><?php esc_html_e( 'Delete', 'autoroyal' ) ?></a>

					</div>

				</div>

			</fieldset>

		</div>

	</form>
	
</div>

<?php } ?>
