<?php
/**
 * My Account > Account Funds page
 *
 * @version 2.0.12
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$page = ! empty( $_GET['page_num'] ) ? (int) $_GET['page_num'] : 1;
$total = count( $payouts ); //total items in array    
$limit = 20; //per page    
$totalPages = ceil( $total/ $limit ); //calculate total pages
$page = max($page, 1); //get 1 page when $_GET['page'] <= 0
$page = min($page, $totalPages); //get last page when $_GET['page'] > $totalPages
$offset = ($page - 1) * $limit;
if( $offset < 0 ) $offset = 0;

$payouts = array_slice( $payouts, $offset, $limit );

?>
<h2><?php _e( 'Recent Payouts', 'autoroyal' ); ?></h2>
<table class="shop_table my_account_payouts">
	<thead>
		<tr>
			<th class="order-date"><span class="nobr"><?php _e( 'Date', 'autoroyal' ); ?></span></th>
			<th class="order-vehicle"><span class="nobr"><?php _e(' Vehicle', 'autoroyal' ); ?></span></th>
			<th class="order-type"><span class="nobr"><?php _e(' Type', 'autoroyal' ); ?></span></th>
			<th class="order-amount"><span class="nobr"><?php _e( 'Amount', 'autoroyal' ); ?></span></th>
		</tr>
	</thead>
	<tbody>
		<?php 

			foreach ( $payouts as $payout ) : 

				$order_date = $payout['date'];
				$order_amount = $payout['amount'];
				$order_vehicle = $payout['car_title'];
				$order_vehicle_id = $payout['car_id'];
				$order_vehicle_sku = "#".$payout['car_id'];
				if( !empty($payout['car_sku']) ) {
					$order_vehicle_sku = $payout['car_sku'];
				}

				if ( get_post_status( $order_vehicle_id ) == 'publish' ) {
					$order_vehicle_url = $payout['car_url'];
				} else {
					$order_vehicle_url = '';
				}

				$order_type = $payout['payment_type'];

				$format = get_option('date_format') . ' ' . get_option('time_format');

		?>
		<tr class="order">
			<td class="order-date" data-title="<?php _e( 'Date', 'autoroyal' ); ?>">
				<time datetime="<?php echo date( 'Y-m-d H:i:s', strtotime( $order_date ) ); ?>" title="<?php echo esc_attr( strtotime( $order_date ) ); ?>">
					<?php echo get_date_from_gmt ( $order_date, get_option('date_format') . ' '. get_option('time_format') ); ?>
				</time>
			</td>
			<td class="order-vehicle" data-title="<?php _e( 'Vehicle', 'autoroyal' ); ?>" style="text-align:left; white-space:nowrap;">
				<?php

					if( !empty($order_vehicle_url)) { 

				?>
				
					<a href="<?php echo esc_url($order_vehicle_url); ?>"><?php echo esc_attr($order_vehicle_sku); echo " - "; echo esc_attr($order_vehicle); ?></a>

				<?php
					} else { 
				?>
					<?php echo esc_attr($order_vehicle_sku); echo " - "; echo esc_attr($order_vehicle); ?>
				<?php 

					}

				?>
			</td>
			<td class="order-type">
				<?php if( $order_type == "Promoted" ) { echo _e( 'Promoted', 'autoroyal' ); } elseif( $order_type == "Featured" ) { echo _e( 'Featured', 'autoroyal' ); } elseif( $order_type == "Submit Fee" ) { echo _e( 'Submit Fee', 'autoroyal' ); } ?>
			</td>
			<td class="order-amount">
				<?php echo wc_price( $order_amount ); ?>
			</td>
		</tr>
		<?php endforeach; ?>
	</tbody>
</table>

<?php

	$link = get_the_permalink().'?page_num=%d';

	$pagerContainer = '<div style="width: 100%">';  

	if( $totalPages != 0 ) {

	  	if( $page == 1 ) { 

	    	$pagerContainer .= ''; 

	  	} else { 

	    	$pagerContainer .= sprintf( '<a href="' . $link . '" style="color: #c00"> &#171; '.__('prev page', 'autoroyal').'</a>', $page - 1 ); 
	  
	  	}

	  	$pagerContainer .= ' <span> '.__('page', 'autoroyal').' <strong>' . $page . '</strong> '.__('from', 'autoroyal').' ' . $totalPages . '</span>'; 

	  	if( $page == $totalPages ) { 

	     	$pagerContainer .= ''; 

	  	} else { 

	    	$pagerContainer .= sprintf( '<a href="' . $link . '" style="color: #c00"> '.__('next page', 'autoroyal').' &#187; </a>', $page + 1 ); 

	  	}         

	} 

	$pagerContainer .= '</div>';

	echo $pagerContainer;

?>

