<?php

/////////////////// Section ///////////////////
$wp_customize->add_section( 'autoroyal_footer_options',
array(
    'title' => esc_html__( 'autoRoyal: Footer', 'autoroyal' ), //Visible title of section
    'priority' => 903, //Determines what order this appears in
    'capability' => 'edit_theme_options', //Capability needed to tweak
    'description' => esc_html__('Allows you to customize Footer for autoRoyal Theme.', 'autoroyal'), //Descriptive tooltip
    )
);
////////////////////////////////////////////////

// <editor-fold defaultstate="collapsed" desc=" footer_copyright_text ">
$wp_customize->add_setting( 'footer_copyright_text',
array(
    'default' => $autoroyal_defaults['footer_copyright_text'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'wp_kses',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('footer_copyright_text', array(
    'settings' => 'footer_copyright_text',
    'label'    => esc_html__('Footer Copyright Text', 'autoroyal'),
    'section'  => 'autoroyal_footer_options',
    'type'     => 'textarea',
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" footer_stats_1_value ">
$wp_customize->add_setting( 'footer_stats_1_value',
array(
    'default' => $autoroyal_defaults['footer_stats_1_value'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('footer_stats_1_value', array(
    'settings' => 'footer_stats_1_value',
    'label'    => esc_html__('Footer stats #1 - Value', 'autoroyal'),
    'section'  => 'autoroyal_footer_options',
    'type'     => 'text',
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" footer_stats_1_label ">
$wp_customize->add_setting( 'footer_stats_1_label',
array(
    'default' => $autoroyal_defaults['footer_stats_1_label'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('footer_stats_1_label', array(
    'settings' => 'footer_stats_1_label',
    'label'    => esc_html__('Footer stats #1 - Label', 'autoroyal'),
    'section'  => 'autoroyal_footer_options',
    'type'     => 'text',
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" footer_stats_1_icon ">
$wp_customize->add_setting( 'footer_stats_1_icon',
array(
    'default' => $autoroyal_defaults['footer_stats_1_icon'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'wp_kses_post',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('footer_stats_1_icon', array(
    'settings' => 'footer_stats_1_icon',
    'label'    => esc_html__('Footer stats #1 - Icon', 'autoroyal'),
    'section'  => 'autoroyal_footer_options',
    'type'     => 'textarea',
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" footer_stats_2_value ">
$wp_customize->add_setting( 'footer_stats_2_value',
array(
    'default' => $autoroyal_defaults['footer_stats_2_value'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('footer_stats_2_value', array(
    'settings' => 'footer_stats_2_value',
    'label'    => esc_html__('Footer stats #2 - Value', 'autoroyal'),
    'section'  => 'autoroyal_footer_options',
    'type'     => 'text',
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" footer_stats_2_label ">
$wp_customize->add_setting( 'footer_stats_2_label',
array(
    'default' => $autoroyal_defaults['footer_stats_2_label'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('footer_stats_2_label', array(
    'settings' => 'footer_stats_2_label',
    'label'    => esc_html__('Footer stats #2 - Label', 'autoroyal'),
    'section'  => 'autoroyal_footer_options',
    'type'     => 'text',
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" footer_stats_2_icon ">
$wp_customize->add_setting( 'footer_stats_2_icon',
array(
    'default' => $autoroyal_defaults['footer_stats_2_icon'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'wp_kses_post',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('footer_stats_2_icon', array(
    'settings' => 'footer_stats_2_icon',
    'label'    => esc_html__('Footer stats #2 - Icon', 'autoroyal'),
    'section'  => 'autoroyal_footer_options',
    'type'     => 'textarea',
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" footer_stats_3_value ">
$wp_customize->add_setting( 'footer_stats_3_value',
array(
    'default' => $autoroyal_defaults['footer_stats_3_value'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('footer_stats_3_value', array(
    'settings' => 'footer_stats_3_value',
    'label'    => esc_html__('Footer stats #3 - Value', 'autoroyal'),
    'section'  => 'autoroyal_footer_options',
    'type'     => 'text',
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" footer_stats_3_label ">
$wp_customize->add_setting( 'footer_stats_3_label',
array(
    'default' => $autoroyal_defaults['footer_stats_3_label'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'esc_attr',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('footer_stats_3_label', array(
    'settings' => 'footer_stats_3_label',
    'label'    => esc_html__('Footer stats #3 - Label', 'autoroyal'),
    'section'  => 'autoroyal_footer_options',
    'type'     => 'text',
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" footer_stats_3_icon ">
$wp_customize->add_setting( 'footer_stats_3_icon',
array(
    'default' => $autoroyal_defaults['footer_stats_3_icon'], //Default setting/value to save
    'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
    'sanitize_callback' => 'wp_kses_post',
    'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
    'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control('footer_stats_3_icon', array(
    'settings' => 'footer_stats_3_icon',
    'label'    => esc_html__('Footer stats #3 - Icon', 'autoroyal'),
    'section'  => 'autoroyal_footer_options',
    'type'     => 'textarea',
));
// </editor-fold>