<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WPBakery Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$moveme_content = '';
$moveme_blog_archive_mask = '%%CONTENT%%';
$moveme_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $moveme_blog_archive_mask);
if ( have_posts() ) {
	the_post(); 
	if (($moveme_content = apply_filters('the_content', get_the_content())) != '') {
		if (($moveme_pos = strpos($moveme_content, $moveme_blog_archive_mask)) !== false) {
			$moveme_content = preg_replace('/(\<p\>\s*)?'.$moveme_blog_archive_mask.'(\s*\<\/p\>)/i', $moveme_blog_archive_subst, $moveme_content);
		} else
			$moveme_content .= $moveme_blog_archive_subst;
		$moveme_content = explode($moveme_blog_archive_mask, $moveme_content);
		// Add VC custom styles to the inline CSS
		$vc_custom_css = get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
		if ( !empty( $vc_custom_css ) ) moveme_add_inline_css(strip_tags($vc_custom_css));
	}
}

// Prepare args for a new query
$moveme_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$moveme_args = moveme_query_add_posts_and_cats($moveme_args, '', moveme_get_theme_option('post_type'), moveme_get_theme_option('parent_cat'));
$moveme_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($moveme_page_number > 1) {
	$moveme_args['paged'] = $moveme_page_number;
	$moveme_args['ignore_sticky_posts'] = true;
}
$moveme_ppp = moveme_get_theme_option('posts_per_page');
if ((int) $moveme_ppp != 0)
	$moveme_args['posts_per_page'] = (int) $moveme_ppp;
// Make a new query
query_posts( $moveme_args );
// Set a new query as main WP Query
$GLOBALS['wp_the_query'] = $GLOBALS['wp_query'];

// Set query vars in the new query!
if (is_array($moveme_content) && count($moveme_content) == 2) {
	set_query_var('blog_archive_start', $moveme_content[0]);
	set_query_var('blog_archive_end', $moveme_content[1]);
}

get_template_part('index');
?>