<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

$moveme_blog_style = explode('_', moveme_get_theme_option('blog_style'));
$moveme_columns = empty($moveme_blog_style[1]) ? 1 : max(1, $moveme_blog_style[1]);
$moveme_expanded = !moveme_sidebar_present() && moveme_is_on(moveme_get_theme_option('expand_content'));
$moveme_post_format = get_post_format();
$moveme_post_format = empty($moveme_post_format) ? 'standard' : str_replace('post-format-', '', $moveme_post_format);
$moveme_animation = moveme_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($moveme_columns).' post_format_'.esc_attr($moveme_post_format) ); ?>
	<?php echo (!moveme_is_off($moveme_animation) ? ' data-animation="'.esc_attr(moveme_get_animation_classes($moveme_animation)).'"' : ''); ?>>

	<?php
	// Add anchor
	if ($moveme_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.the_title_attribute( array( 'echo' => false ) ).'"]');
	}

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	moveme_show_post_featured( array(
											'class' => $moveme_columns == 1 ? 'trx-stretch-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => moveme_get_thumb_size(
																	strpos(moveme_get_theme_option('body_style'), 'full')!==false
																		? ( $moveme_columns > 1 ? 'huge' : 'original' )
																		: (	$moveme_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('moveme_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('moveme_action_before_post_meta'); 

			// Post meta
			$moveme_components = moveme_is_inherit(moveme_get_theme_option_from_meta('meta_parts')) 
										? ($moveme_columns < 2 ? 'categories,' : '') . 'date'.($moveme_columns < 3 ? ',counters' : '')
										: moveme_array_get_keys_by_value(moveme_get_theme_option('meta_parts'));
			$moveme_counters = moveme_is_inherit(moveme_get_theme_option_from_meta('counters')) 
										? 'comments'
										: moveme_array_get_keys_by_value(moveme_get_theme_option('counters'));
			$moveme_post_meta = empty($moveme_components) 
										? '' 
										: moveme_show_post_meta(apply_filters('moveme_filter_post_meta_args', array(
												'components' => $moveme_components,
												'counters' => $moveme_counters,
												'seo' => false,
												'echo' => false
												), $moveme_blog_style[0], $moveme_columns)
											);
			moveme_show_layout($moveme_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$moveme_show_learn_more = !in_array($moveme_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($moveme_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($moveme_post_format == 'quote') {
					if (($quote = moveme_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						moveme_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($moveme_post_format, array('link', 'aside', 'status', 'quote'))) {
				moveme_show_layout($moveme_post_meta);
			}
			// More button
			if ( $moveme_show_learn_more ) {
				?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'moveme'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>