<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('moveme_storage_get')) {
	function moveme_storage_get($var_name, $default='') {
		global $MOVEME_STORAGE;
		return isset($MOVEME_STORAGE[$var_name]) ? $MOVEME_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('moveme_storage_set')) {
	function moveme_storage_set($var_name, $value) {
		global $MOVEME_STORAGE;
		$MOVEME_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('moveme_storage_empty')) {
	function moveme_storage_empty($var_name, $key='', $key2='') {
		global $MOVEME_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($MOVEME_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($MOVEME_STORAGE[$var_name][$key]);
		else
			return empty($MOVEME_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('moveme_storage_isset')) {
	function moveme_storage_isset($var_name, $key='', $key2='') {
		global $MOVEME_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($MOVEME_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($MOVEME_STORAGE[$var_name][$key]);
		else
			return isset($MOVEME_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('moveme_storage_inc')) {
	function moveme_storage_inc($var_name, $value=1) {
		global $MOVEME_STORAGE;
		if (empty($MOVEME_STORAGE[$var_name])) $MOVEME_STORAGE[$var_name] = 0;
		$MOVEME_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('moveme_storage_concat')) {
	function moveme_storage_concat($var_name, $value) {
		global $MOVEME_STORAGE;
		if (empty($MOVEME_STORAGE[$var_name])) $MOVEME_STORAGE[$var_name] = '';
		$MOVEME_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('moveme_storage_get_array')) {
	function moveme_storage_get_array($var_name, $key, $key2='', $default='') {
		global $MOVEME_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($MOVEME_STORAGE[$var_name][$key]) ? $MOVEME_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($MOVEME_STORAGE[$var_name][$key][$key2]) ? $MOVEME_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('moveme_storage_set_array')) {
	function moveme_storage_set_array($var_name, $key, $value) {
		global $MOVEME_STORAGE;
		if (!isset($MOVEME_STORAGE[$var_name])) $MOVEME_STORAGE[$var_name] = array();
		if ($key==='')
			$MOVEME_STORAGE[$var_name][] = $value;
		else
			$MOVEME_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('moveme_storage_set_array2')) {
	function moveme_storage_set_array2($var_name, $key, $key2, $value) {
		global $MOVEME_STORAGE;
		if (!isset($MOVEME_STORAGE[$var_name])) $MOVEME_STORAGE[$var_name] = array();
		if (!isset($MOVEME_STORAGE[$var_name][$key])) $MOVEME_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$MOVEME_STORAGE[$var_name][$key][] = $value;
		else
			$MOVEME_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('moveme_storage_merge_array')) {
	function moveme_storage_merge_array($var_name, $key, $value) {
		global $MOVEME_STORAGE;
		if (!isset($MOVEME_STORAGE[$var_name])) $MOVEME_STORAGE[$var_name] = array();
		if ($key==='')
			$MOVEME_STORAGE[$var_name] = array_merge($MOVEME_STORAGE[$var_name], $value);
		else
			$MOVEME_STORAGE[$var_name][$key] = array_merge($MOVEME_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('moveme_storage_set_array_after')) {
	function moveme_storage_set_array_after($var_name, $after, $key, $value='') {
		global $MOVEME_STORAGE;
		if (!isset($MOVEME_STORAGE[$var_name])) $MOVEME_STORAGE[$var_name] = array();
		if (is_array($key))
			moveme_array_insert_after($MOVEME_STORAGE[$var_name], $after, $key);
		else
			moveme_array_insert_after($MOVEME_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('moveme_storage_set_array_before')) {
	function moveme_storage_set_array_before($var_name, $before, $key, $value='') {
		global $MOVEME_STORAGE;
		if (!isset($MOVEME_STORAGE[$var_name])) $MOVEME_STORAGE[$var_name] = array();
		if (is_array($key))
			moveme_array_insert_before($MOVEME_STORAGE[$var_name], $before, $key);
		else
			moveme_array_insert_before($MOVEME_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('moveme_storage_push_array')) {
	function moveme_storage_push_array($var_name, $key, $value) {
		global $MOVEME_STORAGE;
		if (!isset($MOVEME_STORAGE[$var_name])) $MOVEME_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($MOVEME_STORAGE[$var_name], $value);
		else {
			if (!isset($MOVEME_STORAGE[$var_name][$key])) $MOVEME_STORAGE[$var_name][$key] = array();
			array_push($MOVEME_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('moveme_storage_pop_array')) {
	function moveme_storage_pop_array($var_name, $key='', $defa='') {
		global $MOVEME_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($MOVEME_STORAGE[$var_name]) && is_array($MOVEME_STORAGE[$var_name]) && count($MOVEME_STORAGE[$var_name]) > 0) 
				$rez = array_pop($MOVEME_STORAGE[$var_name]);
		} else {
			if (isset($MOVEME_STORAGE[$var_name][$key]) && is_array($MOVEME_STORAGE[$var_name][$key]) && count($MOVEME_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($MOVEME_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('moveme_storage_inc_array')) {
	function moveme_storage_inc_array($var_name, $key, $value=1) {
		global $MOVEME_STORAGE;
		if (!isset($MOVEME_STORAGE[$var_name])) $MOVEME_STORAGE[$var_name] = array();
		if (empty($MOVEME_STORAGE[$var_name][$key])) $MOVEME_STORAGE[$var_name][$key] = 0;
		$MOVEME_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('moveme_storage_concat_array')) {
	function moveme_storage_concat_array($var_name, $key, $value) {
		global $MOVEME_STORAGE;
		if (!isset($MOVEME_STORAGE[$var_name])) $MOVEME_STORAGE[$var_name] = array();
		if (empty($MOVEME_STORAGE[$var_name][$key])) $MOVEME_STORAGE[$var_name][$key] = '';
		$MOVEME_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('moveme_storage_call_obj_method')) {
	function moveme_storage_call_obj_method($var_name, $method, $param=null) {
		global $MOVEME_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($MOVEME_STORAGE[$var_name]) ? $MOVEME_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($MOVEME_STORAGE[$var_name]) ? $MOVEME_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('moveme_storage_get_obj_property')) {
	function moveme_storage_get_obj_property($var_name, $prop, $default='') {
		global $MOVEME_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($MOVEME_STORAGE[$var_name]->$prop) ? $MOVEME_STORAGE[$var_name]->$prop : $default;
	}
}
?>