<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

moveme_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'imagesloaded' );
wp_enqueue_script( 'masonry' );
wp_enqueue_script( 'classie', moveme_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'gallery-script', moveme_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$moveme_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$moveme_sticky_out = moveme_get_theme_option('sticky_style')=='columns' 
							&& is_array($moveme_stickies) && count($moveme_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$moveme_cat = moveme_get_theme_option('parent_cat');
	$moveme_post_type = moveme_get_theme_option('post_type');
	$moveme_taxonomy = moveme_get_post_type_taxonomy($moveme_post_type);
	$moveme_show_filters = moveme_get_theme_option('show_filters');
	$moveme_tabs = array();
	if (!moveme_is_off($moveme_show_filters)) {
		$moveme_args = array(
			'type'			=> $moveme_post_type,
			'child_of'		=> $moveme_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $moveme_taxonomy,
			'pad_counts'	=> false
		);
		$moveme_portfolio_list = get_terms($moveme_args);
		if (is_array($moveme_portfolio_list) && count($moveme_portfolio_list) > 0) {
			$moveme_tabs[$moveme_cat] = esc_html__('All', 'moveme');
			foreach ($moveme_portfolio_list as $moveme_term) {
				if (isset($moveme_term->term_id)) $moveme_tabs[$moveme_term->term_id] = $moveme_term->name;
			}
		}
	}
	if (count($moveme_tabs) > 0) {
		$moveme_portfolio_filters_ajax = true;
		$moveme_portfolio_filters_active = $moveme_cat;
		$moveme_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters moveme_tabs moveme_tabs_ajax">
			<ul class="portfolio_titles moveme_tabs_titles">
				<?php
				foreach ($moveme_tabs as $moveme_id=>$moveme_title) {
					?><li><a href="<?php echo esc_url(moveme_get_hash_link(sprintf('#%s_%s_content', $moveme_portfolio_filters_id, $moveme_id))); ?>" data-tab="<?php echo esc_attr($moveme_id); ?>"><?php echo esc_html($moveme_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$moveme_ppp = moveme_get_theme_option('posts_per_page');
			if (moveme_is_inherit($moveme_ppp)) $moveme_ppp = '';
			foreach ($moveme_tabs as $moveme_id=>$moveme_title) {
				$moveme_portfolio_need_content = $moveme_id==$moveme_portfolio_filters_active || !$moveme_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $moveme_portfolio_filters_id, $moveme_id)); ?>"
					class="portfolio_content moveme_tabs_content"
					data-blog-template="<?php echo esc_attr(moveme_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(moveme_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($moveme_ppp); ?>"
					data-post-type="<?php echo esc_attr($moveme_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($moveme_taxonomy); ?>"
					data-cat="<?php echo esc_attr($moveme_id); ?>"
					data-parent-cat="<?php echo esc_attr($moveme_cat); ?>"
					data-need-content="<?php echo (false===$moveme_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($moveme_portfolio_need_content) 
						moveme_show_portfolio_posts(array(
							'cat' => $moveme_id,
							'parent_cat' => $moveme_cat,
							'taxonomy' => $moveme_taxonomy,
							'post_type' => $moveme_post_type,
							'page' => 1,
							'sticky' => $moveme_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		moveme_show_portfolio_posts(array(
			'cat' => $moveme_cat,
			'parent_cat' => $moveme_cat,
			'taxonomy' => $moveme_taxonomy,
			'post_type' => $moveme_post_type,
			'page' => 1,
			'sticky' => $moveme_sticky_out
			)
		);
	}

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>