<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0.10
 */

$moveme_footer_scheme =  moveme_is_inherit(moveme_get_theme_option('footer_scheme')) ? moveme_get_theme_option('color_scheme') : moveme_get_theme_option('footer_scheme');
$moveme_footer_id = str_replace('footer-custom-', '', moveme_get_theme_option("footer_style"));
$moveme_footer_meta = get_post_meta($moveme_footer_id, 'trx_addons_options', true);
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr($moveme_footer_id); 
						?> footer_custom_<?php echo esc_attr(sanitize_title(get_the_title($moveme_footer_id))); 
						if (!empty($moveme_footer_meta['margin']) != '') 
							echo ' '.esc_attr(moveme_add_inline_css_class('margin-top: '.esc_attr(moveme_prepare_css_value($moveme_footer_meta['margin'])).';'));
						?> scheme_<?php echo esc_attr($moveme_footer_scheme); 
						?>">
	<?php
    // Custom footer's layout
    do_action('moveme_action_show_layout', $moveme_footer_id);
	?>
</footer><!-- /.footer_wrap -->
