<?php

/////////////////// Section ///////////////////
$wp_customize->add_section( 'autoroyal_logo_options',
array(
    'title' => esc_html__( 'Logo', 'autoroyal' ), //Visible title of section
    'priority' => 35, //Determines what order this appears in
    'capability' => 'edit_theme_options', //Capability needed to tweak
    'description' => esc_html__('Allows you to customize headre for autoRoyal Theme.', 'autoroyal'), //Descriptive tooltip
    'panel'  => 'autoroyal_header_options',
    )
);
////////////////////////////////////////////////

// <editor-fold defaultstate="collapsed" desc=" logo ">
$wp_customize->add_setting( 'logo',
    array(
        'default' => $autoroyal_defaults['logo'], //Default setting/value to save
        'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
        'sanitize_callback' => 'esc_url_raw',
        'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
        'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'logo', array(
    'label'    => esc_html__('Logo', 'autoroyal'),
    'section'  => 'autoroyal_logo_options',
    'settings' => 'logo',
    'description' => esc_html__('The Image should be Retina Ready (twice the size)', 'autoroyal'), //Descriptive tooltip
)));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc=" logo_white ">
$wp_customize->add_setting( 'logo_white',
    array(
        'default' => $autoroyal_defaults['logo_white'], //Default setting/value to save
        'type' => 'theme_mod', //Is this an 'option' or a 'theme_mod'?
        'sanitize_callback' => 'esc_url_raw',
        'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
        'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
    )
);
$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'logo_white', array(
    'label'    => esc_html__('Footer Logo', 'autoroyal'),
    'section'  => 'autoroyal_logo_options',
    'settings' => 'logo_white',
    'description' => esc_html__('The Image should be Retina Ready (twice the size)', 'autoroyal'), //Descriptive tooltip
)));
// </editor-fold>