<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package fantasy_themes
 */

$postID = get_the_ID();
$page_title_block = get_post_meta( $postID , 'page_title' , true );

get_header(); 

?>

	<div class="autoroyal-page-title">

        <div class="container">

            <h2><?php the_title(); ?></h2>

            <div class="breadcrumbs">

                <?php
                    if(function_exists('bcn_display')) {
                        bcn_display();
                    }
                ?>

            </div>
            
        </div>

    </div>

	<div class="container">

		<div class="row">

			<div class="col-md-12 fantasy-themes-content-width">

				<div id="primary" class="content-area">

					<main id="main" class="site-main autoroyal-team-single">

						<div class="row">

							<div class="col-md-4">

								<?php if (has_post_thumbnail( $postID ) ) { $image_bg = wp_get_attachment_image_src( get_post_thumbnail_id( $postID ), 'full' ); ?>
									<img class="autoroyal-team-single-image" src="<?php echo esc_url($image_bg[0]); ?>" alt="<?php the_title_attribute(); ?>">
								<?php } ?>

								<div class="autoroyal-team-single-social">

                                    <?php

			                            $facebook_url = get_post_meta(get_the_ID(), 'autoroyal_facebook_url',true);
			                            $twitter_url = get_post_meta(get_the_ID(), 'autoroyal_twitter_url',true);
			                            $google_plus_url = get_post_meta(get_the_ID(), 'autoroyal_google_plus_url',true);
			                            $linked_in_url = get_post_meta(get_the_ID(), 'autoroyal_linked_in_url',true);

			                            if(!empty($facebook_url) || !empty($twitter_url) || !empty($google_plus_url) || !empty($linked_in_url)){
			                                ?>
		                                    <?php
		                                    if(!empty($facebook_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($facebook_url); ?>">
		                                        	<i class="fab fa-facebook-f" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }
		                                    if(!empty($twitter_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($twitter_url); ?>" >
		                                        	<i class="fab fa-twitter" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }
		                                    if(!empty($linked_in_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($linked_in_url); ?>">
		                                        	<i class="fab fa-linkedin-in" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }

		                                    if(!empty($google_plus_url)){
		                                        ?>
		                                        <a target="_blank" href="<?php echo esc_url($google_plus_url); ?>">
		                                        	<i class="fab fa-google-plus-g" aria-hidden="true"></i>
		                                        </a>
		                                    <?php
		                                    }
		                                    ?>
			                            <?php
			                            }
			                        ?>                            
                                        
                                </div>

							</div>

							<div class="col-md-8">

								<div class="card hentry">

									<div class="card-body">
										
										<div class="autoroyal-team-single-title">

											<h3><?php the_title(); ?></h3>

											<?php $position = get_post_meta(get_the_ID(), 'autoroyal_position',true);  if(!empty($position)) { ?>
			                                <div class="entry-title"><?php echo esc_attr($position); ?></div>
			                                <?php } ?>

			                            </div>

										<?php the_content(); ?>

									</div>

								</div>

							</div>

						</div>

					</main><!-- #main -->

				</div><!-- #primary -->

			</div>

		</div>
		<!-- /.row -->
	</div>
	<!-- /.container -->

<?php
get_footer();
